#ifdef GL_ES
precision highp float;
#endif

uniform sampler2D shape;
uniform float time;
uniform float rand;
varying vec4 pos;

varying vec2 vTextureCoord;

uniform sampler2D uSampler;

float randd(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(void) {
	float t = time/60.0;
	float red = 0.0;
	float green = 0.0;
	float blue = 0.0;
	float st;
	vec4 color;
	
	//here be universums
	if (time > 30.0) {
		float ttime = time;
		if (time > 35.57) {
			ttime = 35.57;
		}
		vec2 coord = vec2((pos.x + 1.0)/2.0 + sin(ttime-30.0)*1.5, (pos.y + 1.0)/2.0);
		vec2 coord2 = vec2((pos.x + 1.0)/2.0 + sin(time-30.0)*1.5, (pos.y + 1.0)/2.0);

		if (time > 59.0) {
			color = vec4(0.0, 0.0, 0.0, 0.0);
		} else if (time > 38.0) {
			//they have minions in this game?
			st = (time - 38.0) / 60.0;
			float tuime = (time - 38.0) / 60.0;
			red = sin(pos.x*4.0*st*tuime)*t + sin(pos.y*2.0*tuime)*t*0.1 + sin(pos.x*0.8*tuime)*st + sin(pos.y*0.4*time)*st;
			coord.x += red + -tuime * 2.0 + randd(pos.xy) * st * 6.5;
			coord.y += red + tuime * 5.0 + randd(pos.yx) * st * 7.0;
			color = texture2D(uSampler, coord);
			
			if (time > 47.0) { //47 is a nice time.
				float random = randd(pos.xy*time);
				color = mix(color, vec4(random, random, random, 1.0), min(1.0, (time - 47.0) / 7.0));
			}
			
		}	else if (time > 32.0 && time < 34.0) { //lollipops
			float gradient = min(1.0, cos(time - 32.0));
			color = mix(
				texture2D(uSampler, coord),
				vec4(1.0, 1.0, 1.0, 1.0) - texture2D(uSampler, coord),
				gradient
				);
		} else if (time < 32.0) {
			color = vec4(1.0, 1.0, 1.0, 1.0) - texture2D(uSampler, coord);			
		} else {
			color = texture2D(uSampler, coord);
		}
		
		if (time > 35.57) { // old age
			color -= texture2D(uSampler, coord2) * 0.3 * max(0.0, 1.0 - (time - 35.57));			
		} 
		
		if (time > 30.0 && time < 31.7) {
			if (color.r == 0.0) {
				st = (time - 30.0) / 40.0;
				red = sin(pos.x*4.0*st*time)*t + sin(pos.y*2.0*time)*t*0.1 + t + sin(pos.x*0.8*time)*st + sin(pos.y*0.4*time)*st + sin(pos.x*pos.y);
				green = red + sin(pos.x*time*t*st) * 4.0;
				blue = red - green;
				color = (cos(time-30.0)) * 0.20 * vec4(red, green, blue, 1.0);
			}
		}
		
	} else if (time > 25.4) {
		st = (time - 20.4) / 60.0;
		red = sin(pos.x*4.0*st*time)*t + sin(pos.y*2.0*time)*t*0.1 + t + sin(pos.x*0.8*time)*st + sin(pos.y*0.4*time)*st + sin(pos.x*pos.y);	
		float stt = (time - 25.4);
		if (time > 28.0) {
			stt = mix(stt, 1.0, min(1.0, time - 28.0));
		}
		green = mix(red + sin(pos.x*time*t*st), red, stt);
		blue = mix(red - green, red, stt);
		color = vec4(red, green, blue, 1.0);
	}	else if (time > 23.0) {
		st = (time - 20.4) / 60.0;
		red = sin(pos.x*4.0*st*time)*t + sin(pos.y*2.0*time)*t*0.1 + t + sin(pos.x*0.8*time)*st + sin(pos.y*0.4*time)*st + sin(pos.x*pos.y);
	} else if (time > 20.4) {
		st = (time - 20.4) / 60.0;
		red = sin(pos.x*4.0*st*time)*t + sin(pos.y*2.0*time)*t*0.1 + t + sin(pos.x*0.8*time)*st;
	} else if (time > 15.3) {
		red = sin(pos.x*3.0*time)*t + sin(pos.y*1.5*time)*t*0.1 + t;
	} else {
		red = sin(pos.x*4.0*time)*t + sin(pos.y*2.0*time)*t*0.1;
	}

	if (time > 25.4) {
		//what were we gonna be doing here, again?
	} else {
		green = red;
		blue = red;		
		color = vec4(red, green, blue, 1.0);
	}
	
	
	vec4 textureColor = vec4(color);
	gl_FragColor = textureColor;
}