var shader_plasma;
var curTime=0.0;
var prevTime=0.0;
var pmtTexture;

var mvMatrix = mat4.create();
var mvMatrixStack = [];
var pMatrix = mat4.create();

function setMatrixUniforms() {
    gl.uniformMatrix4fv(currentShader.pMatrixUniform, false, pMatrix);
    gl.uniformMatrix4fv(currentShader.mvMatrixUniform, false, mvMatrix);
}


function degToRad(degrees) {
    return degrees * Math.PI / 180;
}

var cubeVertexPositionBuffer;
var cubeVertexColorBuffer;
var cubeVertexIndexBuffer;
/////////////

function initTexture() {
  neheTexture = gl.createTexture();
  neheTexture.image = new Image();
  neheTexture.image.onload = function() {
    handleLoadedTexture(neheTexture)
  }

  neheTexture.image.src = "img/shape.png";
}
function demoInit() {
	if (loadDone == 0) {
		//put here stuff that only is inited _ONCE_, on the startup

	}

	//here be stuff that can be reloaded during demo
	loadMessage("Loading shaders...")
	shadersInit();
//	0.3
   cubeVertexPositionBuffer = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, cubeVertexPositionBuffer);
    vertices = [
        // Front face
        -1.0, -1.0,  1.0,
         1.0, -1.0,  1.0,
         1.0,  1.0,  1.0,
        -1.0,  1.0,  1.0,

        // Back face
        -1.0, -1.0, -1.0,
        -1.0,  1.0, -1.0,
         1.0,  1.0, -1.0,
         1.0, -1.0, -1.0,

        // Top face
        -1.0,  1.0, -1.0,
        -1.0,  1.0,  1.0,
         1.0,  1.0,  1.0,
         1.0,  1.0, -1.0,

        // Bottom face
        -1.0, -1.0, -1.0,
         1.0, -1.0, -1.0,
         1.0, -1.0,  1.0,
        -1.0, -1.0,  1.0,

        // Right face
         1.0, -1.0, -1.0,
         1.0,  1.0, -1.0,
         1.0,  1.0,  1.0,
         1.0, -1.0,  1.0,

        // Left face
        -1.0, -1.0, -1.0,
        -1.0, -1.0,  1.0,
        -1.0,  1.0,  1.0,
        -1.0,  1.0, -1.0,
    ];
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(vertices), gl.STATIC_DRAW);
    cubeVertexPositionBuffer.itemSize = 3;
    cubeVertexPositionBuffer.numItems = 24;

    cubeVertexIndexBuffer = gl.createBuffer();
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, cubeVertexIndexBuffer);
    var cubeVertexIndices = [
        0, 1, 2,      0, 2, 3,    // Front face
        4, 5, 6,      4, 6, 7,    // Back face
        8, 9, 10,     8, 10, 11,  // Top face
        12, 13, 14,   12, 14, 15, // Bottom face
        16, 17, 18,   16, 18, 19, // Right face
        20, 21, 22,   20, 22, 23  // Left face
    ];
    gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(cubeVertexIndices), gl.STATIC_DRAW);
    cubeVertexIndexBuffer.itemSize = 1;
    cubeVertexIndexBuffer.numItems = 36;

/*	  pmtTexture = gl.createTexture();
	  pmtTexture.image = new Image();
	  pmtTexture.image.onload = function() { handleTextureLoaded(pmtTexture.image, pmtTexture); }
	  pmtTexture.image.src = "img/shape.png";*/
	initTexture();
	
	
/*	  pmtImage = new Image();
	  pmtImage.onload = function() { handleTextureLoaded(pmtImage, pmtTexture); }
	  pmtImage.src = "img/shape.png";*/
	 cubeVertexTextureCoordBuffer = gl.createBuffer();
	    gl.bindBuffer(gl.ARRAY_BUFFER, cubeVertexTextureCoordBuffer);
	    var textureCoords = [
	      // Front face
	      0.0, 0.0,
	      1.0, 0.0,
	      1.0, 1.0,
	      0.0, 1.0,

	      // Back face
	      1.0, 0.0,
	      1.0, 1.0,
	      0.0, 1.0,
	      0.0, 0.0,

	      // Top face
	      0.0, 1.0,
	      0.0, 0.0,
	      1.0, 0.0,
	      1.0, 1.0,

	      // Bottom face
	      1.0, 1.0,
	      0.0, 1.0,
	      0.0, 0.0,
	      1.0, 0.0,

	      // Right face
	      1.0, 0.0,
	      1.0, 1.0,
	      0.0, 1.0,
	      0.0, 0.0,

	      // Left face
	      0.0, 0.0,
	      1.0, 0.0,
	      1.0, 1.0,
	      0.0, 1.0,
	    ];
	    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(textureCoords), gl.STATIC_DRAW);
	    cubeVertexTextureCoordBuffer.itemSize = 2;
	    cubeVertexTextureCoordBuffer.numItems = 24;
}

function shadersInit() {
	shader_plasma = shaderLoad("glsl/plasma.vs", "glsl/plasma.fs");
	shader_plasma.vertexPositionAttribute = gl.getAttribLocation(shader_plasma, "aVertexPosition");
	gl.enableVertexAttribArray(shader_plasma.vertexPositionAttribute);

	shader_plasma.pMatrixUniform = gl.getUniformLocation(shader_plasma, "uPMatrix");
	shader_plasma.mvMatrixUniform = gl.getUniformLocation(shader_plasma, "uMVMatrix");
	shader_plasma.uTime = gl.getUniformLocation(shader_plasma, "time");
	shader_plasma.rand = gl.getUniformLocation(shader_plasma, "rand");
	shader_plasma.samplerUniform = gl.getUniformLocation(shader_plasma, "uSampler");
}

function handleLoadedTexture(texture) {
  gl.bindTexture(gl.TEXTURE_2D, texture);
  gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
  gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, texture.image);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
  gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
  gl.bindTexture(gl.TEXTURE_2D, null);
}

function demoMain() {
		
	function demoLoop() {
		if (demoDone) {
				return;
		}
		
		curTime = audio.currentTime;
		var deltaTime = curTime - prevTime;
		prevTime = curTime;

		//drawing starts
		shaderUse(shader_plasma);

		gl.viewport(0, 0, gl.viewportWidth, gl.viewportHeight);
    gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

    mat4.perspective(45, gl.viewportWidth / gl.viewportHeight, 0.1, 100.0, pMatrix);

    mat4.identity(mvMatrix);

//    mat4.translate(mvMatrix, [0.0, 0.0, 5.0]);

//		gl.activeTexture(gl.TEXTURE0);
//		gl.bindTexture(gl.TEXTURE_2D, pmtTexture);
		
		gl.uniform1f(currentShader.uTime, curTime);
//		gl.uniform1f(currentShader.rand, Math.random());

    gl.bindBuffer(gl.ARRAY_BUFFER, cubeVertexPositionBuffer);
    gl.vertexAttribPointer(currentShader.vertexPositionAttribute, cubeVertexPositionBuffer.itemSize, gl.FLOAT, false, 0, 0);

	  gl.activeTexture(gl.TEXTURE0);
	    gl.bindTexture(gl.TEXTURE_2D, neheTexture);
	    gl.uniform1i(currentShader.samplerUniform, 0);
	
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, cubeVertexIndexBuffer);
//    setMatrixUniforms();
   	gl.drawElements(gl.TRIANGLES, cubeVertexIndexBuffer.numItems, gl.UNSIGNED_SHORT, 0);

		document.title = curTime;
		setTimeout(demoLoop, 0);
	}

	if (demoDone) {
		audio.removeEventListener('timeupdate', demoLoop, false);

		//add what to show after demo is done hereh
		return;
	} else {
			setTimeout(demoLoop, 0);
	}
}
