
float4 PositionRect;
float4 TexCoordRect;

Texture2D Tex;
SamplerState StdSampler
{
	AddressU = CLAMP;
	AddressV = CLAMP;
	AddressW = CLAMP;
};

float2 Delta;

struct VSInput
{
	float2 Position: POSITION;
};

struct VSOutput
{
	float4 Position: SV_Position;
	float2 TexCoord: TEXCOORD;
};

VSOutput vsMain(VSInput Input)
{
	VSOutput Output;
	Output.Position = float4(Input.Position * PositionRect.zw + PositionRect.xy, 0, 1);
	Output.TexCoord = Input.Position * TexCoordRect.zw;
	Output.TexCoord.y = 1 - Output.TexCoord.y;
	Output.TexCoord += TexCoordRect.xy;
	return Output;
}

float4 psMain(VSOutput Input): SV_Target
{
	float4 c = 0;
	c += Tex.Sample(StdSampler, Input.TexCoord+Delta*3) * 0.65;
	c += Tex.Sample(StdSampler, Input.TexCoord+Delta);
	c += Tex.Sample(StdSampler, Input.TexCoord-Delta);
	c += Tex.Sample(StdSampler, Input.TexCoord-Delta*3) * 0.65;
	return c / 3.3;
}