float4x4 ViewProj;
float3 CameraPosition;
float Time;

struct VSInput
{
	float3 Position: POSITION;
	float2 TexCoord: TEXCOORD;
};

struct VSOutput
{
	float3 Normal: NORMAL;
	float4 ClipPosition: SV_POSITION;
	float2 TexCoord: TEXCOORD;
};

VSOutput vsMain(VSInput input)
{
	VSOutput output;
	output.Normal = normalize(input.Position);
	output.ClipPosition = mul(ViewProj, float4(input.Position*20.0 + CameraPosition, 1.0));
	output.TexCoord = input.TexCoord;
	return output;
}

float3 CA, CB, CC;

float2 Scale, Bias;
float GridAl, GridPow;

float4 psMain(VSOutput input): SV_TARGET
{
	float2 tc = input.TexCoord;
	
	float3 norm = normalize(input.Normal);
	float2 nx = normalize(input.Normal.xy);
	
	tc.x = acos(nx.x) / (2.0*3.14159285);
	if (nx.y < 0.0) tc.x = 1.0 - tc.x;
	
	tc.y = asin(norm.z) / 3.14159285 + 0.5;


	// GRADIENT

	float3 c = float3(tc.xy, 0.0);

	float a = saturate((tc.y - 0.5) * (1.0 / 0.5));
	float b = saturate((-(tc.y - 0.5)) * (1.0 / 0.5));

	c = CA * a + CB * b + CC * (1.0 - (a + b));
	//c = float3(a, b, 1.0 - (a + b));
	//c = float3(0,0,0);

	//c = float3(0,0,0);



	// GRID

	//input.TexCoord.y += Time*0.1;
		
	float2 o = tc.xy * float2(1.0, 9.0 / 16.0) * Scale + Bias, f;

	float i = sin(Time*0.1);
	float ii = 1.0 - i;

	f.x = (sin(o.x * 3.14159285 * i) + cos(o.y * 3.14159285 * ii)) * 0.25;
	f.y = (sin(o.y * 3.14159285 * ii) + cos(o.x * 3.14159285 * i)) * 0.25;

	f = o * 4.0;

	float g = 0.0;
	float m = 2.0;

	for (int i = 0; i < 4; i++)
	{
		g += saturate(pow((sin(f.x * 3.14159285 * m)-0.2), GridPow));
		g += saturate(pow((sin(f.y * 3.14159285 * m)-0.2), GridPow));
		m *= 5.0;
	}

	g = saturate(g * (1.0 / 1.0)) * GridAl;



	// RESULT

	return float4(c.xyz + g.xxx, 1.0);
}
