#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;
uniform mat4 TextureMatrix;

in vec2 POSITION;

out vec4 extinction;
out vec3 inscatter;
out vec2 uv;
out vec2 uv2;
out vec2 uv3;
out vec3 eyeDir;
out vec3 lightDir;
out vec4 shadow_coord;

#include <gerstner_wave_model_include.vert>

#include <atmosphere_model_include.vert>

void main()
{
	vec4 pos;
	vec3 t, b, n;
	//calculateGerstnerVertexTBN(POSITION, pos, t, b, n);
	//pos.xz += EyePosition.xz;

	calculateGerstnerVertexTBN(POSITION + EyePosition.xz, pos, t, b, n);
	//pos.xz += EyePosition.xz;

	calculateGroundAtmosphere(pos.xyz, n, extinction, inscatter);

	vec3 ld = ViewNormalMatrix * SunDirection;
	lightDir.x = dot(ld, t);
	lightDir.y = dot(ld, b);
	lightDir.z = dot(ld, n);

	vec3 eye = -vec3(ModelViewMatrix * pos);
	eyeDir.x = dot(eye, t);
	eyeDir.y = dot(eye, b);
	eyeDir.z = dot(eye, n);

	float angle = (pos.x + pos.z + GerstnerTime)*0.01;
	vec2 uv_offs = vec2(sin(angle), cos(angle));
	uv = pos.xz*(1.0/5.0) + uv_offs;
	uv2 = uv + pos.yy*(1.0/10.0) + uv_offs;
	uv3 = pos.xz*(1.0/10.0);

	shadow_coord = TextureMatrix * pos;
	gl_Position = ModelViewProjectionMatrix * pos;
}
