#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D dof_buffer;
uniform sampler2D ssao_buffer;
uniform sampler2D glow_buffer;
uniform sampler2D depth_buffer;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <blit_include.frag>

#include <dof_include.frag>

void main()
{
	vec2 uv2 = distort_uv(uv);

	vec4 c0 = textureLod(color_buffer, uv2, 0.0);
	vec4 c1 = textureLod(dof_buffer, uv2, 0.0);
	float z = texture2D(depth_buffer, uv2).x;
	vec4 s = texture2D(ssao_buffer, uv2);
	vec4 g = texture2D(glow_buffer, uv2);

	float coc = circleOfConfusion(z);

	vec3 c = (c0.rgb + s.rgb)*s.a*(1.0 - coc) + c1.rgb*coc + g.rgb*(1.5 - coc);

	frag_color = color_lookup(vec4(c, 1.0));
}
