#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bump;

in vec3 eyeDir;
in vec3 lightDir;
in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <shading_models/oren_nayar_model_include.frag>

void main()
{
	vec3 ld = normalize(lightDir);
	vec3 ed = normalize(eyeDir);
	vec3 n = normalize(texture(bump, uv).xyz*2.0 - vec3(1.0));

	vec3 terms = calculate_oren_nayar_model(n, ld, ed, 0.3, 32.0);

	vec4 diff = texture(diffuse, uv);
	vec4 spec = texture(specular, uv);
	frag_color = diff*terms.x + spec*terms.y + diff*pow(1.0 - terms.x, 16.0)*0.2;
}
