#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
//uniform mat4 ViewMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;
in vec4 TANGENT;

out vec3 eyeDir;
out vec3 lightDir;
out vec2 uv;

#include <atmosphere_model_include.vert>

void main()
{
	//vec3 sp = vec3(ModelViewMatrix * vec4(SunPosition, 1.0));
	//vec3 p = vec3(ModelViewMatrix * vec4(POSITION, 1.0));

	vec3 n = normalize(NormalMatrix * NORMAL);
	vec3 t = normalize(NormalMatrix * TANGENT.xyz);
	vec3 b = normalize(cross(t, n));// * TANGENT.w);

	//vec3 ld = sp - p;
	vec3 ld = ViewNormalMatrix * SunDirection;
	//vec3 ld = vec3(0.0, 0.0, 1.0);
	lightDir.x = dot(ld, t);
	lightDir.y = dot(ld, b);
	lightDir.z = dot(ld, n);

	vec3 eye = -vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	eyeDir.x = dot(eye, t);
	eyeDir.y = dot(eye, b);
	eyeDir.z = dot(eye, n);

	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
