#version 330 core

uniform sampler2D depth_buffer;
uniform sampler2D rotate;

uniform vec4 CameraRange; // near, far, (far - near), far*near
uniform vec2 ScreenSize;
uniform float radius;
uniform float attBias;
uniform float attScale;
uniform float depthScale;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

float rand(vec2 co)
{
	return 0.5 + (fract(sin(dot(co.xy, vec2(12.9898, 78.233)))* 43758.5453))*0.5;
}

float conv_depth( in float z )
{
	return CameraRange.w / (z*CameraRange.z - CameraRange.y);
}

void main(void)
{
#if 0
    vec4 rndTable[8] = vec4[8](
        vec4 ( -0.5, -0.5, -0.5, 0.0 ), vec4 (-0.5, -0.5, -0.5, 0.0), 
        vec4 (  0.5, -0.5, -0.5, 0.0 ), vec4 (0.5, -0.5, -0.5, 0.0), 
        vec4 ( -0.5,  0.5, -0.5, 0.0 ), vec4 (-0.5, 0.5, -0.5, 0.0), 
        vec4 (  0.5,  0.5, -0.5, 0.0 ), vec4 (0.5, 0.5, -0.5, 0.0)
    );
#else
    vec4 rndTable[8] = vec4[8](
    vec4(0.527837, -0.085868 ,0.527837, 0.0),
    vec4(-0.040088, 0.536087, -0.040088, 0.0),
    vec4(-0.670445, -0.179949, -0.670445, 0.0),
    vec4(-0.419418, -0.616039, -0.419418, 0.0),
    vec4(0.440453, -0.639399, 0.440453, 0.0),
    vec4(-0.757088, 0.349334, -0.757088, 0.0),
    vec4(0.574619, 0.685879,0.574619, 0.0),
    vec4(0.03851, -0.939059, 0.03851, 0.0)
    );
#endif

    float zb = texture(depth_buffer, uv).x;
    float z = conv_depth(zb);
    float att = 0.0;
    vec3 plane = normalize( texture(rotate, uv*ScreenSize*(1.0/4.0)).xyz*2.0 - vec3(1.0) );

    float r_div_z = radius / z;
    for (int i=0; i < 8; i++)
    {
        vec3 sample = normalize( reflect(rndTable[i].xyz, plane) );
        float zs = conv_depth( texture(depth_buffer, uv + sample.xy*r_div_z*rand(uv)).x );
        float dist = max(zs-z, 0.0) / depthScale;
        float occ = 30.0*max(dist*(2.0 - dist), 0.0);
        att += 1.0 / (1.0 + occ*occ);
    }
    att = pow( clamp( att/8.0 + 0.45, 0.0, 1.0)*attScale, attBias);

    frag_color = vec4(0.0, 0.0, 0.0, att);
    //frag_color = vec4(att);
}
