#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec4 extinction;
out vec3 inscatter;
out vec3 eyeDir;
out vec3 lightDir;
out vec3 normal;
out vec2 uv;

#include <atmosphere_model_include.vert>

void main()
{
	const float bulgeRadius = 1.0/5.0;

	vec3 pos = POSITION;
	float offset = pos.y + time;
	float bulge = mod(offset, 4.0)*0.25;
	float len = abs(TEXCOORD.y - bulge);
	if ( len < bulgeRadius )
	{
		float r = smoothstep(0.0, 0.3, TEXCOORD.y) - smoothstep(0.7, 1.0, TEXCOORD.y);
		float att = 1.0 - (len/bulgeRadius);
		pos += NORMAL*sin(att*1.57)*r*0.05;
	}

	float vr = smoothstep(0.4, 1.0, TEXCOORD.y)*0.1;
	pos.x += sin(time + pos.z*1.57)*vr;
	pos.z += cos(time + pos.x*1.57)*vr;

	float k = smoothstep(0.0, 1.0, (time-320.0)/(336.0 - 320.0));
	pos.y += -1.5 + k*1.5;

	calculateGroundAtmosphere(pos, NORMAL, extinction, inscatter);

	eyeDir = -vec3(ModelViewMatrix * vec4(pos, 1.0));
	lightDir = ViewNormalMatrix * SunDirection;
	normal = NormalMatrix * NORMAL;
	uv = TEXCOORD*vec2(1.0, 8.0);
	gl_Position = ModelViewProjectionMatrix * vec4(pos, 1.0);
}
