#version 330 core

uniform sampler2D diffuse;
uniform vec3 distortParams; // // freq, time, amount

in vec3 eyeDir;
in vec3 lightDir;
in vec3 normal;
in vec3 uv_alpha;

layout (location = 0) out vec4 frag_color;

#include <shading_models/oren_nayar_model_include.frag>

vec2 distort_uv(in vec2 uv)
{
	vec2 offs;

	offs.x = (sin(uv.y*3.14*distortParams.x + 3.14*distortParams.y)*2.0 - 1.0)*distortParams.z;
	offs.y = (sin(uv.x*3.14*distortParams.x + 3.14*distortParams.y)*2.0 - 1.0)*distortParams.z;

	return uv + offs;
}

void main()
{
	vec2 uv = distort_uv(uv_alpha.xy);

	vec3 ed = normalize(eyeDir);
	vec3 ld = normalize(lightDir);
	vec3 n = normalize(normal);

	vec3 terms = calculate_oren_nayar_model_abs(n, ld, ed, 0.3, 8.0);
	vec4 diff = texture(diffuse, uv)*uv_alpha.z;
	frag_color = diff*terms.x + diff*terms.y;
}
