#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform mat3 ViewNormalMatrix;

//uniform vec3 Wind;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 uv;
out vec4 extinction;
out vec3 inscatter;
out vec3 normal;
out vec3 lightDir;
out vec3 eyeDir;

#include <atmosphere_model_include.vert>

void main()
{
	float wind_angle = EyePosition.z*0.1;
	wind_angle += sin(POSITION.y*0.25);
	float s = sin(wind_angle);
	float c = cos(wind_angle);
	vec3 wind = vec3(c-s, 0.0, s+c);
	wind *= ((POSITION.y + 5.0) / 10.0) * 0.25;

	vec3 pos = POSITION + wind;

	vec3 p = vec3(WorldMatrix * vec4(pos, 1.0));
	vec3 n = normalize(WorldNormalMatrix * NORMAL);
	calculateGroundAtmosphere(p, n, extinction, inscatter);

	normal = NormalMatrix * NORMAL;
	lightDir = ViewNormalMatrix * SunDirection;
	eyeDir = -vec3(ModelViewMatrix * vec4(pos, 1.0));

	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(pos, 1.0);
}
