#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;
uniform sampler2D foam;

in vec4 extinction;
in vec3 inscatter;
in vec2 uv;
in vec2 uv2;
in vec3 eyeDir;
in vec3 lightDir;

layout (location = 0) out vec4 frag_color;

#include <gerstner_wave_model_include.vert>

#include <atmosphere_model_include.vert>

void main()
{
	vec3 ed = normalize(eyeDir);
	vec3 ld = normalize(lightDir);
	vec3 n = normalize(texture(bumpmap, uv).xyz*2.0 - vec3(1.0));
	vec3 hv = normalize(ld + ed); //-reflect(ld, n);
	float NdotL = max(dot(ld, n), 0.0);
	float NdotHV = pow(max(dot(hv, n), 0.0), 32.0);

	vec4 diff = (texture(diffuse, uv) + texture(diffuse, uv2)) * 0.5 * (0.8 + 0.2*NdotL);
	vec4 spec = (texture(specular, uv) + texture(specular, uv2)) * 0.5 * NdotHV;
	vec4 f = (texture(foam, uv*0.5 - hv.xy*0.01) + texture(foam, uv2*0.1 - hv.xy*0.01))*0.5*pow(1.0 - NdotL, 1.5) * 2.0;

	vec4 color = diff + f;
	lightGroundAtmosphere(color, extinction, inscatter);

	frag_color = color + spec;
}
