#version 330 core

uniform sampler2D diffuse;
uniform sampler2D bumpmap;
uniform sampler2D specular;
uniform sampler2D alphamask;
uniform samplerCube env;

uniform float time;

in vec4 extinction;
in vec3 inscatter;
in vec3 normal;
in vec3 lightDir;
in vec3 eyeDir;
in vec2 uv;
in vec2 uv2;

layout (location = 0) out vec4 frag_color;

#include <atmosphere_model_include.vert>

#include <shading_models/oren_nayar_model_include.frag>

void main()
{
	float y = smoothstep(0.0, 1.0, (uv.y - time)*0.25);
	float a = texture(alphamask, vec2(uv.x, y)).r;
	if ( a < 0.1 ) discard;

	vec3 ld = normalize(lightDir);
	vec3 ed = normalize(eyeDir);
	vec3 n = normalize(texture(bumpmap, uv2).xyz*2.0 - vec3(1.0));

	vec3 terms = calculate_oren_nayar_model(n, ld, ed, 1.0, 8.0);

	vec4 diff = texture(diffuse, uv2) * texture(env, n);;
	vec4 spec = texture(specular, uv2);
	vec4 color = diff*pow(terms.x, 2.0) + spec*terms.y + diff*0.1;

	lightGroundAtmosphere(color, extinction, inscatter);

	frag_color = mix(color, vec4(0.75), 1.0 - smoothstep(0.0, 1.0, a));
}
