#include "comm.h"
#include "viz.h"
#include "sim.h"
#include "ga.h"
#include <time.h>

state current_state;

clock_t start;
clock_t stop;

class ticker_t
{
	clock_t start;
public:
	ticker_t() : start(clock()) { ; }

	void mark() { start = clock(); }
	float time() const { return float(clock()-start)/CLOCKS_PER_SEC; }

} ticker;

void give_nudge(state& s, comm& c)
{
	float sumvap = 0;
	vec2 center = vec2(0,0);
	for (auto it = s.rc.begin(); it != s.rc.end(); it++)
	{
		sumvap += it->vap;
		center += it->pos*it->vap;
	}
	center /= sumvap;
	const vec2 wind = unitlen(center-s.me.pos)*s.me.vap*0.1;
	apply_wind(s,wind);
	c.send_wind(wind);
}

const int max_sim_inc = 500;
int main(int argc, char* argv[])
{
	srand(clock());
	bool first = true;
	const float spsalpha = 0.8;
	float sps = 70;
	float tt;
	int oldturn = 0;
	float oldlooptime = 0.1;
	//state ss;
	genome g;
	generation gg;
	comm c("127.0.0.1");
	/*if (c.alive())
	{
		c.ready("MY AI");
		while (c.alive()) // simple main loop
		{
			clock_t loop_start = clock();
			state& s = current_state;
			oldturn = s.turn;

			ticker.mark();
			c.recv_state(s);
			if (!c.alive()) break;

			while (gg.about_time(s.turn-oldturn))
			{
				gene ng = 
			}
			while (!g.genes().empty() && s.turn-oldturn >= g.genes().front().wait)
			{
				c.send_wind(g.genes().front().wind);
				apply_wind(ss,g.genes().front().wind);
				g.pop_front();
				//printf("new fitness: %g\n", g.fitness());
			}
			if (first)
			{
				ss = s;
				first = false;
				start = clock();
				gg.init(25);
				stop = clock();
				//printf("init generation took %gs\n", float(stop-start)/CLOCKS_PER_SEC);
				g = gg.genomes.front();
			}
			else
			{
				int gc = 1;
				sps = sps*spsalpha + (1-spsalpha)*(s.turn-oldturn)/oldlooptime;
				//printf("sps: %g (%d/%g)\n", sps, s.turn-oldturn, oldlooptime);
				start = clock();
				gg.next(s.turn-oldturn);
				g = gg.genomes.front();
				tt = float(clock() - start)/CLOCKS_PER_SEC;
				while (!gg.about_time(sps*tt) && tt < 0.1)
				{
					gg.next(0);
					g = gg.genomes.front();
					tt = float(clock() - start)/CLOCKS_PER_SEC;
					gc++;
				}
				stop = clock();
				printf("next %d generations took %3gs - time till next move: %3gs\n", gc, float(stop-start)/CLOCKS_PER_SEC,
					g.genes().front().wait/sps - tt);
				ss = look_ahead(ss,s.turn-ss.turn);
			}


			ready_buffer();
			draw_state(s);
			//draw_state(ss);
			draw_generation(gg);
			show_buffer();

			// insert stuff here to do the boogie
			//c.send_wind(vec2(10,10)); 

			while (gg.about_time(sps*tt))
			{	
				printf("BLOW!\n");
				gene ng = gg.pop_solv();
				tt -= ng.wait/sps;
				//apply_wind(ss,g.ng.wind);
				c.send_wind(ng.wind);
			}
			int sleep = 110-((clock()-loop_start)*1000.0)/CLOCKS_PER_SEC;
			//printf("sleeping %d ms\n", sleep);
			if (sleep > 0)
				Sleep( sleep );
			oldlooptime = float(clock()-loop_start)/CLOCKS_PER_SEC;
		}
	}*/

	state s;
	state ss;
	sim_max_turn = max_sim_inc;
	if (c.alive())
	{
		c.ready("CREEPO");
		ticker.mark();
		c.recv_state(s);
		give_nudge(s,c);
		current_state = s;
		gg.init(35);
	}
	int dt = 0;
	while (c.alive())
	{
		int gc = 0;
		while (ticker.time() < 0.105)
		{
			if (current_state.win || current_state.lose)
				return 0;
			gg.next(dt); dt = 0; gc++;
			genome solv = gg.genomes.front();
			//if (solv.fitness() < 0)
			//	printf("OOP! ");
			int st = ticker.time()*sps - (current_state.turn - s.turn);
			while (solv.about_time(st))
			{
				const gene& ng = solv.genes().front();
				//printf("[%03d/%03d] BLOW! (%g)\n", st+current_state.turn, current_state.turn+ng.wait, gg.genomes.front().fitness());
				c.send_wind(ng.wind);
				current_state = look_ahead(current_state, ng.wait);
				sim_max_turn = current_state.turn+max_sim_inc;
				apply_wind(current_state, ng.wind);
				dt += ng.wait;
				st -= ng.wait;
				solv.pop_front();
			}
			//c.recv_state(s);
		}
		//printf("%d generations in %gs\n", gc, ticker.time());


		sps = sps*spsalpha + (1-spsalpha)*(s.turn-oldturn)/ticker.time(); oldturn = s.turn;
		ticker.mark();
		c.recv_state(s);
		//s.turn += 10;
		ss = look_ahead(current_state, s.turn - current_state.turn);

#ifdef _SAVE_PATH
		ready_buffer();
		draw_state(s);
		//draw_state(ss);
		draw_generation(gg);
		show_buffer();
#endif

		if (!ss.playersequal(s,5) || (s.turn-current_state.turn)/sps > 1.5)
		{
			//printf("SYNC!\n");
			dt += s.turn - current_state.turn;
			current_state = s;
			sim_max_turn = current_state.turn+max_sim_inc;
		}
	}
	//Sleep(4000);
	return 0;
}

