#ifndef _GA_
#define _GA_

//#define _SAVE_PATH

#include "sim.h"
#include <vector>
#include <list>

using std::vector;
using std::list;

typedef unsigned int uint;

class gene
{
public:
	int  wait;
	vec2 wind;

	static gene random(int min_delay);

	gene(int wait, const vec2& wind) : wait(wait), wind(wind) { ; }
};

class genome
{
	mutable float _fitness;
	mutable int   _ts;
	vector<gene>  _genes;
public:
#ifdef _SAVE_PATH
	mutable vector<vec2> path;
#endif
	static genome random();
	genome(const genome& g) : _fitness(-1), _ts(-1), _genes(g._genes) { ; }
	genome() : _fitness(-1), _ts(-1), _genes() { _genes.reserve(8); }

	const vector<gene>& genes() const { return _genes; }
	void cut_front(int steps);
	void pop_front() { _genes.erase(_genes.begin()); _fitness = -1; } 
	float fitness() const { if (_fitness < 0) return fitness_recalc(); else return _fitness; }
	float fitness_recalc() const;

	bool about_time(int toff) const { return !_genes.empty() && _genes.front().wait < toff; }

	bool operator<(const genome& gb) const { return fitness() < gb.fitness(); }

	float distance(const genome& gb) const;

	genome cross_with(const genome& gb) const;
	genome& mutate();
	friend class generation;
};

typedef std::list<genome> genomel;

class generation
{
	genome solv;
	int solvi;
	void set_solv(const genome& s) { solv = s; solvi = 0; }
public:
	generation()  { ; }
	generation(const generation& prev_g, const float dt);

	genomel genomes;

	void init(int pop);
	void next(uint dt); 


	//bool about_time(int toff) const { return solv._genes.size() > solvi && solv._genes[solvi].wait < toff+2; }
	/*gene pop_solv() 
	{ 
		if (!about_time())
			return gene(0,vec2(0,0));
		if (solv._genes.size() > solvi+1)
			solv._genes[solvi+1].wait -= solv._genes[solvi].wait;
		return solv._genes[solvi++]; // actively using operator++ funkyness
	}*/
};

#endif