#ifndef __STATE_H
#define __STATE_H

#include <list>
#include <vector>
using std::list;
using std::vector;
#include "vecmath.h"

class cloud
{
public:
	vec2 pos;
	vec2 vel;
	float vap;
	cloud() : pos(), vel(), vap(0) { ; }
	cloud(vec2 pos, vec2 vel, float vap) : pos(pos), vel(vel), vap(vap) { ; }
};

class state
{
public:
	state() : max_speed(10), min_dist(30), win(false), lose(false) { ; };
	int turn;
	cloud me;
	list<cloud> tc;
	list<cloud> rc;
	float max_speed;
	float min_dist;
	bool win;
	bool lose;

	bool playersequal(const state& sb, float margin) const
	{
		if ( length(me.pos-sb.me.pos) > margin ) 
			return false;
		if (tc.size() != sb.tc.size())
			return false;
		auto it = tc.begin();
		auto jt = sb.tc.begin();
		for ( ; it != tc.end() && jt != sb.tc.end(); it++, jt++)
			if (length(it->pos - jt->pos) > margin)
				return false;
		return true;
	}
};

extern state current_state;

#endif