#ifndef __VECMATH_H
#define __VECMATH_H

#include <math.h>

class vec2
{
public:
	union
	{
		float v[2];
		struct
		{
			float x;
			float y;
		};
	};
	vec2() { ; }
	vec2(float x, float y) : x(x), y(y) { ; }
	inline vec2(const vec2& a);

	inline vec2& operator+=(const vec2& b);
	inline vec2& operator-=(const vec2& b);
	
	inline vec2& operator*=(float c);
	inline vec2& operator/=(float c);

	inline float square() const;
	inline float length() const;
	inline vec2& normalize();
	inline vec2 norm() const;
};
inline __m128 _loadl(const float* d)
{
	//__m128 ra = _mm_load_ss(d);
	//__m128 rb = _mm_load_ss(d+1);
	//return _mm_unpacklo_ps(ra,rb);
	return _mm_loadu_ps(d);
}
inline void _storel(float* d, __m128 r)
{
	_mm_store_ss(d,r);
	r = _mm_shuffle_ps(r,r,_MM_SHUFFLE(3,2,0,1));
	_mm_store_ss(d+1,r);
}
inline vec2::vec2(const vec2& a) : x(a.x),y(a.y) { ; }
//{
//	__m128 ra;
//	_mm_storel_pi((__m64*)this, _mm_loadl_pi(ra,(__m64*)&a));
//}
inline vec2& vec2::operator+=(const vec2& b)
{
	__m128 ra = _loadl(v);
	__m128 rb = _loadl(b.v);
	//ra = _mm_loadu_ps(v);
	//rb = _mm_loadu_ps(b.v);
	ra = _mm_add_ps(ra, rb);
	_storel(v,ra);
	//_mm_storel_pi((__m64*)this,ra);
	return *this;
}
inline vec2& vec2::operator-=(const vec2& b)
{
	__m128 ra = _loadl(v);
	__m128 rb = _loadl(b.v);
	ra = _mm_sub_ps(ra, rb);
	_mm_storel_pi((__m64*)this,ra);
	return *this;
}
inline vec2& vec2::operator*=(float c)
{
	__m128 ra = _loadl(v);
	__m128 rb = _mm_set1_ps(c);
	//ra = _mm_loadl_pi(ra,(__m64*)this);
	ra = _mm_mul_ps(ra,rb);
	_storel(v,ra);
	//_mm_storel_pi((__m64*)this,ra);
	return *this;
}
inline vec2& vec2::operator/=(float c)
{
	__m128 ra;
	__m128 rb = _mm_set1_ps(c);
	ra = _mm_loadl_pi(ra,(__m64*)this);
	ra = _mm_div_ps(ra,rb);
	_mm_storel_pi((__m64*)this,ra);
	return *this;
}
inline float vec2::square() const
{
	float result;
	__m128 ra, rb;
	ra = _loadl(v);
	ra = _mm_mul_ps(ra,ra);
	rb = _mm_shuffle_ps(ra,ra,_MM_SHUFFLE(3,2,0,1));
	ra = _mm_add_ss(ra,rb);
	_mm_store_ss(&result, ra);
	return result;
}
inline float vec2::length() const { return sqrt(square()); }

inline vec2 operator+(const vec2& a, const vec2& b) 
{
	vec2 result = a;
	result += b;
	return result;
}
inline vec2 operator-(const vec2& a, const vec2& b) 
{ 
	vec2 result = a;
	result -= b;
	return result;
}
inline vec2 operator*(const vec2& a, float c) 
{ 
	return vec2(a) *= c; 
}
inline vec2 operator*(float c, const vec2& a) { return a*c; }
inline vec2 operator/(const vec2& a, float c) { return vec2(a.x/c, a.y/c); }
vec2 vec2::norm() const { return (*this)/length(); }

#endif