#include "viz.h"
#include <Windows.h>
#include <gl/GL.h>

#pragma comment(lib,"opengl32.lib")

class window
{
	HDC hDC;
	HWND hwnd;
public:
	const int w;
	const int h;
	window(int w, int h);
	void swap_buffers() { SwapBuffers(hDC); }
};

window::window(int w, int h) : w(w), h(h)
{
	PIXELFORMATDESCRIPTOR pfd;
	hwnd = CreateWindow("button", NULL, WS_POPUP | WS_VISIBLE/* | WS_MAXIMIZE*/, 1500,0, w,h, NULL,NULL,NULL,NULL);
	hDC = GetDC(hwnd);
	//ShowCursor(false);
	pfd.cColorBits = pfd.cDepthBits = 32;
	pfd.dwFlags = PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
	SetPixelFormat(hDC,ChoosePixelFormat(hDC,&pfd),&pfd);
	wglMakeCurrent(hDC,wglCreateContext(hDC));
	ShowCursor(FALSE);
	//glViewport(0,0,winw,winh);
}
window win(1280,720);//(640,360);

void ready_buffer() { glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); }
void show_buffer() { win.swap_buffers(); }
const double PI2 = atan(1.0)*8;
void draw_circle(const vec2& center, float radius)
{
	glPushMatrix();
	glTranslatef(center.x,center.y,0);
	glBegin(GL_LINE_LOOP);
	for (int i = 0; i < 16; i++)
		glVertex2f(radius*cos(i*PI2/16), radius*sin(i*PI2/16));
	glEnd();
	glPopMatrix();
}
void draw_arrow(const vec2& center, const vec2& dir)
{
	glPushMatrix();
	glTranslatef(center.x,center.y,0);
	const vec2 t(-dir.y, dir.x);
	const vec2 arm1 = dir*0.8 + t*0.2;
	const vec2 arm2 = dir*0.8 - t*0.2;
	glBegin(GL_LINES);
	glVertex2f(0,0);
	glVertex2f(dir.x,dir.y);
	glVertex2f(arm1.x,arm1.y);
	glVertex2f(dir.x,dir.y);
	glVertex2f(arm2.x,arm2.y);
	glVertex2f(dir.x,dir.y);
	glEnd();
	glPopMatrix();
}
void draw_state(const state& s)
{
	int c = 0;
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0,1279,719,0,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glBlendFunc(GL_ONE, GL_ONE);
	glEnable(GL_BLEND);

	glColor3f(.2,.2,.7);
	draw_circle(s.me.pos, sqrt(s.me.vap));
	draw_arrow(s.me.pos, s.me.vel);

	glColor3f(.7,.2,.2);
	for (auto it = s.tc.begin(); it != s.tc.end(); it++)
	{
		draw_circle(it->pos, sqrt(it->vap));
		draw_arrow(it->pos, it->vel);
		c++;
	}

	glColor3f(.6,.6,.6);
	for (auto it = s.rc.begin(); it != s.rc.end(); it++)
	{
		draw_circle(it->pos, sqrt(it->vap));
		draw_arrow(it->pos, it->vel);
		c++;
	}
}

void draw_generation(const generation& g)
{
#ifdef _SAVE_PATH
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0,1279,719,0,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glBlendFunc(GL_ONE, GL_ONE);
	glEnable(GL_BLEND);

	for (auto it = g.genomes.begin(); it != g.genomes.end(); it++)
	{
		if (it == g.genomes.begin())
			glColor3f(0,0,1);
		else
			glColor3f(0.2,0.2,0);
		glBegin(GL_LINE_STRIP);
		float len = 0;
		for (int j = 0; j < it->path.size(); j++)
		{
			if (j > 0) len += length(it->path[j]-it->path[j-1]);
			if (len > 1000)
				len = 1000;
			glColor3f(0.2*(1 - len/2000), 0.2*(0.5 + len/2000), 0);
			glVertex2f(it->path[j].x, it->path[j].y);
		}
		glEnd();
		len = 0;
		for (int j = 0; j < it->path.size(); j++)
		{
			if (j > 0) len += length(it->path[j]-it->path[j-1]);
			if (len > 1000)
				len = 1000;
			glColor3f(0.2*(1 - len/2000), 0.2*(0.5 + len/2000), 0);
			draw_circle(it->path[j], 3);
		}
	}
#endif
}
