import java.io.IOException;
import java.util.ArrayList;

// By Marti Minoves Farres
// The Gathering 2011

// Contact: www.aldeaglobal.net/mail.php


// Algorithm Description
// We try to maximize: (the vapor - the cost to reach there)  = maximum profit of the action

public class MyAi extends Client {

    public MyAi() throws IOException, InterruptedException {
        super();
    }

    
    public static float getDistance(Vector v1, Vector v2) {
     
     float x = v2.x - v1.x;
     float y = v2.y - v1.y;
             
     return (float) Math.sqrt(x*x + y*y);
 } 
 
 public static float score1b(Cloud c, Cloud me)
   {
      Vector difpos = new Vector (c.Position.x-me.Position.x, c.Position.y-me.Position.y);
      float possc = (c.Velocity.x*me.Velocity.x + c.Velocity.y*me.Velocity.y);
      float res = possc*(difpos.x*me.Velocity.x+difpos.y*me.Velocity.y);
      return res;
   }
 
 public static Vector propagation(Cloud c, float timeEstimation)
 {
	 
     return new Vector(c.Position.x + timeEstimation*c.Velocity.x, c.Position.y + timeEstimation*c.Velocity.y);
  
 }
 
 
 
 public static float incVelocity(Cloud c, Cloud me)
 {
    float dist1 = getDistance(me.Position , c.Position);

    Vector me2pos = propagation (me,1);
    Vector c2pos = propagation (c,1);
    
    float dist2 = getDistance(me2pos , c2pos);

    return - (dist2 - dist1) ;
 }
 
 
 public static float score1(Cloud c, Cloud me)
 {
    return  (incVelocity(c,me)) * c.Vapor;
 }
 
 
 public static float score2(Cloud c, Vector ms)
 {
    return c.Vapor / getDistance(new Vector(c.Position.x, c.Position.y), ms);
 }

   public static Cloud getTarget(GameState st, Vector massCenter)
   {
	   float consuption = 10;
       ArrayList<Cloud> others = getOthers(st);
       float maxScore = - Float.MAX_VALUE;
       Cloud target = null;
       for (int i=0; i < others.size(); i++)
         {
           if (others.get(i).Vapor + consuption < st.Me().Vapor)
             {
        	   
               float sc = score1(others.get(i),st.Me());
               if (maxScore < sc)
                 {
                   maxScore = sc;
                   target = others.get(i);
                 }
             }
         }
       
       if (Math.sqrt(st.Me().Velocity.x * st.Me().Velocity.x + st.Me().Velocity.y * st.Me().Velocity.y) < 0.01)
         {
    	   System.out.println("Center of masses algorithm!");
           // We use the center of masses algorithm
           maxScore = 0;
           target = null;
           for (int i=0; i<others.size(); i++)
             {
               if (others.get(i).Vapor < st.Me().Vapor)
                 {
                   float sc = score2(others.get(i),massCenter);
                   if (maxScore < sc)
                     {
                	   maxScore = sc;
                       target = others.get(i);
                     }
                 }
             }
         }
       
       System.out.println("Target - Vapor:" + target.Vapor +  " Pos:"+ target.Position.x + "," + target.Position.x );
       
       return target;
   }
    
    
    public void nextMovement(GameState state) throws IOException
    {
        float xFactor = (float) 0.08;
        float yFactor = (float) 0.08;
        
        Vector massCenter = getMassCenter(state);
        System.out.println(massCenter.x);
        System.out.println(massCenter.y);
        
        Cloud target = getTarget(state, massCenter);
        
        
        //float timeEstimation = (float) 0.02 * getDistance(state.Me().Position, target.Position) * incVelocity(target,state.Me());
        float timeEstimation = (float) 10; 
        
        System.out.println("timeEstimation: " + timeEstimation + " incVelocity: " + incVelocity(target,state.Me()) + " Velocity: "+ target.Velocity.x + "," + target.Velocity.y);
       
        Vector targetEstimation = new Vector(0,0);
        // P(t) = Pinicial + v*t
        targetEstimation.x = target.Position.x + (target.Velocity.x * timeEstimation);
        targetEstimation.y = target.Position.y + (target.Velocity.y * timeEstimation);
        
        Vector myPosition = state.Me().Position;
        Wind(xFactor * (targetEstimation.x - myPosition.x) , yFactor * (targetEstimation.y - myPosition.y)); 
        
    }
    
 
    public void waitControl(GameState state, int timeWait) throws IOException, InterruptedException
    {
    	for (int i = 0; i < timeWait; i++)
    	{   state = GetState();
    		if (agentSecurity(state))
        	Thread.sleep(100);
    	}
    }
    
    public boolean agentSecurity(GameState st) throws IOException, InterruptedException
    {
        float xFactor = (float) 0.1;
        float yFactor = (float) 0.1;
        
        ArrayList<Cloud> others = getOthers(st);
        float myMass = st.Me().Vapor;

        
        for (int i=0; i<others.size(); i++)
           if (myMass < others.get(i).Vapor)
             {
           
            	float distCollision = getDistance(propagation(st.Me(),1), propagation(others.get(i),1)) - st.Me().Radius() - others.get(i).Radius();
            	

                
            	
            	float incVel = incVelocity(st.Me(),others.get(i));
            	if (incVel > 0)
            	{
                	//if(getDistance(st.Me().Position,others.get(i).Position) < 200)
                		//System.out.println("***** distCollision1:" + getDistance(st.Me().Position,others.get(i).Position) + " incVel:" + incVel);
	            	//if( distCollision < 100)
	            		//System.out.println("***** distCollision2:" + distCollision +  " getDist:" + getDistance(propagation(st.Me(),1), propagation(others.get(i),1)));
	            	if( distCollision < 20)
	            	{   System.out.println("***** SAFETY MANOUVER !!");
	            	
	            	   float difY = others.get(i).Position.y - st.Me().Position.y;
	            	   float difX = others.get(i).Position.x - st.Me().Position.x;
	            	   
	            	   //90 degrees= (-y,x) or (y,-x)
	            	   Wind( - yFactor * incVel * difY, xFactor * incVel * difX ); 
		            	
		                
		            	Thread.sleep(300);
		            	return false;
	            	}
            	}
            		
             }

    	return true;
    	
    }
    
    
    // Implement your AI here
    // Use these functions to communicate with server:
    //    SetName(name) - Sets your name to appear in the simulator
    //    GetState() - returns the current GameState object
    //    Wind(x, y) - applies a wind in the given direction (returns true if OK, false if IGNORED)
    @Override
    public void RunAi() throws IOException, InterruptedException {
        SetName("SmartAI");

        Cloud jo;
        GameState state;
       
        state = GetState();
        Vector massCenter = getMassCenter(state);
        jo = state.Me();
        
        if (agentSecurity(state))
        {
	        if (jo.Position.y < massCenter.y)
	        {
	            Wind((float) 0, (float) 100);
	        }
	        else
	        {
	            Wind((float) 0, (float) -100); 
	        }
	        waitControl(state, 5);
        }
        
        
        
        for (int i = 0; (i < 10) && Connected(); i++)
        {
            // Poll the game state
            state = GetState();
            if (state == null) break;

            // Ignore game state and do something random!
            // Wind((float) Math.random() * 25 - 50, (float) Math.random() * 25 - 50);

             jo = state.Me();
            //int joIndex = state.MeIndex;
            
            //int oponentIndex = 1 - joIndex;
            //Cloud oponent = state.Thunderstorms.get(oponentIndex);
            
 
            if (agentSecurity(state)){	
	            if (jo.Velocity.y > 0)
	            {
	                Wind((float) 0, (float) 120);
	            }
	            else
	            {
	                Wind((float) 0, (float) -120);
	                
	            }
	            waitControl(state, 6);
            }
            
            
        }
    

        waitControl(state, 24);
	    
	
	    while (Connected()) {
	        // Poll the game state
	        state = GetState();
	        if (state == null) break;
	
	        if (agentSecurity(state))
	        	nextMovement(state);
	        
	        waitControl(state, 20);
	        
	        if (state.Me().Vapor > 2000)
	        {	
	        	waitControl(state, 50);

	        }
	        
	        if (state.Me().Vapor > 2500)
	        {	
	        	waitControl(state, 50);

	        }
	        
	        	
	    }
	}   
    
    
    
    public static ArrayList<Cloud> getOthers(GameState st)
    {
      ArrayList<Cloud> others = new ArrayList<Cloud>(st.Rainclouds);
      if(st.Thunderstorms.size()>1)
    	  for(int i = 0 ; i < st.Thunderstorms.size();i++)
    	  {  if(i != st.MeIndex)
    		  others.add(st.Thunderstorms.get(i));
    	  }
        
      return others;
    }

  public static Vector getMassCenter(GameState st)
  {
      ArrayList<Cloud> others = getOthers(st);
      float myMass = st.Me().Vapor;
      float allMass = 0;
      float x = 0;
      float y = 0;
      
      for (int i=0; i<others.size(); i++)
         if (myMass > others.get(i).Vapor)
           {
             x += others.get(i).Position.x * others.get(i).Vapor;
             y += others.get(i).Position.y * others.get(i).Vapor;             
             allMass += others.get(i).Vapor;
           }
      
      return new Vector(x/allMass, y/allMass);
  } 
    
    
    
    
    
    public static void main(String[] args) {
        try {
            MyAi ai = new MyAi();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

} 