/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;

public class MyAi
extends Client {
    long lastPoll = new Date().getTime();
    long lastIteration = 0L;
    GameState state;
    int noSpeeds;
    int timePerMove;
    int fps = 60;
    int firstFive = 5;
    int INITIAL_MAX_ITERATIONS = 350;
    int MAX_ITERATIONS = 350;

    public MyAi() throws Exception {
        this(5, 150);
    }

    public MyAi(int speeds, int time) throws Exception {
        this.noSpeeds = speeds;
        this.timePerMove = time;
        this.RunAi();
    }

    @Override
    public void RunAi() throws Exception {
        this.setName("Todde Galompen");
        while (this.Connected()) {
            boolean done;
            this.log("");
            this.log("");
            this.state = this.getState();
            long now = new Date().getTime();
            if ((long)this.state.iteration - this.lastIteration > 0L) {
                this.fps = (int)(((double)this.state.iteration * 1.0 - (double)this.lastIteration * 1.0) * 1000.0 / (double)(now - this.lastPoll));
            }
            this.lastIteration = this.state.iteration;
            this.lastPoll = now;
            if (this.state == null) break;
            if (this.state.rainclouds.size() < 1 && this.state.thunderstorms.size() < 2) {
                this.log("VICTORY MODE! AAAAAAAWWW YYYYEEEEAAAAAHH!");
                this.disconnect();
                continue;
            }
            this.log("My vapor is currently " + this.state.me().vapor);
            double n = (double)(this.fps * this.timePerMove) / 1000.0;
            this.log("Simulating " + n + " iterations, the simulator should receive the wind at iteration " + (n + (double)this.state.iteration));
            long availableTime = (long)((double)this.timePerMove * (Math.floor(n) / n));
            this.log("Available time: " + availableTime);
            int i = 0;
            while ((double)i < n) {
                this.state.iterate();
                ++i;
            }
            Result bestResult = new Result(this.state.me().vapor, this.state);
            if (this.state.imDead) {
                this.log("GOING TO DIE!");
                bestResult = new Result(0.0, this.state);
            }
            bestResult.xVal = 0.0;
            bestResult.yVal = 0.0;
            this.log("Vapor " + bestResult.vapor + " with no movement and " + this.fps + " fps");
            double max = this.state.me().vapor / 3.0;
            double min = 1.0;
            double dif = max - min;
            ArrayList<Result> results = new ArrayList<Result>();
            HashSet visited = new HashSet();
            double delta = Math.PI;
            block2: do {
                delta /= 2.0;
                double angle = 0.0;
                done = false;
                while (angle < Math.PI * 2) {
                    if (!visited.contains(angle)) {
                        double x = Math.sin(angle);
                        double y = Math.cos(angle);
                        int speed = 0;
                        while (speed < this.noSpeeds) {
                            double f = min + dif * (double)speed / (double)this.noSpeeds;
                            double xVal = (float)(f * x);
                            double yVal = (float)(f * y);
                            Result r = this.simulateWind(xVal, yVal, 0.5);
                            r.xVal = xVal;
                            r.yVal = yVal;
                            r.angle = angle;
                            r.speed = f;
                            if (r.getValue() > 0.0) {
                                results.add(r);
                            }
                            ++speed;
                        }
                    }
                    angle += delta;
                    long timeSpent = new Date().getTime() - this.lastPoll;
                    --this.firstFive;
                    if (timeSpent + (long)(this.firstFive < 0 ? 7 : 17) <= availableTime) continue;
                    done = true;
                    continue block2;
                }
            } while (!done);
            Collections.sort(results);
            int i2 = 0;
            while (i2 < results.size()) {
                if (((Result)results.get((int)i2)).vapor == 0.0) {
                    ++((Result)results.get((int)((i2 + 1 + results.size()) % results.size()))).deadNeighbours;
                    ++((Result)results.get((int)((i2 - 1 + results.size()) % results.size()))).deadNeighbours;
                    ++((Result)results.get((int)((i2 - this.noSpeeds + results.size()) % results.size()))).deadNeighbours;
                    ++((Result)results.get((int)((i2 + this.noSpeeds + results.size()) % results.size()))).deadNeighbours;
                }
                ++i2;
            }
            for (Result r : results) {
                if (!(r.getValue() > bestResult.getValue() + 0.5)) continue;
                bestResult = r;
            }
            this.log("Best result will give vapor: " + bestResult.vapor);
            long timeSpent = new Date().getTime() - this.lastPoll;
            Thread.sleep(Math.max(0L, availableTime - timeSpent));
            this.log("SPENT: " + timeSpent + " ms");
            this.log("SLEPT " + Math.max(0L, availableTime - timeSpent) + " ms!");
            if (Math.abs(bestResult.xVal) + Math.abs(bestResult.yVal) > 2.0) {
                this.wind(bestResult.xVal, bestResult.yVal);
            }
            if (bestResult.xVal == 0.0 && bestResult.yVal == 0.0) {
                this.MAX_ITERATIONS += 40;
                continue;
            }
            this.MAX_ITERATIONS = this.INITIAL_MAX_ITERATIONS;
        }
    }

    Result simulateWind(double x, double y, double availableTime) {
        GameState copy = this.state.clone();
        float str = (float)Math.sqrt(x * x + y * y);
        if ((double)str < 1.0 || (double)str > this.state.me().vapor / 2.0) {
            return new Result(0.0, copy);
        }
        Vector oldVel = copy.me().velocity;
        double radius = copy.me().radius();
        copy.me().vapor -= (double)str;
        if (copy.me().vapor < 1.0) {
            return new Result(0.0, copy);
        }
        copy.me().velocity.x += x * 5.0 / radius;
        copy.me().velocity.y += y * 5.0 / radius;
        Vector wxwy = new Vector(x / (double)str, y / (double)str);
        double newRadius = Math.sqrt(str);
        double distance = (radius + newRadius) * (double)1.1f;
        Vector pos = new Vector(copy.me().position.x - wxwy.x * distance, copy.me().position.y - wxwy.y * distance);
        Vector vel = new Vector(-(x / (double)str) * 20.0 + oldVel.x, -(y / (double)str) * 20.0 + oldVel.y);
        copy.rainclouds.add(new Cloud(pos.x, pos.y, vel.x, vel.y, str, false));
        long start = new Date().getTime();
        int c = 0;
        while ((double)(new Date().getTime() - start) < availableTime && c < this.MAX_ITERATIONS) {
            copy.iterate();
            ++c;
        }
        double val = copy.me().vapor;
        Result r = new Result(val, copy);
        r.startVapor = this.state.me().vapor;
        if (copy.imDead) {
            r.vapor = 0.0;
        }
        return r;
    }

    public void log(String msg) {
    }

    public static void main(String[] args) {
        try {
            new MyAi(5, 150);
        }
        catch (Exception e) {
            System.err.println("FFFFFFFUUUUUUUUU");
        }
    }
}

