import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;

public abstract class Client {

	private Socket client;
	private BufferedReader reader;
	private PrintWriter writer;
	private byte[] data = new byte[256];
	private InetSocketAddress endPoint;
	private boolean started = false;
	private int iteration = 0;

	public GameState getState() {
		try {
			String line = "";
			if (!started) {
				line = reader.readLine();
				while (line == null || !line.equals("START")) {
					line = reader.readLine();
				}
				started = true;
			}

			//System.out.println("GET_STATE");
			writer.println("GET_STATE");
			writer.flush();

			GameState state = new GameState();
			boolean end = false;
			int c=0;//Hmm
			while (!end && c<500) {
				c++;
				line = reader.readLine();
				if (line != null) {
					String[] msg = line.split("\\s+");
					String key = msg[0];
					if (key.equals("BEGIN_STATE")) {
						iteration = Integer.parseInt(msg[1]);
						//System.out.print("Receiving state for iteration " + iteration);
						state.iteration=iteration;
					} else if (key.equals("END_STATE")) {
						end = true;
					} else if (key.equals("THUNDERSTORM")) {
						state.thunderstorms.add(new Cloud(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]), Float.parseFloat(msg[3]), Float.parseFloat(msg[4]), Float.parseFloat(msg[5]), true));
					} else if (key.equals("RAINCLOUD")) {
						float vapor = Float.parseFloat(msg[5]);
						if (vapor > 0) {
							state.rainclouds.add(new Cloud(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]), Float.parseFloat(msg[3]), Float.parseFloat(msg[4]), Float.parseFloat(msg[5]), false));
						}

					} else if (key.equals("YOU")) {
						state.meIndex = Integer.parseInt(msg[1]);
					}
				}
			}
			return state;
		} catch (Exception e) {
			System.out.println("Error: " + e);
			return null;
		}
	}

	public void setName(String name) {
		//System.out.println("NAME " + name);
		writer.println("NAME " + name);
		writer.flush();
	}

	
	
	public boolean wind(double x, double y) throws IOException {
		//System.out.println("WIND " + x + " " + y);
		writer.println("WIND " + x + " " + y);
		writer.flush();
		String response = reader.readLine();
		boolean ok = response.equals("OK");
		//System.out.println(ok);
		return ok;
	}

	protected boolean Connected() {
		return client.isConnected() && !client.isClosed() && !writer.checkError();
	}
	
	protected void disconnect(){
		try {
			client.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public Client() throws Exception{
		// Connect to server
		client = new Socket();
		endPoint = new InetSocketAddress("127.0.0.1", 1986);
		client.connect(endPoint);
		reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
		writer = new PrintWriter(client.getOutputStream(), true);

		// Runs the implementation in MyAI.cs

	}

	public abstract void RunAi() throws Exception;
}
