

public class Cloud {
    public Vector position;
    public Vector velocity;
    public double vapor;
    public boolean isThunder;

    public double radius() {
        return  Math.sqrt(vapor);
    }

    public Cloud(double x, double y, double vx, double vy, double vapor, boolean isThunder) {
        this.position = new Vector(x, y);
        this.velocity = new Vector(vx, vy);
        this.vapor = vapor;
        this.isThunder=isThunder;
    }
    
	public Cloud clone(){
		return new Cloud(position.x, position.y, velocity.x, velocity.y, vapor, isThunder);
	}
	
	public double distanceTo(Cloud c){
		return Math.sqrt((position.x-c.position.x)*(position.x-c.position.x)+(position.y-c.position.y)*(position.y-c.position.y));
	}
	
	public boolean equals(Cloud c){
		return position.equals(c.position) || velocity.equals(c.velocity);
	}
}
