import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MyAi extends Client {
	// Constructors!
	public MyAi() throws Exception {
		this(5, 150);
	}

	public MyAi(int speeds, int time) throws Exception {
		super();
		this.noSpeeds = speeds;
		this.timePerMove = time;

		RunAi();
	}

	// Variables!
	long lastPoll = new Date().getTime();
	long lastIteration = 0;
	GameState state;

	int noSpeeds;
	int timePerMove;
	int fps = 60;

	int firstFive = 5;

	@Override
	public void RunAi() throws Exception {
		setName("Todde Galompen");

		// UGLY CODE BELOW THIS POINT!

		// DO NOT READ!

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		// I'm serious:(

		while (Connected()) {
			log("");
			log("");

			// Poll the game state
			state = getState();

			// Get the current time
			long now = new Date().getTime();

			// Calculate the simulators FPS (set to minimum 30)
			if (state.iteration - lastIteration > 0) {
				fps = (int) ((state.iteration * 1.0 - lastIteration * 1.0) * 1000.0 / (now - lastPoll));
			}
			lastIteration = state.iteration;
			lastPoll = now;
			if (state == null) {
				break;
			}

			if (state.rainclouds.size() < 1 && state.thunderstorms.size() < 2) {
				log("VICTORY MODE! AAAAAAAWWW YYYYEEEEAAAAAHH!");
				disconnect();
				continue;
			}

			log("My vapor is currently " + state.me().vapor);

			// Try to get the state as it will be when we plan to send the wind
			// command
			double n = fps * timePerMove / 1000.0;
			log("Simulating " + n + " iterations, the simulator should receive the wind at iteration " + (n + state.iteration));

			long availableTime = (long) (timePerMove * ((Math.floor(n) / n)));
			log("Available time: " + availableTime);

			for (int i = 0; i < n; i++) {
				state.iterate();
			}

			// This will be the initial best result
			Result bestResult = new Result(state.me().vapor, state);

			if (state.imDead) {
				log("GOING TO DIE!");
				// I WILL DIE SOON
				bestResult = new Result(0, state);
			}

			bestResult.xVal = 0;
			bestResult.yVal = 0;

			log("Vapor " + bestResult.vapor + " with no movement and " + fps + " fps");

			// Prepare to calculate different directions and speeds

			double max = state.me().vapor / 3;
			double min = 1;
			double dif = (max - min);

			List<Result> results = new ArrayList<Result>();
			Set<Double> visited = new HashSet<Double>();

			double delta = Math.PI;

			while (true) {
				delta /= 2;
				// log("Delta is " + delta);
				double angle = 0;
				boolean done = false;
				while (angle < Math.PI * 2) {
					if (!visited.contains(angle)) {
						double x = Math.sin(angle);
						double y = Math.cos(angle);

						for (int speed = 0; speed < noSpeeds; speed++) {
							double f = min + dif * speed / noSpeeds;
							double xVal = (float) (f * x);
							double yVal = (float) (f * y);

							Result r = simulateWind(xVal, yVal, 0.5);
							r.xVal = xVal;
							r.yVal = yVal;
							r.angle = angle;
							r.speed = f;
							if (r.getValue() > 0)
								results.add(r);
						}
					}
					angle += delta;
					long timeSpent = new Date().getTime() - lastPoll;

					// ABORT! VOI VOI
					firstFive--;
					if (timeSpent + (firstFive < 0 ? 7 : 17) > availableTime) {
						done = true;
						break;
					}
				}
				if (done)
					break;

			}

			// Sort them by angle!
			Collections.sort(results);

			// Prepare results
			for (int i = 0; i < results.size(); i++) {
				if (results.get(i).vapor == 0) {
					results.get((i + 1 + results.size()) % results.size()).deadNeighbours += 1;
					results.get((i - 1 + results.size()) % results.size()).deadNeighbours += 1;
					results.get((i - noSpeeds + results.size()) % results.size()).deadNeighbours += 1;
					results.get((i + noSpeeds + results.size()) % results.size()).deadNeighbours += 1;
				}
			}

			// Find the best result
			for (Result r : results) {
				if (r.getValue() > bestResult.getValue() + 0.5)
					bestResult = r;
			}

			log("Best result will give vapor: " + bestResult.vapor);
			// Sleep a bit?
			long timeSpent = new Date().getTime() - lastPoll;
			Thread.sleep(Math.max(0, availableTime - timeSpent));
			log("SPENT: " + timeSpent + " ms");
			log("SLEPT " + Math.max(0, availableTime - timeSpent) + " ms!");

			// Ignore babies
			if (Math.abs(bestResult.xVal) + +Math.abs(bestResult.yVal) > 2) {
				wind(bestResult.xVal, bestResult.yVal);
			}

			if (bestResult.xVal == 0 && bestResult.yVal == 0) {
				MAX_ITERATIONS += 40;
			} else {
				MAX_ITERATIONS = INITIAL_MAX_ITERATIONS;
			}
		}
	}

	int INITIAL_MAX_ITERATIONS = 350;
	int MAX_ITERATIONS = 350;

	/**
	 * Simulate the given wind for the given amount of time
	 * 
	 * @param x
	 * @param y
	 * @param time
	 * @return
	 */
	Result simulateWind(double x, double y, double availableTime) {
		GameState copy = state.clone();
		float str = (float) Math.sqrt(x * x + y * y);

		// Legal?
		if (str < 1.0 || str > state.me().vapor / 2) {
			return new Result(0, copy);
		}

		// Set new vapor
		// float radius = copy.me().radius();
		Vector oldVel = copy.me().velocity;
		double radius = copy.me().radius();

		copy.me().vapor -= str;

		// Did we die?
		if (copy.me().vapor < 1.0)
			return new Result(0, copy);

		// Set speed
		copy.me().velocity.x += x * 5 / radius;
		copy.me().velocity.y += y * 5 / radius;

		// Spawn a poop
		Vector wxwy = new Vector(x / str, y / str);

		double newRadius = Math.sqrt(str);
		double distance = ((radius + newRadius) * 1.1f);
		Vector pos = new Vector(copy.me().position.x - wxwy.x * distance, copy.me().position.y - wxwy.y * distance);
		Vector vel = new Vector(-(x / str) * 20 + oldVel.x, -(y / str) * 20 + oldVel.y);

		copy.rainclouds.add(new Cloud(pos.x, pos.y, vel.x, vel.y, str, false));

		long start = new Date().getTime();
		int c = 0;
		while (new Date().getTime() - start < availableTime && c < MAX_ITERATIONS) {
			copy.iterate();
			c++;

		}
		// log("Ran " + c + " iterations in " + availableTime + " ms");

		double val = copy.me().vapor;

		Result r = new Result(val, copy);
		r.startVapor = state.me().vapor;
		if (copy.imDead)
			r.vapor = 0;

		return r;
	}

	public void log(String msg) {
		// System.out.println(msg);
	}

	public static void main(String[] args) {
		try {
			// Runtime.getRuntime().exec("C:/ai/simulator/CloudWars.Gui/bin/Debug/CloudWars ai");
			new MyAi(5, 150);

		} catch (Exception e) {
			System.err.println("FFFFFFFUUUUUUUUU");
		}
	}

}
