#!/usr/bin/env python

import random
import socket
import sys
import math
import time

class AI:

	def __init__(self, s=None):
		if s is None:
			self.s = socket.socket(
			socket.AF_INET, socket.SOCK_STREAM)
		else:
			self.s = s

	def connect(self, host, port):
		print "Connecting to", host, port
		try:
			self.s.connect((host, port))
		except Exception, e:
			print >>sys.stderr, e
			sys.exit(1)

	def name(self, nick):
		print "Sending name:", nick
		self.s.send("NAME %s" % (nick,))

	def start(self):
		print "Waiting on start from server..."
		while 1:
			ready = self.s.recv(4096)
			if 'START' in ready:
				print "Received START"
				break

	def wind(self, x, y):
		print "Sending WIND", x, y

		try:
			self.s.send('WIND %s %s' % (x,y))
		except socket.error:
			pass
		
		#while 1:
		status = self.s.recv(1024)
		print "status:", status
		if "OK" in status:
			print "WIND OK"
			return True
			#break
		if "IGNORE" in status:
			print "WIND IGNORE"
			return False
			#break
		#'''

	def getState(self):
		#print "Sending GET_STATE"

		try:
			self.s.send('GET_STATE')
		except Exception, e:
			print e #>>sys.stderr, e
			sys.exit(1)

		currentState = self.s.recv(4096)
		raw = currentState.split("\n")
		#raw = raw.rstrip()
		#print "raw:\n", raw

		# remove the last \n from END_STATE
		# if not we get: IndexError: list index out of range
		raw = raw[:-1]

		state = {}
		state["rainclouds"] = []
		state["thunderstorms"] = []

		#print 'raw', raw

		'''			if not "END_STATE" in raw:
				print "Missing END_STATE"
				break
			elif not "BEGIN_STATE" in raw[0]:
				print "Missing BEGIN_STATE"
				break
		'''
		for i in raw:
			i = i.rstrip()
			l = i.split()
			#print "l:", l

			if len(l) == 0:
				continue 

			if l[0] == "BEGIN_STATE":
				state["interation"] = int(l[1])

			if l[0] == "YOU":
				state["you"] = int(l[1])

			if l[0] == "THUNDERSTORM":
				state["thunderstorms"].append({
					"px": float(l[1]),
					"py": float(l[2]),
					"vx": float(l[3]),
					"vy": float(l[4]),
					"vapor": float(l[5]),
					})

			if l[0] == "RAINCLOUD":
				state["rainclouds"].append({
					"px": float(l[1]),
					"py": float(l[2]),
					"vx": float(l[3]),
					"vy": float(l[4]),
					"vapor": float(l[5]),
					})

		try:
			if not state.get("you", False):
				state["me"] = state["thunderstorms"][state["you"]]
				del state["thunderstorms"][state["you"]]
			else:
				state["me"] = "None"
		except IndexError, KeyError:
			pass

		self.state = state
		return state

	def sleep(self, sec=0.1):
		time.sleep(sec)

################################################################################
# SECRET SAUSE!
################################################################################

	def canAbsorb(self, a, b):
		if a["vapor"] < b["vapor"]:
			return True
		else:
			return False

	def distance(self, x1, y1, x2, y2):
		return math.sqrt(pow(x2 - x1, 2) + pow(y2 - y1, 2));

	def radius(self, cloud):
		return math.sqrt(cloud["vapor"])

	def checkCollision(self, a, b, safeBound):
		if self.distance(a["px"], a["py"], b["px"], b["py"]) < self.radius(a) + self.radius(b) + safeBound:
			return True
		else:
			return False

	def windVaporLoss(self, x, y):
		return math.sqrt(x*x+y*y)

	def warChance(self, cloud):
		return (self.me["vapor"] - self.windVaporLoss(cloud)) - cloud["vapor"]

	def intersectPath(self, a, b):
		intersect = False
		for i in range(1, 50):
			intersectX = abs((a["px"]+a["vx"]*i - b["px"]+b["vx"]*i))<(b["vapor"]+a["vapor"])/2
			intersectY = abs((a["py"]+a["vy"]*i - b["py"]+b["vy"]*i))<(b["vapor"]+a["vapor"])/2
			intersect =  intersectX and intersectY
			if intersect:
				#return i
				return (b["px"]+b["vx"]*i, b["vx"]+b["vy"]*i)
		return intersect 

	def getXYDistance(self, cloud):
		x=cloud["px"]-self.me["px"]
		y=cloud["py"]-self.me["py"]
		return (x,y)
