#!/usr/bin/env python

from ai import AI
import pygame
import sys

class Visualization (AI):

	blue = (0,0,255)
	red = (255,0,0)
	green = (0,255,0)
	white = (255,255,255)
	black = (0,0,0)
	gray = (155,155,155)
	yellow = (255, 255, 0)

	def init(self):
		print " * Init pygame"
		pygame.init()
		self.screen = pygame.display.set_mode((640,480))

	def draw(self, cloud, color):
		px = int(cloud["px"])
		py = int(cloud["py"])
		vx = int(cloud["vx"])
		vy = int(cloud["vy"])
		r = int(self.radius(cloud))

		pygame.draw.circle(self.screen, color, (px, py), r)
		pygame.draw.line(self.screen, self.white, (px, py), (px+vx*r, py+vy*r))

	def target(self, cloud, color, text):
		px = int(cloud["px"])
		py = int(cloud["py"])
		r = int(self.radius(cloud))

		if pygame.font:
			font = pygame.font.Font(None, 26)
			text = font.render(text, True, self.white)
			self.screen.blit(text, (px, py-(r*2)))

		pygame.draw.circle(self.screen, color, (px, py), r+10, 2)

	def update(self, state):
		#print "state:", state
		for event in pygame.event.get():
			if event.type == pygame.QUIT:
				pygame.quit(); sys.exit();

		pygame.display.update()

	def flip(self):
		#pygame.display.flip()
		pygame.display.update()
