#include "comm.h"
#include "util.h"
#include "GameState.h"
#include <iostream>
#include <sstream>
#include <cassert>
#include <fstream>
//#include <sys/time.h>

using namespace std;

ofstream logg;
comm *c;
MyWindow *window;

#ifdef RENDER
SDL_Color textColor = {255, 255, 255};
#endif
//TTF_Font *font = NULL;


void MakeWind(GameState *state, vec2 d) {

    float strength = sqrt(d.x*d.x + d.y*d.y);
    cout << d.x << " " << d.y << " " << strength << endl;
    Cloud *me = state->getMyStorm();
    if (strength < 1.0f) return;
    if (strength > me->vapor/2.0) return;

    //lines.push_back(Line(me->p.x, me->p.y, 
            //5*(me->v.x + 5.0 * (dx / me->getRadius())), 
            //5*(me->v.y + 5.0 * (dy / me->getRadius()))));

    float storm_radius = me->getRadius();
    float raincloud_radius = sqrt(strength);
    vec2 w = d / strength;
    float distance = (storm_radius + raincloud_radius) * 1.1;

    state->getMyStorm()->vapor -= strength;
    // if vapor < 1.0; kill

    state->getMyStorm()->addVelocity(
            (d.x / me->getRadius())*5.0f,
            (d.y / me->getRadius())*5.0f);

    vec2 rainPosition = me->pos - (w * distance);
    vec2 rainVelocity = (d / strength) * -20.0f + me->vel;
    state->addRainCloud(rainPosition, rainVelocity, strength);

//    if (lines.size() > 2)
        //lines.erase(lines.begin());

    c->send_wind(d);
}


void ChooseWind(GameState *state) {
    float dx = frand(-25, 25);
    float dy = frand(-25, 25);

    //Wind(dx, dy);

    //return;

    const int iterations = 10;

    Cloud *me = state->getMyStorm();
    Cloud *theone = NULL;
    float best_score = 99999;
    float use_will = 0;
    vec2 use_direction(0,0);

    //for (size_t i = 0; i < state->clouds.size(); i++) {
        //if (i == state->myindex) continue;
        //Cloud *c = state->clouds[i];
        //if (c->vapor <= 0) continue;

        //for (float t = 1; t < 10; t += 0.1) {
            //vec2 root = lolsolve(state, me, c, t);
            //glColor3f(1, 1, 0);
            //glLoadIdentity();
            //drawLine(me->p.x, me->p.y, root.x, root.y);
        //}
    //}

    // Finn laveste tidspunkt jeg kommer til  kollidere, s finne beste
    // target innen den tiden. Om ingen targets, stikk unna asap.
    float goingToCollide = 0;
    float shortest_collision_time = 99999;
    Cloud *collision_target;
    bool res = checkCollision(state, me->vel, shortest_collision_time, &collision_target);
    if (res) {
        //cout << "PRECHECK DIE in T minus " << shortest_collision_time<< endl;
        goingToCollide = 1;
    }

    float t = 0.1;
    //float will = 200;
    for (int i = 0; !theone && i < 1000; i++, t += 0.1) {

        // Choose cloud to aim for
        for (size_t i = 0; i < state->clouds.size(); i++) {
            if (i == state->myindex) continue;
            Cloud *c = state->clouds[i];
            if (c->vapor <= 0) continue;
            if (c->vapor > me->vapor) continue;

            //for (float t = 0; t < 10; t += 0.1) {
                //cout << "hm t " << t << " " << newD.length() << endl;
            //}

            //vec2 yep = vec2(c->p.x + c->v.x*0.1*iterations, c->p.y + c->v.y*0.1*iterations);
            //vec2 diff = (c->p - me->p);
            //float r = diff.length();
            //float dot = diff.normalized().dot(me->v.normalized());
            //vec2 newD = (((diff.normalized() * will) - me->v) * me->getRadius() / 5.0);

            //vec2 root = lolsolve(state, me, c, t);

            //glColor3f(1, 1, 0);
            //glLoadIdentity();
            //drawLine(me->p.x, me->p.y, root.x, root.y);



            //vec2 hm = c->p + (t * c->v) - me->p - me->v;
            //vec2 root = ((c->p + c->v*t) - me->p)/t;
            vec2 wm = (c->pos + (c->vel * t) - me->pos)/t;
            vec2 hm = wm - me->vel;
            vec2 newD = (hm * me->getRadius() / 5.0);

            float strength = newD.length();
            //cout << "i " << i << " t " << t << " strength " << strength << endl;
            //float strength = ((((c->p - me->p).normalized() * will) - me->v) * me->getRadius() / 5.0).length();
            //
            stringstream text;
            text << "strength: ";
            text << strength;
            c->text = text.str();

            if (strength <= 1.0) continue;
            if (strength >= me->vapor/2) continue;
            if (strength > c->vapor) continue; // Todo: future
            if (c->vapor > me->vapor - strength) {
                //cout << "debug: " << "saved you there!" << endl;
                continue;
            }
            if (!goingToCollide && c->vapor - strength < strength*0.1) {
                //cout << "debug: " << "waste of time!" << endl;
                continue;
            }


            //float time = diff.length() / me->v.length();

            // Check if the new vector is going to collide with any big clouds
            vec2 newV = me->vel + newD;
            float collision_time;
            Cloud *target;
            bool res = checkCollision(state, newV, collision_time, &target);
            if (res) {
                cout << "DIE in T minus " << collision_time << endl;
                continue;
            }


            //float score = dot * c->vapor / r;
            //float score = strength;
            float alpha = 0.5;
            float score = alpha * strength - (1 - alpha) * c->vapor;


            if (!theone || (theone && score < best_score)) {
                //cout << "best so far - i: " << i << " - " << score << endl;
                theone = c;
                best_score = score;
                use_direction = newD;
                //cout << "hm t " << t << " " << newD.length() << endl;
                //use_will = will;
            }
        }
        //will /= 2.0;
    }

    //if (!theone) {
        //cout << "Extra search" << endl;

        //float will = 200;
        //for(int i = 0; !theone && i < 1000; i++) {
            //for (size_t i = 0; i < state->clouds.size(); i++) {
                //if (i == state->myindex) continue;
                //Cloud *c = state->clouds[i];
                //if (c->vapor <= 0) continue;
                //if (c->vapor > me->vapor) continue;

                //float strength = ((((c->p - me->p).normalized() * will) - me->v) * me->getRadius() / 5.0).length();

                //if (strength <= 1.0) continue;
                //if (strength >= me->vapor/2) continue;
                //if (strength > c->vapor) continue;

                ////float score = dot * c->vapor / r;
                //float score = strength;
                //cout << "i: " << i << " - " << score << endl;

                //if (!theone || (theone && score < best_score)) {
                    //theone = c;
                    //best_score = score;
                    //use_will = will;
                //}

            //}

            //will /= 2.0;
        //}
    //}
    if (!theone) {
        float collision_time;
        Cloud *target;
        bool res = checkCollision(state, me->vel, collision_time, &target);
        if (res) {
            vec2 tmp = target->pos - me->pos;
            float haha = tmp.x;
            tmp.x = tmp.y;
            tmp.y = -haha;
            tmp.normalize();
            tmp *= me->vapor/3;

            //cout << "OOHOOOH DIE in T minus " << collision_time << endl;
            MakeWind(state, tmp);
        }
    }

    if (theone) {
#ifdef RENDER
        glLoadIdentity();
        glColor3f(0, 1, 0);
        glTranslatef(theone->pos.x, theone->pos.y, 0);
        glutSolidSphere(theone->getRadius(), 100, 100);
#endif


        //vec2 w = (theone->p - me->p).normalized();
        //w *= use_will;
        ////w *= 20.0;
        ////w.x *= me->vapor/100.1;
        ////w.y *= me->vapor/100.1;

        //vec2 v = me->v;
        //vec2 h = (w - v);

        //vec2 d = h * me->getRadius() / 5.0;

        //cout << w << v << h << endl;
        vec2 d = use_direction;

#ifdef RENDER
        glLoadIdentity();
        drawLine(me->pos.x, me->pos.y, 
            5*(me->vel.x + 5.0 * (d.x / me->getRadius())),
            5*(me->vel.y + 5.0 * (d.y / me->getRadius())));
#endif

        //cout << "r: " << " " << d << " will: " << use_will << endl;

        //glLoadIdentity();
        //for (int i = 0; i < lines.size(); i++) {
            //drawLine(lines[i].a, lines[i].b, lines[i].c, lines[i].d);
        //}

        //if (doIt)
        MakeWind(state, d);
    }

}


void run(GameState *state) {
	//int result = setitimer(ITIMER_REAL, &alarmtimer, NULL);

    //cout << "time " << (my_gettime() - t1) * 1000 << endl;
    //t1 = getTime();
    //GameState *state = gameConnection->getState();
    //GameState *state = gameConnection->getState2();
    //GameState *state = getState();
    //cout << "getstate " << (my_gettime() - t1) * 1000 << endl;

    //int diff_iteration = state->iteration - last_iteration;
    //cout << "diff iteration" << diff_iteration << endl;

    // Render
#ifdef RENDER
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    window->Render(state);
#endif
    //Cloud *me = state->getMyStorm();
    //vec2 new_vel;
    //float col_time = state->checkBorderCollision(me->pos, me->vel, me->getRadius(), new_vel);
//        std::cout << "collide in " << col_time << " " << new_vel << endl;
	
	ChooseWind(state);

#if 0
	double time_sim = getTime();
    GameState *copy = new GameState(*state);
    copy->next_move(window, logg);
    logg << "sim " << ((getTime() - time_sim)*1000.0) << endl;
#endif

#ifdef RENDER
	/*
    for (size_t j = 0; j < state->clouds.size(); j++) {
        Cloud *c = state->clouds[j];
        if (!c->text.empty())
            RenderText(font, 255, 255, 255, c->pos.x, c->pos.y+c->getRadius(), 0, c->text);
    }
	*/
    SDL_GL_SwapBuffers();
#endif
}



int main(int argc, char* argv[])
{

#ifdef RENDER
        window = new MyWindow(argc, argv);
#endif

#ifdef DEBUG
	logg.open("log.txt", ios::app);
	if (!logg.good()) { return 1; };
#endif

	try {

		c = new comm("127.0.0.1");

		if (c->alive())
		{
			c->ready("mongo");

			double last_time = 0;
			double sum_time = 0;
			int i = 0;
			int last_iteration = 0;
			double t1 = 0;

			int time_limit = 801;

			while (c->alive()) // simple main loop
			{
				// Calc time to sleep

				double time = getTime()*1000.0;
				while (time - last_time < time_limit) {
					int sleep = ceil(min((double)time_limit, max(time_limit - (time - last_time), 0.0)));
					//cout << "sleep " << (100 - (time - last_time)) << endl;
					//cout << "sleep " << sleep << endl;
					doSleep(sleep);
					time = getTime()*1000.0;
				}

				//Sleep(1000);
				GameState *state = new GameState();
				double t1 = getTime();

				c->recv_state(*state);
				#ifdef DEBUG
				logg << "getstate " << (getTime() - t1)*1000.0 << "ms" << endl;
#endif

				t1 = getTime();
				#ifdef DEBUG
				logg << state->myindex << endl;
#endif

				run(state);
#ifdef DEBUG
				logg << "computation " << (getTime() - t1)*1000.0 << "ms" << endl;
#endif

				last_iteration = state->iteration;
				last_time = time;
				free(state);
				i++;

				// insert stuff here to do the boogie
				//c.send_wind(vec2(10,10)); 
			}
		}
	}
	catch (const runtime_error &e) {
		logg << e.what() << endl;
	}
	return 0;
}