#include <iostream>
#include "ReplayConnection.h"
#include <cstdio>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <cassert>
#include <string.h>
#include <errno.h>

ReplayConnection::ReplayConnection() {
}

void ReplayConnection::connect(const char *hostname, const char *port) {
    fd = open(hostname, O_RDONLY);
	cout << "open " << hostname << endl;
    if (fd < 0) {
        throw ConnectException("cannot open file");
    }
}

ReplayConnection::~ReplayConnection() {
    close();
}

int ReplayConnection::write(char *buf, int len) {
		return 0;
}

int ReplayConnection::write(std::string string) {
		return 0;
}

int ReplayConnection::read(char *buf, int len) {
		cout << "read" << endl;
	ssize_t t = ::read(fd, buf, len);
    return t;
}

std::string ReplayConnection::readall() {
cout << "readall" << endl;
    char tmp[512];
    std::stringstream buffer;
    size_t bytes = 0;
    while (1) {
        int n = ::read(fd, tmp, sizeof tmp);
        if (n < 0) break;
        if (n == 0) break;
        buffer.write(tmp, n);
        bytes += n;
    }
    assert(bytes == buffer.str().length());
    return buffer.str();
}


std::string ReplayConnection::readLine() {
cout << "readline" << endl;
    std::string line;
    char tmp[512];
    //cout << "BUFFER: " << buffer.str() << endl;
    //cout << "Buffer Size: " << buffer.str().size() << endl;

    if (buffer.good()) {
        getline(buffer, line);
        if (buffer.eof()) {
            buffer.seekg(-((int)line.size()), ios::cur);
            buffer.clear();
        } else {
            return line;
        }
    } else {
        buffer.clear();
    }
        //int lol = buffer.gcount();
        //if (!buffer.eof())
        //return line;
        //else {
            //buffer.seekg(-lol, ios::cur);
        //}
    //}

    while (1) {
        int n = ::read(fd, tmp, sizeof tmp);
		cout << "n " << n << endl;
        if (n == -1) {
            cerr << "errno: " << errno << endl;
            cerr << "error: " << strerror(errno) << endl;
            if (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR) {
                continue;
            }
            throw ConnectException("read failed");
        } else if (n == 0) {
            // End of file
            throw ConnectException("Disconnected");
        }
        //cout << "RECEIVED: " << n << " \"" << string(tmp, n) << "\"" << endl;

        tmp[n] = '\0';

        //if ((p = (char*)memchr(tmp, '\n', sizeof tmp)) != NULL) {
            //cout << n << " " << p-tmp << endl;
            //line = std::string(tmp, p-tmp);
            ////cout << "PPP " << string(p+1, n-(p-tmp)-1) << endl;
            ////cout << "Buffer Size: " << buffer.str().size() << endl;
            //if (!buffer.good())
                //buffer.clear();
            //buffer.write(p+1, n-(p-tmp)-1);
            ////cout << "Buffer Size: " << buffer.str().size() << endl;
            //cout << (n-(p-tmp)-1) << endl;
            //break;
        //}
        if (buffer.eof()) {
            buffer.clear();
            buffer.str("");
        }
        buffer.write(tmp, n);

        if (buffer.good()) {
            getline(buffer, line);
            if (buffer.eof()) {
                buffer.seekg(-((int)line.size()), ios::cur);
                buffer.clear();
                continue;
            }
            return line;
        }
    }
    return line;
}

void ReplayConnection::close() {
    ::close(fd);
    fd = 0;
}

void ReplayConnection::flush() {
#ifndef _WIN32
    ::fsync(fd);
#endif
}

bool ReplayConnection::isConnected() const {
    return fd >= 0;
}
