
#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <stdlib.h>
#include <mmsystem.h>

#pragma comment(lib, "winmm.lib")

#include "GameState.h"


float frand(float min, float max) {
    return ((max-min)*(float)rand() / RAND_MAX) + min;
}

double getTime(void) {
#ifdef _WIN32
	long msec = timeGetTime();
	return msec/1000.0;
#else
    struct timeval TV;
    const int RC = gettimeofday(&TV, 0);
    if (RC == -1) {
        printf("ERROR: Bad call to gettimeofday\n");
        return -1;
    }
    return ( ((double)TV.tv_sec) + 1.0e-6 * ((double)TV.tv_usec) );
#endif
}


void doSleep(int msec) {
#ifdef _WIN32
	Sleep(msec);
#else
	usleep(msec*1000);
#endif
}

bool checkCollision(GameState *state, vec2 velocity, float &min_root, Cloud **collision_target) {
    // Am I going to collide, giving that I'm changing my course to "velocity"?
    Cloud *me = state->getMyStorm();

    bool collide = false;
    min_root = 99999;
    for (size_t i = 0; i < state->clouds.size(); i++) {
        if (i == state->myindex) continue;
        Cloud *c = state->clouds[i];
        if (c->vapor <= 0) continue;

        if (c->vapor < me->vapor) continue; // todo: reinforce if smaller

        float r0 = me->getRadius();
        float r1 = c->getRadius();

        vec2 C0 = vec2(me->pos.x, me->pos.y);
        vec2 V0 = vec2(velocity.x, velocity.y);
        //vec2 V0 = vec2(me->v.x, me->v.y);

        vec2 C1 = vec2(c->pos.x, c->pos.y);
        vec2 V1 = vec2(c->vel.x, c->vel.y);

        vec2 dv = V1 - V0;
        vec2 dc = C1 - C0;

        float ga = dv.dot(dv);
        float gb = 2.0 * dv.dot(dc);
        float gc = dc.dot(dc) - (r0+r1)*(r0+r1);

        float root = 0.0;
        bool res = getLowestRoot(ga, gb, gc, 1000000, &root);
        if (res && root < min_root) {
            *collision_target = c;
            collide = true;
            min_root = root;
        }
    }

    return collide;
}

bool getLowestRoot(float a, float b, float c, float maxR, float* root) {
    // Check if a solution exists
    float determinant = b*b - 4.0f*a*c;
    //cout << "lowest root " << determinant <<  endl;
    // If determinant is negative it means no solutions.
    if (determinant < 0.0f) return false;
    // calculate the two roots: (if determinant == 0 then
    // x1==x2 but lets disregard that slight optimization)
    float sqrtD = sqrt(determinant);
    float r1 = (-b - sqrtD) / (2*a);
    float r2 = (-b + sqrtD) / (2*a);
    // Sort so x1 <= x2
    if (r1 > r2) {
        float temp = r2;
        r2 = r1;
        r1 = temp;
    }
    //cout << "r1 " << r1 << " r2 " << r2 << endl;
    // Get lowest root:
    if (r1 > 0 && r1 < maxR) {
        *root = r1;
        return true;
    }
    // It is possible that we want x2 - this can happen
    // if x1 < 0
    if (r2 > 0 && r2 < maxR) {
        *root = r2;
        return true;
    }
    // No (valid) solutions
    return false;
}

void drawLine(float px, float py, float w, float h) {
#ifdef RENDER
    glBegin(GL_LINES);
    glVertex3f(px, py, 0);
    glVertex3f(px + w, py + h, 0);
    glEnd();
#endif
}
