﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace Wally
{
	public class Cloud
	{
		public Vector Position;
		public Vector Velocity;
		public double Vapor;
		public double Radius
		{
			get { return (float)Math.Sqrt(Vapor); }
		}
		public Cloud(double x, double y, double vx, double vy, double vapor)
		{
			this.Position = new Vector(x, y);
			this.Velocity = new Vector(vx, vy);
			this.Vapor = vapor;
		}
	}

	public class GameState
	{
		public int Iteration;
		public readonly List<Cloud> Thunderstorms = new List<Cloud>();
		public readonly List<Cloud> Rainclouds = new List<Cloud>();
		public List<Cloud> AllClouds { get { var c = new List<Cloud>(Rainclouds); c.AddRange(Thunderstorms); return c; } }
		public Cloud Me;
	}

	public interface IGame
	{
		GameState GetState();
		void SetName(string name);
		bool Wind(float x, float y);
		bool Wind(Vector w);
		bool Connected();
	}
}
