﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Text;
using System.Windows;
using System.Globalization;

namespace Wally
{
	public class NetworkGame : IGame
	{
		private readonly TcpClient client = new TcpClient();
		private readonly StreamReader reader;
		private readonly StreamWriter writer;
		private readonly byte[] data = new byte[256];
		private readonly IPEndPoint endPoint = new IPEndPoint(IPAddress.Parse("127.0.0.1"), 1986);

		public GameState GetState()
		{
			try
			{
				writer.WriteLine("GET_STATE");
				writer.Flush();

				GameState state = new GameState();
				int meIndex = -1;
				bool end = false;
				while (!end)
				{
					string line = reader.ReadLine();
					if (line != null)
					{
						string[] msg = line.Split(' ');
						switch (msg[0])
						{
							case "BEGIN_STATE":
								state.Iteration = int.Parse(msg[1], NumberFormatInfo.InvariantInfo);
								break;
							case "END_STATE": end = true; break;
							case "THUNDERSTORM":
								var v = float.Parse(msg[5], NumberFormatInfo.InvariantInfo);
								if (v > 1)
									state.Thunderstorms.Add(
									new Cloud(
										float.Parse(msg[1], NumberFormatInfo.InvariantInfo),
										float.Parse(msg[2], NumberFormatInfo.InvariantInfo),
										float.Parse(msg[3], NumberFormatInfo.InvariantInfo),
										float.Parse(msg[4], NumberFormatInfo.InvariantInfo),
										v));
								break;
							case "RAINCLOUD":
								v = float.Parse(msg[5], NumberFormatInfo.InvariantInfo);
								if (v > 1)
									state.Rainclouds.Add(
									new Cloud(
										float.Parse(msg[1], NumberFormatInfo.InvariantInfo),
										float.Parse(msg[2], NumberFormatInfo.InvariantInfo),
										float.Parse(msg[3], NumberFormatInfo.InvariantInfo),
										float.Parse(msg[4], NumberFormatInfo.InvariantInfo),
										v));
								break;
							case "YOU": meIndex = int.Parse(msg[1]); break;
						}
					}
				}
				state.Me = state.Thunderstorms[meIndex];
				state.Thunderstorms.RemoveAt(meIndex);
				return state;
			}
			catch (Exception) { return null; }
		}

		public void SetName(string name)
		{
			writer.WriteLine("NAME " + name);
			writer.Flush();
		}

		public bool Wind(float x, float y)
		{
			writer.WriteLine("WIND " + x.ToString(NumberFormatInfo.InvariantInfo) + " " + y.ToString(NumberFormatInfo.InvariantInfo));
			writer.Flush();
			string response = reader.ReadLine();
			if (response == "OK") return true;
			else return false;
		}

		public bool Wind(Vector w) { return Wind((float)w.X, (float)w.Y); }

		public bool Connected()
		{
			return client.GetStream().CanWrite;
		}

		public NetworkGame()
		{
			// Connect to server
			client.Connect(endPoint);
			reader = new StreamReader(client.GetStream(), Encoding.ASCII);
			writer = new StreamWriter(client.GetStream(), Encoding.ASCII);
		}
	}
}