
// Initialize rendering window

w = 1280;
h = 1024;
SetupWindow(w, h, "My Demo");

lyd = new AudioStream("data/lul.ogg");
lyd.Play();

fb = new Framebuffer(w, h, 0, PixelFormatR8G8B8A8, true, true);

lol = new World();
world = new World();

room = new WorldObject(world, "data/primitives/sphere.dae");
rargs = {}
rargs.DiffuseMap = "data/textures/lobby_envmap_darker.jpg";
rargs.NormalMap = "data/textures/cracky_nm.jpg";
room.SetParameters(rargs);
room.SetScale(20,20,20);

cubes = []
cubecount = 10;
cargs = {}
cargs.DiffuseMap = "data/textures/lobby_envmap.jpg";
cargs.NormalMap = "data/textures/cracky_nm.jpg";

for (i=0; i<cubecount; i++)
{
	cubes[i] = new WorldObject(world, "data/primitives/smooth_cube.dae");	
	cubes[i].SetParameters(cargs);
	cubes[i].SetPosition(Math.sin(i)*Math.sin(i*2)*10, Math.cos(i)*20, Math.sin(i*2)*30);
	cubes[i].SetProgram("data/shaders/envmapping_with_bump.cg");
	cubes[i].SetRotation(Math.random()*400,2,1,0);
}

i = 100;

filters = new Filters();

// Mainloop
while (Update())
{
	if (KeyTrigger(KeyLeftArrow)) fancycube.SetScale(i++/100, i++/100, i++/100);

	PushFramebuffer(fb);
	Clear(1,0,0,0,1,0);
	world.SetCameraTarget(0,0,0);
	world.SetCameraPosition(Math.sin(GetTime())*40, Math.cos(GetTime())*40, Math.sin(GetTime()*0.5)*50);
	world.Render();
	PopFramebuffer();
	
	filters.Glow(fb);
	

	Clear(0,0,0,0,1,0);
	//fb.Blit();
}

