// ThreeSVG.js r45dev - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,g;if(c==0)this.r=this.g=this.b=0;else switch(d=Math.floor(a*6),e=a*6-d,a=c*(1-b),g=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=
c;this.g=a;this.b=g;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);
Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w!==void 0?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d;d=c.clone().subSelf(a).dot(b);if(d<=0)return null;a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),
c=c.clone().subSelf(b),e=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(e),f=c.dot(c),c=c.dot(e),e=1/(a*f-b*b),f=(f*d-b*c)*e,a=(a*c-b*d)*e;return f>0&&a>0&&f+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a.matrixWorld.getPosition());if(d==null||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a.matrixWorld.getPosition());if(d==null||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,
Math.max(a.scale.y,a.scale.z)))return[];var e,g,f,h,k,i,l,j,m,n,p=a.geometry,q=p.vertices,v=[],d=0;for(e=p.faces.length;d<e;d++)if(g=p.faces[d],m=this.origin.clone(),n=this.direction.clone(),i=a.matrixWorld,f=i.multiplyVector3(g.centroid.clone()).subSelf(m),j=f.dot(n),!(j<=0)&&(f=i.multiplyVector3(q[g.a].position.clone()),h=i.multiplyVector3(q[g.b].position.clone()),k=i.multiplyVector3(q[g.c].position.clone()),i=g instanceof THREE.Face4?i.multiplyVector3(q[g.d].position.clone()):null,l=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),
j=n.dot(l),a.doubleSided||(a.flipSided?j>0:j<0)))if(j=l.dot((new THREE.Vector3).sub(f,m))/j,m=m.addSelf(n.multiplyScalar(j)),g instanceof THREE.Face3)c(m,f,h,k)&&(g={distance:this.origin.distanceTo(m),point:m,face:g,object:a},v.push(g));else if(g instanceof THREE.Face4&&(c(m,f,h,i)||c(m,h,k,i)))g={distance:this.origin.distanceTo(m),point:m,face:g,object:a},v.push(g);v.sort(function(a,b){return a.distance-b.distance});return v}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;f=e-c}var b,c,d,e,g,f,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return f};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,l,j){h=!1;b=f;c=g;d=l;e=j;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,l,j,m,n){h?(h=!1,b=f<l?f<m?f:m:l<m?l:m,c=g<j?g<n?g:n:j<n?j:n,d=f>l?f>m?f:m:l>m?l:m,e=g>j?g>n?g:n:j>n?j:n):(b=f<l?f<m?f<b?f:b:m<b?m:b:l<m?l<b?l:b:m<b?m:b,c=g<j?g<n?g<c?g:c:n<c?n:c:j<n?j<c?j:c:n<c?n:c,d=f>l?f>m?f>d?f:d:m>d?m:d:l>m?l>d?l:d:m>d?m:d,e=g>j?g>n?g>e?g:e:n>e?n:e:j>n?j>e?j:e:n>e?n:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(e,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,g,f,h,k,i,l,j,m,n,p,q){this.set(a!==void 0?a:1,b||0,c||0,d||0,e||0,g!==void 0?g:1,f||0,h||0,k||0,i||0,l!==void 0?l:1,j||0,m||0,n||0,p||0,q!==void 0?q:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,g,f,h,k,i,l,j,m,n,p,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=g;this.n23=f;this.n24=h;this.n31=k;this.n32=i;this.n33=l;this.n34=j;this.n41=m;this.n42=n;this.n43=p;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());e.cross(g,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=g.x;this.n21=d.y;this.n22=e.y;this.n23=g.y;this.n31=d.z;this.n32=e.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;
a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+
c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,k=a.n23,i=a.n24,l=a.n31,j=a.n32,m=a.n33,n=a.n34,p=a.n41,q=a.n42,v=a.n43,u=a.n44,C=b.n11,K=b.n12,
t=b.n13,w=b.n14,z=b.n21,y=b.n22,o=b.n23,E=b.n24,D=b.n31,F=b.n32,G=b.n33,A=b.n34,M=b.n41,N=b.n42,O=b.n43,S=b.n44;this.n11=c*C+d*z+e*D+g*M;this.n12=c*K+d*y+e*F+g*N;this.n13=c*t+d*o+e*G+g*O;this.n14=c*w+d*E+e*A+g*S;this.n21=f*C+h*z+k*D+i*M;this.n22=f*K+h*y+k*F+i*N;this.n23=f*t+h*o+k*G+i*O;this.n24=f*w+h*E+k*A+i*S;this.n31=l*C+j*z+m*D+n*M;this.n32=l*K+j*y+m*F+n*N;this.n33=l*t+j*o+m*G+n*O;this.n34=l*w+j*E+m*A+n*S;this.n41=p*C+q*z+v*D+u*M;this.n42=p*K+q*y+v*F+u*N;this.n43=p*t+q*o+v*G+u*O;this.n44=p*w+q*
E+v*A+u*S;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=
a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,g=this.n22,f=this.n23,h=this.n24,k=this.n31,i=this.n32,l=this.n33,j=this.n34,m=this.n41,n=this.n42,p=this.n43,q=this.n44;return d*f*i*m-c*h*i*m-d*g*l*m+b*h*l*m+c*g*j*m-b*f*j*m-d*f*k*n+c*h*k*n+d*e*l*n-a*h*l*n-c*e*j*n+a*f*j*n+d*g*k*p-b*h*k*p-d*e*i*p+a*h*i*p+b*e*j*p-a*g*j*p-c*g*k*q+b*f*k*q+c*e*i*q-a*f*i*q-b*e*l*q+a*g*l*q},
transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;
a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;
a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;
a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,
0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,g=a.x,f=a.y,h=a.z,k=e*g,i=e*f;this.set(k*g+c,k*f-d*h,k*h+d*f,0,k*f+d*h,i*f+c,i*h-d*g,0,k*h-d*f,i*h+d*g,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,g=Math.cos(c),c=Math.sin(c),f=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var k=
f*h,i=f*e,l=d*h,j=d*e;this.n11=k+j*c;this.n12=l*c-i;this.n13=g*d;this.n21=g*e;this.n22=g*h;this.n23=-c;this.n31=i*c-l;this.n32=j+k*c;this.n33=g*f;break;case "ZXY":k=f*h;i=f*e;l=d*h;j=d*e;this.n11=k-j*c;this.n12=-g*e;this.n13=l+i*c;this.n21=i+l*c;this.n22=g*h;this.n23=j-k*c;this.n31=-g*d;this.n32=c;this.n33=g*f;break;case "ZYX":k=g*h;i=g*e;l=c*h;j=c*e;this.n11=f*h;this.n12=l*d-i;this.n13=k*d+j;this.n21=f*e;this.n22=j*d+k;this.n23=i*d-l;this.n31=-d;this.n32=c*f;this.n33=g*f;break;case "YZX":k=g*f;i=
g*d;l=c*f;j=c*d;this.n11=f*h;this.n12=j-k*e;this.n13=l*e+i;this.n21=e;this.n22=g*h;this.n23=-c*h;this.n31=-d*h;this.n32=i*e+l;this.n33=k-j*e;break;case "XZY":k=g*f;i=g*d;l=c*f;j=c*d;this.n11=f*h;this.n12=-e;this.n13=d*h;this.n21=k*e+j;this.n22=g*h;this.n23=i*e-l;this.n31=l*e-i;this.n32=c*h;this.n33=j*e+k;break;default:k=g*h,i=g*e,l=c*h,j=c*e,this.n11=f*h,this.n12=-f*e,this.n13=d,this.n21=i+l*d,this.n22=k-j*d,this.n23=-c*f,this.n31=j-k*d,this.n32=l+i*d,this.n33=g*f}return this},setRotationFromQuaternion:function(a){var b=
a.x,c=a.y,d=a.z,e=a.w,g=b+b,f=c+c,h=d+d,a=b*g,k=b*f;b*=h;var i=c*f;c*=h;d*=h;g*=e;f*=e;e*=h;this.n11=1-(i+d);this.n12=k-e;this.n13=b+f;this.n21=k+e;this.n22=1-(a+d);this.n23=c-g;this.n31=b-f;this.n32=c+g;this.n33=1-(a+i);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;
d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);g.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();
c.y=e.length();c.z=g.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,b){var c=1/b.x,d=1/b.y,e=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=
a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,k=a.n23,i=a.n24,l=a.n31,j=a.n32,m=a.n33,n=a.n34,p=a.n41,q=a.n42,v=a.n43,u=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=k*n*q-i*m*q+i*j*v-h*n*v-k*j*u+h*m*u;b.n12=g*m*q-e*n*q-g*j*v+d*n*v+e*j*u-d*m*u;b.n13=e*i*q-g*k*q+g*h*v-d*i*v-e*h*u+d*k*u;b.n14=g*k*j-e*i*j-g*h*m+d*i*m+e*h*n-d*k*n;b.n21=i*m*p-k*n*p-i*l*v+f*n*v+k*l*u-f*m*u;b.n22=e*n*p-g*m*p+g*l*v-c*n*v-e*l*u+c*m*u;b.n23=g*k*p-e*i*p-g*f*v+c*i*v+e*f*u-c*k*u;b.n24=
e*i*l-g*k*l+g*f*m-c*i*m-e*f*n+c*k*n;b.n31=h*n*p-i*j*p+i*l*q-f*n*q-h*l*u+f*j*u;b.n32=g*j*p-d*n*p-g*l*q+c*n*q+d*l*u-c*j*u;b.n33=e*i*p-g*h*p+g*f*q-c*i*q-d*f*u+c*h*u;b.n34=g*h*l-d*i*l-g*f*j+c*i*j+d*f*n-c*h*n;b.n41=k*j*p-h*m*p-k*l*q+f*m*q+h*l*v-f*j*v;b.n42=d*m*p-e*j*p+e*l*q-c*m*q-d*l*v+c*j*v;b.n43=e*h*p-d*k*p-e*f*q+c*k*q+d*f*v-c*h*v;b.n44=d*k*l-e*h*l+e*f*j-c*k*j-d*f*m+c*h*m;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,f=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,k=-a.n32*a.n11+a.n31*a.n12,i=a.n23*a.n12-a.n22*a.n13,l=-a.n23*a.n11+a.n21*a.n13,j=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*f+a.n31*i;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*g;c[3]=a*f;c[4]=a*h;c[5]=a*k;c[6]=a*i;c[7]=a*l;c[8]=a*j;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,g){var f;f=new THREE.Matrix4;f.n11=2*e/(b-a);f.n12=0;f.n13=(b+a)/(b-a);f.n14=0;f.n21=0;f.n22=2*e/(d-c);f.n23=(d+c)/(d-c);f.n24=0;f.n31=0;f.n32=0;f.n33=-(g+e)/(g-e);f.n34=-2*g*e/(g-e);f.n41=0;f.n42=0;f.n43=-1;f.n44=0;return f};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,g){var f,h,k,i;f=new THREE.Matrix4;h=b-a;k=c-d;i=g-e;f.n11=2/h;f.n12=0;f.n13=0;f.n14=-((b+a)/h);f.n21=0;f.n22=2/k;f.n23=0;f.n24=-((c+d)/k);f.n31=0;f.n32=0;f.n33=-2/i;f.n34=-((g+e)/i);f.n41=0;f.n42=0;f.n43=0;f.n44=1;return f};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},remove:function(a){var b=this,c=this.children.indexOf(a);if(c!==-1){a.parent=void 0;for(this.children.splice(c,1);b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.removeChildRecurse(a)}},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===
a)return e;if(b&&(e=e.getChildByName(a,b),e!==void 0))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)},addChild:function(a){console.warn("DEPRECATED: Object3D.addChild() is now Object3D.add()");this.add(a)},removeChild:function(a){console.warn("DEPRECATED: Object3D.removeChild() is now Object3D.remove()");
this.remove(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=k[h]=k[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return e>=0&&f>=0&&g>=0&&h>=0?!0:e<0&&f<0||g<0&&h<0?!1:(e<0?c=Math.max(c,e/(e-f)):f<0&&(d=Math.min(d,e/(e-f))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,e,g=[],f,h,k=[],i,l,j=[],m,n=[],p,q,v=[],u,C,K=[],t=[],w=[],z=new THREE.Vector4,y=new THREE.Vector4,
o=new THREE.Matrix4,E=new THREE.Matrix4,D=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],F=new THREE.Vector4,G=new THREE.Vector4;this.projectVector=function(a,b){o.multiply(b.projectionMatrix,b.matrixWorldInverse);o.multiplyVector3(a);return a};this.unprojectVector=function(a,b){o.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));o.multiplyVector3(a);return a};this.projectObjects=function(a,c,f){var h,i;e=t.length=0;
h=a.objects;a=0;for(c=h.length;a<c;a++){i=h[a];var k;if(!(k=!i.visible))if(k=i instanceof THREE.Mesh)if(k=i.frustumCulled){a:{k=void 0;for(var j=i.matrixWorld,l=-i.geometry.boundingSphere.radius*Math.max(i.scale.x,Math.max(i.scale.y,i.scale.z)),m=0;m<6;m++)if(k=D[m].x*j.n14+D[m].y*j.n24+D[m].z*j.n34+D[m].w,k<=l){k=!1;break a}k=!0}k=!k}if(!k)k=g[e]=g[e]||new THREE.RenderableObject,e++,d=k,z.copy(i.position),o.multiplyVector3(z),d.object=i,d.z=z.z,t.push(d)}f&&t.sort(b);return t};this.projectScene=
function(d,e,g){var t=e.near,S=e.far,z,P,I,L,r,J,H,s,x,B,Q,U,W,X,R,V,T;C=q=m=l=w.length=0;e.matrixAutoUpdate&&e.update(void 0,!0);d.update(void 0,!1,e);o.multiply(e.projectionMatrix,e.matrixWorldInverse);D[0].set(o.n41-o.n11,o.n42-o.n12,o.n43-o.n13,o.n44-o.n14);D[1].set(o.n41+o.n11,o.n42+o.n12,o.n43+o.n13,o.n44+o.n14);D[2].set(o.n41+o.n21,o.n42+o.n22,o.n43+o.n23,o.n44+o.n24);D[3].set(o.n41-o.n21,o.n42-o.n22,o.n43-o.n23,o.n44-o.n24);D[4].set(o.n41-o.n31,o.n42-o.n32,o.n43-o.n33,o.n44-o.n34);D[5].set(o.n41+
o.n31,o.n42+o.n32,o.n43+o.n33,o.n44+o.n34);for(z=0;z<6;z++)x=D[z],x.divideScalar(Math.sqrt(x.x*x.x+x.y*x.y+x.z*x.z));x=this.projectObjects(d,e,!0);d=0;for(z=x.length;d<z;d++)if(B=x[d].object,B.visible)if(Q=B.matrixWorld,U=B.matrixRotationWorld,W=B.materials,X=B.overdraw,h=0,B instanceof THREE.Mesh){R=B.geometry;L=R.vertices;V=R.faces;R=R.faceVertexUvs;P=0;for(I=L.length;P<I;P++)f=a(),f.positionWorld.copy(L[P].position),Q.multiplyVector3(f.positionWorld),f.positionScreen.copy(f.positionWorld),o.multiplyVector4(f.positionScreen),
f.positionScreen.x/=f.positionScreen.w,f.positionScreen.y/=f.positionScreen.w,f.visible=f.positionScreen.z>t&&f.positionScreen.z<S;L=0;for(P=V.length;L<P;L++){I=V[L];if(I instanceof THREE.Face3)if(r=k[I.a],J=k[I.b],H=k[I.c],r.visible&&J.visible&&H.visible&&(B.doubleSided||B.flipSided!=(H.positionScreen.x-r.positionScreen.x)*(J.positionScreen.y-r.positionScreen.y)-(H.positionScreen.y-r.positionScreen.y)*(J.positionScreen.x-r.positionScreen.x)<0))s=j[l]=j[l]||new THREE.RenderableFace3,l++,i=s,i.v1.copy(r),
i.v2.copy(J),i.v3.copy(H);else continue;else if(I instanceof THREE.Face4)if(r=k[I.a],J=k[I.b],H=k[I.c],s=k[I.d],r.visible&&J.visible&&H.visible&&s.visible&&(B.doubleSided||B.flipSided!=((s.positionScreen.x-r.positionScreen.x)*(J.positionScreen.y-r.positionScreen.y)-(s.positionScreen.y-r.positionScreen.y)*(J.positionScreen.x-r.positionScreen.x)<0||(J.positionScreen.x-H.positionScreen.x)*(s.positionScreen.y-H.positionScreen.y)-(J.positionScreen.y-H.positionScreen.y)*(s.positionScreen.x-H.positionScreen.x)<
0)))T=n[m]=n[m]||new THREE.RenderableFace4,m++,i=T,i.v1.copy(r),i.v2.copy(J),i.v3.copy(H),i.v4.copy(s);else continue;i.normalWorld.copy(I.normal);U.multiplyVector3(i.normalWorld);i.centroidWorld.copy(I.centroid);Q.multiplyVector3(i.centroidWorld);i.centroidScreen.copy(i.centroidWorld);o.multiplyVector3(i.centroidScreen);H=I.vertexNormals;r=0;for(J=H.length;r<J;r++)s=i.vertexNormalsWorld[r],s.copy(H[r]),U.multiplyVector3(s);r=0;for(J=R.length;r<J;r++)if(T=R[r][L]){H=0;for(s=T.length;H<s;H++)i.uvs[r][H]=
T[H]}i.meshMaterials=W;i.faceMaterials=I.materials;i.overdraw=X;i.z=i.centroidScreen.z;w.push(i)}}else if(B instanceof THREE.Line){E.multiply(o,Q);L=B.geometry.vertices;r=a();r.positionScreen.copy(L[0].position);E.multiplyVector4(r.positionScreen);P=1;for(I=L.length;P<I;P++)if(r=a(),r.positionScreen.copy(L[P].position),E.multiplyVector4(r.positionScreen),J=k[h-2],F.copy(r.positionScreen),G.copy(J.positionScreen),c(F,G))F.multiplyScalar(1/F.w),G.multiplyScalar(1/G.w),Q=v[q]=v[q]||new THREE.RenderableLine,
q++,p=Q,p.v1.positionScreen.copy(F),p.v2.positionScreen.copy(G),p.z=Math.max(F.z,G.z),p.materials=B.materials,w.push(p)}else if(B instanceof THREE.Particle&&(y.set(B.matrixWorld.n14,B.matrixWorld.n24,B.matrixWorld.n34,1),o.multiplyVector4(y),y.z/=y.w,y.z>0&&y.z<1))Q=K[C]=K[C]||new THREE.RenderableParticle,C++,u=Q,u.x=y.x/y.w,u.y=y.y/y.w,u.z=y.z,u.rotation=B.rotation.z,u.scale.x=B.scale.x*Math.abs(u.x-(y.x+e.projectionMatrix.n11)/(y.w+e.projectionMatrix.n14)),u.scale.y=B.scale.y*Math.abs(u.y-(y.y+
e.projectionMatrix.n22)/(y.w+e.projectionMatrix.n24)),u.materials=B.materials,w.push(u);g&&w.sort(b);return w}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),g=Math.cos(c),c=Math.sin(c),f=a*b,h=d*e;this.w=f*g-h*c;this.x=f*c+h*g;this.y=d*b*g+a*e*c;this.z=a*e*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=a.n32-a.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=a.n13-a.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=a.n21-a.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,d=this.z,e=this.w,g=a.x,f=a.y,h=a.z,a=a.w;this.x=b*a+e*g+c*h-d*f;this.y=c*a+e*f+d*g-b*h;this.z=d*a+e*h+b*f-c*g;this.w=e*a-b*g-c*f-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,g=this.x,f=this.y,h=this.z,k=this.w,i=k*c+f*e-h*d,l=k*d+h*c-g*e,j=k*e+g*d-f*c,c=-g*
c-f*d-h*e;b.x=i*k+c*-g+l*-h-j*-f;b.y=l*k+c*-f+j*-g-i*-h;b.z=j*k+c*-h+i*-f-l*-g;return b}};THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(e),f=Math.sqrt(1-e*e);if(Math.abs(f)<0.0010)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;e=Math.sin((1-d)*g)/f;d=Math.sin(d*g)/f;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};
THREE.Vertex=function(a){this.position=a||new THREE.Vector3};THREE.Face3=function(a,b,c,d,e,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,g,f){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=f instanceof Array?f:[f];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var g=0,f=e.vertexNormals.length;g<f;g++)b.multiplyVector3(e.vertexNormals[g]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,
c,d,e,g,f,h=new THREE.Vector3,k=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],f=this.vertices[g.c],h.sub(f.position,c.position),k.sub(b.position,c.position),h.crossSelf(k);h.isZero()||h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=
Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof
THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,e,g,o){h=a.vertices[b].position;k=a.vertices[c].position;i=a.vertices[d].position;l=f[e];j=f[g];m=f[o];n=k.x-h.x;p=i.x-h.x;q=k.y-h.y;v=i.y-h.y;u=k.z-h.z;C=i.z-h.z;K=j.u-l.u;t=m.u-l.u;w=j.v-l.v;z=m.v-l.v;y=1/(K*z-t*w);F.set((z*n-w*p)*y,(z*q-w*v)*y,(z*u-w*C)*y);G.set((K*p-t*n)*y,(K*v-t*q)*y,(K*C-t*u)*y);E[b].addSelf(F);E[c].addSelf(F);E[d].addSelf(F);D[b].addSelf(G);
D[c].addSelf(G);D[d].addSelf(G)}var b,c,d,e,g,f,h,k,i,l,j,m,n,p,q,v,u,C,K,t,w,z,y,o,E=[],D=[],F=new THREE.Vector3,G=new THREE.Vector3,A=new THREE.Vector3,M=new THREE.Vector3,N=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)E[b]=new THREE.Vector3,D[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],f=this.faceVertexUvs[0][b],g instanceof THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var O=["a","b",
"c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)N.copy(g.vertexNormals[d]),e=g[O[d]],o=E[e],A.copy(o),A.subSelf(N.multiplyScalar(N.dot(o))).normalize(),M.cross(g.vertexNormals[d],o),e=M.dot(D[e]),e=e<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(A.x,A.y,A.z,e)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,
this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=
a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,e,g,f,h=
{};c=0;for(d=this.faces.length;c<d;c++)f=this.faces[c],f instanceof THREE.Face3?(e=a(f.a,f.b),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.a,f.c),b(h,e,c)):f instanceof THREE.Face4&&(e=a(f.b,f.d),b(h,e,c),e=a(f.a,f.b),b(h,e,c),e=a(f.a,f.d),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.c,f.d),b(h,e,c));c=0;for(d=this.edges.length;c<d;c++){f=this.edges[c];e=f.vertexIndices[0];g=f.vertexIndices[1];f.faceIndices=h[a(e,g)].array;for(e=0;e<f.faceIndices.length;e++)g=f.faceIndices[e],f.faces.push(this.faces[g])}}};
THREE.GeometryCount=0;THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c!==void 0?c:0.1;this.far=d!==void 0?d:2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);b.multiplyScalar(a);this.position.addSelf(b);this.target.position.addSelf(b)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(a,b,c,d,e,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=g;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.OrthoCamera=function(a,b,c,d,e,g,f){THREE.Camera.call(this,45,1,e,g,f);this.left=a;this.right=b;this.top=c;this.bottom=d;this.updateProjectionMatrix()};THREE.OrthoCamera.prototype=new THREE.Camera;THREE.OrthoCamera.prototype.constructor=THREE.OrthoCamera;
THREE.OrthoCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.id=THREE.MaterialCount++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.depthWrite=a.depthWrite!==void 0?a.depthWrite:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:
!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?
a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?
a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=
a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.add=function(a){this.supr.add.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.remove=function(a){this.supr.remove.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addChild=function(a){console.warn("DEPRECATED: Scene.addChild() is now Scene.add()");this.add(a)};THREE.Scene.prototype.addObject=function(a){console.warn("DEPRECATED: Scene.addObject() is now Scene.add()");this.add(a)};THREE.Scene.prototype.addLight=function(a){console.warn("DEPRECATED: Scene.addLight() is now Scene.add()");this.add(a)};THREE.Scene.prototype.removeChild=function(a){console.warn("DEPRECATED: Scene.removeChild() is now Scene.remove()");this.remove(a)};
THREE.Scene.prototype.removeObject=function(a){console.warn("DEPRECATED: Scene.removeObject() is now Scene.remove()");this.remove(a)};THREE.Scene.prototype.removeLight=function(a){console.warn("DEPRECATED: Scene.removeLight() is now Scene.remove()");this.remove(a)};
THREE.SVGRenderer=function(){function a(a,b,c){var d,e,f,g;d=0;for(e=a.lights.length;d<e;d++)f=a.lights[d],f instanceof THREE.DirectionalLight?(g=b.normalWorld.dot(f.position)*f.intensity,g>0&&(c.r+=f.color.r*g,c.g+=f.color.g*g,c.b+=f.color.b*g)):f instanceof THREE.PointLight&&(D.sub(f.position,b.centroidWorld),D.normalize(),g=b.normalWorld.dot(D)*f.intensity,g>0&&(c.r+=f.color.r*g,c.g+=f.color.g*g,c.b+=f.color.b*g))}function b(b,c,f,h,i,j){g.data.vertices+=3;g.data.faces++;A=d(M++);A.setAttribute("d",
"M "+b.positionScreen.x+" "+b.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+f.positionScreen.x+","+f.positionScreen.y+"z");i instanceof THREE.MeshBasicMaterial?t.copy(i.color):i instanceof THREE.MeshLambertMaterial?K?(w.r=z.r,w.g=z.g,w.b=z.b,a(j,h,w),t.r=Math.max(0,Math.min(i.color.r*w.r,1)),t.g=Math.max(0,Math.min(i.color.g*w.g,1)),t.b=Math.max(0,Math.min(i.color.b*w.b,1))):t.copy(i.color):i instanceof THREE.MeshDepthMaterial?(E=1-i.__2near/(i.__farPlusNear-h.z*i.__farMinusNear),
t.setRGB(E,E,E)):i instanceof THREE.MeshNormalMaterial&&t.setRGB(e(h.normalWorld.x),e(h.normalWorld.y),e(h.normalWorld.z));i.wireframe?A.setAttribute("style","fill: none; stroke: "+t.getContextStyle()+"; stroke-width: "+i.wireframeLinewidth+"; stroke-opacity: "+i.opacity+"; stroke-linecap: "+i.wireframeLinecap+"; stroke-linejoin: "+i.wireframeLinejoin):A.setAttribute("style","fill: "+t.getContextStyle()+"; fill-opacity: "+i.opacity);k.appendChild(A)}function c(b,c,f,h,i,j,m){g.data.vertices+=4;g.data.faces++;
A=d(M++);A.setAttribute("d","M "+b.positionScreen.x+" "+b.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+f.positionScreen.x+","+f.positionScreen.y+" L "+h.positionScreen.x+","+h.positionScreen.y+"z");j instanceof THREE.MeshBasicMaterial?t.copy(j.color):j instanceof THREE.MeshLambertMaterial?K?(w.r=z.r,w.g=z.g,w.b=z.b,a(m,i,w),t.r=Math.max(0,Math.min(j.color.r*w.r,1)),t.g=Math.max(0,Math.min(j.color.g*w.g,1)),t.b=Math.max(0,Math.min(j.color.b*w.b,1))):t.copy(j.color):j instanceof
THREE.MeshDepthMaterial?(E=1-j.__2near/(j.__farPlusNear-i.z*j.__farMinusNear),t.setRGB(E,E,E)):j instanceof THREE.MeshNormalMaterial&&t.setRGB(e(i.normalWorld.x),e(i.normalWorld.y),e(i.normalWorld.z));j.wireframe?A.setAttribute("style","fill: none; stroke: "+t.getContextStyle()+"; stroke-width: "+j.wireframeLinewidth+"; stroke-opacity: "+j.opacity+"; stroke-linecap: "+j.wireframeLinecap+"; stroke-linejoin: "+j.wireframeLinejoin):A.setAttribute("style","fill: "+t.getContextStyle()+"; fill-opacity: "+
j.opacity);k.appendChild(A)}function d(a){F[a]==null&&(F[a]=document.createElementNS("http://www.w3.org/2000/svg","path"),O==0&&F[a].setAttribute("shape-rendering","crispEdges"));return F[a]}function e(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}var g=this,f=null,h=new THREE.Projector,k=document.createElementNS("http://www.w3.org/2000/svg","svg"),i,l,j,m,n,p,q,v,u=new THREE.Rectangle,C=new THREE.Rectangle,K=!1,t=new THREE.Color(16777215),w=new THREE.Color(16777215),z=new THREE.Color(0),y=new THREE.Color(0),
o=new THREE.Color(0),E,D=new THREE.Vector3,F=[],G=[],A,M,N,O=1;this.domElement=k;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setQuality=function(a){switch(a){case "high":O=1;break;case "low":O=0}};this.setSize=function(a,b){i=a;l=b;j=i/2;m=l/2;k.setAttribute("viewBox",-j+" "+-m+" "+i+" "+l);k.setAttribute("width",i);k.setAttribute("height",l);u.set(-j,-m,j,m)};this.clear=function(){for(;k.childNodes.length>0;)k.removeChild(k.childNodes[0])};this.render=
function(a,d){var e,i,l,r,t,w,s,x;this.autoClear&&this.clear();g.data.vertices=0;g.data.faces=0;f=h.projectScene(a,d,this.sortElements);N=M=0;if(K=a.lights.length>0){s=a.lights;z.setRGB(0,0,0);y.setRGB(0,0,0);o.setRGB(0,0,0);e=0;for(i=s.length;e<i;e++)l=s[e],r=l.color,l instanceof THREE.AmbientLight?(z.r+=r.r,z.g+=r.g,z.b+=r.b):l instanceof THREE.DirectionalLight?(y.r+=r.r,y.g+=r.g,y.b+=r.b):l instanceof THREE.PointLight&&(o.r+=r.r,o.g+=r.g,o.b+=r.b)}e=0;for(i=f.length;e<i;e++)if(s=f[e],C.empty(),
s instanceof THREE.RenderableParticle){n=s;n.x*=j;n.y*=-m;l=0;for(r=s.materials.length;l<r;)l++}else if(s instanceof THREE.RenderableLine){if(n=s.v1,p=s.v2,n.positionScreen.x*=j,n.positionScreen.y*=-m,p.positionScreen.x*=j,p.positionScreen.y*=-m,C.addPoint(n.positionScreen.x,n.positionScreen.y),C.addPoint(p.positionScreen.x,p.positionScreen.y),u.intersects(C)){l=0;for(r=s.materials.length;l<r;)if((x=s.materials[l++])&&x.opacity!=0){t=n;w=p;var B=N++;G[B]==null&&(G[B]=document.createElementNS("http://www.w3.org/2000/svg",
"line"),O==0&&G[B].setAttribute("shape-rendering","crispEdges"));A=G[B];A.setAttribute("x1",t.positionScreen.x);A.setAttribute("y1",t.positionScreen.y);A.setAttribute("x2",w.positionScreen.x);A.setAttribute("y2",w.positionScreen.y);x instanceof THREE.LineBasicMaterial&&(A.setAttribute("style","fill: none; stroke: "+x.color.getContextStyle()+"; stroke-width: "+x.linewidth+"; stroke-opacity: "+x.opacity+"; stroke-linecap: "+x.linecap+"; stroke-linejoin: "+x.linejoin),k.appendChild(A))}}}else if(s instanceof
THREE.RenderableFace3){if(n=s.v1,p=s.v2,q=s.v3,n.positionScreen.x*=j,n.positionScreen.y*=-m,p.positionScreen.x*=j,p.positionScreen.y*=-m,q.positionScreen.x*=j,q.positionScreen.y*=-m,C.addPoint(n.positionScreen.x,n.positionScreen.y),C.addPoint(p.positionScreen.x,p.positionScreen.y),C.addPoint(q.positionScreen.x,q.positionScreen.y),u.intersects(C)){l=0;for(r=s.meshMaterials.length;l<r;)if(x=s.meshMaterials[l++],x instanceof THREE.MeshFaceMaterial){t=0;for(w=s.faceMaterials.length;t<w;)(x=s.faceMaterials[t++])&&
x.opacity!=0&&b(n,p,q,s,x,a)}else x&&x.opacity!=0&&b(n,p,q,s,x,a)}}else if(s instanceof THREE.RenderableFace4&&(n=s.v1,p=s.v2,q=s.v3,v=s.v4,n.positionScreen.x*=j,n.positionScreen.y*=-m,p.positionScreen.x*=j,p.positionScreen.y*=-m,q.positionScreen.x*=j,q.positionScreen.y*=-m,v.positionScreen.x*=j,v.positionScreen.y*=-m,C.addPoint(n.positionScreen.x,n.positionScreen.y),C.addPoint(p.positionScreen.x,p.positionScreen.y),C.addPoint(q.positionScreen.x,q.positionScreen.y),C.addPoint(v.positionScreen.x,v.positionScreen.y),
u.intersects(C))){l=0;for(r=s.meshMaterials.length;l<r;)if(x=s.meshMaterials[l++],x instanceof THREE.MeshFaceMaterial){t=0;for(w=s.faceMaterials.length;t<w;)(x=s.faceMaterials[t++])&&x.opacity!=0&&c(n,p,q,v,s,x,a)}else x&&x.opacity!=0&&c(n,p,q,v,s,x,a)}}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
