// ThreeWebGL.js r45dev - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;THREE.Color=function(b){b!==void 0&&this.setHex(b);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(b){this.r=b.r;this.g=b.g;this.b=b.b;return this},setRGB:function(b,c,d){this.r=b;this.g=c;this.b=d;return this},setHSV:function(b,c,d){var f,j,h;if(d==0)this.r=this.g=this.b=0;else switch(f=Math.floor(b*6),j=b*6-f,b=d*(1-c),h=d*(1-c*j),c=d*(1-c*(1-j)),f){case 1:this.r=h;this.g=d;this.b=b;break;case 2:this.r=b;this.g=d;this.b=c;break;case 3:this.r=b;this.g=h;this.b=d;break;case 4:this.r=c;this.g=b;this.b=d;break;case 5:this.r=
d;this.g=b;this.b=h;break;case 6:case 0:this.r=d,this.g=c,this.b=b}return this},setHex:function(b){b=Math.floor(b);this.r=(b>>16&255)/255;this.g=(b>>8&255)/255;this.b=(b&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(b,c){this.x=b||0;this.y=c||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(b,c){this.x=b;this.y=c;return this},copy:function(b){this.x=b.x;this.y=b.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;return this},
divideScalar:function(b){b?(this.x/=b,this.y/=b):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){var c=this.x-b.x,b=this.y-b.y;return c*c+b*b},setLength:function(b){return this.normalize().multiplyScalar(b)},
equals:function(b){return b.x==this.x&&b.y==this.y}};THREE.Vector3=function(b,c,d){this.x=b||0;this.y=c||0;this.z=d||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(b,c,d){this.x=b;this.y=c;this.z=d;return this},setX:function(b){this.x=b;return this},setY:function(b){this.y=b;return this},setZ:function(b){this.z=b;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;return this},
addScalar:function(b){this.x+=b;this.y+=b;this.z+=b;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=b.z-c.z;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;return this},multiply:function(b,c){this.x=b.x*c.x;this.y=b.y*c.y;this.z=b.z*c.z;return this},multiplySelf:function(b){this.x*=b.x;this.y*=b.y;this.z*=b.z;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;return this},divideSelf:function(b){this.x/=b.x;this.y/=b.y;this.z/=b.z;return this},
divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},
cross:function(b,c){this.x=b.y*c.z-b.z*c.y;this.y=b.z*c.x-b.x*c.z;this.z=b.x*c.y-b.y*c.x;return this},crossSelf:function(b){return this.set(this.y*b.z-this.z*b.y,this.z*b.x-this.x*b.z,this.x*b.y-this.y*b.x)},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){return(new THREE.Vector3).sub(this,b).lengthSq()},setPositionFromMatrix:function(b){this.x=b.n14;this.y=b.n24;this.z=b.n34},setRotationFromMatrix:function(b){var c=Math.cos(this.y);this.y=Math.asin(b.n13);
Math.abs(c)>1.0E-5?(this.x=Math.atan2(-b.n23/c,b.n33/c),this.z=Math.atan2(-b.n12/c,b.n11/c)):(this.x=0,this.z=Math.atan2(b.n21,b.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};THREE.Vector4=function(b,c,d,f){this.x=b||0;this.y=c||0;this.z=d||0;this.w=f!==void 0?f:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(b,c,d,f){this.x=b;this.y=c;this.z=d;this.w=f;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w!==void 0?b.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;this.w=b.w+c.w;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;this.w+=b.w;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=b.z-
c.z;this.w=b.w-c.w;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;this.w-=b.w;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;this.w*=b;return this},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b,this.w/=b):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z+this.w*b.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},lerpSelf:function(b,c){this.x+=(b.x-this.x)*c;this.y+=(b.y-this.y)*c;this.z+=(b.z-this.z)*c;this.w+=(b.w-this.w)*c;return this}};THREE.Ray=function(b,c){this.origin=b||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(b){return this.intersectObjects(b.objects)},intersectObjects:function(b){var c,d,f=[];c=0;for(d=b.length;c<d;c++)f=f.concat(this.intersectObject(b[c]));f.sort(function(b,c){return b.distance-c.distance});return f},intersectObject:function(b){function c(b,c,d){var f;f=d.clone().subSelf(b).dot(c);if(f<=0)return null;b=b.clone().addSelf(c.clone().multiplyScalar(f));return d.distanceTo(b)}function d(b,c,d,f){var f=f.clone().subSelf(c),
d=d.clone().subSelf(c),j=b.clone().subSelf(c),b=f.dot(f),c=f.dot(d),f=f.dot(j),h=d.dot(d),d=d.dot(j),j=1/(b*h-c*c),h=(h*f-c*d)*j,b=(b*d-c*f)*j;return h>0&&b>0&&h+b<1}if(b instanceof THREE.Particle){var f=c(this.origin,this.direction,b.matrixWorld.getPosition());if(f==null||f>b.scale.x)return[];return[{distance:f,point:b.position,face:null,object:b}]}else if(b instanceof THREE.Mesh){f=c(this.origin,this.direction,b.matrixWorld.getPosition());if(f==null||f>b.geometry.boundingSphere.radius*Math.max(b.scale.x,
Math.max(b.scale.y,b.scale.z)))return[];var j,h,k,m,p,q,s,r,u,v,B=b.geometry,y=B.vertices,E=[],f=0;for(j=B.faces.length;f<j;f++)if(h=B.faces[f],u=this.origin.clone(),v=this.direction.clone(),q=b.matrixWorld,k=q.multiplyVector3(h.centroid.clone()).subSelf(u),r=k.dot(v),!(r<=0)&&(k=q.multiplyVector3(y[h.a].position.clone()),m=q.multiplyVector3(y[h.b].position.clone()),p=q.multiplyVector3(y[h.c].position.clone()),q=h instanceof THREE.Face4?q.multiplyVector3(y[h.d].position.clone()):null,s=b.matrixRotationWorld.multiplyVector3(h.normal.clone()),
r=v.dot(s),b.doubleSided||(b.flipSided?r>0:r<0)))if(r=s.dot((new THREE.Vector3).sub(k,u))/r,u=u.addSelf(v.multiplyScalar(r)),h instanceof THREE.Face3)d(u,k,m,p)&&(h={distance:this.origin.distanceTo(u),point:u,face:h,object:b},E.push(h));else if(h instanceof THREE.Face4&&(d(u,k,m,q)||d(u,m,p,q)))h={distance:this.origin.distanceTo(u),point:u,face:h,object:b},E.push(h);E.sort(function(b,c){return b.distance-c.distance});return E}else return[]}};
THREE.Rectangle=function(){function b(){h=f-c;k=j-d}var c,d,f,j,h,k,m=!0;this.getX=function(){return c};this.getY=function(){return d};this.getWidth=function(){return h};this.getHeight=function(){return k};this.getLeft=function(){return c};this.getTop=function(){return d};this.getRight=function(){return f};this.getBottom=function(){return j};this.set=function(h,k,s,r){m=!1;c=h;d=k;f=s;j=r;b()};this.addPoint=function(h,k){m?(m=!1,c=h,d=k,f=h,j=k):(c=c<h?c:h,d=d<k?d:k,f=f>h?f:h,j=j>k?j:k);b()};this.add3Points=
function(h,k,s,r,u,v){m?(m=!1,c=h<s?h<u?h:u:s<u?s:u,d=k<r?k<v?k:v:r<v?r:v,f=h>s?h>u?h:u:s>u?s:u,j=k>r?k>v?k:v:r>v?r:v):(c=h<s?h<u?h<c?h:c:u<c?u:c:s<u?s<c?s:c:u<c?u:c,d=k<r?k<v?k<d?k:d:v<d?v:d:r<v?r<d?r:d:v<d?v:d,f=h>s?h>u?h>f?h:f:u>f?u:f:s>u?s>f?s:f:u>f?u:f,j=k>r?k>v?k>j?k:j:v>j?v:j:r>v?r>j?r:j:v>j?v:j);b()};this.addRectangle=function(h){m?(m=!1,c=h.getLeft(),d=h.getTop(),f=h.getRight(),j=h.getBottom()):(c=c<h.getLeft()?c:h.getLeft(),d=d<h.getTop()?d:h.getTop(),f=f>h.getRight()?f:h.getRight(),j=j>
h.getBottom()?j:h.getBottom());b()};this.inflate=function(h){c-=h;d-=h;f+=h;j+=h;b()};this.minSelf=function(h){c=c>h.getLeft()?c:h.getLeft();d=d>h.getTop()?d:h.getTop();f=f<h.getRight()?f:h.getRight();j=j<h.getBottom()?j:h.getBottom();b()};this.intersects=function(b){return Math.min(f,b.getRight())-Math.max(c,b.getLeft())>=0&&Math.min(j,b.getBottom())-Math.max(d,b.getTop())>=0};this.empty=function(){m=!0;j=f=d=c=0;b()};this.isEmpty=function(){return m}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var b,c=this.m;b=c[1];c[1]=c[3];c[3]=b;b=c[2];c[2]=c[6];c[6]=b;b=c[5];c[5]=c[7];c[7]=b;return this},transposeIntoArray:function(b){var c=this.m;b[0]=c[0];b[1]=c[3];b[2]=c[6];b[3]=c[1];b[4]=c[4];b[5]=c[7];b[6]=c[2];b[7]=c[5];b[8]=c[8];return this}};
THREE.Matrix4=function(b,c,d,f,j,h,k,m,p,q,s,r,u,v,B,y){this.set(b!==void 0?b:1,c||0,d||0,f||0,j||0,h!==void 0?h:1,k||0,m||0,p||0,q||0,s!==void 0?s:1,r||0,u||0,v||0,B||0,y!==void 0?y:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(b,c,d,f,j,h,k,m,p,q,s,r,u,v,B,y){this.n11=b;this.n12=c;this.n13=d;this.n14=f;this.n21=j;this.n22=h;this.n23=k;this.n24=m;this.n31=p;this.n32=q;this.n33=s;this.n34=r;this.n41=u;this.n42=v;this.n43=B;this.n44=y;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(b){this.set(b.n11,b.n12,b.n13,b.n14,b.n21,b.n22,b.n23,b.n24,b.n31,b.n32,b.n33,b.n34,b.n41,b.n42,b.n43,b.n44);return this},lookAt:function(b,
c,d){var f=THREE.Matrix4.__v1,j=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;h.sub(b,c).normalize();if(h.length()===0)h.z=1;f.cross(d,h).normalize();f.length()===0&&(h.x+=1.0E-4,f.cross(d,h).normalize());j.cross(h,f).normalize();this.n11=f.x;this.n12=j.x;this.n13=h.x;this.n21=f.y;this.n22=j.y;this.n23=h.y;this.n31=f.z;this.n32=j.z;this.n33=h.z;return this},multiplyVector3:function(b){var c=b.x,d=b.y,f=b.z,j=1/(this.n41*c+this.n42*d+this.n43*f+this.n44);b.x=(this.n11*c+this.n12*d+this.n13*f+this.n14)*j;
b.y=(this.n21*c+this.n22*d+this.n23*f+this.n24)*j;b.z=(this.n31*c+this.n32*d+this.n33*f+this.n34)*j;return b},multiplyVector4:function(b){var c=b.x,d=b.y,f=b.z,j=b.w;b.x=this.n11*c+this.n12*d+this.n13*f+this.n14*j;b.y=this.n21*c+this.n22*d+this.n23*f+this.n24*j;b.z=this.n31*c+this.n32*d+this.n33*f+this.n34*j;b.w=this.n41*c+this.n42*d+this.n43*f+this.n44*j;return b},rotateAxis:function(b){var c=b.x,d=b.y,f=b.z;b.x=c*this.n11+d*this.n12+f*this.n13;b.y=c*this.n21+d*this.n22+f*this.n23;b.z=c*this.n31+
d*this.n32+f*this.n33;b.normalize();return b},crossVector:function(b){var c=new THREE.Vector4;c.x=this.n11*b.x+this.n12*b.y+this.n13*b.z+this.n14*b.w;c.y=this.n21*b.x+this.n22*b.y+this.n23*b.z+this.n24*b.w;c.z=this.n31*b.x+this.n32*b.y+this.n33*b.z+this.n34*b.w;c.w=b.w?this.n41*b.x+this.n42*b.y+this.n43*b.z+this.n44*b.w:1;return c},multiply:function(b,c){var d=b.n11,f=b.n12,j=b.n13,h=b.n14,k=b.n21,m=b.n22,p=b.n23,q=b.n24,s=b.n31,r=b.n32,u=b.n33,v=b.n34,B=b.n41,y=b.n42,E=b.n43,C=b.n44,ya=c.n11,za=
c.n12,qa=c.n13,sa=c.n14,ga=c.n21,F=c.n22,w=c.n23,ja=c.n24,L=c.n31,ka=c.n32,Y=c.n33,va=c.n34,Q=c.n41,M=c.n42,e=c.n43,Ea=c.n44;this.n11=d*ya+f*ga+j*L+h*Q;this.n12=d*za+f*F+j*ka+h*M;this.n13=d*qa+f*w+j*Y+h*e;this.n14=d*sa+f*ja+j*va+h*Ea;this.n21=k*ya+m*ga+p*L+q*Q;this.n22=k*za+m*F+p*ka+q*M;this.n23=k*qa+m*w+p*Y+q*e;this.n24=k*sa+m*ja+p*va+q*Ea;this.n31=s*ya+r*ga+u*L+v*Q;this.n32=s*za+r*F+u*ka+v*M;this.n33=s*qa+r*w+u*Y+v*e;this.n34=s*sa+r*ja+u*va+v*Ea;this.n41=B*ya+y*ga+E*L+C*Q;this.n42=B*za+y*F+E*ka+
C*M;this.n43=B*qa+y*w+E*Y+C*e;this.n44=B*sa+y*ja+E*va+C*Ea;return this},multiplyToArray:function(b,c,d){this.multiply(b,c);d[0]=this.n11;d[1]=this.n21;d[2]=this.n31;d[3]=this.n41;d[4]=this.n12;d[5]=this.n22;d[6]=this.n32;d[7]=this.n42;d[8]=this.n13;d[9]=this.n23;d[10]=this.n33;d[11]=this.n43;d[12]=this.n14;d[13]=this.n24;d[14]=this.n34;d[15]=this.n44;return this},multiplySelf:function(b){this.multiply(this,b);return this},multiplyScalar:function(b){this.n11*=b;this.n12*=b;this.n13*=b;this.n14*=b;
this.n21*=b;this.n22*=b;this.n23*=b;this.n24*=b;this.n31*=b;this.n32*=b;this.n33*=b;this.n34*=b;this.n41*=b;this.n42*=b;this.n43*=b;this.n44*=b;return this},determinant:function(){var b=this.n11,c=this.n12,d=this.n13,f=this.n14,j=this.n21,h=this.n22,k=this.n23,m=this.n24,p=this.n31,q=this.n32,s=this.n33,r=this.n34,u=this.n41,v=this.n42,B=this.n43,y=this.n44;return f*k*q*u-d*m*q*u-f*h*s*u+c*m*s*u+d*h*r*u-c*k*r*u-f*k*p*v+d*m*p*v+f*j*s*v-b*m*s*v-d*j*r*v+b*k*r*v+f*h*p*B-c*m*p*B-f*j*q*B+b*m*q*B+c*j*r*
B-b*h*r*B-d*h*p*y+c*k*p*y+d*j*q*y-b*k*q*y-c*j*s*y+b*h*s*y},transpose:function(){var b;b=this.n21;this.n21=this.n12;this.n12=b;b=this.n31;this.n31=this.n13;this.n13=b;b=this.n32;this.n32=this.n23;this.n23=b;b=this.n41;this.n41=this.n14;this.n14=b;b=this.n42;this.n42=this.n24;this.n24=b;b=this.n43;this.n43=this.n34;this.n43=b;return this},clone:function(){var b=new THREE.Matrix4;b.n11=this.n11;b.n12=this.n12;b.n13=this.n13;b.n14=this.n14;b.n21=this.n21;b.n22=this.n22;b.n23=this.n23;b.n24=this.n24;b.n31=
this.n31;b.n32=this.n32;b.n33=this.n33;b.n34=this.n34;b.n41=this.n41;b.n42=this.n42;b.n43=this.n43;b.n44=this.n44;return b},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;
return this.flat},flattenToArray:function(b){b[0]=this.n11;b[1]=this.n21;b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return b},flattenToArrayOffset:function(b,c){b[c]=this.n11;b[c+1]=this.n21;b[c+2]=this.n31;b[c+3]=this.n41;b[c+4]=this.n12;b[c+5]=this.n22;b[c+6]=this.n32;b[c+7]=this.n42;b[c+8]=this.n13;b[c+9]=this.n23;b[c+10]=this.n33;b[c+11]=
this.n43;b[c+12]=this.n14;b[c+13]=this.n24;b[c+14]=this.n34;b[c+15]=this.n44;return b},setTranslation:function(b,c,d){this.set(1,0,0,b,0,1,0,c,0,0,1,d,0,0,0,1);return this},setScale:function(b,c,d){this.set(b,0,0,0,0,c,0,0,0,0,d,0,0,0,0,1);return this},setRotationX:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(1,0,0,0,0,c,-b,0,0,b,c,0,0,0,0,1);return this},setRotationY:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,0,b,0,0,1,0,0,-b,0,c,0,0,0,0,1);return this},setRotationZ:function(b){var c=
Math.cos(b),b=Math.sin(b);this.set(c,-b,0,0,b,c,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(b,c){var d=Math.cos(c),f=Math.sin(c),j=1-d,h=b.x,k=b.y,m=b.z,p=j*h,q=j*k;this.set(p*h+d,p*k-f*m,p*m+f*k,0,p*k+f*m,q*k+d,q*m-f*h,0,p*m-f*k,q*m+f*h,j*m*m+d,0,0,0,0,1);return this},setPosition:function(b){this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},
getColumnX:function(){if(!this.columnX)this.columnX=new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(b,c){var d=b.x,f=b.y,j=b.z,h=Math.cos(d),d=Math.sin(d),k=Math.cos(f),
f=Math.sin(f),m=Math.cos(j),j=Math.sin(j);switch(c){case "YXZ":var p=k*m,q=k*j,s=f*m,r=f*j;this.n11=p+r*d;this.n12=s*d-q;this.n13=h*f;this.n21=h*j;this.n22=h*m;this.n23=-d;this.n31=q*d-s;this.n32=r+p*d;this.n33=h*k;break;case "ZXY":p=k*m;q=k*j;s=f*m;r=f*j;this.n11=p-r*d;this.n12=-h*j;this.n13=s+q*d;this.n21=q+s*d;this.n22=h*m;this.n23=r-p*d;this.n31=-h*f;this.n32=d;this.n33=h*k;break;case "ZYX":p=h*m;q=h*j;s=d*m;r=d*j;this.n11=k*m;this.n12=s*f-q;this.n13=p*f+r;this.n21=k*j;this.n22=r*f+p;this.n23=
q*f-s;this.n31=-f;this.n32=d*k;this.n33=h*k;break;case "YZX":p=h*k;q=h*f;s=d*k;r=d*f;this.n11=k*m;this.n12=r-p*j;this.n13=s*j+q;this.n21=j;this.n22=h*m;this.n23=-d*m;this.n31=-f*m;this.n32=q*j+s;this.n33=p-r*j;break;case "XZY":p=h*k;q=h*f;s=d*k;r=d*f;this.n11=k*m;this.n12=-j;this.n13=f*m;this.n21=p*j+r;this.n22=h*m;this.n23=q*j-s;this.n31=s*j-q;this.n32=d*m;this.n33=r*j+p;break;default:p=h*m,q=h*j,s=d*m,r=d*j,this.n11=k*m,this.n12=-k*j,this.n13=f,this.n21=q+s*f,this.n22=p-r*f,this.n23=-d*k,this.n31=
r-p*f,this.n32=s+q*f,this.n33=h*k}return this},setRotationFromQuaternion:function(b){var c=b.x,d=b.y,f=b.z,j=b.w,h=c+c,k=d+d,m=f+f,b=c*h,p=c*k;c*=m;var q=d*k;d*=m;f*=m;h*=j;k*=j;j*=m;this.n11=1-(q+f);this.n12=p-j;this.n13=c+k;this.n21=p+j;this.n22=1-(b+f);this.n23=d-h;this.n31=c-k;this.n32=d+h;this.n33=1-(b+q);return this},scale:function(b){var c=b.x,d=b.y,b=b.z;this.n11*=c;this.n12*=d;this.n13*=b;this.n21*=c;this.n22*=d;this.n23*=b;this.n31*=c;this.n32*=d;this.n33*=b;this.n41*=c;this.n42*=d;this.n43*=
b;return this},compose:function(b,c,d){var f=THREE.Matrix4.__m1,j=THREE.Matrix4.__m2;f.identity();f.setRotationFromQuaternion(c);j.setScale(d.x,d.y,d.z);this.multiply(f,j);this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},decompose:function(b,c,d){var f=THREE.Matrix4.__v1,j=THREE.Matrix4.__v2,h=THREE.Matrix4.__v3;f.set(this.n11,this.n21,this.n31);j.set(this.n12,this.n22,this.n32);h.set(this.n13,this.n23,this.n33);b=b instanceof THREE.Vector3?b:new THREE.Vector3;c=c instanceof THREE.Quaternion?c:
new THREE.Quaternion;d=d instanceof THREE.Vector3?d:new THREE.Vector3;d.x=f.length();d.y=j.length();d.z=h.length();b.x=this.n14;b.y=this.n24;b.z=this.n34;f=THREE.Matrix4.__m1;f.copy(this);f.n11/=d.x;f.n21/=d.x;f.n31/=d.x;f.n12/=d.y;f.n22/=d.y;f.n32/=d.y;f.n13/=d.z;f.n23/=d.z;f.n33/=d.z;c.setFromRotationMatrix(f);return[b,c,d]},extractPosition:function(b){this.n14=b.n14;this.n24=b.n24;this.n34=b.n34},extractRotation:function(b,c){var d=1/c.x,f=1/c.y,j=1/c.z;this.n11=b.n11*d;this.n21=b.n21*d;this.n31=
b.n31*d;this.n12=b.n12*f;this.n22=b.n22*f;this.n32=b.n32*f;this.n13=b.n13*j;this.n23=b.n23*j;this.n33=b.n33*j}};
THREE.Matrix4.makeInvert=function(b,c){var d=b.n11,f=b.n12,j=b.n13,h=b.n14,k=b.n21,m=b.n22,p=b.n23,q=b.n24,s=b.n31,r=b.n32,u=b.n33,v=b.n34,B=b.n41,y=b.n42,E=b.n43,C=b.n44;c===void 0&&(c=new THREE.Matrix4);c.n11=p*v*y-q*u*y+q*r*E-m*v*E-p*r*C+m*u*C;c.n12=h*u*y-j*v*y-h*r*E+f*v*E+j*r*C-f*u*C;c.n13=j*q*y-h*p*y+h*m*E-f*q*E-j*m*C+f*p*C;c.n14=h*p*r-j*q*r-h*m*u+f*q*u+j*m*v-f*p*v;c.n21=q*u*B-p*v*B-q*s*E+k*v*E+p*s*C-k*u*C;c.n22=j*v*B-h*u*B+h*s*E-d*v*E-j*s*C+d*u*C;c.n23=h*p*B-j*q*B-h*k*E+d*q*E+j*k*C-d*p*C;c.n24=
j*q*s-h*p*s+h*k*u-d*q*u-j*k*v+d*p*v;c.n31=m*v*B-q*r*B+q*s*y-k*v*y-m*s*C+k*r*C;c.n32=h*r*B-f*v*B-h*s*y+d*v*y+f*s*C-d*r*C;c.n33=j*q*B-h*m*B+h*k*y-d*q*y-f*k*C+d*m*C;c.n34=h*m*s-f*q*s-h*k*r+d*q*r+f*k*v-d*m*v;c.n41=p*r*B-m*u*B-p*s*y+k*u*y+m*s*E-k*r*E;c.n42=f*u*B-j*r*B+j*s*y-d*u*y-f*s*E+d*r*E;c.n43=j*m*B-f*p*B-j*k*y+d*p*y+f*k*E-d*m*E;c.n44=f*p*s-j*m*s+j*k*r-d*p*r-f*k*u+d*m*u;c.multiplyScalar(1/b.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(b){var c=b.m33,d=c.m,f=b.n33*b.n22-b.n32*b.n23,j=-b.n33*b.n21+b.n31*b.n23,h=b.n32*b.n21-b.n31*b.n22,k=-b.n33*b.n12+b.n32*b.n13,m=b.n33*b.n11-b.n31*b.n13,p=-b.n32*b.n11+b.n31*b.n12,q=b.n23*b.n12-b.n22*b.n13,s=-b.n23*b.n11+b.n21*b.n13,r=b.n22*b.n11-b.n21*b.n12,b=b.n11*f+b.n21*k+b.n31*q;b==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");b=1/b;d[0]=b*f;d[1]=b*j;d[2]=b*h;d[3]=b*k;d[4]=b*m;d[5]=b*p;d[6]=b*q;d[7]=b*s;d[8]=b*r;return c};
THREE.Matrix4.makeFrustum=function(b,c,d,f,j,h){var k;k=new THREE.Matrix4;k.n11=2*j/(c-b);k.n12=0;k.n13=(c+b)/(c-b);k.n14=0;k.n21=0;k.n22=2*j/(f-d);k.n23=(f+d)/(f-d);k.n24=0;k.n31=0;k.n32=0;k.n33=-(h+j)/(h-j);k.n34=-2*h*j/(h-j);k.n41=0;k.n42=0;k.n43=-1;k.n44=0;return k};THREE.Matrix4.makePerspective=function(b,c,d,f){var j,b=d*Math.tan(b*Math.PI/360);j=-b;return THREE.Matrix4.makeFrustum(j*c,b*c,j,b,d,f)};
THREE.Matrix4.makeOrtho=function(b,c,d,f,j,h){var k,m,p,q;k=new THREE.Matrix4;m=c-b;p=d-f;q=h-j;k.n11=2/m;k.n12=0;k.n13=0;k.n14=-((c+b)/m);k.n21=0;k.n22=2/p;k.n23=0;k.n24=-((d+f)/p);k.n31=0;k.n32=0;k.n33=-2/q;k.n34=-((h+j)/q);k.n41=0;k.n42=0;k.n43=0;k.n44=1;return k};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(b,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(b))},translateX:function(b){this.translate(b,this._vector.set(1,0,0))},translateY:function(b){this.translate(b,this._vector.set(0,1,0))},translateZ:function(b){this.translate(b,this._vector.set(0,0,1))},lookAt:function(b){this.matrix.lookAt(b,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(b){if(this.children.indexOf(b)===
-1){b.parent!==void 0&&b.parent.removeChild(b);b.parent=this;this.children.push(b);for(var c=this;c.parent!==void 0;)c=c.parent;c!==void 0&&c instanceof THREE.Scene&&c.addChildRecurse(b)}},remove:function(b){var c=this,d=this.children.indexOf(b);if(d!==-1){b.parent=void 0;for(this.children.splice(d,1);c.parent!==void 0;)c=c.parent;c!==void 0&&c instanceof THREE.Scene&&c.removeChildRecurse(b)}},getChildByName:function(b,c){var d,f,j;d=0;for(f=this.children.length;d<f;d++){j=this.children[d];if(j.name===
b)return j;if(c&&(j=j.getChildByName(b,c),j!==void 0))return j}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(b,c,d){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||c)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,c=!0;for(var b=0,f=this.children.length;b<f;b++)this.children[b].update(this.matrixWorld,c,d)},addChild:function(b){console.warn("DEPRECATED: Object3D.addChild() is now Object3D.add()");this.add(b)},removeChild:function(b){console.warn("DEPRECATED: Object3D.removeChild() is now Object3D.remove()");
this.remove(b)}};THREE.Object3DCount=0;
THREE.Projector=function(){function b(){var b=p[m]=p[m]||new THREE.RenderableVertex;m++;return b}function c(b,c){return c.z-b.z}function d(b,c){var d=0,e=1,f=b.z+b.w,j=c.z+c.w,h=-b.z+b.w,k=-c.z+c.w;return f>=0&&j>=0&&h>=0&&k>=0?!0:f<0&&j<0||h<0&&k<0?!1:(f<0?d=Math.max(d,f/(f-j)):j<0&&(e=Math.min(e,f/(f-j))),h<0?d=Math.max(d,h/(h-k)):k<0&&(e=Math.min(e,h/(h-k))),e<d?!1:(b.lerpSelf(c,d),c.lerpSelf(b,1-e),!0))}var f,j,h=[],k,m,p=[],q,s,r=[],u,v=[],B,y,E=[],C,ya,za=[],qa=[],sa=[],ga=new THREE.Vector4,
F=new THREE.Vector4,w=new THREE.Matrix4,ja=new THREE.Matrix4,L=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],ka=new THREE.Vector4,Y=new THREE.Vector4;this.projectVector=function(b,c){w.multiply(c.projectionMatrix,c.matrixWorldInverse);w.multiplyVector3(b);return b};this.unprojectVector=function(b,c){w.multiply(c.matrixWorld,THREE.Matrix4.makeInvert(c.projectionMatrix));w.multiplyVector3(b);return b};this.projectObjects=function(b,d,k){var e,
m;j=qa.length=0;e=b.objects;b=0;for(d=e.length;b<d;b++){m=e[b];var q;if(!(q=!m.visible))if(q=m instanceof THREE.Mesh)if(q=m.frustumCulled){a:{q=void 0;for(var p=m.matrixWorld,s=-m.geometry.boundingSphere.radius*Math.max(m.scale.x,Math.max(m.scale.y,m.scale.z)),r=0;r<6;r++)if(q=L[r].x*p.n14+L[r].y*p.n24+L[r].z*p.n34+L[r].w,q<=s){q=!1;break a}q=!0}q=!q}if(!q)q=h[j]=h[j]||new THREE.RenderableObject,j++,f=q,ga.copy(m.position),w.multiplyVector3(ga),f.object=m,f.z=ga.z,qa.push(f)}k&&qa.sort(c);return qa};
this.projectScene=function(f,j,h){var e=j.near,qa=j.far,ga,wa,T,Z,J,W,S,V,xa,P,ta,Ga,Aa,Fa,R,Ba,Da;ya=y=u=s=sa.length=0;j.matrixAutoUpdate&&j.update(void 0,!0);f.update(void 0,!1,j);w.multiply(j.projectionMatrix,j.matrixWorldInverse);L[0].set(w.n41-w.n11,w.n42-w.n12,w.n43-w.n13,w.n44-w.n14);L[1].set(w.n41+w.n11,w.n42+w.n12,w.n43+w.n13,w.n44+w.n14);L[2].set(w.n41+w.n21,w.n42+w.n22,w.n43+w.n23,w.n44+w.n24);L[3].set(w.n41-w.n21,w.n42-w.n22,w.n43-w.n23,w.n44-w.n24);L[4].set(w.n41-w.n31,w.n42-w.n32,w.n43-
w.n33,w.n44-w.n34);L[5].set(w.n41+w.n31,w.n42+w.n32,w.n43+w.n33,w.n44+w.n34);for(ga=0;ga<6;ga++)xa=L[ga],xa.divideScalar(Math.sqrt(xa.x*xa.x+xa.y*xa.y+xa.z*xa.z));xa=this.projectObjects(f,j,!0);f=0;for(ga=xa.length;f<ga;f++)if(P=xa[f].object,P.visible)if(ta=P.matrixWorld,Ga=P.matrixRotationWorld,Aa=P.materials,Fa=P.overdraw,m=0,P instanceof THREE.Mesh){R=P.geometry;Z=R.vertices;Ba=R.faces;R=R.faceVertexUvs;wa=0;for(T=Z.length;wa<T;wa++)k=b(),k.positionWorld.copy(Z[wa].position),ta.multiplyVector3(k.positionWorld),
k.positionScreen.copy(k.positionWorld),w.multiplyVector4(k.positionScreen),k.positionScreen.x/=k.positionScreen.w,k.positionScreen.y/=k.positionScreen.w,k.visible=k.positionScreen.z>e&&k.positionScreen.z<qa;Z=0;for(wa=Ba.length;Z<wa;Z++){T=Ba[Z];if(T instanceof THREE.Face3)if(J=p[T.a],W=p[T.b],S=p[T.c],J.visible&&W.visible&&S.visible&&(P.doubleSided||P.flipSided!=(S.positionScreen.x-J.positionScreen.x)*(W.positionScreen.y-J.positionScreen.y)-(S.positionScreen.y-J.positionScreen.y)*(W.positionScreen.x-
J.positionScreen.x)<0))V=r[s]=r[s]||new THREE.RenderableFace3,s++,q=V,q.v1.copy(J),q.v2.copy(W),q.v3.copy(S);else continue;else if(T instanceof THREE.Face4)if(J=p[T.a],W=p[T.b],S=p[T.c],V=p[T.d],J.visible&&W.visible&&S.visible&&V.visible&&(P.doubleSided||P.flipSided!=((V.positionScreen.x-J.positionScreen.x)*(W.positionScreen.y-J.positionScreen.y)-(V.positionScreen.y-J.positionScreen.y)*(W.positionScreen.x-J.positionScreen.x)<0||(W.positionScreen.x-S.positionScreen.x)*(V.positionScreen.y-S.positionScreen.y)-
(W.positionScreen.y-S.positionScreen.y)*(V.positionScreen.x-S.positionScreen.x)<0)))Da=v[u]=v[u]||new THREE.RenderableFace4,u++,q=Da,q.v1.copy(J),q.v2.copy(W),q.v3.copy(S),q.v4.copy(V);else continue;q.normalWorld.copy(T.normal);Ga.multiplyVector3(q.normalWorld);q.centroidWorld.copy(T.centroid);ta.multiplyVector3(q.centroidWorld);q.centroidScreen.copy(q.centroidWorld);w.multiplyVector3(q.centroidScreen);S=T.vertexNormals;J=0;for(W=S.length;J<W;J++)V=q.vertexNormalsWorld[J],V.copy(S[J]),Ga.multiplyVector3(V);
J=0;for(W=R.length;J<W;J++)if(Da=R[J][Z]){S=0;for(V=Da.length;S<V;S++)q.uvs[J][S]=Da[S]}q.meshMaterials=Aa;q.faceMaterials=T.materials;q.overdraw=Fa;q.z=q.centroidScreen.z;sa.push(q)}}else if(P instanceof THREE.Line){ja.multiply(w,ta);Z=P.geometry.vertices;J=b();J.positionScreen.copy(Z[0].position);ja.multiplyVector4(J.positionScreen);wa=1;for(T=Z.length;wa<T;wa++)if(J=b(),J.positionScreen.copy(Z[wa].position),ja.multiplyVector4(J.positionScreen),W=p[m-2],ka.copy(J.positionScreen),Y.copy(W.positionScreen),
d(ka,Y))ka.multiplyScalar(1/ka.w),Y.multiplyScalar(1/Y.w),ta=E[y]=E[y]||new THREE.RenderableLine,y++,B=ta,B.v1.positionScreen.copy(ka),B.v2.positionScreen.copy(Y),B.z=Math.max(ka.z,Y.z),B.materials=P.materials,sa.push(B)}else if(P instanceof THREE.Particle&&(F.set(P.matrixWorld.n14,P.matrixWorld.n24,P.matrixWorld.n34,1),w.multiplyVector4(F),F.z/=F.w,F.z>0&&F.z<1))ta=za[ya]=za[ya]||new THREE.RenderableParticle,ya++,C=ta,C.x=F.x/F.w,C.y=F.y/F.w,C.z=F.z,C.rotation=P.rotation.z,C.scale.x=P.scale.x*Math.abs(C.x-
(F.x+j.projectionMatrix.n11)/(F.w+j.projectionMatrix.n14)),C.scale.y=P.scale.y*Math.abs(C.y-(F.y+j.projectionMatrix.n22)/(F.w+j.projectionMatrix.n24)),C.materials=P.materials,sa.push(C);h&&sa.sort(c);return sa}};THREE.Quaternion=function(b,c,d,f){this.set(b||0,c||0,d||0,f!==void 0?f:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(b,c,d,f){this.x=b;this.y=c;this.z=d;this.w=f;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w;return this},setFromEuler:function(b){var c=0.5*Math.PI/360,d=b.x*c,f=b.y*c,j=b.z*c,b=Math.cos(f),f=Math.sin(f),c=Math.cos(-j),j=Math.sin(-j),h=Math.cos(d),d=Math.sin(d),k=b*c,m=f*j;this.w=k*h-m*d;this.x=k*d+m*h;this.y=f*c*h+b*j*d;this.z=b*j*h-f*c*d;return this},setFromAxisAngle:function(b,c){var d=c/2,f=Math.sin(d);
this.x=b.x*f;this.y=b.y*f;this.z=b.z*f;this.w=Math.cos(d);return this},setFromRotationMatrix:function(b){var c=Math.pow(b.determinant(),1/3);this.w=Math.sqrt(Math.max(0,c+b.n11+b.n22+b.n33))/2;this.x=Math.sqrt(Math.max(0,c+b.n11-b.n22-b.n33))/2;this.y=Math.sqrt(Math.max(0,c-b.n11+b.n22-b.n33))/2;this.z=Math.sqrt(Math.max(0,c-b.n11-b.n22+b.n33))/2;this.x=b.n32-b.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=b.n13-b.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=b.n21-b.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var b=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);b==0?this.w=this.z=this.y=this.x=0:(b=1/b,this.x*=b,this.y*=b,this.z*=b,this.w*=b);return this},multiplySelf:function(b){var c=
this.x,d=this.y,f=this.z,j=this.w,h=b.x,k=b.y,m=b.z,b=b.w;this.x=c*b+j*h+d*m-f*k;this.y=d*b+j*k+f*h-c*m;this.z=f*b+j*m+c*k-d*h;this.w=j*b-c*h-d*k-f*m;return this},multiply:function(b,c){this.x=b.x*c.w+b.y*c.z-b.z*c.y+b.w*c.x;this.y=-b.x*c.z+b.y*c.w+b.z*c.x+b.w*c.y;this.z=b.x*c.y-b.y*c.x+b.z*c.w+b.w*c.z;this.w=-b.x*c.x-b.y*c.y-b.z*c.z+b.w*c.w;return this},multiplyVector3:function(b,c){c||(c=b);var d=b.x,f=b.y,j=b.z,h=this.x,k=this.y,m=this.z,p=this.w,q=p*d+k*j-m*f,s=p*f+m*d-h*j,r=p*j+h*f-k*d,d=-h*
d-k*f-m*j;c.x=q*p+d*-h+s*-m-r*-k;c.y=s*p+d*-k+r*-h-q*-m;c.z=r*p+d*-m+q*-k-s*-h;return c}};THREE.Quaternion.slerp=function(b,c,d,f){var j=b.w*c.w+b.x*c.x+b.y*c.y+b.z*c.z;if(Math.abs(j)>=1)return d.w=b.w,d.x=b.x,d.y=b.y,d.z=b.z,d;var h=Math.acos(j),k=Math.sqrt(1-j*j);if(Math.abs(k)<0.0010)return d.w=0.5*(b.w+c.w),d.x=0.5*(b.x+c.x),d.y=0.5*(b.y+c.y),d.z=0.5*(b.z+c.z),d;j=Math.sin((1-f)*h)/k;f=Math.sin(f*h)/k;d.w=b.w*j+c.w*f;d.x=b.x*j+c.x*f;d.y=b.y*j+c.y*f;d.z=b.z*j+c.z*f;return d};
THREE.Vertex=function(b){this.position=b||new THREE.Vector3};THREE.Face3=function(b,c,d,f,j,h){this.a=b;this.b=c;this.c=d;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=j instanceof THREE.Color?j:new THREE.Color;this.vertexColors=j instanceof Array?j:[];this.vertexTangents=[];this.materials=h instanceof Array?h:[h];this.centroid=new THREE.Vector3};
THREE.Face4=function(b,c,d,f,j,h,k){this.a=b;this.b=c;this.c=d;this.d=f;this.normal=j instanceof THREE.Vector3?j:new THREE.Vector3;this.vertexNormals=j instanceof Array?j:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=k instanceof Array?k:[k];this.centroid=new THREE.Vector3};THREE.UV=function(b,c){this.u=b||0;this.v=c||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(b,c){this.u=b;this.v=c;return this},copy:function(b){this.u=b.u;this.v=b.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(b){var c=new THREE.Matrix4;c.extractRotation(b,new THREE.Vector3(1,1,1));for(var d=0,f=this.vertices.length;d<f;d++)b.multiplyVector3(this.vertices[d].position);d=0;for(f=this.faces.length;d<f;d++){var j=this.faces[d];c.multiplyVector3(j.normal);for(var h=0,k=j.vertexNormals.length;h<k;h++)c.multiplyVector3(j.vertexNormals[h]);b.multiplyVector3(j.centroid)}},computeCentroids:function(){var b,c,d;b=0;for(c=this.faces.length;b<
c;b++)d=this.faces[b],d.centroid.set(0,0,0),d instanceof THREE.Face3?(d.centroid.addSelf(this.vertices[d.a].position),d.centroid.addSelf(this.vertices[d.b].position),d.centroid.addSelf(this.vertices[d.c].position),d.centroid.divideScalar(3)):d instanceof THREE.Face4&&(d.centroid.addSelf(this.vertices[d.a].position),d.centroid.addSelf(this.vertices[d.b].position),d.centroid.addSelf(this.vertices[d.c].position),d.centroid.addSelf(this.vertices[d.d].position),d.centroid.divideScalar(4))},computeFaceNormals:function(b){var c,
d,f,j,h,k,m=new THREE.Vector3,p=new THREE.Vector3;f=0;for(j=this.faces.length;f<j;f++){h=this.faces[f];if(b&&h.vertexNormals.length){m.set(0,0,0);c=0;for(d=h.vertexNormals.length;c<d;c++)m.addSelf(h.vertexNormals[c]);m.divideScalar(3)}else c=this.vertices[h.a],d=this.vertices[h.b],k=this.vertices[h.c],m.sub(k.position,d.position),p.sub(c.position,d.position),m.crossSelf(p);m.isZero()||m.normalize();h.normal.copy(m)}},computeVertexNormals:function(){var b,c,d,f;if(this.__tmpVertices==void 0){f=this.__tmpVertices=
Array(this.vertices.length);b=0;for(c=this.vertices.length;b<c;b++)f[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)if(d=this.faces[b],d instanceof THREE.Face3)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(d instanceof THREE.Face4)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{f=this.__tmpVertices;b=0;for(c=this.vertices.length;b<c;b++)f[b].set(0,0,0)}b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d instanceof
THREE.Face3?(f[d.a].addSelf(d.normal),f[d.b].addSelf(d.normal),f[d.c].addSelf(d.normal)):d instanceof THREE.Face4&&(f[d.a].addSelf(d.normal),f[d.b].addSelf(d.normal),f[d.c].addSelf(d.normal),f[d.d].addSelf(d.normal));b=0;for(c=this.vertices.length;b<c;b++)f[b].normalize();b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d instanceof THREE.Face3?(d.vertexNormals[0].copy(f[d.a]),d.vertexNormals[1].copy(f[d.b]),d.vertexNormals[2].copy(f[d.c])):d instanceof THREE.Face4&&(d.vertexNormals[0].copy(f[d.a]),
d.vertexNormals[1].copy(f[d.b]),d.vertexNormals[2].copy(f[d.c]),d.vertexNormals[3].copy(f[d.d]))},computeTangents:function(){function b(b,e,c,d,f,j,h){m=b.vertices[e].position;p=b.vertices[c].position;q=b.vertices[d].position;s=k[f];r=k[j];u=k[h];v=p.x-m.x;B=q.x-m.x;y=p.y-m.y;E=q.y-m.y;C=p.z-m.z;ya=q.z-m.z;za=r.u-s.u;qa=u.u-s.u;sa=r.v-s.v;ga=u.v-s.v;F=1/(za*ga-qa*sa);ka.set((ga*v-sa*B)*F,(ga*y-sa*E)*F,(ga*C-sa*ya)*F);Y.set((za*B-qa*v)*F,(za*E-qa*y)*F,(za*ya-qa*C)*F);ja[e].addSelf(ka);ja[c].addSelf(ka);
ja[d].addSelf(ka);L[e].addSelf(Y);L[c].addSelf(Y);L[d].addSelf(Y)}var c,d,f,j,h,k,m,p,q,s,r,u,v,B,y,E,C,ya,za,qa,sa,ga,F,w,ja=[],L=[],ka=new THREE.Vector3,Y=new THREE.Vector3,va=new THREE.Vector3,Q=new THREE.Vector3,M=new THREE.Vector3;c=0;for(d=this.vertices.length;c<d;c++)ja[c]=new THREE.Vector3,L[c]=new THREE.Vector3;c=0;for(d=this.faces.length;c<d;c++)h=this.faces[c],k=this.faceVertexUvs[0][c],h instanceof THREE.Face3?b(this,h.a,h.b,h.c,0,1,2):h instanceof THREE.Face4&&(b(this,h.a,h.b,h.c,0,1,
2),b(this,h.a,h.b,h.d,0,1,3));var e=["a","b","c","d"];c=0;for(d=this.faces.length;c<d;c++){h=this.faces[c];for(f=0;f<h.vertexNormals.length;f++)M.copy(h.vertexNormals[f]),j=h[e[f]],w=ja[j],va.copy(w),va.subSelf(M.multiplyScalar(M.dot(w))).normalize(),Q.cross(h.vertexNormals[f],w),j=Q.dot(L[j]),j=j<0?-1:1,h.vertexTangents[f]=new THREE.Vector4(va.x,va.y,va.z,j)}this.hasTangents=!0},computeBoundingBox:function(){var b;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],
y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,d=this.vertices.length;c<d;c++){b=this.vertices[c];if(b.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=b.position.x;else if(b.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=b.position.x;if(b.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=b.position.y;else if(b.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=b.position.y;if(b.position.z<
this.boundingBox.z[0])this.boundingBox.z[0]=b.position.z;else if(b.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=b.position.z}}},computeBoundingSphere:function(){for(var b=0,c=0,d=this.vertices.length;c<d;c++)b=Math.max(b,this.vertices[c].position.length());this.boundingSphere={radius:b}},computeEdgeFaces:function(){function b(b,c){return Math.min(b,c)+"_"+Math.max(b,c)}function c(b,c,d){b[c]===void 0?(b[c]={set:{},array:[]},b[c].set[d]=1,b[c].array.push(d)):b[c].set[d]===void 0&&(b[c].set[d]=
1,b[c].array.push(d))}var d,f,j,h,k,m={};d=0;for(f=this.faces.length;d<f;d++)k=this.faces[d],k instanceof THREE.Face3?(j=b(k.a,k.b),c(m,j,d),j=b(k.b,k.c),c(m,j,d),j=b(k.a,k.c),c(m,j,d)):k instanceof THREE.Face4&&(j=b(k.b,k.d),c(m,j,d),j=b(k.a,k.b),c(m,j,d),j=b(k.a,k.d),c(m,j,d),j=b(k.b,k.c),c(m,j,d),j=b(k.c,k.d),c(m,j,d));d=0;for(f=this.edges.length;d<f;d++){k=this.edges[d];j=k.vertexIndices[0];h=k.vertexIndices[1];k.faceIndices=m[b(j,h)].array;for(j=0;j<k.faceIndices.length;j++)h=k.faceIndices[j],
k.faces.push(this.faces[h])}}};THREE.GeometryCount=0;
THREE.Spline=function(b){function c(b,c,d,f,j,h,k){b=(d-b)*0.5;f=(f-c)*0.5;return(2*(c-d)+b+f)*k+(-3*(c-d)-2*b-f)*h+b*j+c}this.points=b;var d=[],f={x:0,y:0,z:0},j,h,k,m,p,q,s,r,u;this.initFromArray=function(b){this.points=[];for(var c=0;c<b.length;c++)this.points[c]={x:b[c][0],y:b[c][1],z:b[c][2]}};this.getPoint=function(b){j=(this.points.length-1)*b;h=Math.floor(j);k=j-h;d[0]=h==0?h:h-1;d[1]=h;d[2]=h>this.points.length-2?h:h+1;d[3]=h>this.points.length-3?h:h+2;q=this.points[d[0]];s=this.points[d[1]];
r=this.points[d[2]];u=this.points[d[3]];m=k*k;p=k*m;f.x=c(q.x,s.x,r.x,u.x,k,m,p);f.y=c(q.y,s.y,r.y,u.y,k,m,p);f.z=c(q.z,s.z,r.z,u.z,k,m,p);return f};this.getControlPointsArray=function(){var b,c,d=this.points.length,f=[];for(b=0;b<d;b++)c=this.points[b],f[b]=[c.x,c.y,c.z];return f};this.getLength=function(b){var c,d,f=c=c=0,j=new THREE.Vector3,h=new THREE.Vector3,k=[],m=0;k[0]=0;b||(b=100);d=this.points.length*b;j.copy(this.points[0]);for(b=1;b<d;b++)c=b/d,position=this.getPoint(c),h.copy(position),
m+=h.distanceTo(j),j.copy(position),c*=this.points.length-1,c=Math.floor(c),c!=f&&(k[c]=m,f=c);k[k.length]=m;return{chunks:k,total:m}};this.reparametrizeByArcLength=function(b){var c,d,f,j,h,k,m=[],q=new THREE.Vector3,p=this.getLength();m.push(q.copy(this.points[0]).clone());for(c=1;c<this.points.length;c++){d=p.chunks[c]-p.chunks[c-1];k=Math.ceil(b*d/p.total);j=(c-1)/(this.points.length-1);h=c/(this.points.length-1);for(d=1;d<k-1;d++)f=j+d*(1/k)*(h-j),position=this.getPoint(f),m.push(q.copy(position).clone());
m.push(q.copy(this.points[c]).clone())}this.points=m}};THREE.Edge=function(b,c,d,f){this.vertices=[b,c];this.vertexIndices=[d,f];this.faces=[];this.faceIndices=[]};THREE.Camera=function(b,c,d,f,j){THREE.Object3D.call(this);this.fov=b||50;this.aspect=c||1;this.near=d!==void 0?d:0.1;this.far=f!==void 0?f:2E3;this.target=j||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;
THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(b,c){this.matrix.rotateAxis(c);c.multiplyScalar(b);this.position.addSelf(c);this.target.position.addSelf(c)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var b=this.fullWidth/this.fullHeight,c=Math.tan(this.fov*Math.PI/360)*this.near,d=-c,f=b*d,b=Math.abs(b*c-f),d=Math.abs(c-d);this.projectionMatrix=THREE.Matrix4.makeFrustum(f+this.x*b/this.fullWidth,f+(this.x+this.width)*b/this.fullWidth,c-(this.y+this.height)*d/this.fullHeight,c-this.y*d/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(b,c,d,f,j,h){this.fullWidth=b;this.fullHeight=c;this.x=d;this.y=f;this.width=j;this.height=h;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(b,c,d){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),c=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,c=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,d)};THREE.OrthoCamera=function(b,c,d,f,j,h,k){THREE.Camera.call(this,45,1,j,h,k);this.left=b;this.right=c;this.top=d;this.bottom=f;this.updateProjectionMatrix()};THREE.OrthoCamera.prototype=new THREE.Camera;THREE.OrthoCamera.prototype.constructor=THREE.OrthoCamera;
THREE.OrthoCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.Light=function(b){THREE.Object3D.call(this);this.color=new THREE.Color(b)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(b){THREE.Light.call(this,b)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(b,c,d){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.intensity=c!==void 0?c:1;this.distance=d!==void 0?d:0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(b,c,d){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,0,0);this.intensity=c!==void 0?c:1;this.distance=d!==void 0?d:0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.SpotLight=function(b,c,d,f){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=c!==void 0?c:1;this.distance=d!==void 0?d:0;this.castShadow=f!==void 0?f:!1};THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(b){this.id=THREE.MaterialCount++;b=b||{};this.opacity=b.opacity!==void 0?b.opacity:1;this.transparent=b.transparent!==void 0?b.transparent:!1;this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.depthTest=b.depthTest!==void 0?b.depthTest:!0;this.depthWrite=b.depthWrite!==void 0?b.depthWrite:!0;this.polygonOffset=b.polygonOffset!==void 0?b.polygonOffset:!1;this.polygonOffsetFactor=b.polygonOffsetFactor!==void 0?b.polygonOffsetFactor:0;this.polygonOffsetUnits=
b.polygonOffsetUnits!==void 0?b.polygonOffsetUnits:0;this.alphaTest=b.alphaTest!==void 0?b.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.linewidth=b.linewidth!==void 0?b.linewidth:1;this.linecap=b.linecap!==void 0?b.linecap:"round";this.linejoin=b.linejoin!==void 0?b.linejoin:"round";this.vertexColors=b.vertexColors?b.vertexColors:!1;this.fog=b.fog!==void 0?b.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.fog=b.fog!==void 0?b.fog:
!0;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.fog=b.fog!==void 0?
b.fog:!0;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?
b.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.ambient=b.ambient!==void 0?new THREE.Color(b.ambient):new THREE.Color(328965);this.specular=b.specular!==void 0?new THREE.Color(b.specular):new THREE.Color(1118481);this.shininess=b.shininess!==void 0?b.shininess:30;this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;
this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.fog=b.fog!==void 0?b.fog:!0;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=
b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading?b.shading:THREE.FlatShading;this.wireframe=b.wireframe?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth?b.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.fragmentShader=b.fragmentShader!==void 0?b.fragmentShader:"void main() {}";this.vertexShader=b.vertexShader!==void 0?b.vertexShader:"void main() {}";this.uniforms=b.uniforms!==void 0?b.uniforms:{};this.attributes=b.attributes;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.fog=
b.fog!==void 0?b.fog:!1;this.lights=b.lights!==void 0?b.lights:!1;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshShaderMaterial.prototype=new THREE.Material;THREE.MeshShaderMaterial.prototype.constructor=THREE.MeshShaderMaterial;
THREE.ParticleBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.size=b.size!==void 0?b.size:1;this.sizeAttenuation=b.sizeAttenuation!==void 0?b.sizeAttenuation:!0;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.fog=b.fog!==void 0?b.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Texture=function(b,c,d,f,j,h){this.id=THREE.TextureCount++;this.image=b;this.mapping=c!==void 0?c:new THREE.UVMapping;this.wrapS=d!==void 0?d:THREE.ClampToEdgeWrapping;this.wrapT=f!==void 0?f:THREE.ClampToEdgeWrapping;this.magFilter=j!==void 0?j:THREE.LinearFilter;this.minFilter=h!==void 0?h:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var b=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);b.offset.copy(this.offset);b.repeat.copy(this.repeat);return b}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;
THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(b,c,d,f,j,h,k,m,p){THREE.Texture.call(this,null,j,h,k,m,p);this.image={data:b,width:c,height:d};this.format=f!==void 0?f:THREE.RGBAFormat};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var b=new THREE.DataTexture(this.data.slice(0),this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);b.offset.copy(this.offset);b.repeat.copy(this.repeat);return b};THREE.Particle=function(b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.ParticleSystem=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(b,c,d){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.type=d!=void 0?d:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c&&c.length?c:[c];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=b.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var d=0;d<this.geometry.morphTargets.length;d++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[d].name]=
d}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(b){if(this.morphTargetDictionary[b]!==void 0)return this.morphTargetDictionary[b];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+b+" does not exist. Returning 0.");return 0};
THREE.Bone=function(b){THREE.Object3D.call(this);this.skin=b;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(b,c,d){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.skinMatrix.multiply(b,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var f,j=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(f=0;f<j;f++)b=this.children[f],b instanceof THREE.Bone?b.update(this.skinMatrix,c,d):b.update(this.matrixWorld,!0,d)}else for(f=0;f<j;f++)this.children[f].update(this.skinMatrix,
c,d)};THREE.Bone.prototype.addChild=function(b){if(this.children.indexOf(b)===-1&&(b.parent!==void 0&&b.parent.removeChild(b),b.parent=this,this.children.push(b),!(b instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};
THREE.SkinnedMesh=function(b,c){THREE.Mesh.call(this,b,c);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var d,f,j,h,k,m;if(this.geometry.bones!==void 0){for(d=0;d<this.geometry.bones.length;d++)j=this.geometry.bones[d],h=j.pos,k=j.rotq,m=j.scl,f=this.addBone(),f.name=j.name,f.position.set(h[0],h[1],h[2]),f.quaternion.set(k[0],k[1],k[2],k[3]),f.useQuaternion=!0,m!==void 0?f.scale.set(m[0],m[1],m[2]):f.scale.set(1,1,1);for(d=0;d<this.bones.length;d++)j=this.geometry.bones[d],
f=this.bones[d],j.parent===-1?this.addChild(f):this.bones[j.parent].addChild(f);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(b,c,d){if(this.visible){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var f,j=this.children.length;for(f=0;f<j;f++)b=this.children[f],b instanceof THREE.Bone?b.update(this.identityMatrix,!1,d):b.update(this.matrixWorld,c,d);d=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(c=0;c<d;c++)ba[c].skinMatrix.flattenToArrayOffset(bm,
c*16)}};THREE.SkinnedMesh.prototype.addBone=function(b){b===void 0&&(b=new THREE.Bone(this));this.bones.push(b);return b};
THREE.SkinnedMesh.prototype.pose=function(){this.update(void 0,!0);for(var b,c=[],d=0;d<this.bones.length;d++)b=this.bones[d],c.push(THREE.Matrix4.makeInvert(b.skinMatrix)),b.skinMatrix.flattenToArrayOffset(this.boneMatrices,d*16);if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var f;for(b=0;b<this.geometry.skinIndices.length;b++){var d=this.geometry.vertices[b].position,j=this.geometry.skinIndices[b].x,h=this.geometry.skinIndices[b].y;f=new THREE.Vector3(d.x,
d.y,d.z);this.geometry.skinVerticesA.push(c[j].multiplyVector3(f));f=new THREE.Vector3(d.x,d.y,d.z);this.geometry.skinVerticesB.push(c[h].multiplyVector3(f));this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y!==1&&(d=(1-(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y))*0.5,this.geometry.skinWeights[b].x+=d,this.geometry.skinWeights[b].y+=d)}}};THREE.Ribbon=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c]};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.addLevel=function(b,c){c===void 0&&(c=0);for(var c=Math.abs(c),d=0;d<this.LODs.length;d++)if(c<this.LODs[d].visibleAtDistance)break;this.LODs.splice(d,0,{visibleAtDistance:c,object3D:b});this.add(b)};
THREE.LOD.prototype.update=function(b,c,d){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;if(this.LODs.length>1){b=d.matrixWorldInverse;b=-(b.n31*this.position.x+b.n32*this.position.y+b.n33*this.position.z+b.n34);this.LODs[0].object3D.visible=!0;for(var f=1;f<this.LODs.length;f++)if(b>=this.LODs[f].visibleAtDistance)this.LODs[f-1].object3D.visible=!1,
this.LODs[f].object3D.visible=!0;else break;for(;f<this.LODs.length;f++)this.LODs[f].object3D.visible=!1}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,d)};
THREE.Sprite=function(b){THREE.Object3D.call(this);if(b.material!==void 0)this.material=b.material,this.map=void 0,this.blending=material.blending;else if(b.map!==void 0)this.map=b.map instanceof THREE.Texture?b.map:THREE.ImageUtils.loadTexture(b.map),this.material=void 0,this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.useScreenCoordinates=b.useScreenCoordinates!==void 0?b.useScreenCoordinates:!0;this.mergeWith3D=b.mergeWith3D!==void 0?b.mergeWith3D:!this.useScreenCoordinates;
this.affectedByDistance=b.affectedByDistance!==void 0?b.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=b.scaleByViewport!==void 0?b.scaleByViewport:!this.affectedByDistance;this.alignment=b.alignment instanceof THREE.Vector2?b.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.supr=THREE.Object3D.prototype;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);
THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.add=function(b){this.supr.add.call(this,b);this.addChildRecurse(b)};
THREE.Scene.prototype.addChildRecurse=function(b){if(b instanceof THREE.Light)this.lights.indexOf(b)===-1&&this.lights.push(b);else if(!(b instanceof THREE.Camera||b instanceof THREE.Bone)&&this.objects.indexOf(b)===-1)this.objects.push(b),this.__objectsAdded.push(b);for(var c=0;c<b.children.length;c++)this.addChildRecurse(b.children[c])};THREE.Scene.prototype.remove=function(b){this.supr.remove.call(this,b);this.removeChildRecurse(b)};
THREE.Scene.prototype.removeChildRecurse=function(b){if(b instanceof THREE.Light){var c=this.lights.indexOf(b);c!==-1&&this.lights.splice(c,1)}else b instanceof THREE.Camera||(c=this.objects.indexOf(b),c!==-1&&(this.objects.splice(c,1),this.__objectsRemoved.push(b)));for(c=0;c<b.children.length;c++)this.removeChildRecurse(b.children[c])};THREE.Scene.prototype.addChild=function(b){console.warn("DEPRECATED: Scene.addChild() is now Scene.add()");this.add(b)};
THREE.Scene.prototype.addObject=function(b){console.warn("DEPRECATED: Scene.addObject() is now Scene.add()");this.add(b)};THREE.Scene.prototype.addLight=function(b){console.warn("DEPRECATED: Scene.addLight() is now Scene.add()");this.add(b)};THREE.Scene.prototype.removeChild=function(b){console.warn("DEPRECATED: Scene.removeChild() is now Scene.remove()");this.remove(b)};THREE.Scene.prototype.removeObject=function(b){console.warn("DEPRECATED: Scene.removeObject() is now Scene.remove()");this.remove(b)};
THREE.Scene.prototype.removeLight=function(b){console.warn("DEPRECATED: Scene.removeLight() is now Scene.remove()");this.remove(b)};THREE.Fog=function(b,c,d){this.color=new THREE.Color(b);this.near=c!==void 0?c:1;this.far=d!==void 0?d:1E3};THREE.FogExp2=function(b,c){this.color=new THREE.Color(b);this.density=c!==void 0?c:2.5E-4};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",
envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",
envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",
map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",
lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef PHONG\nvPointLight[ i ] = vec4( lVector, lDistance );\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 pointSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight * pointDistance;\npointSpecular += mSpecular * pointSpecularWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 dirSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform float shadowDarkness;\nuniform float shadowBias;\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",
shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_SOFT\nconst float xPixelOffset = 1.0 / SHADOWMAP_WIDTH;\nconst float yPixelOffset = 1.0 / SHADOWMAP_HEIGHT;\n#endif\nvec4 shadowColor = vec4( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nif ( shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0 ) {\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nfor ( float y = -1.25; y <= 1.25; y += 1.25 )\nfor ( float x = -1.25; x <= 1.25; x += 1.25 ) {\nvec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadow += 1.0;\n}\nshadow /= 9.0;\nshadowColor = shadowColor * vec4( vec3( ( 1.0 - shadowDarkness * shadow ) ), 1.0 );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadowColor = shadowColor * vec4( vec3( shadowDarkness ), 1.0 );\n#endif\n}\n}\ngl_FragColor = gl_FragColor * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif"};
THREE.UniformsUtils={merge:function(b){var c,d,f,j={};for(c=0;c<b.length;c++)for(d in f=this.clone(b[c]),f)j[d]=f[d];return j},clone:function(b){var c,d,f,j={};for(c in b)for(d in j[c]={},b[c])f=b[c][d],j[c][d]=f instanceof THREE.Color||f instanceof THREE.Vector2||f instanceof THREE.Vector3||f instanceof THREE.Vector4||f instanceof THREE.Matrix4||f instanceof THREE.Texture?f.clone():f instanceof Array?f.slice():f;return j}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",
value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:3,texture:[]},shadowMatrix:{type:"m4v",value:[]},shadowBias:{type:"f",value:0.0039},shadowDarkness:{type:"f",value:0.2}}};
THREE.ShaderLib={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * vVisibility;\ngl_FragColor = color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * visibility;\ngl_FragColor = color;\n}\n}"},
sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity;\ngl_FragColor = color;\n}"},shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main() {\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform \tfloat \tdarkness;\nvoid main() {\ngl_FragColor = vec4( 0, 0, 0, darkness );\n}"},
shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm ) ), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0 );\n}"},depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},
normal:{uniforms:{opacity:{type:"f",value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"gl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,
"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},
specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,
THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},depthRGBA:{uniforms:{},fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}",vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,
"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")}};
THREE.WebGLRenderer=function(b){function c(b,c,d){var f,j,h,k=b.vertices,m=k.length,H=b.colors,I=H.length,D=b.__vertexArray,q=b.__colorArray,p=b.__sortArray,r=b.__dirtyVertices,s=b.__dirtyColors,u=b.__webglCustomAttributes,w,n;if(u)for(w in u)u[w].offset=0;if(d.sortParticles){Ba.multiplySelf(d.matrixWorld);for(f=0;f<m;f++)j=k[f].position,Ja.copy(j),Ba.multiplyVector3(Ja),p[f]=[Ja.z,f];p.sort(function(b,c){return c[0]-b[0]});for(f=0;f<m;f++)j=k[p[f][1]].position,h=f*3,D[h]=j.x,D[h+1]=j.y,D[h+2]=j.z;
for(f=0;f<I;f++)h=f*3,color=H[p[f][1]],q[h]=color.r,q[h+1]=color.g,q[h+2]=color.b;if(u)for(w in u){f=u[w];H=f.value.length;for(h=0;h<H;h++){index=p[h][1];I=f.offset;if(f.size===1){if(f.boundTo===void 0||f.boundTo==="vertices")f.array[I]=f.value[index]}else{if(f.boundTo===void 0||f.boundTo==="vertices")n=f.value[index];f.size===2?(f.array[I]=n.x,f.array[I+1]=n.y):f.size===3?f.type==="c"?(f.array[I]=n.r,f.array[I+1]=n.g,f.array[I+2]=n.b):(f.array[I]=n.x,f.array[I+1]=n.y,f.array[I+2]=n.z):(f.array[I]=
n.x,f.array[I+1]=n.y,f.array[I+2]=n.z,f.array[I+3]=n.w)}f.offset+=f.size}}}else{if(r)for(f=0;f<m;f++)j=k[f].position,h=f*3,D[h]=j.x,D[h+1]=j.y,D[h+2]=j.z;if(s)for(f=0;f<I;f++)color=H[f],h=f*3,q[h]=color.r,q[h+1]=color.g,q[h+2]=color.b;if(u)for(w in u)if(f=u[w],f.__original.needsUpdate){H=f.value.length;for(h=0;h<H;h++){I=f.offset;if(f.size===1){if(f.boundTo===void 0||f.boundTo==="vertices")f.array[I]=f.value[h]}else{if(f.boundTo===void 0||f.boundTo==="vertices")n=f.value[h];f.size===2?(f.array[I]=
n.x,f.array[I+1]=n.y):f.size===3?f.type==="c"?(f.array[I]=n.r,f.array[I+1]=n.g,f.array[I+2]=n.b):(f.array[I]=n.x,f.array[I+1]=n.y,f.array[I+2]=n.z):(f.array[I]=n.x,f.array[I+1]=n.y,f.array[I+2]=n.z,f.array[I+3]=n.w)}f.offset+=f.size}}}if(r||d.sortParticles)e.bindBuffer(e.ARRAY_BUFFER,b.__webglVertexBuffer),e.bufferData(e.ARRAY_BUFFER,D,c);if(s||d.sortParticles)e.bindBuffer(e.ARRAY_BUFFER,b.__webglColorBuffer),e.bufferData(e.ARRAY_BUFFER,q,c);if(u)for(w in u)if(f=u[w],f.__original.needsUpdate||d.sortParticles)e.bindBuffer(e.ARRAY_BUFFER,
f.buffer),e.bufferData(e.ARRAY_BUFFER,f.array,c)}function d(b,c,d,f,j){f.program||M.initMaterial(f,c,d,j);if(f.morphTargets&&!j.__webglMorphTargetInfluences){j.__webglMorphTargetInfluences=new Float32Array(M.maxMorphTargets);for(var h=0,k=M.maxMorphTargets;h<k;h++)j.__webglMorphTargetInfluences[h]=0}var h=f.program,k=h.uniforms,m=f.uniforms;h!=Va&&(e.useProgram(h),Va=h);e.uniformMatrix4fv(k.projectionMatrix,!1,Da);if(d&&f.fog)if(m.fogColor.value=d.color,d instanceof THREE.Fog)m.fogNear.value=d.near,
m.fogFar.value=d.far;else if(d instanceof THREE.FogExp2)m.fogDensity.value=d.density;if(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||f.lights){var H,q,D,p=0,r=0,s=0,n,u,v,B=Wa,G=B.directional.colors,K=B.directional.positions,y=B.point.colors,A=B.point.positions,C=B.point.distances,E=0,F=0,d=q=v=0;for(H=c.length;d<H;d++)if(q=c[d],D=q.color,n=q.position,u=q.intensity,v=q.distance,q instanceof THREE.AmbientLight)p+=D.r,r+=D.g,s+=D.b;else if(q instanceof THREE.DirectionalLight)v=
E*3,G[v]=D.r*u,G[v+1]=D.g*u,G[v+2]=D.b*u,K[v]=n.x,K[v+1]=n.y,K[v+2]=n.z,E+=1;else if(q instanceof THREE.SpotLight)v=E*3,G[v]=D.r*u,G[v+1]=D.g*u,G[v+2]=D.b*u,D=1/n.length(),K[v]=n.x*D,K[v+1]=n.y*D,K[v+2]=n.z*D,E+=1;else if(q instanceof THREE.PointLight)q=F*3,y[q]=D.r*u,y[q+1]=D.g*u,y[q+2]=D.b*u,A[q]=n.x,A[q+1]=n.y,A[q+2]=n.z,C[F]=v,F+=1;for(d=E*3;d<G.length;d++)G[d]=0;for(d=F*3;d<y.length;d++)y[d]=0;B.point.length=F;B.directional.length=E;B.ambient[0]=p;B.ambient[1]=r;B.ambient[2]=s;c=Wa;m.enableLighting.value=
c.directional.length+c.point.length;m.ambientLightColor.value=c.ambient;m.directionalLightColor.value=c.directional.colors;m.directionalLightDirection.value=c.directional.positions;m.pointLightColor.value=c.point.colors;m.pointLightPosition.value=c.point.positions;m.pointLightDistance.value=c.point.distances}if(f instanceof THREE.MeshBasicMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshPhongMaterial)m.diffuse.value=f.color,m.opacity.value=f.opacity,(m.map.texture=f.map)&&
m.offsetRepeat.value.set(f.map.offset.x,f.map.offset.y,f.map.repeat.x,f.map.repeat.y),m.lightMap.texture=f.lightMap,m.envMap.texture=f.envMap,m.reflectivity.value=f.reflectivity,m.refractionRatio.value=f.refractionRatio,m.combine.value=f.combine,m.useRefract.value=f.envMap&&f.envMap.mapping instanceof THREE.CubeRefractionMapping;if(f instanceof THREE.LineBasicMaterial)m.diffuse.value=f.color,m.opacity.value=f.opacity;else if(f instanceof THREE.ParticleBasicMaterial)m.psColor.value=f.color,m.opacity.value=
f.opacity,m.size.value=f.size,m.scale.value=Ka.height/2,m.map.texture=f.map;else if(f instanceof THREE.MeshPhongMaterial)m.ambient.value=f.ambient,m.specular.value=f.specular,m.shininess.value=f.shininess;else if(f instanceof THREE.MeshDepthMaterial)m.mNear.value=b.near,m.mFar.value=b.far,m.opacity.value=f.opacity;else if(f instanceof THREE.MeshNormalMaterial)m.opacity.value=f.opacity;if(j.receiveShadow&&!f._shadowPass&&m.shadowMatrix){for(c=0;c<Sa.length;c++)m.shadowMatrix.value[c]=Sa[c],m.shadowMap.texture[c]=
M.shadowMap[c];m.shadowDarkness.value=M.shadowMapDarkness;m.shadowBias.value=M.shadowMapBias}for(var N in m)if(H=h.uniforms[N])if(d=m[N],p=d.type,c=d.value,p=="i")e.uniform1i(H,c);else if(p=="f")e.uniform1f(H,c);else if(p=="v2")e.uniform2f(H,c.x,c.y);else if(p=="v3")e.uniform3f(H,c.x,c.y,c.z);else if(p=="v4")e.uniform4f(H,c.x,c.y,c.z,c.w);else if(p=="c")e.uniform3f(H,c.r,c.g,c.b);else if(p=="fv1")e.uniform1fv(H,c);else if(p=="fv")e.uniform3fv(H,c);else if(p=="v3v"){if(!d._array)d._array=new Float32Array(3*
c.length);p=0;for(r=c.length;p<r;p++)s=p*3,d._array[s]=c[p].x,d._array[s+1]=c[p].y,d._array[s+2]=c[p].z;e.uniform3fv(H,d._array)}else if(p=="m4"){if(!d._array)d._array=new Float32Array(16);c.flattenToArray(d._array);e.uniformMatrix4fv(H,!1,d._array)}else if(p=="m4v"){if(!d._array)d._array=new Float32Array(16*c.length);p=0;for(r=c.length;p<r;p++)c[p].flattenToArrayOffset(d._array,p*16);e.uniformMatrix4fv(H,!1,d._array)}else if(p=="t"){if(e.uniform1i(H,c),H=d.texture)if(H.image instanceof Array&&H.image.length==
6){if(d=H,d.image.length==6)if(d.needsUpdate){if(!d.image.__webglTextureCube)d.image.__webglTextureCube=e.createTexture();e.activeTexture(e.TEXTURE0+c);e.bindTexture(e.TEXTURE_CUBE_MAP,d.image.__webglTextureCube);for(c=0;c<6;c++)e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+c,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,d.image[c]);w(e.TEXTURE_CUBE_MAP,d,d.image[0]);d.needsUpdate=!1}else e.activeTexture(e.TEXTURE0+c),e.bindTexture(e.TEXTURE_CUBE_MAP,d.image.__webglTextureCube)}else H instanceof THREE.WebGLRenderTargetCube?
(d=H,e.activeTexture(e.TEXTURE0+c),e.bindTexture(e.TEXTURE_CUBE_MAP,d.__webglTexture)):ja(H,c)}else if(p=="tv"){if(!d._array){d._array=[];p=0;for(r=d.texture.length;p<r;p++)d._array[p]=c+p}e.uniform1iv(H,d._array);p=0;for(r=d.texture.length;p<r;p++)(H=d.texture[p])&&ja(H,d._array[p])}e.uniformMatrix4fv(k.modelViewMatrix,!1,j._modelViewMatrixArray);k.normalMatrix&&e.uniformMatrix3fv(k.normalMatrix,!1,j._normalMatrixArray);(f instanceof THREE.MeshShaderMaterial||f instanceof THREE.MeshPhongMaterial||
f.envMap)&&k.cameraPosition!==null&&e.uniform3f(k.cameraPosition,b.position.x,b.position.y,b.position.z);(f instanceof THREE.MeshShaderMaterial||f.envMap||f.skinning||j.receiveShadow)&&k.objectMatrix!==null&&e.uniformMatrix4fv(k.objectMatrix,!1,j._objectMatrixArray);(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshShaderMaterial||f.skinning)&&k.viewMatrix!==null&&e.uniformMatrix4fv(k.viewMatrix,!1,Ta);f.skinning&&(e.uniformMatrix4fv(k.cameraInverseMatrix,
!1,Ta),e.uniformMatrix4fv(k.boneGlobalMatrices,!1,j.boneMatrices));return h}function f(b,c,f,j,h,k){if(j.opacity!=0){var m,b=d(b,c,f,j,k).attributes;if(!j.morphTargets&&b.position>=0)e.bindBuffer(e.ARRAY_BUFFER,h.__webglVertexBuffer),e.vertexAttribPointer(b.position,3,e.FLOAT,!1,0,0);else if(k.morphTargetBase){c=j.program.attributes;k.morphTargetBase!==-1?(e.bindBuffer(e.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[k.morphTargetBase]),e.vertexAttribPointer(c.position,3,e.FLOAT,!1,0,0)):c.position>=0&&
(e.bindBuffer(e.ARRAY_BUFFER,h.__webglVertexBuffer),e.vertexAttribPointer(c.position,3,e.FLOAT,!1,0,0));if(k.morphTargetForcedOrder.length)for(var f=0,p=k.morphTargetForcedOrder,H=k.morphTargetInfluences;f<j.numSupportedMorphTargets&&f<p.length;)e.bindBuffer(e.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[p[f]]),e.vertexAttribPointer(c["morphTarget"+f],3,e.FLOAT,!1,0,0),k.__webglMorphTargetInfluences[f]=H[p[f]],f++;else{var p=[],q=-1,D=0,H=k.morphTargetInfluences,r,s=H.length,f=0;for(k.morphTargetBase!==
-1&&(p[k.morphTargetBase]=!0);f<j.numSupportedMorphTargets;){for(r=0;r<s;r++)!p[r]&&H[r]>q&&(D=r,q=H[D]);e.bindBuffer(e.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[D]);e.vertexAttribPointer(c["morphTarget"+f],3,e.FLOAT,!1,0,0);k.__webglMorphTargetInfluences[f]=q;p[D]=1;q=-1;f++}}j.program.uniforms.morphTargetInfluences!==null&&e.uniform1fv(j.program.uniforms.morphTargetInfluences,k.__webglMorphTargetInfluences)}if(h.__webglCustomAttributes)for(m in h.__webglCustomAttributes)b[m]>=0&&(c=h.__webglCustomAttributes[m],
e.bindBuffer(e.ARRAY_BUFFER,c.buffer),e.vertexAttribPointer(b[m],c.size,e.FLOAT,!1,0,0));b.color>=0&&(e.bindBuffer(e.ARRAY_BUFFER,h.__webglColorBuffer),e.vertexAttribPointer(b.color,3,e.FLOAT,!1,0,0));b.normal>=0&&(e.bindBuffer(e.ARRAY_BUFFER,h.__webglNormalBuffer),e.vertexAttribPointer(b.normal,3,e.FLOAT,!1,0,0));b.tangent>=0&&(e.bindBuffer(e.ARRAY_BUFFER,h.__webglTangentBuffer),e.vertexAttribPointer(b.tangent,4,e.FLOAT,!1,0,0));b.uv>=0&&(h.__webglUVBuffer?(e.bindBuffer(e.ARRAY_BUFFER,h.__webglUVBuffer),
e.vertexAttribPointer(b.uv,2,e.FLOAT,!1,0,0),e.enableVertexAttribArray(b.uv)):e.disableVertexAttribArray(b.uv));b.uv2>=0&&(h.__webglUV2Buffer?(e.bindBuffer(e.ARRAY_BUFFER,h.__webglUV2Buffer),e.vertexAttribPointer(b.uv2,2,e.FLOAT,!1,0,0),e.enableVertexAttribArray(b.uv2)):e.disableVertexAttribArray(b.uv2));j.skinning&&b.skinVertexA>=0&&b.skinVertexB>=0&&b.skinIndex>=0&&b.skinWeight>=0&&(e.bindBuffer(e.ARRAY_BUFFER,h.__webglSkinVertexABuffer),e.vertexAttribPointer(b.skinVertexA,4,e.FLOAT,!1,0,0),e.bindBuffer(e.ARRAY_BUFFER,
h.__webglSkinVertexBBuffer),e.vertexAttribPointer(b.skinVertexB,4,e.FLOAT,!1,0,0),e.bindBuffer(e.ARRAY_BUFFER,h.__webglSkinIndicesBuffer),e.vertexAttribPointer(b.skinIndex,4,e.FLOAT,!1,0,0),e.bindBuffer(e.ARRAY_BUFFER,h.__webglSkinWeightsBuffer),e.vertexAttribPointer(b.skinWeight,4,e.FLOAT,!1,0,0));k instanceof THREE.Mesh?(j.wireframe?(e.lineWidth(j.wireframeLinewidth),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,h.__webglLineBuffer),e.drawElements(e.LINES,h.__webglLineCount,e.UNSIGNED_SHORT,0)):(e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,
h.__webglFaceBuffer),e.drawElements(e.TRIANGLES,h.__webglFaceCount,e.UNSIGNED_SHORT,0)),M.data.vertices+=h.__webglFaceCount,M.data.faces+=h.__webglFaceCount/3,M.data.drawCalls++):k instanceof THREE.Line?(k=k.type==THREE.LineStrip?e.LINE_STRIP:e.LINES,e.lineWidth(j.linewidth),e.drawArrays(k,0,h.__webglLineCount),M.data.drawCalls++):k instanceof THREE.ParticleSystem?(e.drawArrays(e.POINTS,0,h.__webglParticleCount),M.data.drawCalls++):k instanceof THREE.Ribbon&&(e.drawArrays(e.TRIANGLE_STRIP,0,h.__webglVertexCount),
M.data.drawCalls++)}}function j(b,c,d){if(!b.__webglVertexBuffer)b.__webglVertexBuffer=e.createBuffer();if(!b.__webglNormalBuffer)b.__webglNormalBuffer=e.createBuffer();b.hasPos&&(e.bindBuffer(e.ARRAY_BUFFER,b.__webglVertexBuffer),e.bufferData(e.ARRAY_BUFFER,b.positionArray,e.DYNAMIC_DRAW),e.enableVertexAttribArray(c.attributes.position),e.vertexAttribPointer(c.attributes.position,3,e.FLOAT,!1,0,0));if(b.hasNormal){e.bindBuffer(e.ARRAY_BUFFER,b.__webglNormalBuffer);if(d==THREE.FlatShading){var f,
h,j,k,m,H,p,q,r,s,n=b.count*3;for(s=0;s<n;s+=9)d=b.normalArray,f=d[s],h=d[s+1],j=d[s+2],k=d[s+3],H=d[s+4],q=d[s+5],m=d[s+6],p=d[s+7],r=d[s+8],f=(f+k+m)/3,h=(h+H+p)/3,j=(j+q+r)/3,d[s]=f,d[s+1]=h,d[s+2]=j,d[s+3]=f,d[s+4]=h,d[s+5]=j,d[s+6]=f,d[s+7]=h,d[s+8]=j}e.bufferData(e.ARRAY_BUFFER,b.normalArray,e.DYNAMIC_DRAW);e.enableVertexAttribArray(c.attributes.normal);e.vertexAttribPointer(c.attributes.normal,3,e.FLOAT,!1,0,0)}e.drawArrays(e.TRIANGLES,0,b.count);b.count=0}function h(b){if(T!=b.doubleSided)b.doubleSided?
e.disable(e.CULL_FACE):e.enable(e.CULL_FACE),T=b.doubleSided;if(Z!=b.flipSided)b.flipSided?e.frontFace(e.CW):e.frontFace(e.CCW),Z=b.flipSided}function k(b){W!=b&&(b?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),W=b)}function m(b){S!=b&&(e.depthMask(b),S=b)}function p(b,c,d){V!=b&&(b?e.enable(e.POLYGON_OFFSET_FILL):e.disable(e.POLYGON_OFFSET_FILL),V=b);if(b&&(xa!=c||P!=d))e.polygonOffset(c,d),xa=c,P=d}function q(b){R[0].set(b.n41-b.n11,b.n42-b.n12,b.n43-b.n13,b.n44-b.n14);R[1].set(b.n41+b.n11,b.n42+
b.n12,b.n43+b.n13,b.n44+b.n14);R[2].set(b.n41+b.n21,b.n42+b.n22,b.n43+b.n23,b.n44+b.n24);R[3].set(b.n41-b.n21,b.n42-b.n22,b.n43-b.n23,b.n44-b.n24);R[4].set(b.n41-b.n31,b.n42-b.n32,b.n43-b.n33,b.n44-b.n34);R[5].set(b.n41+b.n31,b.n42+b.n32,b.n43+b.n33,b.n44+b.n34);for(var c,b=0;b<6;b++)c=R[b],c.divideScalar(Math.sqrt(c.x*c.x+c.y*c.y+c.z*c.z))}function s(b){for(var c=b.matrixWorld,d=-b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)),e=0;e<6;e++)if(b=R[e].x*c.n14+R[e].y*
c.n24+R[e].z*c.n34+R[e].w,b<=d)return!1;return!0}function r(b,c){b.list[b.count]=c;b.count+=1}function u(b){var c,d,e=b.object,f=b.opaque,h=b.transparent;h.count=0;b=f.count=0;for(c=e.materials.length;b<c;b++)d=e.materials[b],d.transparent?r(h,d):r(f,d)}function v(b){var c,d,e,f,h=b.object,j=b.buffer,k=b.opaque,m=b.transparent;m.count=0;b=k.count=0;for(e=h.materials.length;b<e;b++)if(c=h.materials[b],c instanceof THREE.MeshFaceMaterial){c=0;for(d=j.materials.length;c<d;c++)(f=j.materials[c])&&(f.transparent?
r(m,f):r(k,f))}else(f=c)&&(f.transparent?r(m,f):r(k,f))}function B(b,c){return c.z-b.z}function y(b,c){var m,p,Ma,r=0,fa,n,H,I,D=b.lights;ra||(ra=new THREE.Camera(M.shadowCameraFov,c.aspect,M.shadowCameraNear,M.shadowCameraFar));m=0;for(p=D.length;m<p;m++)if(Ma=D[m],Ma instanceof THREE.SpotLight&&Ma.castShadow){M.shadowMap[r]||(M.shadowMap[r]=new THREE.WebGLRenderTarget(M.shadowMapWidth,M.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat}));Sa[r]||
(Sa[r]=new THREE.Matrix4);fa=M.shadowMap[r];n=Sa[r];ra.position.copy(Ma.position);ra.target.position.copy(Ma.target.position);ra.update(void 0,!0);b.update(void 0,!1,ra);n.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);n.multiplySelf(ra.projectionMatrix);n.multiplySelf(ra.matrixWorldInverse);ra.matrixWorldInverse.flattenToArray(Ta);ra.projectionMatrix.flattenToArray(Da);Ba.multiply(ra.projectionMatrix,ra.matrixWorldInverse);q(Ba);M.initWebGLObjects(b);L(fa);e.clearColor(1,1,1,1);M.clear();e.clearColor(ha.r,
ha.g,ha.b,Ha);n=b.__webglObjects.length;Ma=b.__webglObjectsImmediate.length;for(fa=0;fa<n;fa++)H=b.__webglObjects[fa],I=H.object,I.visible&&I.castShadow?!(I instanceof THREE.Mesh)||!I.frustumCulled||s(I)?(I.matrixWorld.flattenToArray(I._objectMatrixArray),C(I,ra,!1),H.render=!0):H.render=!1:H.render=!1;k(!0);F(THREE.NormalBlending);for(fa=0;fa<n;fa++)if(H=b.__webglObjects[fa],H.render)I=H.object,buffer=H.buffer,h(I),H=I.customDepthMaterial?I.customDepthMaterial:I.geometry.morphTargets.length?Xa:Ua,
f(ra,D,null,H,buffer,I);for(fa=0;fa<Ma;fa++)H=b.__webglObjectsImmediate[fa],I=H.object,I.visible&&I.castShadow&&(I.matrixAutoUpdate&&I.matrixWorld.flattenToArray(I._objectMatrixArray),C(I,ra,!1),h(I),program=d(ra,D,null,Ua,I),I.render(function(b){j(b,program,Ua.shading)}));r++}}function E(b,c){var d,f,h;d=n.attributes;var j=n.uniforms,k=Fa/Aa,m,p=[],q=Aa*0.5,r=Fa*0.5,s=!0;e.useProgram(n.program);Va=n.program;W=J=-1;Ya||(e.enableVertexAttribArray(n.attributes.position),e.enableVertexAttribArray(n.attributes.uv),
Ya=!0);e.disable(e.CULL_FACE);e.enable(e.BLEND);e.depthMask(!0);e.bindBuffer(e.ARRAY_BUFFER,n.vertexBuffer);e.vertexAttribPointer(d.position,2,e.FLOAT,!1,16,0);e.vertexAttribPointer(d.uv,2,e.FLOAT,!1,16,8);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n.elementBuffer);e.uniformMatrix4fv(j.projectionMatrix,!1,Da);e.activeTexture(e.TEXTURE0);e.uniform1i(j.map,0);d=0;for(f=b.__webglSprites.length;d<f;d++)h=b.__webglSprites[d],h.useScreenCoordinates?h.z=-h.position.z:(h._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,
h.matrixWorld,h._modelViewMatrixArray),h.z=-h._modelViewMatrix.n34);b.__webglSprites.sort(B);d=0;for(f=b.__webglSprites.length;d<f;d++)h=b.__webglSprites[d],h.material===void 0&&h.map&&h.map.image&&h.map.image.width&&(h.useScreenCoordinates?(e.uniform1i(j.useScreenCoordinates,1),e.uniform3f(j.screenPosition,(h.position.x-q)/q,(r-h.position.y)/r,Math.max(0,Math.min(1,h.position.z)))):(e.uniform1i(j.useScreenCoordinates,0),e.uniform1i(j.affectedByDistance,h.affectedByDistance?1:0),e.uniformMatrix4fv(j.modelViewMatrix,
!1,h._modelViewMatrixArray)),m=h.map.image.width/(h.scaleByViewport?Fa:1),p[0]=m*k*h.scale.x,p[1]=m*h.scale.y,e.uniform2f(j.uvScale,h.uvScale.x,h.uvScale.y),e.uniform2f(j.uvOffset,h.uvOffset.x,h.uvOffset.y),e.uniform2f(j.alignment,h.alignment.x,h.alignment.y),e.uniform1f(j.opacity,h.opacity),e.uniform1f(j.rotation,h.rotation),e.uniform2fv(j.scale,p),h.mergeWith3D&&!s?(e.enable(e.DEPTH_TEST),s=!0):!h.mergeWith3D&&s&&(e.disable(e.DEPTH_TEST),s=!1),F(h.blending),ja(h.map,0),e.drawElements(e.TRIANGLES,
6,e.UNSIGNED_SHORT,0));e.enable(e.CULL_FACE);e.enable(e.DEPTH_TEST);e.depthMask(S)}function C(b,c,d){b._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,b.matrixWorld,b._modelViewMatrixArray);d&&THREE.Matrix4.makeInvert3x3(b._modelViewMatrix).transposeIntoArray(b._normalMatrixArray)}function ya(b){var c,d,e,f;f=b.__materials;b=0;for(d=f.length;b<d;b++)if(e=f[b],e.attributes)for(c in e.attributes)if(e.attributes[c].needsUpdate)return!0;return!1}function za(b){var c,d,e,f;f=b.__materials;b=0;for(d=
f.length;b<d;b++)if(e=f[b],e.attributes)for(c in e.attributes)e.attributes[c].needsUpdate=!1}function qa(b,c){var d;for(d=b.length-1;d>=0;d--)b[d].object==c&&b.splice(d,1)}function sa(b){function c(b){var f=[];d=0;for(e=b.length;d<e;d++)b[d]==void 0?f.push("undefined"):f.push(b[d].id);return f.join("_")}var d,e,f,h,j,k,m,p,q={},r=b.morphTargets!==void 0?b.morphTargets.length:0;b.geometryGroups={};f=0;for(h=b.faces.length;f<h;f++)j=b.faces[f],k=j.materials,m=c(k),q[m]==void 0&&(q[m]={hash:m,counter:0}),
p=q[m].hash+"_"+q[m].counter,b.geometryGroups[p]==void 0&&(b.geometryGroups[p]={faces:[],materials:k,vertices:0,numMorphTargets:r}),j=j instanceof THREE.Face3?3:4,b.geometryGroups[p].vertices+j>65535&&(q[m].counter+=1,p=q[m].hash+"_"+q[m].counter,b.geometryGroups[p]==void 0&&(b.geometryGroups[p]={faces:[],materials:k,vertices:0,numMorphTargets:r})),b.geometryGroups[p].faces.push(f),b.geometryGroups[p].vertices+=j;b.geometryGroupsList=[];for(var s in b.geometryGroups)b.geometryGroupsList.push(b.geometryGroups[s])}
function ga(b,c,d){b.push({buffer:c,object:d,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function F(b){if(b!=J){switch(b){case THREE.AdditiveBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE);break;case THREE.SubtractiveBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ZERO,e.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:e.blendEquation(e.FUNC_ADD);e.blendFunc(e.ZERO,e.SRC_COLOR);break;default:e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD),e.blendFuncSeparate(e.SRC_ALPHA,
e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA)}J=b}}function w(b,c,d){(d.width&d.width-1)==0&&(d.height&d.height-1)==0?(e.texParameteri(b,e.TEXTURE_WRAP_S,Q(c.wrapS)),e.texParameteri(b,e.TEXTURE_WRAP_T,Q(c.wrapT)),e.texParameteri(b,e.TEXTURE_MAG_FILTER,Q(c.magFilter)),e.texParameteri(b,e.TEXTURE_MIN_FILTER,Q(c.minFilter)),e.generateMipmap(b)):(e.texParameteri(b,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(b,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.texParameteri(b,e.TEXTURE_MAG_FILTER,va(c.magFilter)),
e.texParameteri(b,e.TEXTURE_MIN_FILTER,va(c.minFilter)))}function ja(b,c){if(b.needsUpdate){if(!b.__webglInit)b.__webglInit=!0,b.__webglTexture=e.createTexture();e.activeTexture(e.TEXTURE0+c);e.bindTexture(e.TEXTURE_2D,b.__webglTexture);b instanceof THREE.DataTexture?e.texImage2D(e.TEXTURE_2D,0,Q(b.format),b.image.width,b.image.height,0,Q(b.format),e.UNSIGNED_BYTE,b.image.data):e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,b.image);w(e.TEXTURE_2D,b,b.image);b.needsUpdate=!1}else e.activeTexture(e.TEXTURE0+
c),e.bindTexture(e.TEXTURE_2D,b.__webglTexture)}function L(b){var c=b instanceof THREE.WebGLRenderTargetCube;if(b&&!b.__webglFramebuffer){if(b.depthBuffer===void 0)b.depthBuffer=!0;if(b.stencilBuffer===void 0)b.stencilBuffer=!0;b.__webglRenderbuffer=e.createRenderbuffer();b.__webglTexture=e.createTexture();if(c){e.bindTexture(e.TEXTURE_CUBE_MAP,b.__webglTexture);w(e.TEXTURE_CUBE_MAP,b,b);b.__webglFramebuffer=[];for(var d=0;d<6;d++)b.__webglFramebuffer[d]=e.createFramebuffer(),e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+
d,0,Q(b.format),b.width,b.height,0,Q(b.format),Q(b.type),null)}else b.__webglFramebuffer=e.createFramebuffer(),e.bindTexture(e.TEXTURE_2D,b.__webglTexture),w(e.TEXTURE_2D,b,b),e.texImage2D(e.TEXTURE_2D,0,Q(b.format),b.width,b.height,0,Q(b.format),Q(b.type),null);e.bindRenderbuffer(e.RENDERBUFFER,b.__webglRenderbuffer);if(c)for(d=0;d<6;++d)e.bindFramebuffer(e.FRAMEBUFFER,b.__webglFramebuffer[d]),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_CUBE_MAP_POSITIVE_X+d,b.__webglTexture,
0);else e.bindFramebuffer(e.FRAMEBUFFER,b.__webglFramebuffer),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,b.__webglTexture,0);b.depthBuffer&&!b.stencilBuffer?(e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_COMPONENT16,b.width,b.height),e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,b.__webglRenderbuffer)):b.depthBuffer&&b.stencilBuffer?(e.renderbufferStorage(e.RENDERBUFFER,e.DEPTH_STENCIL,b.width,b.height),e.framebufferRenderbuffer(e.FRAMEBUFFER,
e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,b.__webglRenderbuffer)):e.renderbufferStorage(e.RENDERBUFFER,e.RGBA4,b.width,b.height);c?e.bindTexture(e.TEXTURE_CUBE_MAP,null):e.bindTexture(e.TEXTURE_2D,null);e.bindRenderbuffer(e.RENDERBUFFER,null);e.bindFramebuffer(e.FRAMEBUFFER,null)}var f,h;b?(c=c?b.__webglFramebuffer[b.activeCubeFace]:b.__webglFramebuffer,d=b.width,b=b.height,h=f=0):(c=null,d=Aa,b=Fa,f=ta,h=Ga);c!=wa&&(e.bindFramebuffer(e.FRAMEBUFFER,c),e.viewport(f,h,d,b),wa=c)}function ka(b){b instanceof
THREE.WebGLRenderTargetCube?(e.bindTexture(e.TEXTURE_CUBE_MAP,b.__webglTexture),e.generateMipmap(e.TEXTURE_CUBE_MAP),e.bindTexture(e.TEXTURE_CUBE_MAP,null)):(e.bindTexture(e.TEXTURE_2D,b.__webglTexture),e.generateMipmap(e.TEXTURE_2D),e.bindTexture(e.TEXTURE_2D,null))}function Y(b,c){var d;b=="fragment"?d=e.createShader(e.FRAGMENT_SHADER):b=="vertex"&&(d=e.createShader(e.VERTEX_SHADER));e.shaderSource(d,c);e.compileShader(d);if(!e.getShaderParameter(d,e.COMPILE_STATUS))return console.error(e.getShaderInfoLog(d)),
console.error(c),null;return d}function va(b){switch(b){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return e.NEAREST;default:return e.LINEAR}}function Q(b){switch(b){case THREE.RepeatWrapping:return e.REPEAT;case THREE.ClampToEdgeWrapping:return e.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return e.MIRRORED_REPEAT;case THREE.NearestFilter:return e.NEAREST;case THREE.NearestMipMapNearestFilter:return e.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return e.NEAREST_MIPMAP_LINEAR;
case THREE.LinearFilter:return e.LINEAR;case THREE.LinearMipMapNearestFilter:return e.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return e.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return e.BYTE;case THREE.UnsignedByteType:return e.UNSIGNED_BYTE;case THREE.ShortType:return e.SHORT;case THREE.UnsignedShortType:return e.UNSIGNED_SHORT;case THREE.IntType:return e.INT;case THREE.UnsignedShortType:return e.UNSIGNED_INT;case THREE.FloatType:return e.FLOAT;case THREE.AlphaFormat:return e.ALPHA;
case THREE.RGBFormat:return e.RGB;case THREE.RGBAFormat:return e.RGBA;case THREE.LuminanceFormat:return e.LUMINANCE;case THREE.LuminanceAlphaFormat:return e.LUMINANCE_ALPHA}return 0}var M=this,e,Ea=[],Va=null,wa=null,T=null,Z=null,J=null,W=null,S=null,V=null,xa=null,P=null,ta=0,Ga=0,Aa=0,Fa=0,R=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],Ba=new THREE.Matrix4,Da=new Float32Array(16),Ta=new Float32Array(16),Ja=new THREE.Vector4,Wa={ambient:[0,
0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}},b=b||{},Ka=b.canvas!==void 0?b.canvas:document.createElement("canvas"),ab=b.stencil!==void 0?b.stencil:!0,bb=b.preserveDrawingBuffer!==void 0?b.preserveDrawingBuffer:!1,cb=b.antialias!==void 0?b.antialias:!1,ha=b.clearColor!==void 0?new THREE.Color(b.clearColor):new THREE.Color(0),Ha=b.clearAlpha!==void 0?b.clearAlpha:0;_maxLights=b.maxLights!==void 0?b.maxLights:4;this.data={vertices:0,faces:0,
drawCalls:0};this.maxMorphTargets=8;this.domElement=Ka;this.sortObjects=this.autoClear=!0;this.shadowMapBias=0.0039;this.shadowMapDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCameraNear=1;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowMap=[];this.shadowMapEnabled=!1;this.shadowMapSoft=!0;var ra,Sa=[],b=THREE.ShaderLib.depthRGBA,Za=THREE.UniformsUtils.clone(b.uniforms),Ua=new THREE.MeshShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,
uniforms:Za}),Xa=new THREE.MeshShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,uniforms:Za,morphTargets:!0});Ua._shadowPass=!0;Xa._shadowPass=!0;try{if(!(e=Ka.getContext("experimental-webgl",{antialias:cb,stencil:ab,preserveDrawingBuffer:bb})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+e.getParameter(e.VERSION)+" | "+e.getParameter(e.VENDOR)+" | "+e.getParameter(e.RENDERER)+" | "+e.getParameter(e.SHADING_LANGUAGE_VERSION))}catch(db){console.error(db)}e.clearColor(0,
0,0,1);e.clearDepth(1);e.clearStencil(0);e.enable(e.DEPTH_TEST);e.depthFunc(e.LEQUAL);e.frontFace(e.CCW);e.cullFace(e.BACK);e.enable(e.CULL_FACE);e.enable(e.BLEND);e.blendEquation(e.FUNC_ADD);e.blendFunc(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA);e.clearColor(ha.r,ha.g,ha.b,Ha);this.context=e;var $a=e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0,n={};n.vertices=new Float32Array(16);n.faces=new Uint16Array(6);i=0;n.vertices[i++]=-1;n.vertices[i++]=-1;n.vertices[i++]=0;n.vertices[i++]=1;n.vertices[i++]=
1;n.vertices[i++]=-1;n.vertices[i++]=1;n.vertices[i++]=1;n.vertices[i++]=1;n.vertices[i++]=1;n.vertices[i++]=1;n.vertices[i++]=0;n.vertices[i++]=-1;n.vertices[i++]=1;n.vertices[i++]=0;i=n.vertices[i++]=0;n.faces[i++]=0;n.faces[i++]=1;n.faces[i++]=2;n.faces[i++]=0;n.faces[i++]=2;n.faces[i++]=3;n.vertexBuffer=e.createBuffer();n.elementBuffer=e.createBuffer();e.bindBuffer(e.ARRAY_BUFFER,n.vertexBuffer);e.bufferData(e.ARRAY_BUFFER,n.vertices,e.STATIC_DRAW);e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n.elementBuffer);
e.bufferData(e.ELEMENT_ARRAY_BUFFER,n.faces,e.STATIC_DRAW);n.program=e.createProgram();e.attachShader(n.program,Y("fragment",THREE.ShaderLib.sprite.fragmentShader));e.attachShader(n.program,Y("vertex",THREE.ShaderLib.sprite.vertexShader));e.linkProgram(n.program);n.attributes={};n.uniforms={};n.attributes.position=e.getAttribLocation(n.program,"position");n.attributes.uv=e.getAttribLocation(n.program,"uv");n.uniforms.uvOffset=e.getUniformLocation(n.program,"uvOffset");n.uniforms.uvScale=e.getUniformLocation(n.program,
"uvScale");n.uniforms.rotation=e.getUniformLocation(n.program,"rotation");n.uniforms.scale=e.getUniformLocation(n.program,"scale");n.uniforms.alignment=e.getUniformLocation(n.program,"alignment");n.uniforms.map=e.getUniformLocation(n.program,"map");n.uniforms.opacity=e.getUniformLocation(n.program,"opacity");n.uniforms.useScreenCoordinates=e.getUniformLocation(n.program,"useScreenCoordinates");n.uniforms.affectedByDistance=e.getUniformLocation(n.program,"affectedByDistance");n.uniforms.screenPosition=
e.getUniformLocation(n.program,"screenPosition");n.uniforms.modelViewMatrix=e.getUniformLocation(n.program,"modelViewMatrix");n.uniforms.projectionMatrix=e.getUniformLocation(n.program,"projectionMatrix");var Ya=!1;this.setSize=function(b,c){Ka.width=b;Ka.height=c;this.setViewport(0,0,Ka.width,Ka.height)};this.setViewport=function(b,c,d,f){ta=b;Ga=c;Aa=d;Fa=f;e.viewport(ta,Ga,Aa,Fa)};this.setScissor=function(b,c,d,f){e.scissor(b,c,d,f)};this.enableScissorTest=function(b){b?e.enable(e.SCISSOR_TEST):
e.disable(e.SCISSOR_TEST)};this.setClearColorHex=function(b,c){ha.setHex(b);Ha=c;e.clearColor(ha.r,ha.g,ha.b,Ha)};this.setClearColor=function(b,c){ha.copy(b);Ha=c;e.clearColor(ha.r,ha.g,ha.b,Ha)};this.getClearColor=function(){return ha};this.getClearAlpha=function(){return Ha};this.clear=function(){e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT|e.STENCIL_BUFFER_BIT)};this.getContext=function(){return e};this.deallocateObject=function(b){if(b.__webglInit)if(b.__webglInit=!1,delete b._modelViewMatrix,
delete b._normalMatrixArray,delete b._modelViewMatrixArray,delete b._objectMatrixArray,b instanceof THREE.Mesh)for(g in b.geometry.geometryGroups){var c=b.geometry.geometryGroups[g];e.deleteBuffer(c.__webglVertexBuffer);e.deleteBuffer(c.__webglNormalBuffer);e.deleteBuffer(c.__webglTangentBuffer);e.deleteBuffer(c.__webglColorBuffer);e.deleteBuffer(c.__webglUVBuffer);e.deleteBuffer(c.__webglUV2Buffer);e.deleteBuffer(c.__webglSkinVertexABuffer);e.deleteBuffer(c.__webglSkinVertexBBuffer);e.deleteBuffer(c.__webglSkinIndicesBuffer);
e.deleteBuffer(c.__webglSkinWeightsBuffer);e.deleteBuffer(c.__webglFaceBuffer);e.deleteBuffer(c.__webglLineBuffer);if(c.numMorphTargets)for(var d=0,f=c.numMorphTargets;d<f;d++)e.deleteBuffer(c.__webglMorphTargetsBuffers[d])}else if(b instanceof THREE.Ribbon)b=b.geometry,e.deleteBuffer(b.__webglVertexBuffer),e.deleteBuffer(b.__webglColorBuffer);else if(b instanceof THREE.Line)b=b.geometry,e.deleteBuffer(b.__webglVertexBuffer),e.deleteBuffer(b.__webglColorBuffer);else if(b instanceof THREE.ParticleSystem)b=
b.geometry,e.deleteBuffer(b.__webglVertexBuffer),e.deleteBuffer(b.__webglColorBuffer)};this.deallocateTexture=function(b){if(b.__webglInit)b.__webglInit=!1,e.deleteTexture(b.__webglTexture)};this.initMaterial=function(b,c,d,f){var h,j,k;b instanceof THREE.MeshDepthMaterial?k="depth":b instanceof THREE.MeshNormalMaterial?k="normal":b instanceof THREE.MeshBasicMaterial?k="basic":b instanceof THREE.MeshLambertMaterial?k="lambert":b instanceof THREE.MeshPhongMaterial?k="phong":b instanceof THREE.LineBasicMaterial?
k="basic":b instanceof THREE.ParticleBasicMaterial&&(k="particle_basic");if(k){var m=THREE.ShaderLib[k];b.uniforms=THREE.UniformsUtils.clone(m.uniforms);b.vertexShader=m.vertexShader;b.fragmentShader=m.fragmentShader}var p,q,r;p=r=m=0;for(q=c.length;p<q;p++)j=c[p],j instanceof THREE.SpotLight&&r++,j instanceof THREE.DirectionalLight&&r++,j instanceof THREE.PointLight&&m++;m+r<=_maxLights?p=r:(p=Math.ceil(_maxLights*r/(m+r)),m=_maxLights-p);j={directional:p,point:m};m=r=0;for(p=c.length;m<p;m++)q=
c[m],q instanceof THREE.SpotLight&&q.castShadow&&r++;var s=50;if(f!==void 0&&f instanceof THREE.SkinnedMesh)s=f.bones.length;var n;a:{p=b.fragmentShader;q=b.vertexShader;var m=b.uniforms,c=b.attributes,d={map:!!b.map,envMap:!!b.envMap,lightMap:!!b.lightMap,vertexColors:b.vertexColors,fog:d,useFog:b.fog,sizeAttenuation:b.sizeAttenuation,skinning:b.skinning,morphTargets:b.morphTargets,maxMorphTargets:this.maxMorphTargets,maxDirLights:j.directional,maxPointLights:j.point,maxBones:s,shadowMapEnabled:this.shadowMapEnabled&&
f.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapWidth:this.shadowMapWidth,shadowMapHeight:this.shadowMapHeight,maxShadows:r,alphaTest:b.alphaTest},u,f=[];k?f.push(k):(f.push(p),f.push(q));for(u in d)f.push(u),f.push(d[u]);k=f.join();u=0;for(f=Ea.length;u<f;u++)if(Ea[u].code==k){n=Ea[u].program;break a}u=e.createProgram();f=[$a?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_SHADOWS "+d.maxShadows,"#define MAX_BONES "+
d.maxBones,d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.skinning?"#define USE_SKINNING":"",d.morphTargets?"#define USE_MORPHTARGETS":"",d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapSoft?"#define SHADOWMAP_SOFT":"",d.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
j=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_SHADOWS "+d.maxShadows,d.alphaTest?"#define ALPHATEST "+d.alphaTest:"",d.useFog&&d.fog?"#define USE_FOG":"",d.useFog&&d.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.shadowMapEnabled?"#define USE_SHADOWMAP":"",
d.shadowMapSoft?"#define SHADOWMAP_SOFT":"",d.shadowMapSoft?"#define SHADOWMAP_WIDTH "+d.shadowMapWidth.toFixed(1):"",d.shadowMapSoft?"#define SHADOWMAP_HEIGHT "+d.shadowMapHeight.toFixed(1):"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");e.attachShader(u,Y("fragment",j+p));e.attachShader(u,Y("vertex",f+q));e.linkProgram(u);e.getProgramParameter(u,e.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+e.getProgramParameter(u,e.VALIDATE_STATUS)+", gl error ["+
e.getError()+"]");u.uniforms={};u.attributes={};var v,f=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(v in m)f.push(v);v=f;f=0;for(m=v.length;f<m;f++)p=v[f],u.uniforms[p]=e.getUniformLocation(u,p);f=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(v=0;v<d.maxMorphTargets;v++)f.push("morphTarget"+v);for(n in c)f.push(n);
n=f;v=0;for(c=n.length;v<c;v++)d=n[v],u.attributes[d]=e.getAttribLocation(u,d);Ea.push({program:u,code:k});n=u}b.program=n;n=b.program.attributes;n.position>=0&&e.enableVertexAttribArray(n.position);n.color>=0&&e.enableVertexAttribArray(n.color);n.normal>=0&&e.enableVertexAttribArray(n.normal);n.tangent>=0&&e.enableVertexAttribArray(n.tangent);b.skinning&&n.skinVertexA>=0&&n.skinVertexB>=0&&n.skinIndex>=0&&n.skinWeight>=0&&(e.enableVertexAttribArray(n.skinVertexA),e.enableVertexAttribArray(n.skinVertexB),
e.enableVertexAttribArray(n.skinIndex),e.enableVertexAttribArray(n.skinWeight));if(b.attributes)for(h in b.attributes)n[h]!==void 0&&n[h]>=0&&e.enableVertexAttribArray(n[h]);if(b.morphTargets)for(h=b.numSupportedMorphTargets=0;h<this.maxMorphTargets;h++)v="morphTarget"+h,n[v]>=0&&(e.enableVertexAttribArray(n[v]),b.numSupportedMorphTargets++)};this.clearTarget=function(b,c,d,f){L(b);b=0;c&&(b|=e.COLOR_BUFFER_BIT);d&&(b|=e.DEPTH_BUFFER_BIT);f&&(b|=e.STENCIL_BUFFER_BIT);e.clear(b)};this.render=function(b,
c,e,r){var n,w,fa,U,H,I,D,Qa,J=b.lights,Ra=b.fog;this.shadowMapEnabled&&y(b,c);M.data.vertices=0;M.data.faces=0;M.data.drawCalls=0;c.matrixAutoUpdate&&c.update(void 0,!0);b.update(void 0,!1,c);c.matrixWorldInverse.flattenToArray(Ta);c.projectionMatrix.flattenToArray(Da);Ba.multiply(c.projectionMatrix,c.matrixWorldInverse);q(Ba);this.initWebGLObjects(b);L(e);(this.autoClear||r)&&this.clear();H=b.__webglObjects.length;for(r=0;r<H;r++)if(n=b.__webglObjects[r],D=n.object,D.visible)if(!(D instanceof THREE.Mesh)||
!D.frustumCulled||s(D)){if(D.matrixWorld.flattenToArray(D._objectMatrixArray),C(D,c,!0),v(n),n.render=!0,this.sortObjects)n.object.renderDepth?n.z=n.object.renderDepth:(Ja.copy(D.position),Ba.multiplyVector3(Ja),n.z=Ja.z)}else n.render=!1;else n.render=!1;this.sortObjects&&b.__webglObjects.sort(B);I=b.__webglObjectsImmediate.length;for(r=0;r<I;r++)n=b.__webglObjectsImmediate[r],D=n.object,D.visible&&(D.matrixAutoUpdate&&D.matrixWorld.flattenToArray(D._objectMatrixArray),C(D,c,!0),u(n));if(b.overrideMaterial){k(b.overrideMaterial.depthTest);
F(b.overrideMaterial.blending);for(r=0;r<H;r++)if(n=b.__webglObjects[r],n.render)D=n.object,Qa=n.buffer,h(D),f(c,J,Ra,b.overrideMaterial,Qa,D);for(r=0;r<I;r++)n=b.__webglObjectsImmediate[r],D=n.object,D.visible&&(h(D),w=d(c,J,Ra,b.overrideMaterial,D),D.render(function(c){j(c,w,b.overrideMaterial.shading)}))}else{F(THREE.NormalBlending);for(r=H-1;r>=0;r--)if(n=b.__webglObjects[r],n.render){D=n.object;Qa=n.buffer;fa=n.opaque;h(D);for(n=0;n<fa.count;n++)U=fa.list[n],k(U.depthTest),m(U.depthWrite),p(U.polygonOffset,
U.polygonOffsetFactor,U.polygonOffsetUnits),f(c,J,Ra,U,Qa,D)}for(r=0;r<I;r++)if(n=b.__webglObjectsImmediate[r],D=n.object,D.visible){fa=n.opaque;h(D);for(n=0;n<fa.count;n++)U=fa.list[n],k(U.depthTest),m(U.depthWrite),p(U.polygonOffset,U.polygonOffsetFactor,U.polygonOffsetUnits),w=d(c,J,Ra,U,D),D.render(function(b){j(b,w,U.shading)})}for(r=0;r<H;r++)if(n=b.__webglObjects[r],n.render){D=n.object;Qa=n.buffer;fa=n.transparent;h(D);for(n=0;n<fa.count;n++)U=fa.list[n],F(U.blending),k(U.depthTest),m(U.depthWrite),
p(U.polygonOffset,U.polygonOffsetFactor,U.polygonOffsetUnits),f(c,J,Ra,U,Qa,D)}for(r=0;r<I;r++)if(n=b.__webglObjectsImmediate[r],D=n.object,D.visible){fa=n.transparent;h(D);for(n=0;n<fa.count;n++)U=fa.list[n],F(U.blending),k(U.depthTest),m(U.depthWrite),p(U.polygonOffset,U.polygonOffsetFactor,U.polygonOffsetUnits),w=d(c,J,Ra,U,D),D.render(function(b){j(b,w,U.shading)})}}b.__webglSprites.length&&E(b,c);e&&e.minFilter!==THREE.NearestFilter&&e.minFilter!==THREE.LinearFilter&&ka(e)};this.initWebGLObjects=
function(b){if(!b.__webglObjects)b.__webglObjects=[],b.__webglObjectsImmediate=[],b.__webglSprites=[];for(;b.__objectsAdded.length;){var d=b.__objectsAdded[0],f=b,h=void 0,j=void 0,k=void 0;if(!d.__webglInit)if(d.__webglInit=!0,d._modelViewMatrix=new THREE.Matrix4,d._normalMatrixArray=new Float32Array(9),d._modelViewMatrixArray=new Float32Array(16),d._objectMatrixArray=new Float32Array(16),d.matrixWorld.flattenToArray(d._objectMatrixArray),d instanceof THREE.Mesh)for(h in j=d.geometry,j.geometryGroups==
void 0&&sa(j),j.geometryGroups){k=j.geometryGroups[h];if(!k.__webglVertexBuffer){var m=k;m.__webglVertexBuffer=e.createBuffer();m.__webglNormalBuffer=e.createBuffer();m.__webglTangentBuffer=e.createBuffer();m.__webglColorBuffer=e.createBuffer();m.__webglUVBuffer=e.createBuffer();m.__webglUV2Buffer=e.createBuffer();m.__webglSkinVertexABuffer=e.createBuffer();m.__webglSkinVertexBBuffer=e.createBuffer();m.__webglSkinIndicesBuffer=e.createBuffer();m.__webglSkinWeightsBuffer=e.createBuffer();m.__webglFaceBuffer=
e.createBuffer();m.__webglLineBuffer=e.createBuffer();if(m.numMorphTargets){var p=void 0,n=void 0;m.__webglMorphTargetsBuffers=[];p=0;for(n=m.numMorphTargets;p<n;p++)m.__webglMorphTargetsBuffers.push(e.createBuffer())}for(var m=k,p=d,r=void 0,q=void 0,s=void 0,u=s=void 0,v=void 0,w=void 0,B=w=n=0,y=s=q=void 0,C=y=q=r=void 0,s=void 0,u=p.geometry,v=u.faces,y=m.faces,r=0,q=y.length;r<q;r++)s=y[r],s=v[s],s instanceof THREE.Face3?(n+=3,w+=1,B+=3):s instanceof THREE.Face4&&(n+=4,w+=2,B+=4);for(var r=m,
q=p,G=y=v=void 0,K=void 0,G=void 0,s=[],v=0,y=q.materials.length;v<y;v++)if(G=q.materials[v],G instanceof THREE.MeshFaceMaterial){G=0;for(l=r.materials.length;G<l;G++)(K=r.materials[G])&&s.push(K)}else(K=G)&&s.push(K);r=s;m.__materials=r;a:{v=q=void 0;y=r.length;for(q=0;q<y;q++)if(v=r[q],v.map||v.lightMap||v instanceof THREE.MeshShaderMaterial){q=!0;break a}q=!1}a:{y=v=void 0;s=r.length;for(v=0;v<s;v++)if(y=r[v],!(y instanceof THREE.MeshBasicMaterial&&!y.envMap||y instanceof THREE.MeshDepthMaterial)){y=
y&&y.shading!=void 0&&y.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;break a}y=!1}a:{s=v=void 0;G=r.length;for(v=0;v<G;v++)if(s=r[v],s.vertexColors){s=s.vertexColors;break a}s=!1}m.__vertexArray=new Float32Array(n*3);if(y)m.__normalArray=new Float32Array(n*3);if(u.hasTangents)m.__tangentArray=new Float32Array(n*4);if(s)m.__colorArray=new Float32Array(n*3);if(q){if(u.faceUvs.length>0||u.faceVertexUvs.length>0)m.__uvArray=new Float32Array(n*2);if(u.faceUvs.length>1||u.faceVertexUvs.length>
1)m.__uv2Array=new Float32Array(n*2)}if(p.geometry.skinWeights.length&&p.geometry.skinIndices.length)m.__skinVertexAArray=new Float32Array(n*4),m.__skinVertexBArray=new Float32Array(n*4),m.__skinIndexArray=new Float32Array(n*4),m.__skinWeightArray=new Float32Array(n*4);m.__faceArray=new Uint16Array(w*3+(p.geometry.edgeFaces?p.geometry.edgeFaces.length*6:0));m.__lineArray=new Uint16Array(B*2);if(m.numMorphTargets){m.__morphTargetsArrays=[];u=0;for(v=m.numMorphTargets;u<v;u++)m.__morphTargetsArrays.push(new Float32Array(n*
3))}m.__needsSmoothNormals=y==THREE.SmoothShading;m.__uvType=q;m.__vertexColorType=s;m.__normalType=y;m.__webglFaceCount=w*3+(p.geometry.edgeFaces?p.geometry.edgeFaces.length*6:0);m.__webglLineCount=B*2;u=0;for(v=r.length;u<v;u++)if(q=r[u],q.attributes){if(m.__webglCustomAttributes===void 0)m.__webglCustomAttributes={};for(a in q.attributes){s=q.attributes[a];y={};for(C in s)y[C]=s[C];if(!y.__webglInitialized||y.createUniqueBuffers)y.__webglInitialized=!0,w=1,y.type==="v2"?w=2:y.type==="v3"?w=3:y.type===
"v4"?w=4:y.type==="c"&&(w=3),y.size=w,y.array=new Float32Array(n*w),y.buffer=e.createBuffer(),y.buffer.belongsToAttribute=a,s.needsUpdate=!0,y.__original=s;m.__webglCustomAttributes[a]=y}}m.__inittedArrays=!0;j.__dirtyVertices=!0;j.__dirtyMorphTargets=!0;j.__dirtyElements=!0;j.__dirtyUvs=!0;j.__dirtyNormals=!0;j.__dirtyTangents=!0;j.__dirtyColors=!0}ga(f.__webglObjects,k,d)}else if(d instanceof THREE.Ribbon){j=d.geometry;if(!j.__webglVertexBuffer)h=j,h.__webglVertexBuffer=e.createBuffer(),h.__webglColorBuffer=
e.createBuffer(),h=j,k=h.vertices.length,h.__vertexArray=new Float32Array(k*3),h.__colorArray=new Float32Array(k*3),h.__webglVertexCount=k,j.__dirtyVertices=!0,j.__dirtyColors=!0;ga(f.__webglObjects,j,d)}else if(d instanceof THREE.Line){j=d.geometry;if(!j.__webglVertexBuffer)h=j,h.__webglVertexBuffer=e.createBuffer(),h.__webglColorBuffer=e.createBuffer(),h=j,k=h.vertices.length,h.__vertexArray=new Float32Array(k*3),h.__colorArray=new Float32Array(k*3),h.__webglLineCount=k,j.__dirtyVertices=!0,j.__dirtyColors=
!0;ga(f.__webglObjects,j,d)}else if(d instanceof THREE.ParticleSystem){j=d.geometry;if(!j.__webglVertexBuffer){h=j;h.__webglVertexBuffer=e.createBuffer();h.__webglColorBuffer=e.createBuffer();h=j;k=d;m=h.vertices.length;h.__vertexArray=new Float32Array(m*3);h.__colorArray=new Float32Array(m*3);h.__sortArray=[];h.__webglParticleCount=m;h.__materials=k.materials;C=n=p=void 0;p=0;for(n=k.materials.length;p<n;p++)if(C=k.materials[p],C.attributes){if(h.__webglCustomAttributes===void 0)h.__webglCustomAttributes=
{};for(a in C.attributes){originalAttribute=C.attributes[a];attribute={};for(property in originalAttribute)attribute[property]=originalAttribute[property];if(!attribute.__webglInitialized||attribute.createUniqueBuffers)attribute.__webglInitialized=!0,size=1,attribute.type==="v2"?size=2:attribute.type==="v3"?size=3:attribute.type==="v4"?size=4:attribute.type==="c"&&(size=3),attribute.size=size,attribute.array=new Float32Array(m*size),attribute.buffer=e.createBuffer(),attribute.buffer.belongsToAttribute=
a,originalAttribute.needsUpdate=!0,attribute.__original=originalAttribute;h.__webglCustomAttributes[a]=attribute}}j.__dirtyVertices=!0;j.__dirtyColors=!0}ga(f.__webglObjects,j,d)}else THREE.MarchingCubes!==void 0&&d instanceof THREE.MarchingCubes?f.__webglObjectsImmediate.push({object:d,opaque:{list:[],count:0},transparent:{list:[],count:0}}):d instanceof THREE.Sprite&&f.__webglSprites.push(d);b.__objectsAdded.splice(0,1)}for(;b.__objectsRemoved.length;){f=b.__objectsRemoved[0];d=b;if(f instanceof
THREE.Mesh||f instanceof THREE.ParticleSystem||f instanceof THREE.Ribbon||f instanceof THREE.Line)qa(d.__webglObjects,f);else if(f instanceof THREE.Sprite){d=d.__webglSprites;j=void 0;for(j=d.length-1;j>=0;j--)d[j]==f&&d.splice(j,1)}else f instanceof THREE.MarchingCubes&&qa(d.__webglObjectsImmediate,f);b.__objectsRemoved.splice(0,1)}d=0;for(f=b.__webglObjects.length;d<f;d++)if(h=b.__webglObjects[d].object,n=k=j=void 0,h instanceof THREE.Mesh){j=h.geometry;m=0;for(p=j.geometryGroupsList.length;m<p;m++)if(k=
j.geometryGroupsList[m],n=ya(k),j.__dirtyVertices||j.__dirtyMorphTargets||j.__dirtyElements||j.__dirtyUvs||j.__dirtyNormals||j.__dirtyColors||j.__dirtyTangents||n)if(n=k,C=e.DYNAMIC_DRAW,w=!j.dynamic,n.__inittedArrays){var E=u=B=void 0,A=void 0,J=E=void 0,F=void 0,M=void 0,N=void 0,O=K=G=s=y=v=q=r=void 0,L=void 0,t=A=N=A=M=F=void 0,o=void 0,z=o=t=F=void 0,P=void 0,S=z=o=t=E=E=J=N=A=z=o=t=P=z=o=t=P=z=o=t=void 0,ia=0,ma=0,W=0,Y=0,T=0,Q=0,X=0,R=0,la=0,x=0,na=0,z=t=0,z=void 0,oa=n.__vertexArray,ja=n.__uvArray,
ka=n.__uv2Array,V=n.__normalArray,$=n.__tangentArray,pa=n.__colorArray,aa=n.__skinVertexAArray,ca=n.__skinVertexBArray,da=n.__skinIndexArray,ea=n.__skinWeightArray,ra=n.__morphTargetsArrays,Z=n.__webglCustomAttributes,o=void 0,ha=n.__faceArray,Ca=n.__lineArray,xa=n.__needsSmoothNormals,q=n.__vertexColorType,r=n.__uvType,v=n.__normalType,ua=h.geometry,va=ua.__dirtyVertices,wa=ua.__dirtyElements,ta=ua.__dirtyUvs,Ba=ua.__dirtyNormals,Da=ua.__dirtyTangents,Ea=ua.__dirtyColors,Fa=ua.__dirtyMorphTargets,
Aa=ua.vertices,Ga=n.faces,Ka=ua.faces,Ha=ua.faceVertexUvs[0],Ja=ua.faceVertexUvs[1],Na=ua.skinVerticesA,Oa=ua.skinVerticesB,Pa=ua.skinIndices,La=ua.skinWeights,Ia=ua.morphTargets;if(Z)for(S in Z)Z[S].offset=0,Z[S].offsetSrc=0;B=0;for(u=Ga.length;B<u;B++)if(E=Ga[B],A=Ka[E],Ha&&(y=Ha[E]),Ja&&(s=Ja[E]),E=A.vertexNormals,J=A.normal,F=A.vertexColors,M=A.color,N=A.vertexTangents,A instanceof THREE.Face3){if(va)G=Aa[A.a].position,K=Aa[A.b].position,O=Aa[A.c].position,oa[ma]=G.x,oa[ma+1]=G.y,oa[ma+2]=G.z,
oa[ma+3]=K.x,oa[ma+4]=K.y,oa[ma+5]=K.z,oa[ma+6]=O.x,oa[ma+7]=O.y,oa[ma+8]=O.z,ma+=9;if(Z)for(S in Z)if(o=Z[S],o.__original.needsUpdate)t=o.offset,z=o.offsetSrc,o.size===1?(o.boundTo===void 0||o.boundTo==="vertices"?(o.array[t]=o.value[A.a],o.array[t+1]=o.value[A.b],o.array[t+2]=o.value[A.c]):o.boundTo==="faces"?(z=o.value[z],o.array[t]=z,o.array[t+1]=z,o.array[t+2]=z,o.offsetSrc++):o.boundTo==="faceVertices"&&(o.array[t]=o.value[z],o.array[t+1]=o.value[z+1],o.array[t+2]=o.value[z+2],o.offsetSrc+=
3),o.offset+=3):(o.boundTo===void 0||o.boundTo==="vertices"?(G=o.value[A.a],K=o.value[A.b],O=o.value[A.c]):o.boundTo==="faces"?(O=K=G=z=o.value[z],o.offsetSrc++):o.boundTo==="faceVertices"&&(G=o.value[z],K=o.value[z+1],O=o.value[z+2],o.offsetSrc+=3),o.size===2?(o.array[t]=G.x,o.array[t+1]=G.y,o.array[t+2]=K.x,o.array[t+3]=K.y,o.array[t+4]=O.x,o.array[t+5]=O.y,o.offset+=6):o.size===3?(o.type==="c"?(o.array[t]=G.r,o.array[t+1]=G.g,o.array[t+2]=G.b,o.array[t+3]=K.r,o.array[t+4]=K.g,o.array[t+5]=K.b,
o.array[t+6]=O.r,o.array[t+7]=O.g,o.array[t+8]=O.b):(o.array[t]=G.x,o.array[t+1]=G.y,o.array[t+2]=G.z,o.array[t+3]=K.x,o.array[t+4]=K.y,o.array[t+5]=K.z,o.array[t+6]=O.x,o.array[t+7]=O.y,o.array[t+8]=O.z),o.offset+=9):(o.array[t]=G.x,o.array[t+1]=G.y,o.array[t+2]=G.z,o.array[t+3]=G.w,o.array[t+4]=K.x,o.array[t+5]=K.y,o.array[t+6]=K.z,o.array[t+7]=K.w,o.array[t+8]=O.x,o.array[t+9]=O.y,o.array[t+10]=O.z,o.array[t+11]=O.w,o.offset+=12));if(Fa){t=0;for(o=Ia.length;t<o;t++)G=Ia[t].vertices[A.a].position,
K=Ia[t].vertices[A.b].position,O=Ia[t].vertices[A.c].position,z=ra[t],z[na]=G.x,z[na+1]=G.y,z[na+2]=G.z,z[na+3]=K.x,z[na+4]=K.y,z[na+5]=K.z,z[na+6]=O.x,z[na+7]=O.y,z[na+8]=O.z;na+=9}if(La.length)t=La[A.a],o=La[A.b],z=La[A.c],ea[x]=t.x,ea[x+1]=t.y,ea[x+2]=t.z,ea[x+3]=t.w,ea[x+4]=o.x,ea[x+5]=o.y,ea[x+6]=o.z,ea[x+7]=o.w,ea[x+8]=z.x,ea[x+9]=z.y,ea[x+10]=z.z,ea[x+11]=z.w,t=Pa[A.a],o=Pa[A.b],z=Pa[A.c],da[x]=t.x,da[x+1]=t.y,da[x+2]=t.z,da[x+3]=t.w,da[x+4]=o.x,da[x+5]=o.y,da[x+6]=o.z,da[x+7]=o.w,da[x+8]=
z.x,da[x+9]=z.y,da[x+10]=z.z,da[x+11]=z.w,t=Na[A.a],o=Na[A.b],z=Na[A.c],aa[x]=t.x,aa[x+1]=t.y,aa[x+2]=t.z,aa[x+3]=1,aa[x+4]=o.x,aa[x+5]=o.y,aa[x+6]=o.z,aa[x+7]=1,aa[x+8]=z.x,aa[x+9]=z.y,aa[x+10]=z.z,aa[x+11]=1,t=Oa[A.a],o=Oa[A.b],z=Oa[A.c],ca[x]=t.x,ca[x+1]=t.y,ca[x+2]=t.z,ca[x+3]=1,ca[x+4]=o.x,ca[x+5]=o.y,ca[x+6]=o.z,ca[x+7]=1,ca[x+8]=z.x,ca[x+9]=z.y,ca[x+10]=z.z,ca[x+11]=1,x+=12;if(Ea&&q)F.length==3&&q==THREE.VertexColors?(A=F[0],t=F[1],o=F[2]):o=t=A=M,pa[la]=A.r,pa[la+1]=A.g,pa[la+2]=A.b,pa[la+
3]=t.r,pa[la+4]=t.g,pa[la+5]=t.b,pa[la+6]=o.r,pa[la+7]=o.g,pa[la+8]=o.b,la+=9;if(Da&&ua.hasTangents)F=N[0],M=N[1],A=N[2],$[X]=F.x,$[X+1]=F.y,$[X+2]=F.z,$[X+3]=F.w,$[X+4]=M.x,$[X+5]=M.y,$[X+6]=M.z,$[X+7]=M.w,$[X+8]=A.x,$[X+9]=A.y,$[X+10]=A.z,$[X+11]=A.w,X+=12;if(Ba&&v)if(E.length==3&&xa)for(N=0;N<3;N++)J=E[N],V[Q]=J.x,V[Q+1]=J.y,V[Q+2]=J.z,Q+=3;else for(N=0;N<3;N++)V[Q]=J.x,V[Q+1]=J.y,V[Q+2]=J.z,Q+=3;if(ta&&y!==void 0&&r)for(N=0;N<3;N++)E=y[N],ja[W]=E.u,ja[W+1]=E.v,W+=2;if(ta&&s!==void 0&&r)for(N=
0;N<3;N++)E=s[N],ka[Y]=E.u,ka[Y+1]=E.v,Y+=2;wa&&(ha[T]=ia,ha[T+1]=ia+1,ha[T+2]=ia+2,T+=3,Ca[R]=ia,Ca[R+1]=ia+1,Ca[R+2]=ia,Ca[R+3]=ia+2,Ca[R+4]=ia+1,Ca[R+5]=ia+2,R+=6,ia+=3)}else if(A instanceof THREE.Face4){if(va)G=Aa[A.a].position,K=Aa[A.b].position,O=Aa[A.c].position,L=Aa[A.d].position,oa[ma]=G.x,oa[ma+1]=G.y,oa[ma+2]=G.z,oa[ma+3]=K.x,oa[ma+4]=K.y,oa[ma+5]=K.z,oa[ma+6]=O.x,oa[ma+7]=O.y,oa[ma+8]=O.z,oa[ma+9]=L.x,oa[ma+10]=L.y,oa[ma+11]=L.z,ma+=12;if(Z)for(S in Z)if(o=Z[S],o.__original.needsUpdate)t=
o.offset,z=o.offsetSrc,o.size===1?(o.boundTo===void 0||o.boundTo==="vertices"?(o.array[t]=o.value[A.a],o.array[t+1]=o.value[A.b],o.array[t+2]=o.value[A.c],o.array[t+3]=o.value[A.d]):o.boundTo==="faces"?(z=o.value[z],o.array[t]=z,o.array[t+1]=z,o.array[t+2]=z,o.array[t+3]=z,o.offsetSrc++):o.boundTo==="faceVertices"&&(o.array[t]=o.value[z],o.array[t+1]=o.value[z+1],o.array[t+2]=o.value[z+2],o.array[t+3]=o.value[z+3],o.offsetSrc+=4),o.offset+=4):(o.boundTo===void 0||o.boundTo==="vertices"?(G=o.value[A.a],
K=o.value[A.b],O=o.value[A.c],L=o.value[A.d]):o.boundTo==="faces"?(L=O=K=G=z=o.value[z],o.offsetSrc++):o.boundTo==="faceVertices"&&(G=o.value[z],K=o.value[z+1],O=o.value[z+2],L=o.value[z+3],o.offsetSrc+=4),o.size===2?(o.array[t]=G.x,o.array[t+1]=G.y,o.array[t+2]=K.x,o.array[t+3]=K.y,o.array[t+4]=O.x,o.array[t+5]=O.y,o.array[t+6]=L.x,o.array[t+7]=L.y,o.offset+=8):o.size===3?(o.type==="c"?(o.array[t]=G.r,o.array[t+1]=G.g,o.array[t+2]=G.b,o.array[t+3]=K.r,o.array[t+4]=K.g,o.array[t+5]=K.b,o.array[t+
6]=O.r,o.array[t+7]=O.g,o.array[t+8]=O.b,o.array[t+9]=L.r,o.array[t+10]=L.g,o.array[t+11]=L.b):(o.array[t]=G.x,o.array[t+1]=G.y,o.array[t+2]=G.z,o.array[t+3]=K.x,o.array[t+4]=K.y,o.array[t+5]=K.z,o.array[t+6]=O.x,o.array[t+7]=O.y,o.array[t+8]=O.z,o.array[t+9]=L.x,o.array[t+10]=L.y,o.array[t+11]=L.z),o.offset+=12):(o.array[t]=G.x,o.array[t+1]=G.y,o.array[t+2]=G.z,o.array[t+3]=G.w,o.array[t+4]=K.x,o.array[t+5]=K.y,o.array[t+6]=K.z,o.array[t+7]=K.w,o.array[t+8]=O.x,o.array[t+9]=O.y,o.array[t+10]=O.z,
o.array[t+11]=O.w,o.array[t+12]=L.x,o.array[t+13]=L.y,o.array[t+14]=L.z,o.array[t+15]=L.w,o.offset+=16));if(Fa){t=0;for(o=Ia.length;t<o;t++)G=Ia[t].vertices[A.a].position,K=Ia[t].vertices[A.b].position,O=Ia[t].vertices[A.c].position,L=Ia[t].vertices[A.d].position,z=ra[t],z[na]=G.x,z[na+1]=G.y,z[na+2]=G.z,z[na+3]=K.x,z[na+4]=K.y,z[na+5]=K.z,z[na+6]=O.x,z[na+7]=O.y,z[na+8]=O.z,z[na+9]=L.x,z[na+10]=L.y,z[na+11]=L.z;na+=12}if(La.length)t=La[A.a],o=La[A.b],z=La[A.c],P=La[A.d],ea[x]=t.x,ea[x+1]=t.y,ea[x+
2]=t.z,ea[x+3]=t.w,ea[x+4]=o.x,ea[x+5]=o.y,ea[x+6]=o.z,ea[x+7]=o.w,ea[x+8]=z.x,ea[x+9]=z.y,ea[x+10]=z.z,ea[x+11]=z.w,ea[x+12]=P.x,ea[x+13]=P.y,ea[x+14]=P.z,ea[x+15]=P.w,t=Pa[A.a],o=Pa[A.b],z=Pa[A.c],P=Pa[A.d],da[x]=t.x,da[x+1]=t.y,da[x+2]=t.z,da[x+3]=t.w,da[x+4]=o.x,da[x+5]=o.y,da[x+6]=o.z,da[x+7]=o.w,da[x+8]=z.x,da[x+9]=z.y,da[x+10]=z.z,da[x+11]=z.w,da[x+12]=P.x,da[x+13]=P.y,da[x+14]=P.z,da[x+15]=P.w,t=Na[A.a],o=Na[A.b],z=Na[A.c],P=Na[A.d],aa[x]=t.x,aa[x+1]=t.y,aa[x+2]=t.z,aa[x+3]=1,aa[x+4]=o.x,
aa[x+5]=o.y,aa[x+6]=o.z,aa[x+7]=1,aa[x+8]=z.x,aa[x+9]=z.y,aa[x+10]=z.z,aa[x+11]=1,aa[x+12]=P.x,aa[x+13]=P.y,aa[x+14]=P.z,aa[x+15]=1,t=Oa[A.a],o=Oa[A.b],z=Oa[A.c],A=Oa[A.d],ca[x]=t.x,ca[x+1]=t.y,ca[x+2]=t.z,ca[x+3]=1,ca[x+4]=o.x,ca[x+5]=o.y,ca[x+6]=o.z,ca[x+7]=1,ca[x+8]=z.x,ca[x+9]=z.y,ca[x+10]=z.z,ca[x+11]=1,ca[x+12]=A.x,ca[x+13]=A.y,ca[x+14]=A.z,ca[x+15]=1,x+=16;if(Ea&&q)F.length==4&&q==THREE.VertexColors?(A=F[0],t=F[1],o=F[2],F=F[3]):F=o=t=A=M,pa[la]=A.r,pa[la+1]=A.g,pa[la+2]=A.b,pa[la+3]=t.r,pa[la+
4]=t.g,pa[la+5]=t.b,pa[la+6]=o.r,pa[la+7]=o.g,pa[la+8]=o.b,pa[la+9]=F.r,pa[la+10]=F.g,pa[la+11]=F.b,la+=12;if(Da&&ua.hasTangents)F=N[0],M=N[1],A=N[2],N=N[3],$[X]=F.x,$[X+1]=F.y,$[X+2]=F.z,$[X+3]=F.w,$[X+4]=M.x,$[X+5]=M.y,$[X+6]=M.z,$[X+7]=M.w,$[X+8]=A.x,$[X+9]=A.y,$[X+10]=A.z,$[X+11]=A.w,$[X+12]=N.x,$[X+13]=N.y,$[X+14]=N.z,$[X+15]=N.w,X+=16;if(Ba&&v)if(E.length==4&&xa)for(N=0;N<4;N++)J=E[N],V[Q]=J.x,V[Q+1]=J.y,V[Q+2]=J.z,Q+=3;else for(N=0;N<4;N++)V[Q]=J.x,V[Q+1]=J.y,V[Q+2]=J.z,Q+=3;if(ta&&y!==void 0&&
r)for(N=0;N<4;N++)E=y[N],ja[W]=E.u,ja[W+1]=E.v,W+=2;if(ta&&s!==void 0&&r)for(N=0;N<4;N++)E=s[N],ka[Y]=E.u,ka[Y+1]=E.v,Y+=2;wa&&(ha[T]=ia,ha[T+1]=ia+1,ha[T+2]=ia+3,ha[T+3]=ia+1,ha[T+4]=ia+2,ha[T+5]=ia+3,T+=6,Ca[R]=ia,Ca[R+1]=ia+1,Ca[R+2]=ia,Ca[R+3]=ia+3,Ca[R+4]=ia+1,Ca[R+5]=ia+2,Ca[R+6]=ia+2,Ca[R+7]=ia+3,R+=8,ia+=4)}va&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglVertexBuffer),e.bufferData(e.ARRAY_BUFFER,oa,C));if(Z)for(S in Z)o=Z[S],o.__original.needsUpdate&&(e.bindBuffer(e.ARRAY_BUFFER,o.buffer),e.bufferData(e.ARRAY_BUFFER,
o.array,C));if(Fa){t=0;for(o=Ia.length;t<o;t++)e.bindBuffer(e.ARRAY_BUFFER,n.__webglMorphTargetsBuffers[t]),e.bufferData(e.ARRAY_BUFFER,ra[t],C)}Ea&&la>0&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglColorBuffer),e.bufferData(e.ARRAY_BUFFER,pa,C));Ba&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglNormalBuffer),e.bufferData(e.ARRAY_BUFFER,V,C));Da&&ua.hasTangents&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglTangentBuffer),e.bufferData(e.ARRAY_BUFFER,$,C));ta&&W>0&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglUVBuffer),e.bufferData(e.ARRAY_BUFFER,
ja,C));ta&&Y>0&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglUV2Buffer),e.bufferData(e.ARRAY_BUFFER,ka,C));wa&&(e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n.__webglFaceBuffer),e.bufferData(e.ELEMENT_ARRAY_BUFFER,ha,C),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n.__webglLineBuffer),e.bufferData(e.ELEMENT_ARRAY_BUFFER,Ca,C));x>0&&(e.bindBuffer(e.ARRAY_BUFFER,n.__webglSkinVertexABuffer),e.bufferData(e.ARRAY_BUFFER,aa,C),e.bindBuffer(e.ARRAY_BUFFER,n.__webglSkinVertexBBuffer),e.bufferData(e.ARRAY_BUFFER,ca,C),e.bindBuffer(e.ARRAY_BUFFER,
n.__webglSkinIndicesBuffer),e.bufferData(e.ARRAY_BUFFER,da,C),e.bindBuffer(e.ARRAY_BUFFER,n.__webglSkinWeightsBuffer),e.bufferData(e.ARRAY_BUFFER,ea,C));w&&(delete n.__inittedArrays,delete n.__colorArray,delete n.__normalArray,delete n.__tangentArray,delete n.__uvArray,delete n.__uv2Array,delete n.__faceArray,delete n.__vertexArray,delete n.__lineArray,delete n.__skinVertexAArray,delete n.__skinVertexBArray,delete n.__skinIndexArray,delete n.__skinWeightArray)}j.__dirtyVertices=!1;j.__dirtyMorphTargets=
!1;j.__dirtyElements=!1;j.__dirtyUvs=!1;j.__dirtyNormals=!1;j.__dirtyTangents=!1;j.__dirtyColors=!1;za(k)}else if(h instanceof THREE.Ribbon){j=h.geometry;if(j.__dirtyVertices||j.__dirtyColors){h=j;k=e.DYNAMIC_DRAW;m=B=w=w=void 0;u=h.vertices;p=h.colors;r=u.length;n=p.length;q=h.__vertexArray;C=h.__colorArray;v=h.__dirtyColors;if(h.__dirtyVertices){for(w=0;w<r;w++)B=u[w].position,m=w*3,q[m]=B.x,q[m+1]=B.y,q[m+2]=B.z;e.bindBuffer(e.ARRAY_BUFFER,h.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,q,k)}if(v){for(w=
0;w<n;w++)color=p[w],m=w*3,C[m]=color.r,C[m+1]=color.g,C[m+2]=color.b;e.bindBuffer(e.ARRAY_BUFFER,h.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,C,k)}}j.__dirtyVertices=!1;j.__dirtyColors=!1}else if(h instanceof THREE.Line){j=h.geometry;if(j.__dirtyVertices||j.__dirtyColors){h=j;k=e.DYNAMIC_DRAW;m=B=w=w=void 0;u=h.vertices;p=h.colors;r=u.length;n=p.length;q=h.__vertexArray;C=h.__colorArray;v=h.__dirtyColors;if(h.__dirtyVertices){for(w=0;w<r;w++)B=u[w].position,m=w*3,q[m]=B.x,q[m+1]=B.y,q[m+2]=
B.z;e.bindBuffer(e.ARRAY_BUFFER,h.__webglVertexBuffer);e.bufferData(e.ARRAY_BUFFER,q,k)}if(v){for(w=0;w<n;w++)color=p[w],m=w*3,C[m]=color.r,C[m+1]=color.g,C[m+2]=color.b;e.bindBuffer(e.ARRAY_BUFFER,h.__webglColorBuffer);e.bufferData(e.ARRAY_BUFFER,C,k)}}j.__dirtyVertices=!1;j.__dirtyColors=!1}else if(h instanceof THREE.ParticleSystem)j=h.geometry,n=ya(j),(j.__dirtyVertices||j.__dirtyColors||h.sortParticles||n)&&c(j,e.DYNAMIC_DRAW,h),j.__dirtyVertices=!1,j.__dirtyColors=!1,za(j)};this.setFaceCulling=
function(b,c){b?(!c||c=="ccw"?e.frontFace(e.CCW):e.frontFace(e.CW),b=="back"?e.cullFace(e.BACK):b=="front"?e.cullFace(e.FRONT):e.cullFace(e.FRONT_AND_BACK),e.enable(e.CULL_FACE)):e.disable(e.CULL_FACE)};this.supportsVertexTextures=function(){return $a}};
THREE.WebGLRenderTarget=function(b,c,d){this.width=b;this.height=c;d=d||{};this.wrapS=d.wrapS!==void 0?d.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=d.wrapT!==void 0?d.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=d.magFilter!==void 0?d.magFilter:THREE.LinearFilter;this.minFilter=d.minFilter!==void 0?d.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=d.format!==void 0?d.format:THREE.RGBAFormat;this.type=d.type!==void 0?d.type:
THREE.UnsignedByteType;this.depthBuffer=d.depthBuffer!==void 0?d.depthBuffer:!0;this.stencilBuffer=d.stencilBuffer!==void 0?d.stencilBuffer:!0};
THREE.WebGLRenderTarget.prototype.clone=function(){var b=new THREE.WebGLRenderTarget(this.width,this.height);b.wrapS=this.wrapS;b.wrapT=this.wrapT;b.magFilter=this.magFilter;b.minFilter=this.minFilter;b.offset.copy(this.offset);b.repeat.copy(this.repeat);b.format=this.format;b.type=this.type;b.depthBuffer=this.depthBuffer;b.stencilBuffer=this.stencilBuffer;return b};THREE.WebGLRenderTargetCube=function(b,c,d){THREE.WebGLRenderTarget.call(this,b,c,d);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;
