/**
 * @author alteredq / http://alteredqualia.com/
 */

THREE.VignettePass = function (tDiffuse, opacity) {

	var shader = THREE.ShaderExtras[ "vignette" ];

	this.uniforms = THREE.UniformsUtils.clone( shader.uniforms );

	if (tDiffuse !== undefined) this.uniforms["tDiffuse"].value = tDiffuse;
	if (opacity !== undefined) this.uniforms["opacity"].value = opacity;


	this.material = new THREE.MeshShaderMaterial( {

		uniforms: this.uniforms,
		vertexShader: shader.vertexShader,
		fragmentShader: shader.fragmentShader

	} );

	this.renderToScreen = false;
	this.needsSwap = true;

};

THREE.VignettePass.prototype = {

	render: function ( renderer, writeBuffer, readBuffer, delta ) {

	    this.uniforms["tDiffuse"].texture = readBuffer;
		this.uniforms["opacity"].value.set(readBuffer.width, readBuffer.height);

		THREE.EffectComposer.quad.materials[ 0 ] = this.material;

		if ( this.renderToScreen ) {

			renderer.render( THREE.EffectComposer.scene, THREE.EffectComposer.camera );

		} else {

			renderer.render( THREE.EffectComposer.scene, THREE.EffectComposer.camera, writeBuffer, false );

		}

	}

};
