#version 150 compatibility
#extension GL_EXT_gpu_shader4 : enable

uniform mat4 View;

uniform sampler2D PosTex;
uniform sampler2D NormalTex;

uniform vec3 LightPos;
uniform vec4 LightColor;
uniform float LightRadius;

void main()
{
	ivec2 puv = ivec2(gl_FragCoord.xy);
	vec3 pos = texelFetch(PosTex, puv, 0).xyz;
	vec3 l = (View * vec4(LightPos, 1)).xyz - pos;
	float llen = length(l);
	if (pos.z >= 0.0 || llen > LightRadius) discard;
	vec3 normal = texelFetch(NormalTex, puv, 0).xyz;
	gl_FragData[0] = LightColor * max(-dot(normal, normalize(l)), 0.0)/* * (1.0 - max(llen / LightRadius, 0.0))*/;
}
