#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D Tex;
uniform float Time;
uniform float Distortion;
uniform float Flash;

varying vec2 TexCoord;

void main()
{
	vec2 skew = vec2(pow(sin(sin(TexCoord.y * 6.0 + Time * .4) * 6.0), 3.0) * .03, 0) * Distortion;
	vec4 tmp = texture2D(Tex, TexCoord + skew * .4);
	vec4 c = vec4(texture2D(Tex, TexCoord + skew).r, tmp.g, tmp.b, 1) - vec4(.1, .05, 0, 0); // Reduce r & g components (helps with the polaroid feel)

	ivec2 pixelCoord = ivec2(gl_FragCoord.xy);
	if (((pixelCoord.x | pixelCoord.y) & 3) == 0) c -= .2 * TexCoord.y; // Dots

	c.g -= .2 * abs(TexCoord.y - .5) * (.6 + .4 * TexCoord.x); // Gradient
	c -= pow(length(TexCoord - .5) * 1.7, 2.0) * .4; // Vignette

	gl_FragData[0] = c + Flash;
}
