#ifdef GL_ES
precision highp float;
#endif

uniform float beat;
uniform float time;
uniform sampler2D tex0;


void main(void)
{
	float distortion = sin(time)*beat*0.005;
    
	vec2 p = gl_TexCoord[0].xy ;
	
	p.x = p.x+sin(p.y*time*0.15411113+sin(p.y*time*1.1925))*abs(sin(time*0.911231312)*12.0)*0.01411131*beat*0.1;
	p.y = p.y+sin(time)*beat*0.0125;

	if (p.x<0.0) p.x = 0.0;
	if (p.x>1.0) p.x = 1.0;

	vec2 r = vec2(p.x+distortion,p.y-distortion);
	vec2 g = vec2(p.x-distortion,p.y+distortion);
	vec2 b = vec2(p.x+distortion,p.y);

    vec3 col =  vec3(texture2D(tex0,r).x, texture2D(tex0,g).y, texture2D(tex0,b).z);
	gl_FragColor = vec4(col,1.0);
}
