// zoomblur taken from IQ's shadertoy webpage - http://www.iquilezles.org/apps/shadertoy/
#ifdef GL_ES
precision highp float;
#endif

uniform int idx;
uniform float time;
uniform float beat;
uniform sampler2D tex0;
uniform sampler2D tex1;

float fade(float t, float start, float end)
{
	if (t<start) return 0.0;
	if (t>end) return 1.0;
	return (t-start)/(end-start);
}
void distort(void)
{
	float distortion = sin(time)*beat*0.005;
    
	vec2 p = gl_TexCoord[0].xy ;
	
	p.x = p.x+sin(p.y*time*0.15411113+sin(p.y*time*1.1925))*abs(sin(time*0.911231312)*12.0)*0.01411131*beat;
	p.y = p.y+sin(time)*beat*0.1;

	if (p.x<0.0) p.x = 0.0;
	if (p.x>1.0) p.x = 1.0;

	vec2 r = vec2(p.x+distortion,p.y-distortion);
	vec2 g = vec2(p.x-distortion,p.y+distortion);
	vec2 b = vec2(p.x+distortion,p.y);

    vec3 col =  vec3(texture2D(tex0,r).x, texture2D(tex0,g).x, texture2D(tex0,b).x);
	gl_FragColor = vec4(col,1.0);
}

void bloom(float start, float end)
{
	vec2 p = gl_TexCoord[0].xy ;
	vec3 col = vec3(texture2D(tex0, p));
	col = vec3(col.r,col.r,col.r)+col*col*col*col*beat;
	gl_FragColor = vec4(col,1.0)*fade(time, start, end);
}


void emboss(float start, float end)
{
	float d = 0.01;
	vec2 p = gl_TexCoord[0].xy ;
	vec3 col0 = vec3(texture2D(tex0, p));

	p.x += d;
	vec3 col1 = vec3(texture2D(tex0, p));

	p.x -= 2.0*d;
	vec3 col2 = vec3(texture2D(tex0, p));

	p.x += d;
	p.y += d;
	vec3 col3 = vec3(texture2D(tex0, p));

	p.y -= 2.0*d;
	vec3 col4 = vec3(texture2D(tex0, p));

	vec3 colwhite = vec3(1,1,1);

	vec3 col = 2.0*(((col1-col2)+(col3-col4))/1.0);
	gl_FragColor = (vec4(col,1.0)*beat+vec4(col0.r,col0.r,col0.r, 1.0))*fade(time, start, end);
}

void grayscale(float start, float end)
{
	
	vec2 p = gl_TexCoord[0].xy ;
	vec3 col = vec3(texture2D(tex0, p));
	float gs = 0.0;
	float idx = beat*3.0;

//	gl_FragColor = min(idx,1.0)*vec4(col,1.0);
	gs += min(idx,1.0)*col.r;
	//col = col*0.0;
	gl_FragColor = (vec4(col,1.0)*gs+vec4(gs,gs,gs,1.0))*fade(time, start, end);
	
}
vec3 zoomblur_deform( in vec2 p )
{
    vec2 uv;

    vec2 q = vec2( sin(5.1*time+p.x),sin(5.2*time+p.y) );

    float a = atan(q.y,q.x);
    float r = sqrt(dot(q,q));

    uv.x = 1.0+p.x*sqrt(r*r+1.0);
    uv.y = 1.0+p.y*sqrt(r*r+1.0);

	return texture2D(tex0,uv*.5).xyz;
}

void zoomblur(float start, float end)
{
    //vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / vec2(640,480);
	vec3 col = vec3(texture2D(tex0, gl_TexCoord[0].xy));
    vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy ;
	vec2 s = p;

    vec3 total = vec3(0.0);
    vec2 d = (vec2(0.0,0.0)-p)/40.0;
    float w = 1.0;
    for( int i=0; i<40; i++ )
    {
        vec3 res = zoomblur_deform(s);
        res = smoothstep(0.1,1.0,res*res);
        total += w*res;
        w *= .99;
        s += d;
    }
    total /= 40.0;
    float r = 1.5/(1.0+dot(p,p));
//    gl_FragColor = texture2D(tex0,gl_TexCoord[0].xy)+vec4( total*r,1.0);
    gl_FragColor = (vec4( total*r,1.0)+vec4(col.r,col.r,col.r,1.0))*fade(time, start, end);
}
/*
vec3 zoomblur_deform( in vec2 p )
{
    vec2 uv;

    vec2 q = vec2( 0.0,0.0);//sin(1.1*time+p.x),sin(1.2*time+p.y) );

    float a = atan(q.y,q.x);
    float r = sqrt(dot(q,q));

    uv.x = sin(0.0+1.0*time)+p.x*sqrt(r*r+1.0);
    uv.y = sin(0.6+1.1*time)+p.y*sqrt(r*r+1.0);

    return texture2D(tex0,uv*.5).xyz;
}

void zoomblur(float start, float end)
{
	vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy;
	vec3 col = vec3(texture2D(tex0, gl_TexCoord[0].xy));
//    vec2 p = -1.0 + 2.0 * gl_FragCoord.xy;
    vec2 s = p;

    vec3 total = vec3(0.0);
    vec2 d = (vec2(0.0,0.0)-p)/40.0;
    float w = 1.0;
    for( float i=0.0; i<5.0+35.0*beat; i++ )
    {
        vec3 res = zoomblur_deform(s);
        res = smoothstep(0.1,1.0,res*res);
        total += w*res;
        w *= .99;
        s += d;
    }
	total /= 40.0;
    float r = 1.5/(1.0+dot(p,p));
    gl_FragColor = (vec4( total*r,1.0)+vec4(col.r,col.r,col.r,1.0))*fade(time, start, end);
}
*/


void zi(void)
{
		vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy;
    //vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;
    vec2 uv;

    float a = atan(p.y,p.x);
    float r = sqrt(dot(p,p));

    uv.x = cos(0.6+time) + cos(cos(1.2+time)+a)/r;
    uv.y = cos(0.3+time) + sin(cos(2.0+time)+a)/r;

    vec3 col =  texture2D(tex0,uv*.25).xyz;

    gl_FragColor = vec4(col*r*r,1.0);
}



void warp(void)
{
		vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy;
   	vec2 m = vec2(-1.0,0.0);

    float a1 = atan(p.y-m.y,p.x-m.x);
    float r1 = sqrt(dot(p-m,p-m));
    float a2 = atan(p.y+m.y,p.x+m.x);
    float r2 = sqrt(dot(p+m,p+m));

    vec2 uv;
    uv.x = -0.5+(r1-r2)*0.25;
    uv.y = -0.5+sin(2.0*(a1-a2))/4.0;

    float w = r1*r2*0.8;
    vec3 col = texture2D(tex0,uv).xyz;

		float s = fade(time, 50.0, 54.0);

		col = vec3(col.r,col.r,col.r)*(1.0-beat)+beat*vec3(col.b,col.b,col.b);

    gl_FragColor = vec4(s*(col/(.1+w)),1.0);
}

void main(void)
{
	if (time<30.0) bloom(0.0,4.0);
	else if (time<50.0) grayscale(30.0,45.0);
	else if (time<82.0) warp(); 
	else if (time<110.0) emboss(82.0,86.0);
	else if (time<150.0) zoomblur(110.0,114.0);
	else if (time<180.0) grayscale(150.0,154.0);
	else if (time<200.0) zoomblur(180.0,184.0);
	else grayscale(200.0,204.0);
}

/*
void main(void)
{
	vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy;

	float movement = sin(time);
	vec2 uv;
    uv.y = 0.5*time + 0.5/abs(p.y);
    uv.x = 0.5*p.x/(p.y)+sin(time+uv.y*1.75);

	float light = p.y*p.y*2.0;
	vec4 col = texture2D(tex0,uv);

    gl_FragColor = vec4(col.xyz * light, 1.0);
}*/
