#ifdef GL_ES
precision highp float;
#endif

uniform vec2 resolution;
uniform vec2 pos;
uniform float intensity;
uniform float time;
uniform sampler2D tex0;
uniform sampler2D tex1;

vec4 data(vec2 p)
{
	vec2 uv;
    	uv.y = 0.5*time + 0.5/abs(p.y);
    	uv.x = 0.5*p.x/(p.y)+sin(time+uv.y*1.75);

	float light = p.y*p.y*2.0;
	vec4 col = texture2D(tex0,uv)*light;
	return col;
}

void main(void)
{
	float gap=0.01;
	vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy;
	float l = ( 			+data(vec2(p.x+gap,p.y))
 			+data(vec2(p.x-gap,p.y))
 			+data(vec2(p.x,p.y+gap))
 			+data(vec2(p.x,p.y-gap))).r/20.0;
	gl_FragColor =  data(p)+vec4(l,l,l,l);
/*
	vec2 p = -1.0 + 2.0 * gl_TexCoord[0].xy;

	float movement = sin(time);
	vec2 uv;
    uv.y = 0.5*time + 0.5/abs(p.y);
    uv.x = 0.5*p.x/(p.y)+sin(time+uv.y*1.75);

	float light = p.y*p.y*2.0;
	vec4 col = texture2D(tex0,uv);

    gl_FragColor = vec4(col.xyz * light, 1.0);
*/
}
