DECLARE SUB vesasetpage (pag%)
DECLARE SUB copyattributes (sour%, dest%)
DECLARE SUB printstr (xpos%, ypos%, col%, z$)
DECLARE SUB vlin (start&, startpag%, leng%, col%)
DECLARE SUB hlin (start&, leng%, col%)
DECLARE SUB fillscreen (startpag%, col%)
DECLARE SUB drawline (x0%, y0%, x1%, y1%, col%)
DECLARE SUB vline2 (x&, ydim&, segtemp&, offtemp&, stp%, shadeoffs%)

'History:
'11/18/1993 05:33PM EDITBORD.BAS  <- Original end of development
'04/07/1999 10:43PM EDITBO99.BAS  <- Replaced most TSENG code with VESA
'01/26/2005 02:58AM EDITBO05.BAS  <- Replaced all incompatible VESA code

COMMON SHARED yclip%
maxlines% = 2048
maxwalls% = 4096
version$ = "Editbord V1.01 11/13/93"
DIM picture%(9, 9), picture2%(9, 9), picture3%(9, 9)
DIM SHARED regs%(7)
regs%(0) = 0: CALL int86old(&H33, regs%(), regs%())
numlines% = 0
DIM SHARED x1%(maxlines%), y1%(maxlines%), x2%(maxlines%), y2%(maxlines%)
DIM SHARED picnum%(3, maxlines%), shade%(3, maxlines%), heinum%(3, maxlines%)
DIM SHARED z1%(maxlines%), z2%(maxlines%), cstat%(maxlines%), zosc%(maxlines%)
DIM SHARED repeat%(maxlines%)
DIM tempbuf%(4096)
DIM cl%(16, 3), walsiz%(maxwalls%), waloffs&(maxwalls%)
DIM SHARED pow2&(16)
pow2&(0) = 1: pow2&(1) = 2: pow2&(2) = 4: pow2&(3) = 8
pow2&(4) = 16: pow2&(5) = 32: pow2&(6) = 64: pow2&(7) = 128
pow2&(8) = 256: pow2&(9) = 512: pow2&(10) = 1024: pow2&(11) = 2048
pow2&(12) = 4096: pow2&(13) = 8192: pow2&(14) = 16384: pow2&(15) = 32768
picsbuf$ = STRING$(16384, 0)
DIM SHARED fontbuf%(128 - 1, 8 - 1)

scrx% = 0: scry% = 0
zoom1& = 128: zoom2& = 4

IF COMMAND$ <> "" THEN
   fil$ = COMMAND$
   IF INSTR(fil$, ".") = 0 THEN fil$ = fil$ + ".dat"
ELSE
   fil$ = "kboards.dat"
END IF
OPEN "pics.dat" FOR BINARY AS #2
buf$ = STRING$(maxwalls%, 0): GET #2, , buf$
FOR z% = 0 TO maxwalls% - 1
   walsiz%(z%) = ASC(MID$(buf$, z% + 1, 1))
NEXT z%
totsiz& = maxwalls% * 2 + 1
FOR z% = 0 TO maxwalls% - 1
   waloffs&(z%) = totsiz&
   IF walsiz%(z%) > 0 THEN totsiz& = totsiz& + pow2&((walsiz%(z%) AND 15) + (walsiz%(z%) \ 16))
NEXT z%

   '01/26/2006: Fix: int 0x10 font routines don't work in VESA
IF walsiz%(85) THEN
   GET #2, waloffs&(85), picsbuf$
   DEF SEG = VARSEG(picsbuf$): offs& = SADD(picsbuf$)
   FOR i% = 0 TO 127
      x% = (i% AND 15) * 8: y% = (i% \ 16) * 8
      FOR xx% = 0 TO 7: fontbuf%(i%, xx%) = 0: NEXT xx%
      FOR yy% = 0 TO 7
         FOR xx% = 0 TO 7
            IF PEEK(offs& + (x% + xx%) * 64 + y% + yy%) < 128 THEN
               fontbuf%(i%, xx%) = fontbuf%(i%, xx%) + pow2&(yy%)
            END IF
         NEXT xx%
      NEXT yy%
   NEXT i%
END IF

shownpic% = -1: obstatus% = -1
lastxsmoosh% = -1: lastysmoosh% = -1
ozosc% = -1
picnum%(0, maxlines%) = 0: picnum%(1, maxlines%) = 0: picnum%(2, maxlines%) = 0
shade%(0, maxlines%) = 0: shade%(1, maxlines%) = 0: shade%(2, maxlines%) = 0

z1%(maxlines%) = 128: z2%(maxlines%) = 192: cstat%(maxlines%) = 3: zosc%(maxlines%) = 0: repeat%(maxlines%) = 1
order% = 0
GOSUB loadboards
GOSUB setupscreen
oldx% = -1: oldy% = -1: ang% = 1536
zzn% = -1
GOSUB backupcursor
x% = x% + scrx%: y% = y% + scry%
GOSUB gethighlight
x% = x% - scrx%: y% = y% - scry%
DO
   DEF SEG = &HA000
   FOR zzxx% = y% - 4 TO y% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x% - 4 TO x% + 4
         IF z% = x% OR zzxx% = y% THEN
            addr& = (zzxx% AND 63) * 1024& + z%
            picture%(z% - (x% - 4), zzxx% - (y% - 4)) = PEEK(addr&)
            POKE (addr&), 31
         END IF
      NEXT z%
   NEXT zzxx%

   x% = x% + scrx%: y% = y% + scry%
   GOSUB gethighlight
   x% = x% - scrx%: y% = y% - scry%
  
   IF y% < 576 THEN
      yclip% = 576
      IF (cstat%(zzn%) AND 15) <> 0 THEN
         CALL drawline(x1%(zzn%) - scrx%, y1%(zzn%) - scry%, x2%(zzn%) - scrx%, y2%(zzn%) - scry%, 159)
        
         CALL drawline(x2%(zzn%) - scrx% - 1, y2%(zzn%) - scry% - 4, x2%(zzn%) - scrx% + 1, y2%(zzn%) - scry% - 4, 90)
         CALL drawline(x2%(zzn%) - scrx% - 2, y2%(zzn%) - scry% - 3, x2%(zzn%) - scrx% + 2, y2%(zzn%) - scry% - 3, 91)
         CALL drawline(x2%(zzn%) - scrx% - 3, y2%(zzn%) - scry% - 2, x2%(zzn%) - scrx% + 3, y2%(zzn%) - scry% - 2, 92)
         CALL drawline(x2%(zzn%) - scrx% - 4, y2%(zzn%) - scry% - 1, x2%(zzn%) - scrx% + 4, y2%(zzn%) - scry% - 1, 93)
         CALL drawline(x2%(zzn%) - scrx% - 4, y2%(zzn%) - scry% + 0, x2%(zzn%) - scrx% + 4, y2%(zzn%) - scry% + 0, 94)
         CALL drawline(x2%(zzn%) - scrx% - 4, y2%(zzn%) - scry% + 1, x2%(zzn%) - scrx% + 4, y2%(zzn%) - scry% + 1, 93)
         CALL drawline(x2%(zzn%) - scrx% - 3, y2%(zzn%) - scry% + 2, x2%(zzn%) - scrx% + 3, y2%(zzn%) - scry% + 2, 92)
         CALL drawline(x2%(zzn%) - scrx% - 2, y2%(zzn%) - scry% + 3, x2%(zzn%) - scrx% + 2, y2%(zzn%) - scry% + 3, 91)
         CALL drawline(x2%(zzn%) - scrx% - 1, y2%(zzn%) - scry% + 4, x2%(zzn%) - scrx% + 1, y2%(zzn%) - scry% + 4, 90)
      END IF

      CALL drawline(x1%(zzn%) - scrx% - 1, y1%(zzn%) - scry% - 4, x1%(zzn%) - scrx% + 1, y1%(zzn%) - scry% - 4, 31)
      CALL drawline(x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% - 3, x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% - 3, 31)
      CALL drawline(x1%(zzn%) - scrx% - 3, y1%(zzn%) - scry% - 2, x1%(zzn%) - scrx% + 3, y1%(zzn%) - scry% - 2, 31)
      CALL drawline(x1%(zzn%) - scrx% - 4, y1%(zzn%) - scry% - 1, x1%(zzn%) - scrx% + 4, y1%(zzn%) - scry% - 1, 31)
      CALL drawline(x1%(zzn%) - scrx% - 4, y1%(zzn%) - scry% + 0, x1%(zzn%) - scrx% + 4, y1%(zzn%) - scry% + 0, 31)
      CALL drawline(x1%(zzn%) - scrx% - 4, y1%(zzn%) - scry% + 1, x1%(zzn%) - scrx% + 4, y1%(zzn%) - scry% + 1, 31)
      CALL drawline(x1%(zzn%) - scrx% - 3, y1%(zzn%) - scry% + 2, x1%(zzn%) - scrx% + 3, y1%(zzn%) - scry% + 2, 31)
      CALL drawline(x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% + 3, x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% + 3, 31)
      CALL drawline(x1%(zzn%) - scrx% - 1, y1%(zzn%) - scry% + 4, x1%(zzn%) - scrx% + 1, y1%(zzn%) - scry% + 4, 31)
   END IF
   DO
      z$ = INKEY$
      regs%(0) = 11: CALL int86old(&H33, regs%(), regs%())
      mousx% = regs%(2) \ 2
      mousy% = regs%(3) \ 2
      regs%(0) = 5: CALL int86old(&H33, regs%(), regs%())
      obstatus% = bstatus%: bstatus% = regs%(0)
   LOOP WHILE z$ = "" AND mousx% = 0 AND mousy% = 0 AND obstatus% = bstatus%
  
   DEF SEG = &HA000
   FOR zzxx% = y% - 4 TO y% + 4
      CALL vesasetpage(zzxx% \ 64)
      FOR z% = x% - 4 TO x% + 4
         IF z% = x% OR zzxx% = y% THEN
            POKE ((zzxx% AND 63) * 1024& + z%), picture%(z% - (x% - 4), zzxx% - (y% - 4))
         END IF
      NEXT z%
   NEXT zzxx%
  
   IF (mousx% OR mousy%) <> 0 THEN
      x% = x% + mousx%
      y% = y% + mousy%
      IF x% < 4 THEN x% = 4
      IF y% < 4 THEN y% = 4
      IF x% >= xres% - 4 THEN x% = xres% - 5
      IF y% >= yres% - 4 THEN y% = yres% - 5
   END IF
   DEF SEG = 0
   IF (PEEK(&H417) AND 1) > 0 THEN
      IF z$ = CHR$(0) + CHR$(75) AND x% > 4 THEN x% = x% - 1
      IF z$ = CHR$(0) + CHR$(77) AND x% < xres% - 5 THEN x% = x% + 1
      IF z$ = CHR$(0) + CHR$(72) AND y% > 4 THEN y% = y% - 1
      IF z$ = CHR$(0) + CHR$(80) AND y% < yres% - 5 THEN y% = y% + 1
   END IF
   IF (PEEK(&H417) AND 3) = 0 THEN
      IF z$ = CHR$(0) + CHR$(75) AND x% > 11 THEN x% = (x% - 8) AND &HFFF8
      IF z$ = CHR$(0) + CHR$(77) AND x% < xres% - 12 THEN x% = (x% + 8) AND &HFFF8
      IF z$ = CHR$(0) + CHR$(72) AND y% > 11 THEN y% = (y% - 8) AND &HFFF8
      IF z$ = CHR$(0) + CHR$(80) AND y% < yres% - 12 THEN y% = (y% + 8) AND &HFFF8
   END IF
   IF z$ = CHR$(0) + CHR$(71) THEN order% = 0: SOUND 523, 1
   IF z$ = CHR$(0) + CHR$(79) THEN order% = 1: SOUND 523, 1
  
   x% = x% + scrx%: y% = y% + scry%
   GOSUB gethighlight
   x% = x% - scrx%: y% = y% - scry%

   DEF SEG = 0
   IF z$ = CHR$(0) + CHR$(115) OR (z$ = CHR$(0) + CHR$(75) AND (PEEK(&H417) AND 2) > 0) THEN
      scrx% = scrx% - 64
      IF z$ = CHR$(0) + CHR$(115) THEN scrx% = scrx% - 192
      IF scrx% < 0 THEN scrx% = 0
      GOSUB drawboard
   END IF
   DEF SEG = 0
   IF z$ = CHR$(0) + CHR$(116) OR (z$ = CHR$(0) + CHR$(77) AND (PEEK(&H417) AND 2) > 0) THEN
      scrx% = scrx% + 64
      IF z$ = CHR$(0) + CHR$(116) THEN scrx% = scrx% + 192
      IF scrx% >= 32 * 32 THEN scrx% = 32 * 32
      GOSUB drawboard
   END IF
   DEF SEG = 0
   IF z$ = CHR$(0) + CHR$(73) OR (z$ = CHR$(0) + CHR$(72) AND (PEEK(&H417) AND 2) > 0) THEN
      scry% = scry% - 64
      IF z$ = CHR$(0) + CHR$(73) THEN scry% = scry% - 192
      IF scry% < 0 THEN scry% = 0
      GOSUB drawboard
   END IF
   DEF SEG = 0
   IF z$ = CHR$(0) + CHR$(81) OR (z$ = CHR$(0) + CHR$(80) AND (PEEK(&H417) AND 2) > 0) THEN
      scry% = scry% + 64
      IF z$ = CHR$(0) + CHR$(81) THEN scry% = scry% + 192
      IF scry% >= 46 * 32 THEN scry% = 46 * 32
      GOSUB drawboard
   END IF
   IF z$ = "V" OR z$ = "v" THEN
      GOSUB drawhiresboard
      zzn% = -1
      x% = x% + scrx%: y% = y% + scry%
      GOSUB gethighlight
      x% = x% - scrx%: y% = y% - scry%
   END IF
   IF z$ <> "" THEN
      IF ASC(z$) >= 49 AND ASC(z$) <= 57 THEN
         x% = x% + scrx%: y% = y% + scry%
         GOSUB gethighlight
         IF y% > 576 THEN
            repeat%(maxlines%) = (repeat%(maxlines%) AND 240) + (ASC(z$) - 48): SOUND 110 * (2 ^ ((ASC(z$) - 48) / 12)), 1
            GOSUB showattributes
         ELSE
            repeat%(zzn%) = (repeat%(zzn%) AND 240) + (ASC(z$) - 48): SOUND 110 * (2 ^ ((ASC(z$) - 48) / 12)), 1
          END IF
         x% = x% - scrx%: y% = y% - scry%
      END IF
   END IF
   IF y% < 576 THEN
      IF z$ = "\" THEN posx% = x% + scrx%: posy% = y% + scry%
      IF (z$ = CHR$(9) OR (bstatus% AND 2) > (obstatus% AND 2)) THEN
         IF numlines% > 0 THEN
            x% = x% + scrx%: y% = y% + scry%
            GOSUB gethighlight
            CALL copyattributes(zzn%, maxlines%)
            shownpic% = -1
            x% = x% - scrx%: y% = y% - scry%
         END IF
         GOSUB updateattributes
      END IF
      IF (z$ = "C" OR z$ = "c") AND numlines% > 0 THEN
         x% = x% + scrx%: y% = y% + scry%
         GOSUB gethighlight
         lintouch1% = -1
         lintouch2% = -1
         FOR z% = 0 TO numlines% - 1
            IF (x1%(zzn%) = x1%(z%) AND y1%(zzn%) = y1%(z%) AND x2%(zzn%) = x2%(z%) AND y2%(zzn%) = y2%(z%)) OR (x1%(zzn%) = x2%(z%) AND y1%(zzn%) = y2%(z%) AND x2%(zzn%) = x1%(z%) AND y2%(zzn%) = y1%(z%)) THEN
               IF z% <> zzn% THEN
                  CALL copyattributes(numlines% - 1, z%)
                  IF zzn% = numlines% - 1 THEN zzn% = z%
                  numlines% = numlines% - 1
                  CALL printstr(100, 76, 31, "Numlines = " + STR$(numlines%) + " ")
               END IF
            ELSE
               IF x1%(zzn%) = x2%(z%) AND y1%(zzn%) = y2%(z%) THEN lintouch1% = z%
               IF x1%(zzn%) = x1%(z%) AND y1%(zzn%) = y1%(z%) THEN lintouch2% = z%
            END IF
         NEXT z%
         IF lintouch1% = -1 OR lintouch2% = -1 THEN
            SOUND 37, 1
         ELSE
            firstone% = 0
            IF z1%(lintouch1%) <> z1%(lintouch2%) OR picnum%(1, lintouch1%) <> picnum%(1, lintouch2%) OR heinum%(1, lintouch1%) <> heinum%(1, lintouch2%) OR shade%(1, lintouch1%) <> shade%(1, lintouch2%) THEN
               firstone% = 1
               IF z1%(lintouch1%) <= z1%(lintouch2%) THEN
                  z1%(zzn%) = z1%(lintouch1%)
                  z2%(zzn%) = z1%(lintouch2%)
                  picnum%(0, zzn%) = picnum%(0, lintouch1%)
                  picnum%(1, zzn%) = picnum%(1, lintouch1%)
                  picnum%(2, zzn%) = picnum%(1, lintouch2%)
                  heinum%(1, zzn%) = heinum%(1, lintouch1%)
                  heinum%(2, zzn%) = heinum%(1, lintouch2%)
                  shade%(0, zzn%) = shade%(0, lintouch1%)
                  shade%(1, zzn%) = shade%(1, lintouch1%)
                  shade%(2, zzn%) = shade%(1, lintouch2%)
                  cstat%(zzn%) = (cstat%(lintouch1%) AND 240) + 9
                  zosc%(zzn%) = zosc%(lintouch1%)
               ELSE
                  SWAP x1%(zzn%), x2%(zzn%)
                  SWAP y1%(zzn%), y2%(zzn%)
                  z1%(zzn%) = z1%(lintouch2%)
                  z2%(zzn%) = z1%(lintouch1%)
                  picnum%(0, zzn%) = picnum%(0, lintouch2%)
                  picnum%(1, zzn%) = picnum%(1, lintouch2%)
                  picnum%(2, zzn%) = picnum%(1, lintouch1%)
                  heinum%(1, zzn%) = heinum%(1, lintouch2%)
                  heinum%(2, zzn%) = heinum%(1, lintouch1%)
                  shade%(0, zzn%) = shade%(0, lintouch2%)
                  shade%(1, zzn%) = shade%(1, lintouch2%)
                  shade%(2, zzn%) = shade%(1, lintouch1%)
                  cstat%(zzn%) = (cstat%(lintouch2%) AND 240) + 9
                  zosc%(zzn%) = zosc%(lintouch2%)
               END IF
               xlen& = x1%(zzn%) - x2%(zzn%)
               ylen& = y1%(zzn%) - y2%(zzn%)
               junk% = pow2&(walsiz%(picnum%(0, zzn%)) AND 15)
               repeat%(zzn%) = (repeat%(zzn%) AND 240) + CINT((SQR(xlen& * xlen& + ylen& * ylen&) * 2) / junk%)
               IF (repeat%(zzn%) AND 15) = 0 THEN repeat%(zzn%) = (repeat%(zzn%) AND 240) + 1
               SOUND 523, 1
            END IF
            IF z2%(lintouch1%) <> z2%(lintouch2%) OR picnum%(2, lintouch1%) <> picnum%(2, lintouch2%) OR shade%(2, lintouch1%) <> shade%(2, lintouch2%) THEN
               IF firstone% = 1 THEN
                  x1%(numlines%) = x1%(zzn%)
                  y1%(numlines%) = y1%(zzn%)
                  x2%(numlines%) = x2%(zzn%)
                  y2%(numlines%) = y2%(zzn%)
                  zzn% = numlines%
                  numlines% = numlines% + 1
                  CALL printstr(100, 76, 31, "Numlines = " + STR$(numlines%) + " /" + STR$(maxlines%) + " ")
                  IF numlines% > maxlines% - 16 THEN SOUND 131, 1
               END IF
               IF z2%(lintouch1%) >= z2%(lintouch2%) THEN
                  z1%(zzn%) = z2%(lintouch2%)
                  z2%(zzn%) = z2%(lintouch1%)
                  picnum%(0, zzn%) = picnum%(0, lintouch1%)
                  picnum%(1, zzn%) = picnum%(2, lintouch2%)
                  picnum%(2, zzn%) = picnum%(2, lintouch1%)
                  heinum%(1, zzn%) = heinum%(2, lintouch2%)
                  heinum%(2, zzn%) = heinum%(2, lintouch1%)
                  shade%(0, zzn%) = shade%(0, lintouch1%)
                  shade%(1, zzn%) = shade%(2, lintouch2%)
                  shade%(2, zzn%) = shade%(2, lintouch1%)
                  cstat%(zzn%) = (cstat%(lintouch1%) AND 240) + 6
                  zosc%(zzn%) = zosc%(lintouch1%)
               ELSE
                  SWAP x1%(zzn%), x2%(zzn%)
                  SWAP y1%(zzn%), y2%(zzn%)
                  z1%(zzn%) = z2%(lintouch1%)
                  z2%(zzn%) = z2%(lintouch2%)
                  picnum%(0, zzn%) = picnum%(0, lintouch2%)
                  picnum%(1, zzn%) = picnum%(2, lintouch1%)
                  picnum%(2, zzn%) = picnum%(2, lintouch2%)
                  heinum%(1, zzn%) = heinum%(2, lintouch1%)
                  heinum%(2, zzn%) = heinum%(2, lintouch2%)
                  shade%(0, zzn%) = shade%(0, lintouch2%)
                  shade%(1, zzn%) = shade%(2, lintouch1%)
                  shade%(2, zzn%) = shade%(2, lintouch2%)
                  cstat%(zzn%) = (cstat%(lintouch2%) AND 240) + 6
                  zosc%(zzn%) = zosc%(lintouch2%)
               END IF
               xlen& = x1%(zzn%) - x2%(zzn%)
               ylen& = y1%(zzn%) - y2%(zzn%)
               junk% = pow2&(walsiz%(picnum%(0, zzn%)) AND 15)
               repeat%(zzn%) = (repeat%(zzn%) AND 240) + CINT((SQR(xlen& * xlen& + ylen& * ylen&) * 2) / junk%)
               IF (repeat%(zzn%) AND 15) = 0 THEN repeat%(zzn%) = (repeat%(zzn%) AND 240) + 1
               SOUND 523, 1
            END IF
         END IF
         GOSUB drawboard
         x% = x% - scrx%: y% = y% - scry%
      END IF
      IF (z$ = "U" OR z$ = "u") AND numlines% > 0 THEN
         x% = x% + scrx%: y% = y% + scry%
         GOSUB gethighlight
         x1%(maxlines%) = x1%(zzn%)  'Don't copyattributes these by faking
         y1%(maxlines%) = y1%(zzn%)
         x2%(maxlines%) = x2%(zzn%)
         y2%(maxlines%) = y2%(zzn%)
         CALL copyattributes(maxlines%, zzn%)
         IF (cstat%(zzn%) AND 15) = 0 THEN
            CALL drawline(x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% - 2, x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% + 2, 31)
            CALL drawline(x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% - 2, x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% + 2, 31)
            CALL drawline(x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% - 1, x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% + 3, 31)
            CALL drawline(x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% - 1, x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% + 3, 31)
         ELSE
            CALL drawline(x1%(zzn%) - scrx%, y1%(zzn%) - scry%, x2%(zzn%) - scrx%, y2%(zzn%) - scry%, 31)
         END IF
     
         bad1% = 0: bad2% = 0
         FOR z% = 0 TO numlines% - 1
            IF (x1%(z%) = x1%(zzn%) AND y1%(z%) = y1%(zzn%)) OR (x1%(z%) = x2%(zzn%) AND y1%(z%) = y2%(zzn%)) OR (x2%(z%) = x1%(zzn%) AND y2%(z%) = y1%(zzn%)) OR (x2%(z%) = x2%(zzn%) AND y2%(z%) = y2%(zzn%)) THEN
               IF z1%(z%) = z1%(zzn%) AND (shade%(1, z%) <> shade%(1, zzn%) OR picnum%(1, z%) <> picnum%(1, zzn%) OR heinum%(1, z%) <> heinum%(1, zzn%)) THEN bad1% = z1%(zzn%) + 256
               IF z1%(z%) = z2%(zzn%) AND (shade%(1, z%) <> shade%(2, zzn%) OR picnum%(1, z%) <> picnum%(2, zzn%) OR heinum%(1, z%) <> heinum%(2, zzn%)) THEN bad2% = z2%(zzn%) + 256
               IF z2%(z%) = z1%(zzn%) AND (shade%(2, z%) <> shade%(1, zzn%) OR picnum%(2, z%) <> picnum%(1, zzn%) OR heinum%(2, z%) <> heinum%(1, zzn%)) THEN bad1% = z1%(zzn%) + 256
               IF z2%(z%) = z2%(zzn%) AND (shade%(2, z%) <> shade%(2, zzn%) OR picnum%(2, z%) <> picnum%(2, zzn%) OR heinum%(2, z%) <> heinum%(2, zzn%)) THEN bad2% = z2%(zzn%) + 256
            END IF
         NEXT z%
         IF bad1% > 0 OR bad2% > 0 THEN
            SOUND 523, 1
            CALL printstr(0, 0, 31, "Ceiling mismatch: Update area?")
            DO
               z$ = UCASE$(INKEY$)
            LOOP WHILE z$ <> "Y" AND z$ <> "N" AND z$ <> CHR$(13) AND z$ <> CHR$(27)
            IF z$ = CHR$(13) THEN z$ = "Y"
            IF z$ = CHR$(27) THEN z$ = "N"
            IF z$ = "Y" THEN
               FOR z% = 0 TO numlines% - 1
                  tempbuf%(z% + 2048) = 0
               NEXT z%
               tempbuf%(z% + 2048) = 1
               tempbuf%(0) = zzn%
               lcount% = 0
               lgoal% = 1
               WHILE lcount% < lgoal%
                  SOUND lcount% * 20 + 37, .1
                  zzn% = tempbuf%(lcount%)
                  CALL drawline(x1%(zzn%) - scrx%, y1%(zzn%) - scry%, x2%(zzn%) - scrx%, y2%(zzn%) - scry%, 15)
                  FOR z% = 0 TO numlines% - 1
                     IF z% <> zzn% THEN
                        IF (x1%(z%) = x1%(zzn%) AND y1%(z%) = y1%(zzn%)) OR (x1%(z%) = x2%(zzn%) AND y1%(z%) = y2%(zzn%)) OR (x2%(z%) = x1%(zzn%) AND y2%(z%) = y1%(zzn%)) OR (x2%(z%) = x2%(zzn%) AND y2%(z%) = y2%(zzn%)) THEN
                           IF z1%(z%) = bad1% - 256 OR z1%(z%) = bad2% - 256 THEN
                              IF z1%(z%) = z1%(zzn%) THEN
                                 IF shade%(1, z%) <> shade%(1, zzn%) OR picnum%(1, z%) <> picnum%(1, zzn%) OR heinum%(1, z%) <> heinum%(1, zzn%) THEN
                                    shade%(1, z%) = shade%(1, zzn%): picnum%(1, z%) = picnum%(1, zzn%): heinum%(1, z%) = heinum%(1, zzn%)
                                    IF tempbuf%(z% + 2048) = 0 THEN
                                       tempbuf%(z% + 2048) = 1
                                       tempbuf%(lgoal%) = z%: lgoal% = lgoal% + 1
                                    END IF
                                 END IF
                              END IF
                              IF z1%(z%) = z2%(zzn%) THEN
                                 IF shade%(1, z%) <> shade%(2, zzn%) OR picnum%(1, z%) <> picnum%(2, zzn%) OR heinum%(1, z%) <> heinum%(2, zzn%) THEN
                                    shade%(1, z%) = shade%(2, zzn%): picnum%(1, z%) = picnum%(2, zzn%): heinum%(1, z%) = heinum%(2, zzn%)
                                    IF tempbuf%(z% + 2048) = 0 THEN
                                       tempbuf%(z% + 2048) = 1
                                       tempbuf%(lgoal%) = z%: lgoal% = lgoal% + 1
                                    END IF
                                 END IF
                              END IF
                           END IF
                           IF z2%(z%) = bad1% - 256 OR z2%(z%) = bad2% - 256 THEN
                              IF z2%(z%) = z1%(zzn%) THEN
                                 IF shade%(2, z%) <> shade%(1, zzn%) OR picnum%(2, z%) <> picnum%(1, zzn%) OR heinum%(2, z%) <> heinum%(1, zzn%) THEN
                                    shade%(2, z%) = shade%(1, zzn%): picnum%(2, z%) = picnum%(1, zzn%): heinum%(2, z%) = heinum%(1, zzn%)
                                    IF tempbuf%(z% + 2048) = 0 THEN
                                       tempbuf%(z% + 2048) = 1
                                       tempbuf%(lgoal%) = z%: lgoal% = lgoal% + 1
                                    END IF
                                 END IF
                              END IF
                              IF z2%(z%) = z2%(zzn%) THEN
                                 IF shade%(2, z%) <> shade%(2, zzn%) OR picnum%(2, z%) <> picnum%(2, zzn%) OR heinum%(2, z%) <> heinum%(2, zzn%) THEN
                                    shade%(2, z%) = shade%(2, zzn%): picnum%(2, z%) = picnum%(2, zzn%): heinum%(2, z%) = heinum%(2, zzn%)
                                    IF tempbuf%(z% + 2048) = 0 THEN
                                       tempbuf%(z% + 2048) = 1
                                       tempbuf%(lgoal%) = z%: lgoal% = lgoal% + 1
                                    END IF
                                 END IF
                              END IF
                           END IF
                        END IF
                     END IF
                  NEXT z%
                  lcount% = lcount% + 1
               WEND
            END IF
         END IF
         x% = x% - scrx%: y% = y% - scry%
         GOSUB drawboard
      END IF
      IF (z$ = " " OR (bstatus% AND 2) > (obstatus% AND 2)) THEN
         x% = x% + scrx%: y% = y% + scry%
         FOR z% = 0 TO numlines% - 1
            IF ABS(x% - x1%(z%)) + ABS(y% - y1%(z%)) < 5 THEN x% = x1%(z%): y% = y1%(z%)
            IF ABS(x% - x2%(z%)) + ABS(y% - y2%(z%)) < 5 THEN x% = x2%(z%): y% = y2%(z%)
         NEXT z%
         IF ((x% + 2) AND 31) <= 4 THEN x% = (x% + 16) AND &HFFE0
         IF ((y% + 2) AND 31) <= 4 THEN y% = (y% + 16) AND &HFFE0
         oldx% = x%: oldy% = y%
         x% = x% - scrx%: y% = y% - scry%
      END IF
      IF z$ = CHR$(0) + CHR$(83) AND numlines% > 0 THEN
         x% = x% + scrx%: y% = y% + scry%
         GOSUB gethighlight
         CALL copyattributes(numlines% - 1, zzn%)
         numlines% = numlines% - 1
         CALL printstr(100, 76, 31, "Numlines = " + STR$(numlines%) + " ")
         GOSUB drawboard
         x% = x% - scrx%: y% = y% - scry%
      END IF
      IF z$ = "F" OR z$ = "f" THEN
         x% = x% + scrx%: y% = y% + scry%
         GOSUB gethighlight
         SWAP x1%(zzn%), x2%(zzn%)
         SWAP y1%(zzn%), y2%(zzn%)
         SOUND 131, 1
         x% = x% - scrx%: y% = y% - scry%
      END IF
      IF (z$ = CHR$(13) OR (bstatus% AND 1) > (obstatus% AND 1)) THEN
         IF numlines% >= maxlines% - 1 OR (oldx% = x% + scrx% AND oldy% = y% + scry%) THEN
            SOUND 40, 1
         ELSE
            x% = x% + scrx%: y% = y% + scry%
            FOR z% = 0 TO numlines% - 1
               IF ABS(x% - x1%(z%)) + ABS(y% - y1%(z%)) < 5 THEN x% = x1%(z%): y% = y1%(z%)
               IF ABS(x% - x2%(z%)) + ABS(y% - y2%(z%)) < 5 THEN x% = x2%(z%): y% = y2%(z%)
            NEXT z%
            IF ((x% + 2) AND 31) <= 4 THEN x% = (x% + 16) AND &HFFE0
            IF ((y% + 2) AND 31) <= 4 THEN y% = (y% + 16) AND &HFFE0
            IF oldx% >= 0 AND oldy% >= 0 THEN
               CALL copyattributes(maxlines%, numlines%)
               x1%(numlines%) = oldx%
               y1%(numlines%) = oldy%
               x2%(numlines%) = x%
               y2%(numlines%) = y%
               xlen& = oldx% - x%
               ylen& = oldy% - y%
               junk% = pow2&(walsiz%(picnum%(0, maxlines%)) AND 15)
               repeat%(numlines%) = (repeat%(numlines%) AND 240) + CINT((SQR(xlen& * xlen& + ylen& * ylen&) * 2) / junk%)
               IF (repeat%(numlines%) AND 15) = 0 THEN repeat%(numlines%) = repeat%(numlines%) + 1
               CALL drawline(oldx% - scrx%, oldy% - scry%, x% - scrx%, y% - scry%, 31)
               numlines% = numlines% + 1
               CALL printstr(100, 76, 31, "Numlines = " + STR$(numlines%) + " ")
               IF numlines% > maxlines% - 16 THEN SOUND 131, 1
               oldx% = x%
               oldy% = y%
            END IF
            x% = x% - scrx%: y% = y% - scry%
         END IF
      END IF
      IF z$ = "0" THEN
         IF numlines% >= maxlines% - 1 THEN
            SOUND 40, 1
         ELSE
            x% = x% + scrx%: y% = y% + scry%
            x1%(numlines%) = x%
            y1%(numlines%) = y%
            x2%(numlines%) = x%
            y2%(numlines%) = y%
            picnum%(0, numlines%) = picnum%(0, maxlines%)
            picnum%(1, numlines%) = 0
            picnum%(2, numlines%) = 0
            heinum%(1, numlines%) = 0
            heinum%(2, numlines%) = 0
            shade%(0, numlines%) = shade%(0, maxlines%)
            shade%(1, numlines%) = 0
            shade%(2, numlines%) = 0
            z1%(numlines%) = z1%(maxlines%)
            z2%(numlines%) = z2%(maxlines%)
            cstat%(numlines%) = (cstat%(maxlines%) AND 240)
            zosc%(numlines%) = zosc%(maxlines%)
            repeat%(numlines%) = repeat%(maxlines%)
            CALL drawline(x% - scrx% - 2, y% - scry% - 2, x% - scrx% + 2, y% - scry% + 2, 31)
            CALL drawline(x% - scrx% + 2, y% - scry% - 2, x% - scrx% - 2, y% - scry% + 2, 31)
            CALL drawline(x% - scrx% - 2, y% - scry% - 1, x% - scrx% + 2, y% - scry% + 3, 31)
            CALL drawline(x% - scrx% + 2, y% - scry% - 1, x% - scrx% - 2, y% - scry% + 3, 31)
            numlines% = numlines% + 1
            CALL printstr(100, 76, 31, "Numlines = " + STR$(numlines%) + " ")
            IF numlines% > maxlines% - 16 THEN SOUND 131, 1
            x% = x% - scrx%: y% = y% - scry%
         END IF
      END IF
      IF z$ = "R" OR z$ = "r" THEN
         GOSUB saveboards
         CALL printstr(0, 0, 31, "Loading game at cursor...")
         SHELL "game " + fil$ + " " + STR$(x% + scrx%) + STR$(y% + scry%) + " > nul"
         GOSUB setupscreen
      END IF
   END IF
   IF y% >= 576 THEN
      IF x% >= 50 AND x% < 132 THEN
         IF (z$ = CHR$(9) OR (bstatus% AND 2) > (obstatus% AND 2)) THEN
            picone% = 0
            IF y% < 640 THEN picone% = 1
            IF y% > 704 THEN picone% = 2
           
            oldsha% = shade%(picone%, maxlines%)
            walnume& = picnum%(picone%, maxlines%)
            IF walsiz%(walnume&) <> 0 THEN
               GET #2, waloffs&(walnume&), picsbuf$
               xdim& = pow2&(walsiz%(walnume&) AND 15)
               ydim& = pow2&(walsiz%(walnume&) \ 16)
               DEF SEG = VARSEG(picsbuf$)
               p& = SADD(picsbuf$)
               darkestcol% = 31
               lightestcol% = 0
               FOR z% = 0 TO xdim& - 1
                  FOR zz% = 0 TO ydim& - 1
                     dat% = PEEK(p&)
                     IF (dat% AND 31) < darkestcol% THEN darkestcol% = (dat% AND 31)
                     IF (dat% AND 31) > lightestcol% THEN lightestcol% = (dat% AND 31)
                     p& = p& + 1
                  NEXT zz%
               NEXT z%
               FOR z% = 0 TO 8
                  CALL fillscreen(z%, 0)
               NEXT z%
               FOR z% = 0 TO 31
                  FOR zz% = 0 TO 7
                     walpos& = zz% * 32 + z%
                     shadeoffs% = zz% * 32 + z%
                     GOSUB showall
                  NEXT zz%
               NEXT z%
             
               DO
                  startp& = (shade%(picone%, maxlines%) AND 31) * 32&
                  IF (shade%(picone%, maxlines%) AND 32) > 0 THEN startp& = startp& + 32768
                  startpag% = ((shade%(picone%, maxlines%) \ 64) AND 7)
                  CALL vesasetpage(startpag%)
                  CALL hlin(startp&, 31, 31)
                  CALL hlin(startp& + 1024, 31, 31)
                  CALL hlin(startp& + 32768 - 1024, 31, 31)
                  CALL hlin(startp& + 32768 - 2048, 31, 31)
                  CALL vlin(startp&, startpag%, 31, 31)
                  CALL vlin(startp& + 1, startpag%, 31, 31)
                  CALL vlin(startp& + 30, startpag%, 31, 31)
                  CALL vlin(startp& + 31, startpag%, 31, 31)
               
                  DO
                     z$ = INKEY$
                     regs%(0) = 11: CALL int86old(&H33, regs%(), regs%())
                     mousx% = regs%(2) \ 2
                     mousy% = regs%(3) \ 2
                     regs%(0) = 5: CALL int86old(&H33, regs%(), regs%())
                     obstatus% = bstatus%: bstatus% = regs%(0)
                  LOOP WHILE z$ = "" AND mousx% = 0 AND mousy% = 0 AND obstatus% = bstatus%
                 
                  startp& = (shade%(picone%, maxlines%) AND 31) * 32&
                  IF (shade%(picone%, maxlines%) AND 32) > 0 THEN startp& = startp& + 32768
                  startpag% = ((shade%(picone%, maxlines%) \ 64) AND 7)
                  CALL vesasetpage(startpag%)
                  CALL hlin(startp&, 31, 0)
                  CALL hlin(startp& + 1024, 31, 0)
                  CALL hlin(startp& + 32768 - 1024, 31, 0)
                  CALL hlin(startp& + 32768 - 2048, 31, 0)
                  CALL vlin(startp&, startpag%, 31, 0)
                  CALL vlin(startp& + 1, startpag%, 31, 0)
                  CALL vlin(startp& + 30, startpag%, 31, 0)
                  CALL vlin(startp& + 31, startpag%, 31, 0)
                    
                  walnume& = picnum%(picone%, maxlines%)
                  walpos& = shade%(picone%, maxlines%)
                  shadeoffs% = shade%(picone%, maxlines%)
                  GOSUB showall
              
                  IF (z$ = CHR$(0) + CHR$(75) OR mousx% < 0) AND (shade%(picone%, maxlines%) AND 31) > 0 THEN shade%(picone%, maxlines%) = shade%(picone%, maxlines%) - 1
                  IF (z$ = CHR$(0) + CHR$(77) OR mousx% > 0) AND (shade%(picone%, maxlines%) AND 31) < 31 THEN shade%(picone%, maxlines%) = shade%(picone%, maxlines%) + 1
                  IF (z$ = CHR$(0) + CHR$(72) OR mousy% < 0) AND shade%(picone%, maxlines%) >= 32 THEN shade%(picone%, maxlines%) = shade%(picone%, maxlines%) - 32
                  IF (z$ = CHR$(0) + CHR$(80) OR mousy% > 0) AND shade%(picone%, maxlines%) < 256 - 32 THEN shade%(picone%, maxlines%) = shade%(picone%, maxlines%) + 32
               LOOP WHILE z$ <> CHR$(13) AND z$ <> CHR$(27) AND (bstatus% AND 1) >= (obstatus% AND 1)
               IF z$ = CHR$(27) THEN
                  shade%(picone%, maxlines%) = oldcur%
               ELSE
                  IF ((darkestcol% + (shadeoffs% AND 31)) OR 31) <> (shadeoffs% OR 31) OR ((lightestcol% + (shadeoffs% AND 31)) OR 31) <> (shadeoffs% OR 31) THEN SOUND 110, .1: SOUND 220, .1: SOUND 110, .1
                  GOSUB drawpic
               END IF
               z$ = ""
               GOSUB drawboard
            END IF
         END IF
      ELSEIF x% >= 132 AND x% <= 228 THEN
         IF z$ = "," OR z$ = "." THEN
            picone% = 0
            IF y% < 640 THEN picone% = 1
            IF y% > 704 THEN picone% = 2
            oldcur% = picnum%(picone%, maxlines%)
            IF z$ = "," THEN
               shade%(picone%, maxlines%) = (shade%(picone%, maxlines%) + 255) AND 255
               GOSUB drawpic
            END IF
            IF z$ = "." THEN
               shade%(picone%, maxlines%) = (shade%(picone%, maxlines%) + 1) AND 255
               GOSUB drawpic
            END IF
         END IF
         IF z$ = "*" OR z$ = "/" THEN
            IF z$ = "*" THEN cstat%(maxlines%) = (cstat%(maxlines%) AND 240) + ((cstat%(maxlines%) + 3) AND 15): IF (cstat%(maxlines%) AND 15) = 15 THEN cstat%(maxlines%) = (cstat%(maxlines%) AND 240)
            IF z$ = "/" THEN cstat%(maxlines%) = (cstat%(maxlines%) AND 240) - ((cstat%(maxlines%) + 13) AND 15): IF (cstat%(maxlines%) AND 15) = 13 THEN cstat%(maxlines%) = (cstat%(maxlines%) AND 240) + 12
            GOSUB showattributes
            FOR z% = 604 TO 639
               CALL drawline(100, z%, 227, z%, 236)
            NEXT z%
            picone% = 1: GOSUB drawpic
            FOR z% = 704 TO 736
               CALL drawline(100, z%, 227, z%, 236)
            NEXT z%
            picone% = 2: GOSUB drawpic
            GOSUB showattributes
         END IF
         IF (z$ = CHR$(9) OR (bstatus% AND 2) > (obstatus% AND 2)) THEN
            FOR z% = 0 TO 8
               CALL fillscreen(z%, 0)
            NEXT z%
            shadeoffs% = 0
            FOR walnume& = 0 TO maxwalls% - 1
               walpos& = walnume&
               GET #2, waloffs&(walnume&), picsbuf$
               GOSUB showall
            NEXT walnume&
           
            picone% = 0
            IF y% < 640 THEN picone% = 1
            IF y% > 704 THEN picone% = 2
            oldcur% = picnum%(picone%, maxlines%)
           
            DO
               startp& = (picnum%(picone%, maxlines%) AND 31) * 32&
               IF (picnum%(picone%, maxlines%) AND 32) > 0 THEN startp& = startp& + 32768
               startpag% = ((picnum%(picone%, maxlines%) \ 64) AND 15)
               CALL vesasetpage(startpag%)
               CALL hlin(startp&, 31, 31)
               CALL hlin(startp& + 1024, 31, 31)
               CALL hlin(startp& + 32768 - 1024, 31, 31)
               CALL hlin(startp& + 32768 - 2048, 31, 31)
               CALL vlin(startp&, startpag%, 31, 31)
               CALL vlin(startp& + 1, startpag%, 31, 31)
               CALL vlin(startp& + 30, startpag%, 31, 31)
               CALL vlin(startp& + 31, startpag%, 31, 31)
              
               DO
                  z$ = INKEY$
                  regs%(0) = 11: CALL int86old(&H33, regs%(), regs%())
                  mousx% = regs%(2) \ 2
                  mousy% = regs%(3) \ 2
                  regs%(0) = 5: CALL int86old(&H33, regs%(), regs%())
                  obstatus% = bstatus%: bstatus% = regs%(0)
               LOOP WHILE z$ = "" AND mousx% = 0 AND mousy% = 0 AND obstatus% = bstatus%
              
               startp& = (picnum%(picone%, maxlines%) AND 31) * 32&
               IF (picnum%(picone%, maxlines%) AND 32) > 0 THEN startp& = startp& + 32768
               startpag% = ((picnum%(picone%, maxlines%) \ 64) AND 15)
               CALL vesasetpage(startpag%)
               CALL hlin(startp&, 31, 0)
               CALL hlin(startp& + 1024, 31, 0)
               CALL hlin(startp& + 32768 - 1024, 31, 0)
               CALL hlin(startp& + 32768 - 2048, 31, 0)
               CALL vlin(startp&, startpag%, 31, 0)
               CALL vlin(startp& + 1, startpag%, 31, 0)
               CALL vlin(startp& + 30, startpag%, 31, 0)
               CALL vlin(startp& + 31, startpag%, 31, 0)
              
               walnume& = picnum%(picone%, maxlines%)
               walpos& = walnume&
               GET #2, waloffs&(walnume&), picsbuf$
               GOSUB showall
              
               IF (z$ = CHR$(0) + CHR$(75) OR mousx% < 0) AND (picnum%(picone%, maxlines%) AND 31) > 0 THEN picnum%(picone%, maxlines%) = picnum%(picone%, maxlines%) - 1
               IF (z$ = CHR$(0) + CHR$(77) OR mousx% > 0) AND (picnum%(picone%, maxlines%) AND 31) < 31 THEN picnum%(picone%, maxlines%) = picnum%(picone%, maxlines%) + 1
               IF (z$ = CHR$(0) + CHR$(72) OR mousy% < 0) AND picnum%(picone%, maxlines%) >= 32 THEN picnum%(picone%, maxlines%) = picnum%(picone%, maxlines%) - 32
               IF (z$ = CHR$(0) + CHR$(80) OR mousy% > 0) AND picnum%(picone%, maxlines%) < 576 - 32 THEN picnum%(picone%, maxlines%) = picnum%(picone%, maxlines%) + 32
            LOOP WHILE z$ <> CHR$(13) AND z$ <> CHR$(27) AND (bstatus% AND 1) >= (obstatus% AND 1)
            IF z$ = CHR$(27) THEN
               picnum%(picone%, maxlines%) = oldcur%
            ELSE
               GOSUB drawpic
            END IF
            z$ = ""
            GOSUB drawboard
         END IF
      ELSEIF x% >= 260 AND x% <= 324 THEN
         IF z$ = "+" OR z$ = "-" OR UCASE$(z$) = "A" OR UCASE$(z$) = "Z" THEN
            IF z$ = "+" THEN repeat%(maxlines%) = repeat%(maxlines%) OR 16: SOUND 523, 1
            IF z$ = "-" THEN repeat%(maxlines%) = repeat%(maxlines%) AND (255 - 16): SOUND 131, 1
            IF UCASE$(z$) = "A" THEN
               zosc%(maxlines%) = zosc%(maxlines%) + 4
               IF zosc%(maxlines%) >= 252 THEN zosc%(maxlines%) = 252
            END IF
            IF UCASE$(z$) = "Z" THEN
              zosc%(maxlines%) = zosc%(maxlines%) - 4
              IF zosc%(maxlines%) < 0 THEN zosc%(maxlines%) = 0
            END IF
            GOSUB showattributes
         END IF
      END IF
      IF (z$ = "B" OR z$ = "b") THEN
         cstat%(maxlines%) = cstat%(maxlines%) XOR 128
         IF (cstat%(maxlines%) AND 128) > 0 THEN SOUND 523, 1 ELSE SOUND 131, 1
         GOSUB showattributes
      END IF
      IF (z$ = "P" OR z$ = "p") THEN
         cstat%(maxlines%) = cstat%(maxlines%) XOR 64
         IF (cstat%(maxlines%) AND 64) > 0 THEN SOUND 523, 1 ELSE SOUND 131, 1
         GOSUB updateattributes
      END IF
      IF (z$ = "G" OR z$ = "g") THEN
         cstat%(maxlines%) = cstat%(maxlines%) XOR 32
         IF (cstat%(maxlines%) AND 32) > 0 THEN
            heinum%(1, maxlines%) = picnum%(1, maxlines%)
            heinum%(2, maxlines%) = picnum%(1, maxlines%)
            SOUND 523, 1
         ELSE
            heinum%(1, maxlines%) = 0
            heinum%(2, maxlines%) = 0
            SOUND 131, 1
         END IF
         GOSUB showattributes
      END IF
      IF (bstatus% <> obstatus% OR bstatus% > 0) AND x% < 50 THEN
         IF bstatus% > obstatus% THEN
            z1%(maxlines%) = ((y% - heightoffs% + 4) AND &HFFFE) * 2
            IF z1%(maxlines%) < 0 THEN z1%(maxlines%) = 0
            IF z1%(maxlines%) > 255 THEN z1%(maxlines%) = 255
         ELSE
            z2%(maxlines%) = ((y% - heightoffs% + 4) AND &HFFFE) * 2
            IF z2%(maxlines%) < 0 THEN z2%(maxlines%) = 0
            IF z2%(maxlines%) > 255 THEN z2%(maxlines%) = 255
            IF z2%(maxlines%) <= z1%(maxlines%) THEN z1%(maxlines%) = z2%(maxlines%)
         END IF
         oz1% = z1%(maxlines%) \ 2 + heightoffs%: IF oz1% = heightoffs% THEN oz1% = heightoffs% + 1
         oz2% = z2%(maxlines%) \ 2 + heightoffs%: IF oz2% = heightoffs% THEN oz2% = heightoffs% + 1
         yclip% = 768
         IF heightoffs% + 1 <= oz1% - 1 THEN
            FOR z% = heightoffs% + 1 TO oz1% - 1
               CALL drawline(31, z%, 48, z%, 0)
            NEXT z%
         END IF
         FOR z% = oz1% TO oz2%
            IF ((z% - heightoffs%) AND 7) <> 0 THEN
               CALL drawline(31, z%, 48, z%, 31 - ((z% - heightoffs%) AND 8))
            ELSE
               CALL drawline(31, z%, 48, z%, 0)
            END IF
         NEXT z%
         IF oz2% + 1 <= heightoffs% + 127 THEN
            FOR z% = oz2% + 1 TO heightoffs% + 127
               CALL drawline(31, z%, 48, z%, 0)
            NEXT z%
         END IF
         CALL printstr(0, 74, 31, LTRIM$(RTRIM$(STR$(z1%(maxlines%)))) + "-" + LTRIM$(RTRIM$(STR$(z2%(maxlines%)))) + "  ")
         yclip% = 576
      END IF
   END IF
   IF z$ = CHR$(27) THEN
      CALL printstr(0, 0, 31, "Quit? (Y/N)")
      DO
         zx$ = UCASE$(INPUT$(1))
      LOOP WHILE zx$ <> "Y" AND zx$ <> "N"
      IF zx$ = "N" THEN
         z$ = ""
         GOSUB setupscreen
      END IF
   END IF
LOOP WHILE z$ <> CHR$(27)
CLOSE #2
CALL printstr(0, 0, 31, "Save changes?                     ")
DO
   z$ = UCASE$(INKEY$)
LOOP WHILE z$ <> "Y" AND z$ <> "N" AND z$ <> CHR$(13)
IF z$ = CHR$(13) OR z$ = "Y" THEN GOSUB saveboards
regs%(0) = &H3: CALL int86old(&H10, regs%(), regs%())
END

saveboards:
   'SHELL "del " + fil$ + " > nul"
   'OPEN fil$ FOR BINARY AS #1
   'z$ = MKI$(posx%): PUT #1, , z$
   'z$ = MKI$(posy%): PUT #1, , z$
   'z$ = MKI$(ang%): PUT #1, , z$
   'z$ = MKI$(numlines%): PUT #1, , z$
   'z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(x1%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(y1%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(x2%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(y2%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(picnum%(0, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(picnum%(1, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(picnum%(2, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(heinum%(1, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + MKI$(heinum%(2, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(shade%(0, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(shade%(1, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(shade%(2, z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(z1%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(z2%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(cstat%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(zosc%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'FOR z% = 0 TO numlines% - 1: z$ = z$ + CHR$(repeat%(z%)): NEXT z%: PUT #1, , z$: z$ = ""
   'CLOSE #1
RETURN

loadboards:
   OPEN fil$ FOR BINARY AS #1
   z$ = "  ": GET #1, , z$: posx% = CVI(z$)
   z$ = "  ": GET #1, , z$: posy% = CVI(z$)
   z$ = "  ": GET #1, , z$: ang% = CVI(z$)
   z$ = "  ": GET #1, , z$: numlines% = CVI(z$)
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      x1%(z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      y1%(z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      x2%(z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      y2%(z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      picnum%(0, z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      picnum%(1, z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      picnum%(2, z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      heinum%(1, z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines% * 2, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      heinum%(2, z%) = CVI(MID$(z$, z% * 2 + 1, 2))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      shade%(0, z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
     shade%(1, z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      shade%(2, z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      z1%(z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      z2%(z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      cstat%(z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      zosc%(z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
    z$ = STRING$(numlines%, 0): GET #1, , z$
   FOR z% = 0 TO numlines% - 1
      repeat%(z%) = ASC(MID$(z$, z% + 1, 1))
   NEXT z%
   CLOSE #1
   scrx% = posx% - 512: scry% = posy% - 576 \ 2
   IF scrx% < 0 THEN scrx% = 0
   IF scrx% >= 32 * 32 THEN scrx% = 32 * 32
   IF scry% < 0 THEN scry% = 0
   IF scry% >= 46 * 32 THEN scry% = 46 * 32
   scrx% = scrx% AND &HFFE0
   scry% = scry% AND &HFFE0
   x% = posx% - scrx%: y% = posy% - scry%
RETURN

drawboard:
   FOR z% = 0 TO 8
      CALL fillscreen(z%, 0)
   NEXT z%
   FOR z% = 0 TO xres% - 1 STEP 32
      CALL drawline(z%, 0, z%, yres% - 193, 206)
   NEXT z%
   FOR z% = 0 TO yres% - 193 STEP 32
      CALL drawline(0, z%, xres% - 1, z%, 202)
   NEXT z%
   FOR z% = 0 TO numlines% - 1
      x1p% = x1%(z%) - scrx%
      y1p% = y1%(z%) - scry%
      x2p% = x2%(z%) - scrx%
      y2p% = y2%(z%) - scry%
      IF x1p% >= 0 OR x2p% >= 0 THEN
         IF x1p% <= xres% - 1 OR x2p% <= xres% - 1 THEN
            IF y1p% >= 0 OR y2p% >= 0 THEN
               IF y1p% <= yres% - 193 OR y2p% <= yres% - 193 THEN
                  IF (cstat%(z%) AND 15) = 0 THEN
                     CALL drawline(x1p% - 2, y1p% - 2, x1p% + 2, y1p% + 2, 31)
                     CALL drawline(x1p% + 2, y1p% - 2, x1p% - 2, y1p% + 2, 31)
                     CALL drawline(x1p% - 2, y1p% - 1, x1p% + 2, y1p% + 3, 31)
                     CALL drawline(x1p% + 2, y1p% - 1, x1p% - 2, y1p% + 3, 31)
                  ELSE
                     CALL drawline(x1p%, y1p%, x2p%, y2p%, 31)
                  END IF
               END IF
            END IF
         END IF
      END IF
   NEXT z%
   zzn% = -1
RETURN

updateattributes:
   GOSUB setupcolors
   FOR z% = 9 TO 11
      CALL fillscreen(z%, 236)
   NEXT z%
   yclip% = 768
   picone% = 0: GOSUB drawpic
   picone% = 1: GOSUB drawpic
   picone% = 2: GOSUB drawpic
   heightoffs% = 604
   CALL drawline(0, heightoffs%, 0, heightoffs% + 128, 92)
   CALL drawline(1, heightoffs%, 1, heightoffs% + 128, 95)
   CALL drawline(2, heightoffs%, 2, heightoffs% + 128, 92)
   CALL drawline(27, heightoffs%, 27, heightoffs% + 128, 92)
   CALL drawline(28, heightoffs%, 28, heightoffs% + 128, 95)
   CALL drawline(29, heightoffs%, 29, heightoffs% + 128, 92)
   CALL drawline(49, heightoffs%, 49, heightoffs% + 128, 223)
   CALL drawline(31, heightoffs%, 49, heightoffs%, 223)
   CALL drawline(31, heightoffs% + 128, 49, heightoffs% + 128, 223)
   CALL drawline(30, heightoffs%, 30, heightoffs% + 128, 223)
   FOR z% = 0 TO 128 STEP 2
      IF (z% AND 31) = 0 THEN
         CALL drawline(3, z% + heightoffs% - 1, 26, z% + heightoffs%, 90)
         CALL drawline(3, z% + heightoffs% + 0, 26, z% + heightoffs%, 95)
         CALL drawline(3, z% + heightoffs% + 1, 26, z% + heightoffs%, 90)
      ELSEIF (z% AND 7) = 0 THEN
         CALL drawline(3, z% + heightoffs%, 26, z% + heightoffs%, 92)
      END IF
   NEXT z%
   oz1% = z1%(maxlines%) \ 2 + heightoffs%: IF oz1% = heightoffs% THEN oz1% = heightoffs% + 1
   oz2% = z2%(maxlines%) \ 2 + heightoffs%: IF oz2% = heightoffs% THEN oz2% = heightoffs% + 1
   IF heightoffs% + 1 <= oz1% - 1 THEN
      FOR z% = heightoffs% + 1 TO oz1% - 1
         CALL drawline(31, z%, 48, z%, 0)
      NEXT z%
   END IF
   FOR z% = oz1% TO oz2%
      IF ((z% - heightoffs%) AND 7) <> 0 THEN
         CALL drawline(31, z%, 48, z%, 31 - ((z% - heightoffs%) AND 8))
      ELSE
         CALL drawline(31, z%, 48, z%, 0)
      END IF
   NEXT z%
   IF oz2% + 1 <= heightoffs% + 127 THEN
      FOR z% = oz2% + 1 TO heightoffs% + 127
         CALL drawline(31, z%, 48, z%, 0)
      NEXT z%
   END IF
   lastxsmoosh% = -1: lastysmoosh% = -1: ozosc% = -1: GOSUB showattributes
   CALL printstr(0, 74, 31, LTRIM$(RTRIM$(STR$(z1%(maxlines%)))) + "-" + LTRIM$(RTRIM$(STR$(z2%(maxlines%)))) + "  ")
   CALL printstr(100, 74, 31, version$)
   CALL printstr(100, 76, 31, "Numlines = " + STR$(numlines%) + " /" + STR$(maxlines%) + " ")
   yclip% = 576
RETURN

setupcolors:
   OPEN "palette.dat" FOR BINARY AS #3
   pal$ = STRING$(768, 0)
   GET #3, , pal$
   OUT &H3C8, 0
   FOR z% = 0 TO 767
      OUT &H3C9, ASC(MID$(pal$, z% + 1, 1))
   NEXT z%
   CLOSE #3
RETURN

drawpic:
   IF walsiz%(picnum%(picone%, maxlines%)) = 0 THEN RETURN
   totsiz& = 0
   FOR z% = 0 TO picnum%(picone%, maxlines%) - 1
      IF walsiz%(z%) > 0 THEN totsiz& = totsiz& + pow2&((walsiz%(z%) AND 15) + (walsiz%(z%) \ 16))
   NEXT z%
   xdim& = pow2&(walsiz%(picnum%(picone%, maxlines%)) AND 15)
   ydim& = pow2&(walsiz%(picnum%(picone%, maxlines%)) \ 16)
   GET #2, totsiz& + maxwalls% * 2 + 1, picsbuf$
   DEF SEG = VARSEG(picsbuf$): offs& = SADD(picsbuf$)
   IF picone% = 0 THEN
      CALL vesasetpage(10)
      p& = 132
      IF xdim& > ydim& THEN
         xz% = 0
         ytim& = ydim& * 64
         FOR zz% = 0 TO 63
            yz% = 0
            xdiv% = xz% \ 64
            FOR zzz% = 0 TO 63
               DEF SEG = VARSEG(picsbuf$): dat% = PEEK(offs& + xdiv% + (yz% \ 64) * ydim&)
               DEF SEG = &HA000: POKE p&, dat% + shade%(0, maxlines%): p& = p& + 1
               yz% = yz% + xdim&
            NEXT zzz%
            p& = p& + 1024 - 64
            xz% = xz% + xdim&: IF xz% >= ytim& THEN xz% = xz% - ytim&
         NEXT zz%
      ELSE
         xz% = 0
         xtim& = xdim& * 64
         FOR zz% = 0 TO 63
            yz% = 0
            xdiv% = xz% \ 64
            FOR zzz% = 0 TO 63
               DEF SEG = VARSEG(picsbuf$): dat% = PEEK(offs& + xdiv% + (yz% \ 64) * ydim&)
               DEF SEG = &HA000: POKE p&, dat% + shade%(0, maxlines%): p& = p& + 1
               yz% = yz% + ydim&: IF yz% >= xtim& THEN yz% = yz% - xtim&
            NEXT zzz%
            p& = p& + 1024 - 64
            xz% = xz% + ydim&
         NEXT zz%
      END IF
      GOSUB showattributes
      CALL printstr(7, 83, 31, "Pic=" + LTRIM$(RTRIM$(STR$(picnum%(0, maxlines%)))) + " ")
      IF shade%(0, maxlines%) < 128 THEN
         CALL printstr(7, 84, 31, "Sha=" + LTRIM$(RTRIM$(STR$(shade%(0, maxlines%)))) + " ")
      ELSE
         CALL printstr(7, 84, 31, "Sha=" + LTRIM$(RTRIM$(STR$(shade%(0, maxlines%) - 256))) + " ")
      END IF
   ELSEIF picone% = 1 THEN
      CALL vesasetpage(9)
      FOR zz% = 32 TO 63
         CALL hlin(zz% * 1024& + 100, 128, 236)
      NEXT zz%
      IF (cstat%(maxlines%) AND 15) > 0 THEN
         IF xdim& = 128 THEN stp% = 2 ELSE stp% = 1
         FOR z% = 0 TO 63
            FOR zz% = 0 TO 63 STEP 2
               IF (cstat%(maxlines%) AND 1) > 0 THEN
                  xdf% = z% + 132 + ((63 - zz%) * (z% - 32)) \ 64
                  DEF SEG = VARSEG(picsbuf$): dat% = PEEK(offs&) + shade%(1, maxlines%)
                  DEF SEG = &HA000
                  IF (cstat%(maxlines%) AND 64) = 0 THEN
                     p& = (zz% \ 2 + 32) * 1024& + xdf%
                     POKE p&, dat%
                     POKE p& + 1, dat%
                  ELSE
                     p& = zz% * 1024& + z% * 2 + 100
                     POKE p&, dat%
                     POKE p& + 1, dat%
                     POKE p& + 1024, dat%
                     POKE p& + 1025, dat%
                  END IF
               ELSE
                  xdf% = z% + 132 - ((63 - zz%) * (z% - 32)) \ 96
                  IF (cstat%(maxlines%) AND 64) > 0 THEN xdf% = z% * 1.5 + 116
                  DEF SEG = VARSEG(picsbuf$): dat% = PEEK(offs&) + shade%(1, maxlines%)
                  DEF SEG = &HA000
                  IF (cstat%(maxlines%) AND 64) = 0 THEN
                     p& = (zz% \ 2 + 32) * 1024& + xdf%
                     POKE p&, dat%
                     POKE p& + 1, dat%
                  ELSE
                     p& = zz% * 1024& + z% * 2 + 100
                     POKE p&, dat%
                     POKE p& + 1, dat%
                     POKE p& + 1024, dat%
                     POKE p& + 1025, dat%
                  END IF
               END IF
               offs& = offs& + stp% + stp%
            NEXT zz%
            IF xdim& = 128 THEN offs& = offs& + 128
         NEXT z%
         CALL printstr(7, 79, 31, "Pic=" + LTRIM$(RTRIM$(STR$(picnum%(1, maxlines%)))) + " ")
         IF shade%(1, maxlines%) < 128 THEN
            CALL printstr(7, 80, 31, "Sha=" + LTRIM$(RTRIM$(STR$(shade%(1, maxlines%)))) + " ")
         ELSE
            CALL printstr(7, 80, 31, "Sha=" + LTRIM$(RTRIM$(STR$(shade%(1, maxlines%) - 256))) + " ")
         END IF
      END IF
   ELSEIF picone% = 2 THEN
      CALL vesasetpage(11)
      FOR zz% = 0 TO 31
         CALL hlin(zz% * 1024& + 100, 128, 236)
      NEXT zz%
      IF (cstat%(maxlines%) AND 15) > 0 THEN
         IF xdim& = 128 THEN stp% = 2 ELSE stp% = 1
         FOR z% = 0 TO 63
            FOR zz% = 0 TO 63 STEP 2
               IF (cstat%(maxlines%) AND 2) > 0 THEN
                  xdf% = z% + 132 + (zz% * (z% - 32)) \ 64
                  DEF SEG = VARSEG(picsbuf$): dat% = PEEK(offs&) + shade%(2, maxlines%)
                  DEF SEG = &HA000
                  p& = (zz% \ 2) * 1024& + xdf%
                  POKE p&, dat%
                  POKE p& + 1, dat%
               ELSE
                  xdf% = z% + 132 - (zz% * (z% - 32)) \ 96
                  DEF SEG = VARSEG(picsbuf$): dat% = PEEK(offs&) + shade%(2, maxlines%)
                  DEF SEG = &HA000
                  p& = (zz% \ 2) * 1024& + xdf%
                  POKE p&, dat%
               END IF
               offs& = offs& + stp% + stp%
            NEXT zz%
            IF xdim& = 128 THEN offs& = offs& + 128
         NEXT z%
         CALL printstr(7, 87, 31, "Pic=" + LTRIM$(RTRIM$(STR$(picnum%(2, maxlines%)))) + " ")
         IF shade%(2, maxlines%) < 128 THEN
            CALL printstr(7, 88, 31, "Sha=" + LTRIM$(RTRIM$(STR$(shade%(2, maxlines%)))) + " ")
         ELSE
            CALL printstr(7, 88, 31, "Sha=" + LTRIM$(RTRIM$(STR$(shade%(2, maxlines%) - 256))) + " ")
         END IF
      END IF
   END IF
RETURN

gethighlight:
   oldzzn% = zzn%
   IF y% - scry% >= 576 THEN RETURN
   dist& = 1000000
   zzn% = numlines% - 1
   FOR z% = 0 TO numlines% - 1
      dst& = ABS(x% - (x1%(z%) + x2%(z%)) \ 2)
      dst& = dst& + ABS(y% - (y1%(z%) + y2%(z%)) \ 2)
      IF dst& < dist& THEN
         dist& = dst&: zzn% = z%
      ELSEIF dst& = dist& THEN
         IF x1%(z%) = x1%(zzn%) AND y1%(z%) = y1%(zzn%) AND x2%(z%) = x2%(zzn%) AND y2%(z%) = y2%(zzn%) THEN
            IF order% = 0 THEN
               IF z1%(z%) < z1%(zzn%) THEN zzn% = z%
            ELSE
               IF z1%(z%) > z1%(zzn%) THEN zzn% = z%
            END IF
         END IF
         IF x1%(z%) = x2%(zzn%) AND y1%(z%) = y2%(zzn%) AND x2%(z%) = x1%(zzn%) AND y2%(z%) = y1%(zzn%) THEN
            IF order% = 0 THEN
               IF z1%(z%) < z1%(zzn%) THEN zzn% = z%
            ELSE
               IF z1%(z%) > z1%(zzn%) THEN zzn% = z%
            END IF
         END IF
      END IF
   NEXT z%
   IF zzn% <> oldzzn% THEN
      newzzn% = zzn%
      zzn% = oldzzn%: GOSUB restorecursor
      zzn% = newzzn%: GOSUB backupcursor
   END IF
RETURN

drawhiresboard:
   yclip% = 1024
   IF z$ = "v" THEN
      FOR pag% = 0 TO 15
         CALL fillscreen(pag%, 0)
      NEXT pag%
      FOR z% = 0 TO 1023 STEP 16
         CALL drawline(z%, 0, z%, 1023, 16)
      NEXT z%
      FOR z% = 0 TO 1023 STEP 16
         CALL drawline(0, z%, 1023, z%, 16)
      NEXT z%
      FOR z% = 0 TO numlines% - 1
         CALL drawline(x1%(z%) \ 2, y1%(z%) \ 2, x2%(z%) \ 2, y2%(z%) \ 2, 223)
         CALL drawline(x1%(z%) \ 2 + 1, y1%(z%) \ 2, x2%(z%) \ 2 + 1, y2%(z%) \ 2, 223)
         CALL drawline(x1%(z%) \ 2, y1%(z%) \ 2 + 1, x2%(z%) \ 2, y2%(z%) \ 2 + 1, 223)
      NEXT z%
   ELSE
      FOR pag% = 0 TO 15
         CALL fillscreen(pag%, 31)
      NEXT pag%
      FOR z% = 0 TO numlines% - 1
         IF (cstat%(z%) AND 15) = 3 THEN col% = 0 ELSE col% = 6
         CALL drawline(x1%(z%) \ 2, y1%(z%) \ 2, x2%(z%) \ 2, y2%(z%) \ 2, col%)
         CALL drawline(x1%(z%) \ 2 + 1, y1%(z%) \ 2, x2%(z%) \ 2 + 1, y2%(z%) \ 2, col%)
         CALL drawline(x1%(z%) \ 2, y1%(z%) \ 2 + 1, x2%(z%) \ 2, y2%(z%) \ 2 + 1, col%)
      NEXT z%
   END IF
   p& = 0
   DO
      regs%(0) = 11: CALL int86old(&H33, regs%(), regs%())
      mousx% = regs%(2) \ 2
      mousy% = regs%(3) \ 2
      p& = p& + 256 * mousy%
      IF p& < 0 THEN p& = 0
      IF p& > 65536 - 256 THEN p& = 65536 - 256
      OUT &H3D4, &HC: OUT &H3D5, p& \ 256
      OUT &H3D4, &HD: OUT &H3D5, p& AND 255
   LOOP WHILE INKEY$ = ""
   xres% = 1024: yres% = 768
   yclip% = 576
   OUT &H3D4, &HC: OUT &H3D5, 0
   OUT &H3D4, &HD: OUT &H3D5, 0
   GOSUB updateattributes
   GOSUB drawboard
RETURN

setupscreen:
   regs%(0) = &H4F02: regs%(1) = &H105: CALL int86old(&H10, regs%(), regs%())
   regs%(0) = &H11 * 256& + &H23: regs%(1) = 0
   CALL int86old(&H10, regs%(), regs%())         'set 8*8 text
   xres% = 1024: yres% = 768
   yclip% = 576
   GOSUB updateattributes
   GOSUB drawboard
RETURN

readcursor:
   DEF SEG = &HA000
   FOR zzxx% = y1%(zzn%) - scry% - 4 TO y1%(zzn%) - scry% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x1%(zzn%) - scrx% - 4 TO x1%(zzn%) - scrx% + 4
         addr& = (zzxx% AND 63) * 1024& + z%
         IF ((z% OR zzxx%) AND &HFC00) = 0 AND zzxx% < 576 THEN picture2%(z% - (x1%(zzn%) - scrx% - 4), zzxx% - (y1%(zzn%) - scry% - 4)) = PEEK(addr&)
      NEXT z%
   NEXT zzxx%
   FOR zzxx% = y2%(zzn%) - scry% - 4 TO y2%(zzn%) - scry% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x2%(zzn%) - scrx% - 4 TO x2%(zzn%) - scrx% + 4
         addr& = (zzxx% AND 63) * 1024& + z%
         IF ((z% OR zzxx%) AND &HFC00) = 0 AND zzxx% < 576 THEN picture3%(z% - (x2%(zzn%) - scrx% - 4), zzxx% - (y2%(zzn%) - scry% - 4)) = PEEK(addr&)
      NEXT z%
   NEXT zzxx%
RETURN
   
backupcursor:
   IF zzn% < 0 OR zzn% >= numlines% THEN RETURN
   DEF SEG = &HA000
   FOR zzxx% = y1%(zzn%) - scry% - 4 TO y1%(zzn%) - scry% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x1%(zzn%) - scrx% - 4 TO x1%(zzn%) - scrx% + 4
         addr& = (zzxx% AND 63) * 1024& + z%
         IF ((z% OR zzxx%) AND &HFC00) = 0 AND zzxx% < 576 THEN picture2%(z% - (x1%(zzn%) - scrx% - 4), zzxx% - (y1%(zzn%) - scry% - 4)) = PEEK(addr&)
      NEXT z%
   NEXT zzxx%
   FOR zzxx% = y2%(zzn%) - scry% - 4 TO y2%(zzn%) - scry% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x2%(zzn%) - scrx% - 4 TO x2%(zzn%) - scrx% + 4
         addr& = (zzxx% AND 63) * 1024& + z%
         IF ((z% OR zzxx%) AND &HFC00) = 0 AND zzxx% < 576 THEN picture3%(z% - (x2%(zzn%) - scrx% - 4), zzxx% - (y2%(zzn%) - scry% - 4)) = PEEK(addr&)
      NEXT z%
   NEXT zzxx%
RETURN
    
restorecursor:
   IF zzn% < 0 OR zzn% >= numlines% THEN RETURN
   DEF SEG = &HA000
   FOR zzxx% = y2%(zzn%) - scry% - 4 TO y2%(zzn%) - scry% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x2%(zzn%) - scrx% - 4 TO x2%(zzn%) - scrx% + 4
         addr& = (zzxx% AND 63) * 1024& + z%
         IF ((z% OR zzxx%) AND &HFC00) = 0 AND zzxx% < 576 THEN POKE addr&, picture3%(z% - (x2%(zzn%) - scrx% - 4), zzxx% - (y2%(zzn%) - scry% - 4))
      NEXT z%
   NEXT zzxx%
   FOR zzxx% = y1%(zzn%) - scry% - 4 TO y1%(zzn%) - scry% + 4
      CALL vesasetpage((zzxx% \ 64) + (zzxx% \ 64) * 16)
      FOR z% = x1%(zzn%) - scrx% - 4 TO x1%(zzn%) - scrx% + 4
         addr& = (zzxx% AND 63) * 1024& + z%
         IF ((z% OR zzxx%) AND &HFC00) = 0 AND zzxx% < 576 THEN POKE addr&, picture2%(z% - (x1%(zzn%) - scrx% - 4), zzxx% - (y1%(zzn%) - scry% - 4))
      NEXT z%
   NEXT zzxx%
   yclip% = 576
   IF (cstat%(zzn%) AND 15) = 0 THEN
      CALL drawline(x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% - 2, x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% + 2, 31)
      CALL drawline(x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% - 2, x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% + 2, 31)
      CALL drawline(x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% - 1, x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% + 3, 31)
      CALL drawline(x1%(zzn%) - scrx% + 2, y1%(zzn%) - scry% - 1, x1%(zzn%) - scrx% - 2, y1%(zzn%) - scry% + 3, 31)
   ELSE
      CALL drawline(x1%(zzn%) - scrx%, y1%(zzn%) - scry%, x2%(zzn%) - scrx%, y2%(zzn%) - scry%, 31)
   END IF
RETURN

showall:
   startp& = (walpos& AND 31) * 32&
   IF (walpos& AND 32) > 0 THEN startp& = startp& + 32768
   CALL vesasetpage((walpos& \ 64) AND 15)
   xdim& = pow2&(walsiz%(walnume&) AND 15)
   ydim& = pow2&(walsiz%(walnume&) \ 16)
   IF xdim& <= 64 AND ydim& <= 64 THEN
      stp% = 2: stpadd& = ydim& * 4&
   ELSE
      stp% = 4: stpadd& = ydim& * 8&: xdim& = xdim& \ 2
   END IF
   tempseg& = VARSEG(picsbuf$)
   offs& = SADD(picsbuf$)
   FOR zx& = startp& TO startp& + (xdim&) \ 2 - 1 STEP 2
      CALL vline2(zx&, ydim&, tempseg&, offs&, stp%, shadeoffs%)
      offs& = offs& + stpadd&
   NEXT zx&
RETURN
           
showattributes:
   lastxsmoosh% = xsmoosh%: lastysmoosh% = ysmoosh%
   xsmoosh% = (repeat%(maxlines%) AND 15)
   ysmoosh% = (repeat%(maxlines%) \ 16 + 1)
   IF lastxsmoosh% <> xsmoosh% OR lasysmoosh% <> ysmoosh% THEN
      startpag% = 10
      IF lastxsmoosh% > 0 THEN
         FOR zxr = 260 TO 323 STEP 64 / lastxsmoosh%
            CALL vlin(CINT(zxr), startpag%, 64, 236)
         NEXT zxr
         IF lastysmoosh% = 2 THEN
            CALL vesasetpage(startpag%)
            CALL hlin(260 + (1024& * 32&), 64, 236)
         END IF
      END IF
      FOR zxr = 260 TO 323 STEP 64 / xsmoosh%
         CALL vlin(CINT(zxr), startpag%, 64, 31)
      NEXT zxr
      CALL vlin(324, startpag%, 64, 31)
      CALL vesasetpage(startpag%)
      CALL hlin(260, 64, 31)
      CALL hlin(260 + (1024& * 63&), 64, 31)
      IF ysmoosh% = 2 THEN CALL hlin(260 + (1024& * 32&), 64, 31)
   END IF

   IF zosc%(maxlines%) <> ozosc% THEN
      CALL vesasetpage(9)
      FOR z% = 0 TO 63
         CALL hlin(260 + 1024& * z%, 64, 236)
      NEXT z%
      IF (zosc%(maxlines%) > 0) THEN
         FOR zxr% = 260 TO 323 STEP 4
            sinz% = 63 - (zosc%(maxlines%) \ 4) * SIN((zxr% - 260) * 3.141592 / 64)
            CALL hlin(zxr% + 1024& * sinz%, 4, 31)
         NEXT zxr%
      END IF
      CALL printstr(32, 74, 31, "Zosc = " + LTRIM$(RTRIM$(STR$(zosc%(maxlines%)))) + " ")
      ozosc% = zosc%(maxlines%)
   END IF

   CALL printstr(32, 94, 31, "Groudraw =  " + LTRIM$(RTRIM$(STR$((cstat%(maxlines%) AND 32) \ 32))) + "  ")
   CALL printstr(32, 95, 31, "ClipBlock = " + LTRIM$(RTRIM$(STR$((cstat%(maxlines%) AND 128) \ 128))) + "  ")

   IF (cstat%(maxlines%) AND 15) = 0 THEN CALL printstr(16, 92, 31, "  Sprite  ")
   IF (cstat%(maxlines%) AND 15) = 3 THEN CALL printstr(16, 92, 31, " End Wall ")
   IF (cstat%(maxlines%) AND 15) = 6 THEN CALL printstr(16, 92, 31, "Floor Step")
   IF (cstat%(maxlines%) AND 15) = 9 THEN CALL printstr(16, 92, 31, "Ceil. Step")
   IF (cstat%(maxlines%) AND 15) = 12 THEN CALL printstr(16, 92, 31, "Start Wall")
RETURN

SUB copyattributes (sour%, dest%)
   x1%(dest%) = x1%(sour%)
   y1%(dest%) = y1%(sour%)
   x2%(dest%) = x2%(sour%)
   y2%(dest%) = y2%(sour%)
   picnum%(0, dest%) = picnum%(0, sour%)
   picnum%(1, dest%) = picnum%(1, sour%)
   picnum%(2, dest%) = picnum%(2, sour%)
   heinum%(1, dest%) = heinum%(1, sour%)
   heinum%(2, dest%) = heinum%(2, sour%)
   shade%(0, dest%) = shade%(0, sour%)
   shade%(1, dest%) = shade%(1, sour%)
   shade%(2, dest%) = shade%(2, sour%)
   z1%(dest%) = z1%(sour%)
   z2%(dest%) = z2%(sour%)
   cstat%(dest%) = cstat%(sour%)
   zosc%(dest%) = zosc%(sour%)
   repeat%(dest%) = repeat%(sour%)
END SUB

SUB drawline (tx0%, ty0%, tx1%, ty1%, col%)
   x0% = tx0%
   y0% = ty0%
   x1% = tx1%
   y1% = ty1%
   DEF SEG = &HA000
   xdim% = ABS(x1% - x0%)
   ydim% = ABS(y1% - y0%)
   IF ydim% = 0 THEN
      IF x1% < x0% THEN SWAP x0%, x1%: SWAP y0%, y1%
      IF x0% < 0 THEN x0% = 0
      IF x1% >= 1024 THEN x1% = 1023
      p& = ((y0% + 1024) AND 63) * 1024& + x0%
      pag% = (y0% + 1024) \ 64 - 16
      CALL vesasetpage(pag%)
      IF x1% >= x0% AND y0% < yclip% THEN CALL hlin(p&, x1% - x0%, col%)
   ELSEIF xdim% = 0 THEN
      IF y1% < y0% THEN SWAP x0%, x1%: SWAP y0%, y1%
      IF y0% < 0 THEN y0% = 0
      IF y1% >= yclip% THEN y1% = yclip% - 1
      p& = ((y0% + 1024) AND 63) * 1024& + x0%
      pag% = (y0% + 1024) \ 64 - 16
      IF y1% >= y0% THEN CALL vlin(p&, pag%, y1% - y0%, col%)
   ELSEIF xdim% >= ydim% THEN
      IF x1% < x0% THEN SWAP x0%, x1%: SWAP y0%, y1%
      p& = ((y0% + 1024) AND 63) * 1024& + x0%
      pag% = (y0% + 1024) \ 64 - 16
      CALL vesasetpage(pag%)
      cnt% = 0
      IF y1% > y0% THEN pinc& = 1024: ydir% = 1 ELSE pinc& = -1024: ydir% = -1
      y% = y0%
      IF x1% > 1024 THEN x1% = 1024
      FOR zx% = x0% TO x1%
         IF (((zx% OR y%) AND &HFC00) = 0) AND y% < yclip% THEN POKE p&, col%
         cnt% = cnt% + ydim%
         p& = p& + 1
         IF cnt% >= xdim% THEN
            cnt% = cnt% - xdim%
            p& = p& + pinc&: y% = y% + ydir%
            IF (p& AND &HFFFF0000) <> 0 THEN
               IF p& < 0 THEN pag% = pag% - 1: CALL vesasetpage(pag%): p& = p& + 65536
               IF p& > 65535 THEN pag% = pag% + 1: CALL vesasetpage(pag%): p& = p& - 65536
            END IF
         END IF
      NEXT zx%
   ELSE
      IF y1% < y0% THEN SWAP x0%, x1%: SWAP y0%, y1%
      p& = ((y0% + 1024) AND 63) * 1024& + x0%
      pag% = (y0% + 1024) \ 64 - 16
      CALL vesasetpage(pag%)
      cnt% = 0
      x% = x0%
      IF x1% > x0% THEN pinc& = 1: xdir% = 1 ELSE pinc& = -1: xdir% = -1
      IF y1% >= yclip% THEN y1% = yclip% - 1
      FOR zx% = y0% TO y1%
         IF (((zx% OR x%) AND &HFC00) = 0) THEN POKE p&, col%
         cnt% = cnt% + xdim%
         IF cnt% >= ydim% THEN
            cnt% = cnt% - ydim%
            p& = p& + pinc&: x% = x% + xdir%
         END IF
         p& = p& + 1024
         IF (p& AND &HFFFF0000) <> 0 THEN
            IF p& < 0 THEN pag% = pag% - 1: CALL vesasetpage(pag%): p& = p& + 65536
            IF p& > 65535 THEN pag% = pag% + 1: CALL vesasetpage(pag%): p& = p& - 65536
         END IF
      NEXT zx%
   END IF
END SUB

SUB fillscreen (startpag%, col%)
IF 0 THEN
      '01/26/2006: Fix: chain trick doesn't work with modern VESA emulation
      'Some cards don't support this trick (such as ATI brand)
   OUT &H3C4, 2: OUT &H3C5, 15
   OUT &H3C4, &H4: OUT &H3C5, INP(&H3C5) AND (255 - 8)    'CHAIN 4 OFF
   OUT &H3D4, &H17: OUT &H3D5, INP(&H3D5) OR 64           'WORD MODE
   OUT &H3D4, &H14: OUT &H3D5, INP(&H3D5) AND (255 - 64)  '2-WORD MODE
   CALL vesasetpage(startpag% \ 4): diplc& = (startpag% AND 3) * 16384&
   leng& = 8192
ELSE
   CALL vesasetpage(startpag%): diplc& = 0
   leng& = 32768
END IF
   DIM asmprog%(12)
   DEF SEG = VARSEG(asmprog%(0)): p& = VARPTR(asmprog%(0))
   POKE p& + 0, &H55
   POKE p& + 1, &H8B: POKE p& + 2, &HEC
   POKE p& + 3, &HB8: POKE p& + 4, &H0: POKE p& + 5, &HA0
   POKE p& + 6, &H8E: POKE p& + 7, &HC0
   POKE p& + 8, &HB9: POKE p& + 9, &H0: POKE p& + 10, leng& \ 256
   POKE p& + 11, &HBF: POKE p& + 12, diplc& AND 255: POKE p& + 13, diplc& \ 256
   POKE p& + 14, &HB8: POKE p& + 15, col%: POKE p& + 16, col%
   POKE p& + 17, &HF3: POKE p& + 18, &HAB
   POKE p& + 19, &H5D
   POKE p& + 20, &HCA: POKE p& + 21, &H2: POKE p& + 22, &H0

' 55        : 'push bp
' 8B EC     : 'mov bp, sp
' B8 00 A0  : 'mov ax, &ha000
' 8E C0     : 'mov es, ax
' B9 00 20  : 'mov cx, 8192 or 32768
' 33 ?  ?   : 'mov di, 0x8888
' B8 ?  ?   : 'mov ax, 0x8888
' F3 AB     : 'rep stosw
' 5D        : 'pop bp
' CA 02 00  : 'ret 2

   CALL ABSOLUTE(0, p&)
  
IF 0 THEN
      '01/26/2006: Fix: chain trick doesn't work with modern VESA emulation
      'Some cards don't support this trick (such as ATI brand)
   OUT &H3C4, 4: OUT &H3C5, INP(&H3C5) OR 8             'CHAIN 4 ON
END IF
END SUB

SUB hlin (start&, leng%, col%)
   DIM asmprog%(15)
   DEF SEG = VARSEG(asmprog%(0)): p& = VARPTR(asmprog%(0))
   POKE p& + 0, &H55
   POKE p& + 1, &H8B
   POKE p& + 2, &HEC
   POKE p& + 3, &HB8
   POKE p& + 4, &H0
   POKE p& + 5, &HA0
   POKE p& + 6, &H8E
   POKE p& + 7, &HC0
   POKE p& + 8, &HB9
   POKE p& + 9, leng% AND 255
   POKE p& + 10, leng% \ 256
   POKE p& + 11, &HBF
   POKE p& + 12, start& AND 255
   POKE p& + 13, start& \ 256
   POKE p& + 14, &HB8
   POKE p& + 15, col%
   POKE p& + 16, col%
   POKE p& + 17, &HD1
   POKE p& + 18, &HE9
   POKE p& + 19, &HF3
   POKE p& + 20, &HAB
   POKE p& + 21, &HD1
   POKE p& + 22, &HD1
   POKE p& + 23, &H83
   POKE p& + 24, &HE1
   POKE p& + 25, &H1
   POKE p& + 26, &HF3
   POKE p& + 27, &HAA
   POKE p& + 28, &H5D
   POKE p& + 29, &HCA
   POKE p& + 30, &H2
   POKE p& + 31, &H0
'DATA &H55              : 'PUSH BP
'DATA &H8B, &HEC        : 'MOV BP,SP
'DATA &HB8, &H00, &HA0  : 'MOV AX, &HA000
'DATA &H8E, &HC0        : 'MOV ES, AX
'DATA &HB9, &H?,  &H?   : 'MOV CX, LEN
'DATA &HBF, &H?,  &H?   : 'MOV DI, START
'DATA &HB8, &H?,  &H?   : 'MOV AX, COL
'DATA &HD1, &HE9        : 'SHR CX, 1
'DATA &HF3, &HAB        : 'REP STOSW
'DATA &HD1, &HD1        : 'RCL CX, 1
'DATA &H83, &HE1, &H01  : 'AND CX, 1
'DATA &HF3, &HAA        : 'REP STOSB
'DATA &H5D              : 'POP BP
'DATA &HCA, &H02, &H00  : 'RET 2
   CALL ABSOLUTE(0, p&)
   DEF SEG
END SUB

SUB printstr (xpos%, ypos%, col%, z$)
IF 1 THEN
      '01/26/2006: Fix: int 0x10 font routines don't work in VESA
   CALL vesasetpage(ypos% \ 8)
   DEF SEG = &HA000 + (((ypos% * 8&) AND 63) * 1024) \ 16
   p% = xpos% * 8
   FOR z% = 1 TO LEN(z$)
      ch% = ASC(MID$(z$, z%, 1)): np% = p%
      FOR y% = 0 TO 7
         m% = pow2&(y%)
         FOR x% = 0 TO 7
            POKE np% + x%, ((fontbuf%(ch%, x%) AND m%) <> 0) AND col%
         NEXT x%
         np% = np% + 1024
      NEXT y%
      p% = p% + 8
   NEXT z%
ELSE
   zxsnots% = xpos%
   FOR zxsnotsers% = 1 TO LEN(z$)
      regs%(0) = &H2 * 256
      regs%(1) = 0
      regs%(3) = ypos% * 256 + zxsnots%
      CALL int86old(&H10, regs%(), regs%())
      zxsnots% = zxsnots% + 1
      regs%(0) = &HA * 256 + ASC(MID$(z$, zxsnotsers%, 1))
      regs%(1) = col%
      regs%(2) = 1
      CALL int86old(&H10, regs%(), regs%())
   NEXT zxsnotsers%
END IF
END SUB

SUB vesasetpage (pag%)
   regs%(0) = &H4F05: regs%(1) = &H0: regs%(3) = (pag% AND 15)
   CALL int86xold(&H10, regs%(), regs%())
  
   regs%(0) = &H4F05: regs%(1) = &H100: regs%(3) = (pag% \ 16)
   CALL int86xold(&H10, regs%(), regs%())
END SUB

SUB vlin (start&, startpag%, leng%, col%)
  
      'Re-wrote this code (in 1999) because that assembly stuff had 0x3cd's
   DEF SEG = &HA000
   p& = start&: dapag% = startpag%: CALL vesasetpage(dapag%)
   FOR y% = 0 TO leng% - 1
      POKE p&, col%
      p& = p& + 1024
      IF p& >= 65536 THEN
         p& = p& AND 65535: dapag% = dapag% + 1: CALL vesasetpage(dapag%)
      END IF
   NEXT y%
   EXIT SUB
  
   DIM asmprog%(25)
   DEF SEG = VARSEG(asmprog%(0)): p& = VARPTR(asmprog%(0))
   POKE p& + 0, &H55
   POKE p& + 1, &H8B
   POKE p& + 2, &HEC
   POKE p& + 3, &HB8
   POKE p& + 4, &H0
   POKE p& + 5, &HA0
   POKE p& + 6, &H8E
   POKE p& + 7, &HC0
   POKE p& + 8, &HBA
   POKE p& + 9, &HCD
   POKE p& + 10, &H3
   POKE p& + 11, &HB4
   POKE p& + 12, col%
   POKE p& + 13, &HB0
   POKE p& + 14, startpag%
   POKE p& + 15, &HEE
   POKE p& + 16, &HBF
   POKE p& + 17, start& AND 255
   POKE p& + 18, start& \ 256
   POKE p& + 19, &HB9
   POKE p& + 20, leng% AND 255
   POKE p& + 21, leng% \ 256
   POKE p& + 22, &H26
   POKE p& + 23, &H88
   POKE p& + 24, &H25
   POKE p& + 25, &H81
   POKE p& + 26, &HC7
   POKE p& + 27, &H0
   POKE p& + 28, &H4
   POKE p& + 29, &H72
   POKE p& + 30, &H7
   POKE p& + 31, &H83
   POKE p& + 32, &HE9
   POKE p& + 33, &H1
   POKE p& + 34, &H73
   POKE p& + 35, &HF2
   POKE p& + 36, &H72
   POKE p& + 37, &H8
   POKE p& + 38, &HFE
   POKE p& + 39, &HC0
   POKE p& + 40, &HEE
   POKE p& + 41, &H83
   POKE p& + 42, &HE9
   POKE p& + 43, &H1
   POKE p& + 44, &H73
   POKE p& + 45, &HE8
   POKE p& + 46, &H5D
   POKE p& + 47, &HCA
   POKE p& + 48, &H2
   POKE p& + 49, &H0
   CALL ABSOLUTE(0, p&)
   DEF SEG
   
'     55             push bp
'     8b ec          mov bp, sp
'     b8 00 a0       mov ax, 0xa000
'     8e c0          mov es, ax
'     ba cd 03       mov dx, 0x3cd
'     b4 ?           mov ah, 0x88        (col)
'     b0 ?           mov al, 0x88        (startpag)
'     ee             out dx, al
'     bf ?  ?        mov di, 0x8888      (start)
'     b9 ?  ?        mov cx, 0x8888      (leng)
'lab: 26 88 25       mov byte ptr es:[di], ah
'     81 c7 00 04    add di, 1024
'     72 07          jc skp
'     83 e9 01       sub cx, 1
'     73 f2          jnc lab
'     72 08          jc stp
'skp: fe c0          inc al
'     ee             out dx, al
'     83 e9 01       sub cx, 1
'     73 e8          jnc lab
'stp: 5d             pop bp
'     ca 02 00       ret 2

END SUB

SUB vline2 (x&, ydim&, segtemp&, offtemp&, stp%, shadeoffs%)
   DIM asmprog%(31)
   DEF SEG = VARSEG(asmprog%(0)): p& = VARPTR(asmprog%(0))
   POKE p& + 0, &H55
   POKE p& + 1, &H8B: POKE p& + 2, &HEC
   POKE p& + 3, &HB8: POKE p& + 4, &H0: POKE p& + 5, &HA0
   POKE p& + 6, &H8E: POKE p& + 7, &HC0
   POKE p& + 8, &HBF: POKE p& + 9, x& AND 255: POKE p& + 10, x& \ 256
   POKE p& + 11, &HB9: POKE p& + 12, (ydim& \ stp%) AND 255: POKE p& + 13, (ydim& \ stp%) \ 256
   POKE p& + 14, &HBB: POKE p& + 15, ydim AND 255: POKE p& + 16, ydim& \ 256
   POKE p& + 17, &HB8: POKE p& + 18, segtemp& AND 255: POKE p& + 19, segtemp& \ 256
   POKE p& + 20, &HBE: POKE p& + 21, offtemp& AND 255: POKE p& + 22, offtemp& \ 256
   POKE p& + 23, &H33: POKE p& + 24, &HD2
   POKE p& + 25, &H1E
   POKE p& + 26, &H8E: POKE p& + 27, &HD8
   POKE p& + 28, &H3E: POKE p& + 29, &H8A: POKE p& + 30, &H4
   POKE p& + 31, &H3E: POKE p& + 32, &H8A: POKE p& + 33, &H20
   POKE p& + 34, &H4: POKE p& + 35, shadeoffs%
   POKE p& + 36, &H80: POKE p& + 37, &HC4: POKE p& + 38, shadeoffs%
   POKE p& + 39, &H26: POKE p& + 40, &H89: POKE p& + 41, &H5
   POKE p& + 42, &H81: POKE p& + 43, &HC7: POKE p& + 44, &H0: POKE p& + 45, &H4
   POKE p& + 46, &H81: POKE p& + 47, &HC2: POKE p& + 48, 0: POKE p& + 49, 0
   POKE p& + 50, &H81: POKE p& + 51, &HD6: POKE p& + 52, stp%: POKE p& + 53, 0
   POKE p& + 54, &HE2: POKE p& + 55, &HE4
   POKE p& + 56, &H1F
   POKE p& + 57, &H5D
   POKE p& + 58, &HCA: POKE p& + 59, &H2: POKE p& + 60, &H0
   CALL ABSOLUTE(0, p&)
   DEF SEG

'      55             push bp
'      8b ec          mov bp, sp
'      b8 00 a0       mov ax, 0xa000
'      8e c0          mov es, ax
'      bf ?  ?        mov di, 0x8888   ;x position
'      b9 ?  ?        mov cx, 0x8888   ;leng
'      bb ?  ?        mov bx, 0x8888   ;ydim
'      b8 ?  ?        mov ax, 0x8888   ;seg tempbuf
'      be ?  ?        mov si, 0x8888   ;offset tempbuf
'      33 d2          xor dx, dx
'      1e             push ds
'      8e d8          mov ds, ax
' beg: 3e 8a 04       mov al, byte ptr ds:[si]
'      3e 8a 20       mov ah, byte ptr ds:[bx][si]
'      04 88          add al, 0x88
'      80 c4 88       add ah, 0x88
'      26 89 05       mov word ptr es:[di], ax
'      81 c7 00 04    add di, 1024
'      81 c2 ? ?      add dx, 0x8888   ;incr value
'      81 d6 ? 0      adc si, 0x88     ;step
'      e2 e4          loop beg
'      1f             pop ds
'      5d             pop bp
'      ca 02 00       ret 2

END SUB

