#define MAIN
#include <stdlib.h>
#include "build.h"

static char tempscreenbuf[64000];

main(short int argc,char **argv)
{
	char signmessage[] = {"        Welcome to BUILD, a graphical engine by Ken Silverman.   This sign is a demo of how parts of tiles can be copied onto parts of other tiles.  Please look at readme.txt if you want an explanation on how to do this."};
	char nextletter, nextlettercnt, boardfilename[80];
	short int i, signcharcnt, signleng, numargs;
	long templong;

	numargs = argc;
	if (numargs >= 2)
	{
		strcpy(&boardfilename,argv[1]);
		if(strchr(boardfilename,'.') == 0)
			strcat(boardfilename,".dat");
	}
	else
		strcpy(&boardfilename,"boards.dat");

	loadpics("pics.dat");
	loadboard(boardfilename);
	initengine();

	if (numargs == 4)
	{
		posx = ((atol(argv[2]))<<5);       //Allow EDITBORD to load build at
		posy = ((atol(argv[3]))<<5);       //mouse cursor
	}
	else
	{
		setvmode(0x13);
		loadpcx("build.pcx",&tempscreenbuf);
		setupdraw2buffer(&tempscreenbuf);
		templong = 16384;
		keystatus[0x1c] = 0, keystatus[0x9c] = 0, keystatus[0x1] = 0, keystatus[0x39] = 0;
		while ((templong >= 4096) && ((keystatus[0x1c]|keystatus[0x9c]|keystatus[1]|keystatus[0x39]) == 0))
		{
			draw2d(262144*160,262144*100,templong,((templong+4096)>>2)&2047);
			templong -= 64;
		}
		while ((keystatus[0x1c]|keystatus[0x9c]|keystatus[1]|keystatus[0x39]) == 0);
	}
	setgamemode();

	signleng = 0;
	while (signmessage[signleng] != 0)
		signleng++;
	signcharcnt = 0;
	nextlettercnt = 7;

	if (numargs == 1)
		showpositioncapture("poscapt.dat");         //run through demo sequence

	resettiming();
	while (keystatus[1] == 0)
	{
		for (i=5;i<xdim-5;i++)                      //define rounded corners
		{
			umost[i] = 0;
			dmost[i] = ydim;
		}
		umost[0] = 5, dmost[0] = ydim-umost[0];
		umost[1] = 3, dmost[1] = ydim-umost[1];
		umost[2] = 2, dmost[2] = ydim-umost[2];
		umost[3] = 1, dmost[3] = ydim-umost[3];
		umost[4] = 1, dmost[4] = ydim-umost[4];
		umost[xdim-1] = 5, dmost[xdim-1] = ydim-umost[xdim-1];
		umost[xdim-2] = 3, dmost[xdim-2] = ydim-umost[xdim-2];
		umost[xdim-3] = 2, dmost[xdim-3] = ydim-umost[xdim-3];
		umost[xdim-4] = 1, dmost[xdim-4] = ydim-umost[xdim-4];
		umost[xdim-5] = 1, dmost[xdim-5] = ydim-umost[xdim-5];
		drawscreen(1);

		//drawsprite(160,16,64,34,0);          //draw the demo sign (sprite 34)
		//drawspriterot(x,y,ang,siz,walnume,shadeoffs);          Coming soon

		nextlettercnt++;
		if (nextlettercnt >= 8)          //get next letter coming in from the
		{                                //right for the sign
			nextlettercnt = 0;
			nextletter = signmessage[signcharcnt];
			signcharcnt++;
			if (signcharcnt >= signleng)
				signcharcnt = 0;
		}
		copytilepiece(84,17,48,95,8,84,16,48,0);           //animate the sign
		copytilepiece(85,((nextletter&15)<<3)+nextlettercnt,(nextletter>>4)<<3,1,8,84,111,48,13);

		engineinput();  //check arrow keys, mouse, and update accordingly
		//engineinputingame();//Replace engineinput() with engineinputingame()
									 //to use the subroutine I have included in game.c

		if (keystatus[0x39] > 0)   //press spacebar for electricution effect!
		{
			posx += (rand()&64)-32;    //randomly add small numbers to your
			posy += (rand()&64)-32;    //coordinates
			posz += (rand()&64)-32;
			ang += (rand()&16)-8;
		}
		if (keystatus[0x1d] > 0)   //press L-CTRL for lighting effect!
		{
			if (brightenarea < 6)
				brightenarea++;
		}
		else
		{
			if (brightenarea > 0)
				brightenarea--;
		}
		nextpage();
	}
	uninitengine();

	if (numargs != 4)                      //Don't show statistics if loaded
		showengineinfo(1);                  //Build from within editbord
}

engineinputingame()
{
	int i;

	if (vel < 0)
	{
		vel+=(clockspeed>>3)+1;
		if (vel > 0) vel = 0;
	}
	if (vel > 0)
	{
		vel-=(clockspeed>>3)+1;
		if (vel < 0) vel = 0;
	}
	if (svel < 0)
	{
		svel+=(clockspeed>>2)+1;
		if (svel > 0) svel = 0;
	}
	if (svel > 0)
	{
		svel-=(clockspeed>>2)+1;
		if (svel < 0) svel = 0;
	}
	if (hvel < 0)
	{
		hvel+=(clockspeed>>2)+1;
		if (hvel > 0) hvel = 0;
	}
	if (hvel > 0)
	{
		hvel-=(clockspeed>>2)+1;
		if (hvel < 0) hvel = 0;
	}
	if (angvel < 0)
	{
		angvel+=(clockspeed>>1)+1;
		if (angvel > 0) angvel = 0;
	}
	if (angvel > 0)
	{
		angvel-=(clockspeed>>1)+1;
		if (angvel < 0) angvel = 0;
	}
	if (keystatus[0x9d] == 0)
	{
		if (keystatus[0xcb] > 0) angvel -= 10;
		if (keystatus[0xcd] > 0) angvel += 10;
	}
	else
	{
		if (keystatus[0xcb] > 0) svel += 6;
		if (keystatus[0xcd] > 0) svel -= 6;
	}
	if (keystatus[0x1e] > 0) hvel -= 6;
	if (keystatus[0x2c] > 0) hvel += 6;
	if (keystatus[0xc8] > 0) vel += 6;
	if (keystatus[0xd0] > 0) vel -= 6;

	if (vel < -16) vel = -16;
	if (vel > 16) vel = 16;
	if (svel < -16) svel = -16;
	if (svel > 16) svel = 16;
	if (hvel < -16) hvel = -16;
	if (hvel > 16) hvel = 16;
	if (angvel < -24) angvel = -24;
	if (angvel > 24) angvel = 24;

	if (keystatus[0x2a] > 0)
	{
		vel += vel;
		svel += svel;
		hvel += hvel;
	}
	if (keystatus[88] > 0)
	{
		screencapture();
		keystatus[88] = 0;
	}
	if (angvel != 0)
	{
		ang += ((angvel*clockspeed)>>3);
		ang = (ang+2048)&2047;
	}
	if (vel != 0)
		clipmove(vel*clockspeed);
	if (svel != 0)
	{
		ang = ((ang+1536)&2047);
		clipmove(svel*clockspeed);
		ang = ((ang+512)&2047);
	}
	if (hvel != 0)
	{
		posz += ((hvel*clockspeed)<<3);
		if (posz < 0) posz = 0;
		if (posz > 65535) posz = 65535;
	}
	posz = (posz+posz+posz+newposz)>>2;
}
