#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include <math.h>

extern long kdmsamplerate, kdmnumspeakers, kdmbytespersample;
extern void kdmrendersound (void *, long);
extern long kdmload (char *);
extern void kdmmusicon ();
extern void kdmmusicoff ();

	//Global window variables
HWND ghwnd;
HINSTANCE ghinst, ghpinst;
LPSTR gcmdline;
int gncmdshow;

char displaybuf[256];
char *programname = "KDMwin", curfilename[256];
static char keystatus[256];
OPENFILENAME ofn;

//MultiMedia Sound Data & Code begins-------------------------------------
#define SOUNDBUFFERS 4
HWAVEOUT WaveOut;
WAVEHDR WaveOutHdr[SOUNDBUFFERS];
HGLOBAL hsoundbuf[SOUNDBUFFERS];
void *soundbuf[SOUNDBUFFERS];
long soundbufdoneflag = 0x80000000, soundbufside = 0, bufleng = 0;

initsound(long dasamplerate, long danumspeakers, long dabytespersample)
{
	WAVEOUTCAPS WaveOutCaps;
	PCMWAVEFORMAT mywaveformat;
	char tempbuf[256], tempbuf2[256];
	MMRESULT m;
	long i;

	kdmsamplerate = dasamplerate; kdmnumspeakers = danumspeakers; kdmbytespersample = dabytespersample;
		//dwFormats:
		//WAVE_FORMAT_1M08:D0,WAVE_FORMAT_1S08:D1,WAVE_FORMAT_1M16:D2,WAVE_FORMAT_1S16:D3
		//WAVE_FORMAT_2M08:D4,WAVE_FORMAT_2S08:D5,WAVE_FORMAT_2M16:D6,WAVE_FORMAT_2S16:D7
		//WAVE_FORMAT_4M08:D8,WAVE_FORMAT_4S08:D9,WAVE_FORMAT_4M16:D10,WAVE_FORMAT_4S16:D11
	waveOutGetDevCaps(0,&WaveOutCaps,sizeof(WaveOutCaps));
	if (!(WaveOutCaps.dwFormats&0xaaa)) kdmnumspeakers = 1;
	if (!(WaveOutCaps.dwFormats&0xccc)) kdmbytespersample = 1;
	if (!(WaveOutCaps.dwFormats&0xf00)) kdmsamplerate = 22050;
	if (!(WaveOutCaps.dwFormats&0xff0)) kdmsamplerate = 11025;

	mywaveformat.wf.wFormatTag = WAVE_FORMAT_PCM;
	mywaveformat.wf.nChannels = kdmnumspeakers;
	mywaveformat.wf.nSamplesPerSec = kdmsamplerate;
	mywaveformat.wf.nAvgBytesPerSec = kdmsamplerate*kdmnumspeakers*kdmbytespersample;
	mywaveformat.wf.nBlockAlign = kdmnumspeakers*kdmbytespersample;
	mywaveformat.wBitsPerSample = (kdmbytespersample<<3);
	if ((m = waveOutOpen(&WaveOut,WAVE_MAPPER,(const struct tWAVEFORMATEX *)&mywaveformat,(long)ghwnd,0L,WAVE_ALLOWSYNC|CALLBACK_WINDOW)) != 0)
	{
		waveOutGetErrorText(m,tempbuf2,256);
		sprintf(tempbuf,"%s",tempbuf2);
		MessageBox(0,tempbuf,"Tough luck",MB_OK);
		return(-1);
	}

	bufleng = kdmsamplerate-(kdmsamplerate%(kdmbytespersample*kdmnumspeakers));

		//BUFLENG MUST BE MULTIPLE OF SAMPLERATE/120!
	bufleng -= (bufleng%(kdmsamplerate/120));

	for(i=0;i<SOUNDBUFFERS;i++)
	{
		hsoundbuf[i] = GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE,bufleng);
		soundbuf[i] = (void *)GlobalLock(hsoundbuf[i]);

		WaveOutHdr[i].lpData = (char *)soundbuf[i];
		WaveOutHdr[i].dwBufferLength = bufleng;
		WaveOutHdr[i].dwBytesRecorded = 0;
		WaveOutHdr[i].dwUser = 0;
		WaveOutHdr[i].dwFlags = 0; //WHDR_BEGINLOOP|WHDR_ENDLOOP?;
		WaveOutHdr[i].dwLoops = 1;
		waveOutPrepareHeader(WaveOut,&WaveOutHdr[i],sizeof(WAVEHDR));
	}

	soundbufdoneflag = SOUNDBUFFERS;
	return(0);
}

void uninitsound ()
{
	long i;

	waveOutReset(WaveOut);
	waveOutClose(WaveOut);

	for(i=0;i<SOUNDBUFFERS;i++)
	{
		waveOutUnprepareHeader(WaveOut,&WaveOutHdr[i],sizeof(WAVEHDR));
		GlobalFree(hsoundbuf[i]);
	}
	soundbufdoneflag = 0x80000000;
}

void soundbreath ()
{
	long i;

	while (soundbufdoneflag > 0)
	{
		soundbufdoneflag--;
		i = (soundbufside%SOUNDBUFFERS);
		kdmrendersound(soundbuf[i],bufleng);
		waveOutWrite(WaveOut,&WaveOutHdr[i],sizeof(WAVEHDR));
		soundbufside++;
	}
}
//MultiMedia Sound Data & Code ends --------------------------------------

LONG FAR PASCAL Handlers(HWND hwnd,unsigned msg,UINT wparam,LONG lparam)
{
	PAINTSTRUCT ps;
	HDC hDC;
	RECT rect;

	switch(msg)
	{
		case WM_PAINT:
			hDC = BeginPaint(hwnd,&ps);
			SetTextAlign(hDC,TA_CENTER);
			SetBkColor(hDC,0x808080);
			GetClientRect(hwnd,&rect);
			TextOut(hDC,(rect.left+rect.right)>>1,rect.top,displaybuf,strlen(displaybuf));
			EndPaint(hwnd,&ps);
			break;
		case WM_KEYDOWN: keystatus[((lparam>>16)&127)+((lparam>>17)&128)] = 1; break;
		case WM_KEYUP: keystatus[((lparam>>16)&127)+((lparam>>17)&128)] = 0; break;
		case MM_WOM_DONE:
			soundbufdoneflag++;
			soundbreath();  //This makes playback work during opening files
			break;
		case WM_DESTROY:
			kdmmusicoff();
			uninitsound();
			PostQuitMessage(0);
			break;
		default: return(DefWindowProc(hwnd,msg,wparam,lparam));
	}
	return(0);
}

int PASCAL WinMain(HINSTANCE hinst, HINSTANCE hpinst, LPSTR cmdline, int ncmdshow)
{
	WNDCLASS wc;
	MSG msg;
	HDC hDC;
	long i, argc;
	char *argv[64], tempbuf[256];
	
	ghinst = hinst; ghpinst = hpinst; gcmdline = cmdline; gncmdshow = ncmdshow;

	argv[0] = programname; argc = 1;
	if (cmdline[0] != 0)
	{
		if ((cmdline[0] != ' ') && (cmdline[0] != 9)) argv[argc++] = cmdline;
		for (i=1;cmdline[i];i++)
		{
			if ((cmdline[i-1] != ' ') && (cmdline[i-1] != 9)) continue;
			cmdline[i-1] = 0;
			if ((cmdline[i] != ' ') && (cmdline[i] != 9)) argv[argc++] = &cmdline[i];
		}
	}

	if (argc != 2)
	{
		curfilename[0] = 0;
		tempbuf[0] = 0;

		ofn.lStructSize = sizeof(OPENFILENAME);
		ofn.hwndOwner = NULL; //ghwnd;
		ofn.hInstance = ghinst;
		ofn.lpstrFilter = "Ken's Digital Music file (*.KDM)\0*.kdm\0";
		ofn.lpstrDefExt = "kdm";
		ofn.nFilterIndex = 1;
		ofn.lpstrFile = tempbuf; ofn.nMaxFile = sizeof(tempbuf);
		ofn.lpstrFileTitle = curfilename; ofn.nMaxFileTitle = sizeof(curfilename);
		ofn.lpstrInitialDir = NULL; //NULL means use current directory
		ofn.lpstrTitle = "Open KDM file";
		ofn.Flags = OFN_SHOWHELP|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT; //OFN_NOCHANGEDIR
		if (!GetOpenFileName(&ofn))
		//   strcpy(curfilename,ofn.lpstrFile);
		//else
		{
			MessageBox(0,"Please specify a filename",programname,MB_OK);
			return(1);
		}
	}
	else
	{
			//Chop off quotes at beginning and end of filename
		for(i=strlen(argv[1]);i>0;i--)
			if (argv[1][i-1] == '\\')
				break;
		i = max(i,(argv[1][0] == '\"'));
		strcpy(curfilename,&argv[1][i]);
		if (curfilename[0] == 0) return(-1);
		if (curfilename[strlen(curfilename)-1] == '\"') curfilename[strlen(curfilename)-1] = 0;
		strlwr(curfilename);
		if (!strstr(curfilename,".kdm")) strcat(curfilename,".kdm");
	}

	if (ghwnd = FindWindow(programname,programname)) SendMessage(ghwnd,WM_DESTROY,0,0);
	
	if (!hpinst)
	{
		wc.style = CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc = (LPVOID)Handlers;
		wc.cbClsExtra = 0; wc.cbWndExtra = 0;
		wc.hInstance = ghinst;
		wc.hIcon = LoadIcon(0,IDI_APPLICATION);
		wc.hCursor = LoadCursor(0,IDC_ARROW);
		wc.hbrBackground = GetStockObject(BLACK_BRUSH);
		wc.lpszMenuName = "      KensMenu"; wc.lpszClassName = programname;
		if (!RegisterClass(&wc)) return(0);
	}
	hDC = GetDC(0);
	i = GetDeviceCaps(hDC,VERTRES);
	ReleaseDC(0,hDC);
	if (!(ghwnd = CreateWindow(programname,programname,WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME & ~WS_MAXIMIZEBOX,(GetSystemMetrics(SM_CXSCREEN)-248)>>1,i-68,248,38,0,0,ghinst,0)))
		return(0);

	ShowWindow(ghwnd,SW_SHOWMINNOACTIVE); //gncmdshow);

	if (initsound(44100,2,2) < 0) return(1);
	if (kdmload(curfilename) < 0)
	{
		sprintf(tempbuf,"File not found (%s)",curfilename);
		MessageBox(0,tempbuf,programname,MB_OK);
		return(1);
	}
	kdmmusicon();
	sprintf(displaybuf,"%s, %5ldhz, Speed:%ld",curfilename,kdmsamplerate,240); //speed);

	UpdateWindow(ghwnd);

	while (1)
	{
		while (PeekMessage(&msg,0,0,0,PM_REMOVE))
		{
			if (msg.message == WM_QUIT) return(msg.wParam);
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if (keystatus[1]) PostMessage(ghwnd,WM_CLOSE,0,0);
#if 0
		if (keystatus[0x33])  // <,
		{
			keystatus[0x33] = 0;
			i = speed;
			speed = max(((speed*7)>>3),60);
			if ((i > 240) && (speed < 240)) speed = 240;
			sprintf(displaybuf,"%s, %5ldhz, Speed:%ld",curfilename,kdmsamplerate,speed);
			InvalidateRect(ghwnd,0,1);
		}
		if (keystatus[0x34])  // >.
		{
			keystatus[0x34] = 0;
			i = speed;
			speed = min(((speed*9)>>3),960);
			if ((i < 240) && (speed > 240)) speed = 240;
			sprintf(displaybuf,"%s, %5ldhz, Speed:%ld",curfilename,kdmsamplerate,speed);
			InvalidateRect(ghwnd,0,1);
		}
#endif
		if (keystatus[0x26]) //L
		{
			keystatus[0x26] = 0;
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = ghwnd;
			ofn.hInstance = ghinst;
			ofn.lpstrFilter = "Ken's Digital Music file (*.KDM)\0*.kdm\0";
			ofn.lpstrDefExt = "kdm";
			ofn.nFilterIndex = 1;
			ofn.lpstrFile = curfilename; ofn.nMaxFile = sizeof(curfilename);
			ofn.lpstrFileTitle = tempbuf; ofn.nMaxFileTitle = sizeof(tempbuf);
			ofn.lpstrInitialDir = NULL; //NULL means use current directory
			ofn.lpstrTitle = "Open KDM file";
			ofn.Flags = OFN_SHOWHELP|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT; //OFN_NOCHANGEDIR
			if (GetOpenFileName(&ofn))
			{
				kdmmusicoff();
				if (kdmload(ofn.lpstrFile) < 0)
				{
					sprintf(tempbuf,"File not found (%s)",ofn.lpstrFile);
					MessageBox(0,tempbuf,programname,MB_OK);
				}
				else
				{
					strcpy(curfilename,tempbuf);

					sprintf(displaybuf,"%s, %5ldhz, Speed:%ld",curfilename,kdmsamplerate,240); //speed);
					InvalidateRect(ghwnd,0,1);
				}
				kdmmusicon();
			}
		}
		soundbreath();
	}
	return(1);
}
