;==========================================KEYBOARD HANDLER=====================================
;handle the keypresses - the callback subroutine-names below are found in the datatables.inc file

keyer	;C64 keyboard handler (scanner) routine  ;zeropage variables can be seen in main source
		lda #0
		sta zpkeysi ;keypress sign (nonzero, if key was pressed, Shift & C= are exceptions)
		sta zpkeyco
		lda #$fe
		sta zpkcsel ;will rotate through keymatrix columns
		jsr shcbget ;shift & CBM key requester
keylp2	lda zpkcsel  ;check keymatrix column 7..0
		sta $dc00
		ldy #0
		sty zpkeyro
		iny
		sty zpkyand
keylp1	lda $dc01
		cmp #$ff  ;much faster pre-testing, why should we examine column, if no keypress at all there?
		beq colcach 
		and zpkyand  ;check keymatrix row 7..0
		bne morekey
		;a key was pressed, branch to its routine
		lda zpkeyco ;calculate jump-address from row & column
		asl
		asl
		asl ;..x8
		asl ;x2 (word-iterator)
		sta adder+1 ;self writing code to store accu
		lda zpkeyro
		asl ;jump-addresses are given in words, so multiply by 2
		clc
adder	adc #00 ;self-written (accu restore)
		tay	;Y is keycode here
		cpy #30 ;Left-Shift?   -not to count shift/cbm keys now, done already in 'shcbget'
		beq morekey ;check next
		cpy #104 ;Right-Shift?
		beq morekey ;check next
		cpy #122 ;C= key?
		beq morekey ;check next
		cpy zprvkey ;compare previous key to actual, if different, reset repeat-counter
		beq + ;if the same key is pressed, no counter-reset
		ldx #respd1 ;no pressed key, repeatcounter resets
		stx repecnt ;using X to preserve A
+		sty zprvkey
		
		ldx namemode ;name-typing mode?
		beq +
		jmp nametyper
		+
		
.if COMPILEDAPP=1 ;next part needed for editor only		
		ldx menumode
		beq +     ;if menu, just a list of some keys are allowed (cursor u/d, +/-, ESC/F8, RETURN, etc.)
		ldx #(endmenukeys-menukeys)-1
-		tya
		cmp menukeys,x
		beq +
		dex
		bpl -
		rts
		
+		lda keyjmp,y          ;(if different jumptable for Shift/CBM, examine them here - not yet considered)
		sta jumper+1
		lda keyjmp+1,y
		sta jumper+2 
jumper	jmp $1111     ;jump to the given address from keytable
.FI
		 
menukeys ;    ret,F7 ,curdn,stop,+  ,-  ,F1 ,F3 
		.byte $02,$06,$0e  ,$7e ,$50,$56,$08,$0a ;allowed key-codes in menu (multplied by 2)
endmenukeys
;-----------------------------------------------------------
morekey inc zpkeyro     ;check for other keys if not found pressed
		asl zpkyand
		bcc keylp1
colcach	inc zpkeyco
		sec
		rol zpkcsel
		bcs keylp2
		
.if COMPILEDAPP=1 ;next part needed for editor only		
restsig	lda #0 ;self-written variable ;signs that there was restore pressed
		beq nokey      ;check if restore key was pressed, and perform Page-UP if was
		lda #0
		sta restsig+1
		inc shiftsi
		jmp slasher
.FI
		
nokey	lda zpkeysi
		bne retkey
		lda #respd1 ;no pressed key, repeatcounter resets
		sta repecnt
.if COMPILEDAPP=1 ;next part needed for editor only
		lda #0
		sta jamnote+1
.FI
retkey	rts         ;return from key-handler routine

;-----------------------------------------------------------
repeat  ;repeat-counter routine, output: Z-flag = 1 if first / repeat can be done
		lda repecnt ;keyrepeat-counter
		bne norsrep ;check, if repeat counter is 0
		lda #repspd2 ;if 0, reset counter to repeatspeed 2, returning Z-flag = 0
		sta repecnt
		rts
norsrep	cmp #respd1 ;check, of repeat counter is initial value (repeatspeed 1)
		bne repcan  ;if no, then just decrease the repeat counter
		dec repecnt ;if yes, decrease by one, and reset Z-flag - repeat possible
		lda #0
		rts
repcan	lda ptrdysi ;should wait for pattern-redraw? 
		bne + ;if nonzero, repeater should wait for pattern-redrawing
		dec repecnt ;if 0 happens, a repeat occurs, next round will reset to speed 2
+		rts

;=================================
retukey	inc zpkeysi  ;keypress sign (counts simultaneously pressed keys)
		jmp morekey ;return from multiple oriented keyroutines

dummykey
		;inc $d021     ;dummy handler for unused keys
		jmp retukey
keyret0 rts


.if COMPILEDAPP=1 ;next part needed for editor only

;*******************************************KEYBOARD-INITIATED ROUTINES********************************

;===================================HEXA KEYS==================================
;hexa-key handler routines  - datawriter subroutine is in datawriter.inc

key0sub ;handle key '0' - value-typing (2), note-entry (D#), jamming (D#)
		ldy #$00 ;value 2
		ldx #12+12+4 ;D# in the second higher keyboard octave
		jmp writevalue  ;write value into actual windowposition

key1sub ;handle key '1' - value-typing (1), note-entry (no note for this), jamming (no note)
		lda cbmsig ;C= key signal (00-no C=, 01- C= pressed )
		beq +
		lda #0
		sta jamoctave+1
		rts
+		ldx shiftsi ;shift key signal (00- no shift, 01- l/r shift was pressed)
		beq +
		jsr repeat
		bne key1ret
		ldy #0 ;mute track 1
mutYtrk	lda mutesolo,y ;mute/solo track1
		eor #1
		sta mutesolo,y
		sty msorefr+1 ;refresh mute-solo colouring
key1ret	rts
+		ldy #$01 ;value for the entry stored in X
		ldx #0 ;no note to play, using for NOP placement
		jmp writevalue

key2sub ;handle key '2' - value-typing (2), note-entry (C#), jamming (C#)
		lda cbmsig
		beq +
		lda #1
		sta jamoctave+1
		rts
+		lda shiftsi
		beq +
		jsr repeat
		bne key1ret
		ldy #1 ;mute/solo track2
		jmp mutYtrk
+		ldy #$02 ;value 2
		ldx #12+2 ;C# in the higher keyboard octave
		jmp writevalue

key3sub ;handle key '3' - value-typing (3), note-entry (D#), jamming (D#)
		lda cbmsig
		beq +
		lda #2
		sta jamoctave+1
		rts
+		lda shiftsi
		beq +
		jsr repeat
		bne key4ret
		ldy #2 ;mute/solo track3
		jmp mutYtrk
+		ldy #$03 ;value 2
		ldx #12+4 ;D# in the higher keyboard octave
		jmp writevalue

key4sub ;handle key '4' - value-typing (4), note-entry (no note), jamming (no note)
		lda cbmsig
		beq +
		lda #3
		sta jamoctave+1
key4ret	rts
+		ldy #$04 ;value 2
		ldx #$ff ; no note for key 4
		jmp writevalue

key5sub ;handle key '5' - value-typing (5), note-entry (F#), jamming (F#)
		lda cbmsig
		beq +
		lda #4
		sta jamoctave+1
key5ret	rts
+		ldy #$05 ;value 2
		ldx #12+7 ;F# in the higher keyboard octave
		jmp writevalue

key6sub ;handle key '6' - value-typing (6), note-entry (G#), jamming (G#)
		lda cbmsig
		beq +
		lda #5
		sta jamoctave+1
key6ret	rts
+		ldy #$06 ;value 2
		ldx #12+9 ;G# in the higher keyboard octave
		jmp writevalue

key7sub ;handle key '7' - value-typing (7), note-entry (A#), jamming (A#)
		lda cbmsig
		beq +
		lda #6
		sta jamoctave+1
key7ret	rts
+		ldy #$07 ;value 2
		ldx #12+11 ;A# in the higher keyboard octave
		jmp writevalue

key8sub ;handle key '8' - value-typing (8), note-entry (no note), jamming (no note)
		lda cbmsig
		beq +
		lda #7
		sta jamoctave+1
key8ret	rts
+		ldy #$08 ;value 2
		ldx #$ff ;no note for key 8
		jmp writevalue

key9sub ;handle key '9' - value-typing (9), note-entry (C#), jamming (C#)
		ldy #$09 ;value 2
		ldx #12+12+2 ;C# in the second higher keyboard octave
		jmp writevalue

keyAsub ;handle key 'A' - value-typing (A), note-entry (no note), jamming (no note)
		lda shiftsi
		beq norakey
		jsr repeat
		bne keyAret
		lda autoadv ;toggle autoadvance mode
		cmp #$0f
		beq keyAret
		inc autoadv
keyAret	rts
norakey	ldy #$0A ;value 2
		ldx #0 ;no note assigned for key A, using it for NOP
		jmp writevalue

keyBsub ;handle key 'B' - value-typing (B), note-entry (G), jamming (G)
		lda shiftsi
		beq norbkey
		jsr repeat
		bne keyBret
		lda bindtrk ;toggle track-binding
		eor #1
		sta bindtrk
keyBret	rts
norbkey	ldy #$0B ;value 2
		ldx #0+8 ;G in the lower keyboard octave
		jmp writevalue

keyCsub ;handle key 'C' - value-typing (C), note-entry (E), jamming (E)
		lda cbmsig ;check CTRL+C - copy
		ora shiftsi ;if shift+C, that also Copy setting - in copier it signs end of selection
		beq norCkey
		jsr repeat
		bne keyBret
		lda actwind
		bne + ;if not patternwindow
		jmp copytobuf ;copy patterndata (from cursorposition) to buffer		
+		cmp #2
		bne keyBret   ;copy instrument if it´s instrument window
CopyIns	jsr setinsptr
		ldx #maxinstsize-1
-		jsr instpt1
		sta instbuffer,x
		dex
		bpl -
		rts
norCkey	ldy #$0C ;value 2
		ldx #0+5 ;E in the lower keyboard octave
		jmp writevalue

keyDsub ;handle key 'D' - value-typing (D), note-entry (D#), jamming (D#)
		lda shiftsi
		beq norDkey
		jsr repeat
		bne doveret
		lda dovetail
		eor #1
		sta dovetail
doveret	rts
norDkey	ldy #$0D ;value 2
		ldx #0+4 ;D# in the higher keyboard octave
		jmp writevalue

keyEsub ;handle key 'E' - value-typing (E), note-entry (E), jamming (E)
		ldy #$0E ;value 2
		ldx #12+5 ;E in the higher keyboard octave
		jmp writevalue


;================================================NOTE KEYS=====================

wkeysub	lda shiftsi
		beq choctra ;if shift pressed, transpose up halfnote
transup	jsr repeat  ;check & handle repeat counter
		bne keyBret ;if Zero flag=0, then no repeat (go to returner)
		ldx #1 ;amount to add to note (increase by 1)
		jmp transptn ;transpose actual pattern from cursorposition down (insdelcopy.inc)
choctra	lda cbmsig
		beq norWkey ;if cbm-key pressed, transpose up 1 octave
		jsr repeat  ;check & handle repeat counter
		bne keyBret ;if Zero flag=0, then no repeat (go to returner)
		ldx #12 ;amount to add to note - if CBM pressed, an octave (12 halftones)
		jmp transptn ;transpose actual pattern from cursorposition down (insdelcopy.inc)		
norWkey	ldx #12+3 ;'D' note in upper octave 
		jmp notecol
		
starkey ; * key subruitine
		lda shiftsi
		bne transup
		rts
		
zkeysub	lda shiftsi
		beq norZkey
		jsr repeat
		bne +
		lda autoadv
		beq +
		dec autoadv
+		rts
norZkey	ldx #0+1  ;'C' note in lower octave
		jmp notecol
		
skeysub	ldx #0+2  ;'C#' note in lower octave
		lda shiftsi
		beq +
		ldx #SYNCONFX ;SYNC-BIT ON to note-column
+		lda cbmsig
		beq +
		ldx #SYNCOFFX ;SYNC-BIT OFF to note-column
+		jmp notecol
		
rkeysub	ldx #12+6 ;'F' note in upper octave
		lda shiftsi
		beq +
		ldx #RINGONFX ;RING-BIT ON to note-column
+		lda cbmsig
		beq +
		ldx #RINGOFFX ;RING-BIT OFF to note-column
+		jmp notecol
		
xkeysub	lda cbmsig
		beq norXkey
		jsr repeat
		bne retpnt2
		lda actwind
		bne + ;pattern-window?
		jmp cutandcopy ;cut patterndata from cursorposition, copy cut data to buffer
+		cmp #2 ;cut instrument? (copy to buffer, then delete)
		bne + ;instrument-window?
		jsr CopyIns
		lda inszptr+0
		sta decozptr+0 ;won't interfere, because decozptr is only used when compressing/decompressing
		lda inszptr+1
		sta decozptr+1
		jsr EmptIns
+		rts
norXkey	ldx #0+3  ;'D' note in lower octave
		jmp notecol
		
ykeysub	lda shiftsi
		beq norykey
		jsr repeat
		bne retpnt2
inctmpp	lda seltemp+1 ;increment tempoprg number
		cmp #MAXTEMPOPRAMOUNT-2  ;$3e ;just $3e, $3f wouldn't be well recognized in length at insertion 
		beq retpnt2
		inc seltemp+1
tmpzero	ldx #0
		lda #4 ;tempowindow number
		jmp chthome
norykey	ldx #12+10 ;'A' note in upper octave
		jmp notecol
		
gkeysub	lda shiftsi
		beq norgkey ;check SHIFT
		jsr repeat  ;check & handle repeat counter
		bne noincfs ;if Zero flag=0, then no repeat (go to returner)
		lda framesp
		cmp #8
		beq noincfs
		inc framesp ;SHIFT+F - increase fremespeed
noincfs	rts
norgkey	ldx #0+7  ;'F#' note in lower octave
		jmp notecol
		
hkeysub	lda shiftsi
		beq norhkey
		jsr repeat
		bne retpnt2
		lda stpthck  ;decrease highlight step
		cmp #1
		beq retpnt2
		dec stpthck
		inc hilrefr+1 ;refresh step-highlighting
retpnt2	rts
norhkey	ldx #0+9  ;'G#' note in lower octave
		jmp notecol
		
ukeysub	ldx #12+12 ;'H' note in upper octave
		jmp notecol
		
vkeysub	lda cbmsig
		beq nocVkey
		jsr repeat
		bne retpnt2
		lda actwind
		bne + ;if not patternwindow
		jmp pastebuf ;jsr pastebuf  ;paste buffer data starting with cursorposition in target pattern	
+		cmp #2
		bne vkeyret  ;paste instrument if it´s instrument window
		jsr setinsptr
		ldx #maxinstsize-1
-		lda instbuffer,x
		jsr instpt2
		dex
		bpl -
vkeyret	rts
nocVkey	ldx #0+6  ;'F' note in lower octave
		lda shiftsi
		beq +
		ldx #$66   ;Vibrato into note column  
+		jmp notecol

ikeysub	ldx #12+12+1  ;'C' note in 2nd upper octave
		jmp notecol

jkeysub	lda shiftsi
		beq norjkey
		jsr repeat
		bne nothinc
		lda stpthck ;increase highlight step
		cmp #$10
		beq nothinc
		inc stpthck
		inc hilrefr+1 ;refresh step-highlighting
nothinc	rts
norjkey	ldx #0+11  ;'A#' note in lower octave
		jmp notecol

mkeysub	ldx #0+12  ;'H' note in lower octave
		jmp notecol
okeysub	ldx #12+12+3  ;'D' note in 2nd upper octave
		jmp notecol
		
nkeysub	lda shiftsi
		beq norNkey
		jsr repeat
		bne vkeyret
		;rename instrument
		inc namemode ;tell keyhandler it's instrument naming mode
		lda #inamesize-1 
		sta compzvar4
		lda #<vidram+$20
		ldx #>vidram+$20
		jmp setyfl2
norNkey	ldx #0+10  ;'A' note in lower octave
		jmp notecol
		
pkeysub	lda cbmsig
		beq +
.IF PWRESETSW_ON
		jsr repeat
		bne nothinc ;toggle pulse-reset on instrument-notestart
		jsr setinsptr 
		ldx #0
		jsr instpt1
		eor #$40
		jsr instpt2
		jmp goirefr
.ELSE
		rts
.FI
+		ldx #12+12+5  ;'E' note in 2nd upper octave
		lda shiftsi
		beq +
		ldx #PORTAMFX ;autoportamento in note column
+		jmp notecol

lkeysub	lda shiftsi
		beq norlkey ;check SHIFT
		jsr repeat  ;check & handle repeat counter
		bne nothinc ;noincch ;if Zero flag=0, then no repeat (go to returner)
incchor	lda selchor+1
		cmp #MAXCHORDAMOUNT-2 ;$3e ;to be safe about insertion length in last chord, it's $3E not $3F
		beq nothinc ;noincch
		inc selchor+1;SHIFT+K - increase chordnumber
chdzero	ldx #0
		lda #3 ;chordwindow number
		jmp chthome
norlkey	ldx #12+2  ;'C#' note in upper octave at lower row
		jmp notecol
		
qkeysub	lda shiftsi
		beq choctr2
transdn	jsr repeat  ;check & handle repeat counter
		bne keyret8 ;if Zero flag=0, then no repeat (go to returner)
		ldx #$ff ;amount to add to note (decrease by 1)
		jmp transptn ;transpose actual pattern from cursorposition down (insdelcopy.inc)
choctr2	ldy cbmsig
		beq norQkey
		jsr repeat  ;check & handle repeat counter
		bne keyret8 ;if Zero flag=0, then no repeat (go to returner)
		ldx #$f4  ;if CBM/Control key is on, transpose a whole uctave down
		jmp transptn ;transpose actual pattern from cursorposition down (insdelcopy.inc)		 
norQkey	ldx #12+1  ;'C' note in upper octave
		jmp notecol

atkeysub  ;for @ key
		lda shiftsi
		bne transdn
		rts
		
;-----------------------
fkeyer  ;F key handler
		lda shiftsi ;check SHIFT key
		beq +
		jsr repeat  ;check & handle repeat counter
		bne keyret8 ;if Zero flag=0, then no repeat (go to returner)
		lda framesp
		cmp #1
		beq keyret8
		dec framesp ;C= + F - decrease framespeed
keyret8	rts
+		lda cbmsig
		beq +
.IF FILTRESETSW_ON
		jsr repeat
		bne keyret8 ;toggle filter-reset on instrument-notestart
		jsr setinsptr 
		ldx #0
		jsr instpt1
		eor #$80
		jsr instpt2
		jmp goirefr
.ELSE
		rts
.FI
+		ldy #$0f
		ldx #$ff ; no sound produced on F key for jamming
		jmp writevalue 
		
;-----------------------
tkeyer  ;T key handler
		lda cbmsig ;if cbm+F, toggle single/funktempo of subtune
		beq +
.IF TEMPOPRGSUPP_ON
		jsr repeat  ;check & handle repeat counter
		bne keyret8 ;if Zero flag=0, then no repeat (go to returner)
		jsr calcsubsp1
		eor #$80        ;toggle subtune-funktempo
		jmp setstm2
.ELSE
		rts
.FI
+		lda shiftsi 
		beq nortkey
		jsr repeat
		bne keyret8 ;decrement tempoprogram
dectmpp	lda seltemp+1 
		cmp #1
		beq keyret8
		dec seltemp+1
		jmp tmpzero
nortkey	ldx #12+8 ;'G' note in upper octave
		jmp notecol; musical note for T key
;------------------------
kkeyer  ;K key handler
		lda shiftsi  ;check SHIFT key
		beq keyret8
		jsr repeat
		bne keyret8
decchor	lda selchor+1
		cmp #1
		beq keyret8 ;keyreta
		dec selchor+1 ;Shift + K - decrease chordnumber
		jmp chdzero

;===================================================CONTROLLER KEYS============

pluser	;plus (+) key handler
		jsr repeat  ;check & handle repeat counter
		bne keyret8 ;if Zero flag=0, then no repeat (go to returner)
		lda menumode
		beq norplus
		lda menucurpos  ;signs pattern-length setting
		cmp #ptlenmenupt ;pattern-length setter menupoint's number
		bne norplus ;if no patternlength-setting
		lda defptlen
		cmp #maxptnlen-1
		beq keyrett
		inc defptlen
keyrett	rts 
norplus	lda shiftsi
		bne incinst ;check SHIFT
		lda actwind
		cmp #3
		bmi incinst ;if ptn/orderlist/instrument window, no need for shit to +/- to select instrument 
		bne + ;if chordwindow
		jmp incchor ;increment chordnumber
+		cmp #4
		bne keyrett
		jmp inctmpp ;increment tempoprogram
incinst	lda selinst+1
		cmp #maxinstamount-1  ;minus 1, because last instrument is the buffer for instrument copying
		beq retpntX ;nothinc ;noincis
		inc selinst+1;SHIFT + PLUS - increase inst.number
		jmp instinit ;jsr instinit

;----------------------
minuser	;minus (-) key handler
		jsr repeat  ;check & handle repeat counter
		bne retpntX ;nodecis ;keyret2 ;if Zero flag=0, then no repeat (go to returner)
		lda menumode
		beq norminu
		lda menucurpos  ;signs pattern-length setting
		cmp #ptlenmenupt ;pattern-length setter menupoint's number
		bne norminu
		lda defptlen
		cmp #1
		beq +
		dec defptlen
+		rts 
norminu	lda shiftsi
		bne decinst ;check SHIFT
		lda actwind
		cmp #3
		bmi decinst
		bne +
		jmp decchor
+		cmp #4
		bne retpntX ;nodecis
		jmp dectmpp
decinst	lda selinst+1
		cmp #1
		beq retpntX ;nodecis
		dec selinst+1;SHIFT + MINUS - decrease inst.number
		jmp instinit ;jsr instinit

instinit ;initialize (zero) cursor/scroll positions at instrument-switching
        ldx #0
        lda subwpos1+2 ;are we in instrument-main table?
		beq tionly ;only table-scroll-pos init?
		stx subwpos3+2 ;zero cursor Y-position in window 2 (instr.window)
		stx subwpos2+2 ;zero cursor X-position in window 2
tionly	stx pwtbpos
		stx ctftpos
		stx wfarpos
goirefr	inc insrefr+1  ;to display it
retpntX	rts
		
;----------------------
spacer  ;SPACE key handler
		jsr repeat
		bne retpntX ;keyret3
		lda shiftsi
		beq cbmspc   ;if SHIFT not pressed
	    lda actwind
	    bne + ;patternwindow? play patterns from cursorposition
	    jsr f3play ;pattern-playing
	    ldx #2
-	    lda prowpos,x
	    clc
	    adc subwpos3+0
	    ldy actptn1,x
	    cmp ptnlength,y
	    bcs nocurp
	    sta ptrowpos,x
	    lda ptncurs,x  ;-but not from 0 position, but from cursor position
	    clc
	    adc ptn1pos,x
	    ldy mul7chn,x
	    sta PTNPOS,y
nocurp  dex
	    bpl -
	    rts
+	    cmp #1 ;orderlist?
		beq olspace ;if orderlist
		cmp #2 ;instrument-window?
		bne keyret3
.IF GATEOFFPTR_ON
		jsr setinsptr
		jsr getitbi ;get actual instrument table row pointer to X
		tay
		lda subwpos1+2 ;instrument-subwindow
		beq keyret3 ;if main instrument settings not tables
		clc
		adc #$0c-1 ;GATEOFF pointers in instrument-data
		tax  ;position
		jsr instpt1 ;check actual gate-off pointer to decide on action 
		sta icurpst+1
		bne icurpst ;if gateoff-pointer nonzero, zero if cursor is at it, otherwise modify
		tya
		jmp instpt2 ;gateoff pointer was zero, so set it to actual position
icurpst	cpy #0 ;self-written code - position of actual data under cursor
		bne +
		ldy #0
+		tya
		jmp instpt2
.ELSE
		rts
.FI
		
olspace	;set playing startpositions in orderlist
		jsr getcurptn ;get orderlist memory index under cursor to A and Y
		ldx #2
-		sta olstart,x
		dex
		bpl -
		rts
		
cbmspc	lda cbmsig
		beq normspc ;if SHIFT and CBM both ´unpressed´
setmark	ldx #2      ;set playing startpositions to currently played positions
-		ldy mul7chn,x
		lda SEQPOS,y
		sta olstart,x
		dex
		bpl -
		inc seqrefr
		rts
		
normspc	lda jammode+1  ;toggle edit/jam mode
		eor #1
		sta jammode+1
keyret3	rts

;----------------------
semidot ; (:) doublestop key handler
		lda shiftsi
		beq norsdot
		jsr repeat
		bne keyret3
		jsr calcsubsp1  		;decrement subtune-funktempo (the right one)
		bmi retpntY ;if not funktempo
		lda subtunes+1,y
		sec
		sbc #1
		bvs retpntY
		jmp setstmp
norsdot	ldx #12+4  ;'D#' note in upper octave at lower row
		jmp notecol ;musical note for : key
keyret4	jmp retukey

;----------------------
semicol ; (;) key handler
		lda shiftsi
		beq norscol
		jsr repeat
		bne keyret3
		jsr calcsubsp1  		;increment subtune-funktempo (the right one)
		bmi retpntY ;+ ;if not funktempo
		lda subtunes+1,y
		clc
		adc #1
		cmp #$c0
		bcs retpntY ;+ ;second tempo cannot be smaller than $80
setstmp	sta SUBTUNES+1,y
		sta TEMPOTBL+1
retpntY	rts
norscol	; musical note for ; key (not sure if needed or not)
keyret5	jmp retukey

;----------------------
coloner ; (,) key handler
		lda shiftsi
		beq cbmcolo
		jsr repeat
		bne retpntY
		jsr calcsubsp1   		;decrement subtune-tempo (the left one)
		sec
		sbc #1
		bcc retpntQ
		bvs retpntQ
setstm2	sta SUBTUNES,y
		sta TEMPOTBL+0
retpntQ	rts
cbmcolo	lda cbmsig
		beq norcolo
		jsr repeat
		bne retpntY 
		lda selsubt+1 ;decrement subtune
		beq retpntY 
		dec selsubt+1
		jmp resetune
norcolo	ldx #12+1  ;'C' note in upper octave at lower row
		jmp notecol; musical note for , key
		
;----------------------
dotter ; (.) key handler
		lda shiftsi
		beq cbmdot
		jsr repeat
		bne retpntY 
		jsr calcsubsp1		    ;increment subtune-tempo (the left one)
		and #$3f
		cmp #$3f
		beq retpntQ
		lda subtunes,y
		clc
		adc #1
		jmp setstm2
cbmdot	lda cbmsig
		beq normdot
		jsr repeat
		bne retpntY 
		lda selsubt+1 ;increment subtune
		cmp #maxsubtuneamount  ;maximum number of subtunes it $1f80 / ($80 * 3) = $15 = 21 , $80 left is sizelist
		beq retpntY 
		inc selsubt+1
		jmp resetune
normdot	ldx #12+3  ;'D' note in upper octave at lower row
		jmp notecol ; musical note for . key

		
;==============================================================================
cursori  ;cursor-right key handler
		jsr shcbget ;get shift/cbm key status (to make sure VICE cursorkeys work all times)
		jsr repeat  ;check & handle repeat counter
		bne keyrtbb ;if Zero flag=0, then no repeat (go to returner)
		lda shiftsi
		beq norcrri ;check SHIFT
		
norcrle	lda actwind    ;-----------------------CURSOR-TO-LEFT------------------
		bne noptcle
		dec subwpos2+0 ;window 0 (ptn) branch
		bpl keyrtbb ;retrigh
		lda #6
		sta subwpos2+0
		jmp tabptbk
		
noptcle cmp #1
		bne noseqle    ;window 1 (orderlist) branch
		lda subwpos2+1
		beq +
		dec subwpos2+1
		rts
+		lda seqdpos+1
		beq +
		dec seqdpos+1
+		rts

noseqle	cmp #2      ;instrument window branch
		bne chktmpl
		dec subwpos2+2 ;window 2 (inst)
		bpl nodecle
		lda #0
		sta subwpos2+2
keyrtbb	rts

chktmpl	tax            ;X=window 3 or 4 (chord/tempotable)
		lda subwpos2,x
		beq + ;bktoiwb
		dec subwpos2,x
nodecle	rts

norcrri	lda actwind     ;---------------------------------CURSOR-TO-RIGHT------
		bne noptcri
ptncuri	lda subwpos2+0 ;window 0
		cmp #6  ;width of pattern
		bne noincle
		lda #0
		sta subwpos2+0
		jmp tabptfw
noincle	inc subwpos2+0
		rts		
noptcri	cmp #1         
		bne noseqri  ;Orderlist is the actual window?
		jsr setseqptr  ;set the datapointer for actual orderlist position
		lda subwpos2+1  ;test if $ff is at previous place or $fe is in actual place in orderlist
		clc ;shouldn't be after lsr?
		lsr
		adc seqdpos+1 ;add cursor position
		cmp #seqlength+1
		bcs keyretb
		tay
seqstpr1 dey
seqstpr2 ldx #1
-		jsr seqaddb ;get data under orderlist cursor into A, index in orderlist is Y
		cmp #$FE  ;orderlist-end signal
		beq endolri
		dey ;lets accessing the number (jump position) after $ff
		dex
		bpl -
		cmp #$ff  ;orderlist jumper loop-signal, jump position given after
		beq keyretb
noseqend               ;orderlist (window 1) branch
		lda subwpos2+1  
		cmp #39        ;check end of orderlist-display, and if reached maximum of orderlist
		beq +
		inc subwpos2+1
		rts
+		;lda seqdpos+1
		;cmp #$ec    ;no need to check, insertion already limits patternlength
		;beq endolri
		inc seqdpos+1
		ldy valuecont   ;to check whether the cusror advance was initiated from typing - provide continous typing
		beq endolri
		lda #38
		sta subwpos2+1
		lda #0
		sta valuecont
endolri	rts
valuecont .byte 0   ;signs, if this is an autoadvance (seqstpr1) initiated from datawriter

noseqri	cmp #2
		bne chtempw     ;instrument window
inswiri	lda subwpos2+2  ;check window2 x-coord
		cmp #5
		beq + ;jptowin  ;switch windowwth cursormovement, not needed
		inc subwpos2+2
+		rts

chtempw tax           ;X=window 3 or 4 (chord/tempotable)
chtmrig	lda subwpos2,x
		cmp #1
		beq keyretb
		inc subwpos2,x
keyretb	rts


;==============================================================================
menucup	lda menucurpos ;menu corsor goes up
		cmp #firstcpos
		beq + 
		dec menucurpos
+		rts

cursrdn  ;cursor-down key handler
		jsr shcbget
		jsr repeat  ;check & handle repeat counter
		bne keyretb ;if Zero flag=0, then no repeat (go to returner)
		lda shiftsi
		beq norcrdn ;check SHIFT
;------------------------------------------------Cursor UP branch--------------

norcrup	lda menumode
		bne menucup
		lda actwind  
		bne noptcup
		;ptn-window branch
upinptn	lda subwpos3+0 ;common point to go up in pattern, used by pageup too
		beq nodecpu
		dec subwpos3+0
		rts
nodecpu ldx subwpos1+0 ;actual tracknumber
		lda bindtrk
        beq ptscrup    ;if binding is off, scroll only actual track
bindupp ldx #2
-		jsr ptscrup
		dex
		bne - ;X is 0 here, to do 1st track too...
ptscrup	lda #2 ;or 3?
		sta ptrdysi ;notifies key-repeater to wait for pattern-redraw
		lda prowpos,x
		beq +
		dec prowpos,x
+		rts
		
noptcup cmp #1
		bne noupseq     ;up-key in orderlist
		lda subwpos1+1
		bne +
		lda #2
		sta subwpos1+1
		jmp sseqend
+		dec subwpos1+1
		jmp sseqend         ;check if zero under cursor, set position to writable area
		
noupseq	cmp #2
		bne noiscup
		lda subwpos3+2
		beq nodeciu
		dec subwpos3+2 ;if cursor Y is not zero, simply go up in instrument subwindow
		rts
nodeciu	ldx subwpos1+2 ;instrument-subwindow
		beq isupret ;if main instrument settings, scroll nothing
		lda wfarpos-1,x ;X is 1..3 here, this trick solves it to be 0..2 index
		beq isupret
		dec wfarpos-1,x  ;scroll up corresponding instrument-table
isupret	rts
		
noiscup	tax  ;X is 3 or 4 here (chordtable/tempotable)
		lda subwpos1,x ;up in tempo/chordwindow
		beq chscrup
		dec subwpos1,x
		rts
chscrup ;scroll up in chord-window
		lda chorpos-3,x
		beq retscru
		dec chorpos-3,x
retscru	rts

;-----------------------------------------------Cursor-Down Branch-------------
norcrdn	lda menumode
		bne menucdn
		lda actwind ;no shift for CURSOR-Down
		bne noptcdn ;if not ptn-window, go testing which
        ;pattern window
godownp	lda #2  ;or 3?
		sta ptrdysi ;notifies key-repeater to wait for pattern-redraw
		jsr compcur     ;common point to go down in pattern, used by pagedown,return,etc.
		beq notrscr     ;if cursor is at last row of pattern
		lda subwpos3+0  ;Y position in pattern-window
		cmp #25-1  ;max. amount of pattern-rows
		beq noincpu     ;if cursor is at last row of pattern-screen
		inc subwpos3+0
		rts
		
menucdn	lda menucurpos
		cmp #lastcrpos
		beq +
		inc menucurpos
+		rts

noincpu ;scroll down in actual track
		ldx subwpos1+0 ;actual tracknumber to X
		lda bindtrk
        beq ptscrdn    ;if no binding, scroll track individually
        ldx #2
-       jsr ptscrdn
        dex
        bne -   ;leave X 0 here, and do the job for track 1 too
ptscrdn	ldy actptn1,x    ;scroll down indexed patten (if possible)
		lda ptnlength,y
		cmp prowpos,x
		beq notrscr
		inc prowpos,x
notrscr	rts
		
noptcdn cmp #1
		bne noseqdn     ;orderlist window
		lda subwpos1+1
		cmp #2
		bne +
		lda #0
		sta subwpos1+1
		jmp sseqend 
+		inc subwpos1+1
		jmp sseqend     ;check if zero under cursor, set position to writable area
		
noseqdn	cmp #2
		bne noiscdn   ;instrument window here
		jsr setinsptr
		jsr getitbi ;get actual inst.table row memory-position index to X
		jsr instpt1
		ldy subwpos1+2  ;actual subwindow
		beq +
		cmp #$ff  ;table endsignal under cursor!!!
		beq isdnret ;if endsignal, not going further
+		lda subwpos3+2  ;cursor-Y coordinate in instrument-window
		cmp iswmaxy,y   ;detect actual instrument-subwindow cursor-Y end-reach
		beq noinciu
		inc subwpos3+2
		rts
noinciu	ldx subwpos1+2 ;actual instrument-subwindow
		beq isdnret ;if main instrument settings
		inc wfarpos-1,x ;X is 1..3 here, this trick solves it to be 0..2 index
isdnret	rts

noiscdn cmp #3
		bne nochddn     ;chord window
		jsr getctpos    ;check if chordlength has been reached
		bmi + ;in chordtable, more than $80 is allowed
		cmp #$7e    ;if chord end/loop, no advance
		bcs keyretc
+		lda subwpos1+3
		cmp #12
		beq chscrol
		inc subwpos1+3
		rts
chscrol ;scroll down chord window
		inc chorpos
		rts
		
nochddn	cmp #4
		bne keyretc
		jsr gettpos
		bmi keyretc   ;if tempoprogram endsignal, no advance
		lda subwpos1+4  ;tempowindow
		cmp #3
		beq tmscrol
		inc subwpos1+4
		rts
tmscrol ;scroll down tempo wondow
		inc temppos
keyretc	rts

;==============================================================================

ctrler  ;CONTROL (TAB) key handler
		jsr repeat  ;check & handle repeat counter
		bne keyretd ;if Zero flag=0, then no repeat (go to returner)
		lda shiftsi
		beq norctrl ;check SHIFT
		lda actwind
		bne noptabb
tabptbk	dec subwpos1+0 ;tabulate back pattern 1..3
		bpl nonegpt
		lda #2
		sta subwpos1+0
nonegpt jmp chkcury  ;check if cursor in pattern display-area

noptabb cmp #2 ;check for another window
		bne noitabb
		dec subwpos1+2 ;tabulate back instrument-window
		bpl nonegit
		lda #3
		sta subwpos1+2
nonegit jmp tabinsw
noitabb cmp #3      ;chordtable/tempotable
		bmi keyretd
		lda #2
		sta actwind ;back to instrument window
		rts
		
norctrl	lda actwind ;normal (witnout Shift) CTRL/TAB key branch
		bne nopttab
tabptfw	ldx subwpos1+0 ;track in patternwindow
		cpx #2
		bne nomaxpt
		ldx #$ff
nomaxpt	inx
		stx subwpos1+0 ;tabulate pattern 1..3
		jmp chkcury  ;check if cursor in pattern display-area
		
nopttab cmp #2
		bne noistab
		ldx subwpos1+2 ;instrument-subwindow
		cpx #3
		bne nomaxit
		ldx #$ff
nomaxit	inx
		stx subwpos1+2 ;tabulate instrument-window
tabinsw	lda #0         ;always go to zero position in table, safely in writeable part
		sta subwpos3+2
		sta subwpos2+2
		rts
noistab cmp #3
		bmi keyretd  ;chord-/tempotable
		lda #0
		sta actwind  ;simply go back to patternwindow
keyretd	rts

;-------------------------------------------------------------------
homer	;HOME key handler
		jsr repeat
		bne homret1
		ldx #0       ;prepare 0 value for cusror- and scroll position setting
		lda shiftsi
		bne homret
		lda actwind  ;check which window we are in
		bne iwinhom  ;are we in pattern-window?
		lda subwpos2+0
		ora subwpos3+0 ;check both positions if zero
		bne smallho  ;if any cursorposition is not zero, small home (no scrolling up)
		ldy subwpos1+0 ;actual track
		lda #0
		sta prowpos,y 
		ldy bindtrk
		beq +
		ldy #2
-		sta prowpos,y
		dey
		bpl -
+		rts
smallho	stx subwpos3+0
		stx subwpos2+0
homret1	rts
		
iwinhom	cmp #1
		bne noseqho  ;are we in sequence/orderlist window?
		lda subwpos2+1
		beq +
		lda #0
		sta subwpos2+1
		rts
+		lda #0
		sta seqdpos+1
		rts
		
noseqho	cmp #2
		bne chthome   ;are we in instrument window (2)
		stx subwpos3+2 ;zero cursor Y-position in window 2 (instr.window)
		stx subwpos2+2 ;zero cursor X-position in window 2
		ldy subwpos1+2 ;are we in instrument-main table?
		beq homret
		txa
		sta wfarpos-1,y ;zero wftable scroll-position  (-1 is trick to lower X=1..3 to X=0..2)
		rts
		
chthome	tay
		txa
		sta subwpos1,y ;zero chordtable cursor-position
		sta chorpos-3,y   ;zero chordtable scroll-position (-3 lowers X indexing range)
		inc insrefr+1  ;to display it
homret	rts

;-----------------------------------------------------------------------
f7er	;F7 key handler
		jsr repeat
		bne f7reter
		lda menumode
		beq +
		inc clearmenu ;initiate a menu-clearance (sign to main loop)
		rts
+		lda cbmsig
		bne swtotmp
		lda shiftsi
		bne menuer ; go to MENU
		;ldx #0
		;lda actwind
		;cmp #2
		;beq swtoins
		ldx #2
swtoins	stx actwind
		rts
swtotmp	lda #4        ;switch to tempotable
		sta actwind
		rts
		
menuer	lda #1 ;jmp packdepack 
		sta menumode
		lda #0
		sta menupoint ;init menu (nothing pressed yet)

f7reter	rts

;-----------------------
f1er	;F1 key handler (reset and play whole tune from beginning)
		jsr repeat
		bne f7reter ;f1reter
		ldx #0
		lda cbmsig
		beq +
		ldx #1
+		stx followp+1 ;if commodore key is pressed together, follow-playing switches ON, else OFF
		jsr resetimer
		lda shiftsi
		bne f2er
		lda #1
		sta playmod
		jsr ptploff ;switch off pattern-playing in player-code (playadapter.inc)
		inc inirequ+1
		rts ;jmp reseptn
f2er	;F2 (shift+F1) key handler (play tune from orderlist markers)
		lda #1
		sta playmod
		jsr ptploff ;switch off pattern-playing in player-code (playadapter.inc)
		lda selsubt+1
		inc StrtPos+1 ;tell initer it's not the beginning of the tune
		jsr INITER ;sets subtune too in case there was subtune-jumping meanwhile :)
		dec StrtPos+1 ;set initer back to normal
		ldx #2
-		lda #0
		sta ptrowpos,x
		dex
		bpl -
		rts

;-----------------------
f3er	;F3 key handler (play actual pattern from its beginning) 
		jsr repeat
		bne f3reter
		ldx #0
		lda cbmsig
		beq +
		ldx #1
+		stx followp+1 ;if commodore key is pressed together, follow-playing switches ON, else OFF
		lda shiftsi
		bne f4er
f3play	jsr resetimer
		lda #2
		sta playmod
		jsr ptplyon ;switch ON pattern-playing mode in player-code
reseptn	ldx #2
-		ldy mul7chn,x
		lda #0
		sta PTNPOS,y
		;lda #$ff
		sta ptrowpos,x
		sta SPDCNT,y ;jmp INICNTR ;init speedcounters - ensure that player starts with rowread
		lda actptn1,x
		sta ACTPTN,y  ; jsr PTNPTR ;set played patterns to selected patterns
		dex
		bpl -
f3reter	rts 

f4er	;F4 (Shift+F3) key handler (stop playback / ? continue  (play/pause))
		ldx pmodstore ;defualt X - value for possible continuation
		lda playmod
		beq +
		sta pmodstore ;store if 1 or 2 (song/patternplay) was previously, to resume at continuation
		ldx #0 ;altered X - value for stopping playback
		stx jambuf+1
		stx jamnote+1
		;stx followp+1
+		stx playmod
		beq + ;if playback is stopped
		jmp continue ;continue paused playback, restore played instruments
+		jmp pause ;pause playback, store numbers of played instruments 
        ;(these routines are in playadapter.inc)
pmodstore .byte 0 ;used to remember what playmode was before stopping, so continuation will be the same
	
;-----------------------
f5er	;F5 key handler
		jsr repeat
		bne f5reter
		lda cbmsig
		beq swtoseq
		lda #3
		sta actwind
		rts
swtoseq	lda shiftsi
		beq ptnwsel
		;lda actwind
		;cmp #1
		;bne +
		;lda #0 ;prevwin
		;jmp ++
+		lda #1
+		sta actwind
		rts
ptnwsel	;lda menumode
		;bne f5reter ;don't select pattern-window, if menu is on
		lda #0     ;F5 for pattern editor
		sta actwind
f5reter	rts

;=================================================================================
reter	;return (enter) key handler
		jsr repeat
		bne f5reter
		
		lda menumode
		beq +
		lda menucurpos
		sec
		sbc #firstcpos-1
		sta menupoint ;will launch a menupoint to main loop (if other than 0)
		rts
+		lda actwind
		cmp #2 ;instrument window or above?
		bmi goposit ;if not pattern or orderlist,simply a carreturn (except instrument main data)
		bne carretn ;if instrument-window, check, if last column in main instrument data
		
		;instrument-window branch
		lda subwpos1+2
		bne carretn ;if not main instrument data
		lda subwpos2+2
		cmp #4
		bmi carretn ;if not last 2 columns in main instrument data
		jsr setinsptr ;set instrument base/memory position to instpt1 and instpt2
		ldx #0 ;set index to 1st byte of instrument basedata (control reg.)
		jsr instpt1
		ldy subwpos3+2 ;action depending on y coordinate
		bne + ;if row 0
		eor #$08
		jmp instpt2 ;jsr instpt2
+		cpy #2
		bpl + ;if not row 1
		eor #$04
		jmp instpt2
+		bne + ;if not row 2
		and #$cf
		sta wrvibty+1
		jsr instpt1
		and #$30 ;mask out vibrato type bits ($10 and $20)
		clc
		adc #$10 ;roll vibrato type
		cmp #$40
		bmi wrvibty
		lda #0
wrvibty	ora #0 ;self-written
retiwr	jmp instpt2
+		;row4  - octave
		ldx #9
		jsr instpt1
		beq f5reter ;if zero (+0), don´t change direction
		sec
		sbc #1
		eor #$ff
		jmp instpt2
		
		;simple carreturn
carretn	ldy actwind  ;shift+return - a cursor position down
		bne retdown
		lda subwpos2+0
		bne retdown ;patternwindow note column?
		ldx #$7d ;gateon
		lda jammode+1
		bne retdown
		jmp noterep
retdown	lda #0
		sta subwpos2,y
		jmp norcrdn

goposit	;go to corresponding inst/tableposition
		cmp #1 ;orderlist?
		bne ptninsr ;check if not orderlist
		lda shiftsi
		beq + ;if SHIFT pressed, all 3 tracks is selected for orderlist position
		ldy #0
		jsr jmptopt
		ldy #1
		jsr jmptopt
		ldy #2
		jsr jmptopt
		ldy subwpos1+1
		jmp postopt
+		lda cbmsig
		beq +
cbmretu	ldx #2 ;cbm+return - go to actually played patterns
-		ldy mul7chn,x
		lda ACTPTN,y ;help from player
		beq invptn
		cmp #maxptnamount+1
		bcs invptn ;don't allow invalid patterns
		ldy followp+1 ;if followplay is on, don´t disturb pointers
		bne invptn
		sta actptn1,x ;go to currently played patterns
		lda #0
		sta prowpos,x
invptn	dex
		bpl -
		jmp postop2
+		ldy subwpos1+1 ;orderlist row (track 1..3) 
		jsr jmptopt ;jump to pattern uner orderlist cursor
		ldy subwpos1+1
postopt	sty subwpos1+0 ;track in patternwindow
postop2	lda #0
		sta actwind
		sta subwpos2+0
		sta subwpos3+0
rereter	rts

ptninsr	lda shiftsi           ;insert gateon/gateoff into pattern
		bne carretn
		lda cbmsig
		bne cbmretu
		lda subwpos2+0 ;column in track
		bne + ;note-column?
		ldx #$7e ;gateoff
		lda jammode+1
		bne retdown
		jmp noterep
+		cmp #1 ;instrument-column
		beq +
		cmp #2 ;instrument-column
		beq +
returet	rts
+		jsr setptnptr ;prepare pattern pointers
		ldx subwpos1+0 ;actual track
		lda ptncurs,x
		tax
		jsr instpt1 ;if no second column
		bpl rereter
		inx ;second column
		jsr instpt1
		and #$7f
		beq rereter ;if instrument is 0
		cmp #maxinstamount ;max number of instrument. Don't select instrument if bigger than $3e.
		bpl rereter
		ldx #2
		stx actwind
		sta selinst+1
		jmp instinit ;zero out instrument coordinates at instrument-change


;=================================================================================
stopper	;RUN/STOP (ESC in VICE) handler 
		jsr repeat
		bne rereter
		lda menumode
		beq +
		inc clearmenu ;initiate a menu-clearance (sign to main loop)
		rts
+		ldx #0
		lda cbmsig
		beq +
		ldx #1
+		stx followp+1 ;if commodore key is pressed together, follow-playing switches ON, else OFF
		jmp F4er

;- similar to Return, type gateon/gateoff
;+		lda actwind
;		bne returet ;if not patternwindow, no process
;		lda subwpos2+0 ;column in track
;		bne returet ;note-column?
;		ldx #$7d ;gateon
;		lda shiftsi           ;insert gateon/gateoff into pattern
;		bne +
;		ldx #$7e ;gateoff
;+		jmp notecol

;-----------------------
slasher	;slash (/) handler (page-up/dn)
		jsr repeat
		bne slasret
		lda #8 ;default page-up/dn amount is 8
		ldx actwind
		cpx #1
		bne +
		lda #4
		sta pgricnt+1
		sta pglecnt+1
		lda shiftsi
		beq pgrilp
pglelp	jsr norcrle
		dec pglecnt+1
pglecnt	lda #0
		bne pglelp
		rts
pgrilp	jsr norcrri   ;orderlist-fast navigation
		dec pgricnt+1
pgricnt	lda #0
		bne pgrilp
		rts
		
+		cpx #4
		beq ++
+		cpx #2
		bne ++
		ldx subwpos1+2 ;check subwindow in instrument-window
		cpx #2
		bmi ++
+		lda #4 ;page-up/dn amount is 4 in short windows
+		sta pgdncnt+1
		sta pgupcnt+1
		lda shiftsi
		bne pgupper
		;page-dn
pgdnlop	jsr norcrdn
		dec pgdncnt+1
pgdncnt	lda #0
		bne pgdnlop
		rts
pgupper	;page-up
pguplop	jsr norcrup
		dec pgupcnt+1
pgupcnt	lda #0
		bne pguplop
slasret rts

;==============================================================================
deleter  ;INST/DEL key handler
		lda cbmsig
		beq +
		jmp delrower
+		lda shiftsi
		beq +
		jmp inskeye
+		jsr repeat
		beq +
fpdret	jmp delret
+		lda actwind  ;branch is here when no shift or c= pressed
		beq +
		jmp delordl  ;patternwindow delete row, rest moves back
+		lda followp+1 ;don't allow any deletions in pattern in followp+1lay-mode
		bne fpdret
		jsr setptnptr ;set pattern pointers in advance based upon actual track/pattern position
		jsr compcur ;output: Accu holds pattern-rowposition under cursor, x-actual track, y-actual pattern
		bne delinpt
		;end-of-pattern - reduce patternsize, delete last row
		;ldy subwpos1+0 ;actual track
		;ldx actptn1,y   ;actual pattern number to X
		lda ptnlength,y ;Y calculated in compcur already
		cmp #1
		beq slasret ;minptnr ;don't allow zero-length pattern
		lda subwpos3+0 ;if cursor at zero dislpay-position, don't delete, because no ptncurs calculated
		beq slasret ;minptnr
		jsr dellast
		ldy subwpos1+0 
		ldx actptn1,y   ;actual pattern number to X
		dec ptnlength,x ;decrease patternlength
		lda prowpos,y
		beq +
		lda subwpos3+0 ;cursor Y position in patternwindow
		cmp #13
		bpl + ;minptnr ;if at position 0 or 1, don't perform decrease -focus should follow fast instead
		jmp nodecpu ;scroll up pattern if possible to keep focus
+		jmp upinptn ;and follow endsignal up with cursor and scroll

delinpt	;delete one row in pattern, then append end of pattern to keep patternlength
		jsr getcurnote ;notevalue in A, positon in X (from pattern displayposition)
		jsr getdelamount ;to Y
		jsr delbackpt ;deletesactual patternrow, amunt given in Y, position in X
		ldy subwpos1+0 ;put a NOP at the end of pattern  
		ldx actptn1,y ;actual pattern
		lda pptrlo,x ;set pattern-pointers to its beginning
		sta instpt2+1
		lda pptrhi,x
		sta instpt2+2
		lda ptnsize,x ;increase patternlength by 1 (size was increased already in insertptn)
		inc ptnsize,x
		tax
		dex
		lda #0 ;append zero to the end of the pattern
		jsr instpt2
		lda #$ff ;append $ff endsignal to end of pattern
		inx
		jmp instpt2 

dellast ;delete last row of pattern
		jsr getlast ;get memo-position of last row to X
delgivn	jsr instpt1 
		jsr getdelamount ;get amount of data in that row
		jmp delbackpt ;jsr delbackpt ;delete data last row from X position with Y amount

delordl	cmp #1
		bne delitbl                 ;delete-key subroutine in orderlist
		jsr setseqptr ;get sequence pointers
		lda seqaddb+1
		sta oldelet+1
		sta oldeleb+1
		lda seqaddb+2
		sta oldelet+2
		sta oldeleb+2
		ldy #0
		jsr seqaddb
		cmp #$fe ;check if endsignal
		bcs delret    ;don't allow lower than zero length sequence
		jsr getcurptn ;get orderlist memory index under cursor to A and Y
		dey
		jsr seqaddb ;get data before cursor
		iny
		cmp #$ff
		beq delret ;don't allow deletion in loop-jumpvalue position
		jsr seqaddb ;get data under cursor
		cmp #$fe ;check if endsignal
		bcc jusdele    ;if $fe/$ff under cursor, not delete, but backspace
		lda subwpos2+1
		cmp #20 ;below half of the screen - delete with seqdisplay movement to stay in scope
		bcs no0bspc ;if cursor below position 20, get orderlist into focus
		lda seqdpos+1 ;if display position zero, no need to follow focus
		beq no0bspc
		dec seqdpos+1
		jmp backdel
no0bspc	lda subwpos2+1
		sec
		sbc #2
		sta subwpos2+1
backdel	dey	;backspace delete position
jusdele	tya
		tax
		inx
oldelet	lda $1111,x   ;deletion loop
oldeleb	sta $1111,y
		inx
		iny
		cpy #seqlength+1
		bne oldelet
delret	rts

delitbl	cmp #2
		bne delchrd                 ;delete-key subroutine in instrument window
		jsr setinsptr  ;set instrument´s memory basepointers
		lda subwpos1+2  ;actual instrument-subwindow
		beq delret     ;if main instrument settings, no insertion possible
		jsr getitbi
		sta stoinsp+1
		clc
		adc #tblwidth
		tay
		;delete from instrument-table , 3 bytes at one step
		jsr instpt1
		cmp #$ff
		beq delret ;if $ff under cursor, don't delete any further
-		lda (inszptr),y  ;read
		jsr instpt2      ;write
		inx
		iny
		cpy #lastinstpt+1
		bne -
		ldx #2
		lda #0
-		dey
		sta (inszptr),y ;the 0 for the last place
		dex
		bpl -
;decrement PW/CTF table pointers if needed
		ldy #$0b ;rel.address of CTF-table
		ldx subwpos1+2 ;subwindow (3..1)
-		cpx #tblamoun
		beq +
		lda (inszptr),y
		sec
		sbc #tblwidth
		sta (inszptr),y
		inx
		dey
		bne -	
;shift gateoff-pointers
+		ldy #$0c ;1st gateoff-pointer
-		lda (inszptr),y ;modify tablepointers in batch
		cmp stoinsp+1
		beq + ;=?
		bcc + ;<?
		sec
		sbc #tblwidth ;3
		sta (inszptr),y
+		iny
		cpy #$0c+tblamoun+1
		bne -
;correct jump-addresses (substract 3 from $fe addresses which point after insertion cursor-position)
+		ldy stoinsp+1 
-		lda (inszptr),y ;read 1st column
		cmp #$fe ;check if $fe at 1st column, if $fe, correct jump-address
		bne +
		iny
		lda (inszptr),y
		cmp stoinsp+1 ;check if target of jump is smaller or bigger than cursor-data-index (insertion-position)
		beq ++ ;=?
		bcc ++ ;<?
		sec
		sbc #tblwidth ;increase pointer in case
		sta (inszptr),y
		jmp ++
+		cmp #$ff
		beq ++ ;in case of $ff endsignal step only 1 byte, as $ff is not followed by other bytes in particular tables
		iny
+		iny
+		iny
		cpy #lastinstpt ;+1? ;loop checking until end of table is reached
		bcc -
deret2	rts

delchrd	cmp #3
		bne deltmpt              ;delete-key subroutine in chordtable
		jsr getctpos ;get chordtable-position under cursor (position in X, value in A)
		bmi + ;in chordtable more than $80 is allowed to delete
		cmp #$7e
		bcs deret2 ;delret ;if $7e or $7f endsignal reached, no process
		+
-		lda CHORDS+1,x ;delete back one byte in chordtable
		sta CHORDS,x
		inx
		cpx #$ff
		bne -
		ldx selchor+1;adjust back rest of chordpointers by 1
		inx
-		dec CHDPTRLO,x
		inx
		cpx #$40
		bne -
		rts

deltmpt ;here comes deletion in tempotable
		jsr gettpos 
		bmi deret2 ;delret ;if end of tempoprogram
-		lda TEMPOTBL+1,x
		sta TEMPOTBL,x
		inx
		cpx #$ff
		bne -
		ldx seltemp+1
		inx
-		dec TEMPTRLO,x
		inx
		cpx #$40
		bne -
retpntz	rts

;------------------------------------------------------------------------------
inskeye	;insertion handler
		jsr repeat
		bne retpntz ;delret
		lda actwind
		beq +
		jmp olinser ;is it pattern-window?
+		lda followp+1 ;don't allow any insertions into pattern in followp+1lay-mode
		bne retpntz ;+
		jsr setptnptr ;set pattern pointers in advance based upon actual track/pattern position
		jsr compcur ;check, if cursor is at pattern-endposition , Y holds actual pattern's number
		bne insinpt ;branch if we are inside pattern 
		;branch when we're at the pattern endsignal to increase patternlength
		ldy subwpos1+0 ;actual track
		ldx actptn1,y ;actual pattern
		lda pptrlo,x ;set pointer to beginning of pattern
		sta instpt2+1
		lda pptrhi,x
		sta instpt2+2
		lda ptnsize,x ;if insertion is succesful, increase pattern/size (insert NOP)
		cmp #maxptnlen 
		bcs retpntz ;+    ;if patternsize is full do nothing
		inc ptnsize,x
		inc ptnlength,x
		tax
		dex
		lda #0
		jsr instpt2 ;end-of-pattern - increase patternsize, insert empty row
		inx
		lda #$ff
		jsr instpt2
		jmp godownp

insinpt	;insert one row into pattern, delete last row to keep patternsize constant
		jsr dellast
		jsr getcurnote ;notevalue in A, positon in X (from pattern displayposition)
		dex
		ldy #1
		lda #0
		jmp insertpt ;jsr insertpt
		
olinser	cmp #1   ;-------------------------------------------------------------
		bne insinst ;is it orderlist?
		jsr setseqptr ;get sequence pointers
		ldy #seqlength-1 ;one before last byte
		jsr seqaddb
		cmp #$ff  ;if sequence is full
		beq retpntz
		cmp #$fe  ;if sequence is full
		beq retpntz
		jsr getcurptn ;get orderlist memory index under cursor to A and Y
		jsr seqaddb
		beq retpntz ;don't let pattern $00 to be overwritten (it's special)
		dey
		jsr seqaddb ;check if we are not on loop-jumpposition number or on 00 value
		cmp #$ff 
		beq retpntz  ;if it's jumpposition operand, don't proceed with insertion
		;iny
		sty olinsrc+1
		lda seqaddb+1
		sta olinsrt+1
		sta olinsrb+1
		lda seqaddb+2
		sta olinsrt+2
		sta olinsrb+2
		ldx #seqlength-1
		ldy #seqlength
olinsrt	lda $1111,x ;self-written  - insertion loop, move the rest forward
olinsrb	sta $1111,y ;self-written
		dex
		dey
olinsrc	cpx #0  ;self-written
		bne olinsrt
		lda #$01 ;value to write into empty place, and Y holds actual position
		jsr seqaddc
		iny
		jsr seqaddb
		cmp #$fe
		beq +
		cmp #$ff
		bne retpnto ;deleret
+		lda subwpos2+1
		cmp #39
		beq +
		jsr seqstpr1 ;step to still see $ff and inserted amount
+		jsr seqstpr1 
retpnto	rts

insinst	cmp #2     ;-----------------------------------------------------------
		bne inschrd ;is it instrument-window?
		jsr setinsptr  ;set instrument´s memory basepointers
		lda subwpos1+2  ;actual instrument-subwindow
		beq deleret     ;if cursor at main instrument settings, no insertion possible
		jsr getitbi ;get instrument-data-pointer under cursor to X
insitbl	;insert into instrument-table , 3 bytes at one step
		stx stoinsp+1
		ldy #lastinstpt ;points to 1st column of last possible row in instrument
		lda (inszptr),y
		bne deleret ;if pattern is full (its very last row's 1st column is non-zero, but $ff)
		ldx #lastinstpt-tblwidth  ;move data
-		jsr instpt1      ;read data to move
		sta (inszptr),y  ;write data to new place
		dey
		dex
stoinsp	cpx #0 ;self-written code
		bcs -
		inx
		ldy #2
		lda #0
-		jsr instpt2 ;fill inserted row with zero
		inx
		dey
		bpl -
;shift tablepointers
		ldy #$0b ;rel.address of CTF-table
		ldx subwpos1+2 ;subwindow (3..1) ;cycle through table-pointers from actual table
-		cpx #tblamoun
		beq + ;check if reached last table
		lda (inszptr),y ;modify tablepointers in batch
		clc
		adc #tblwidth ;3
		sta (inszptr),y
		inx
		dey
		bne -
;shift gateoff-pointers
+		ldy #$0c ;1st gateoff-pointer
-		lda (inszptr),y ;modify tablepointers in batch
		cmp stoinsp+1
		bcc +
		clc
		adc #tblwidth ;3
		sta (inszptr),y
+		iny
		cpy #$0c+tblamoun+1
		bne -
;correct jump-addresses (add 3 to $fe addresses which point after insertion cursor-position)
+		ldy stoinsp+1 
-		lda (inszptr),y ;read 1st column
		cmp #$fe ;check if $fe at 1st column, if $fe, correct jump-address
		bne +
		iny
		lda (inszptr),y
		cmp stoinsp+1 ;check if target of jump is smaller or bigger than cursor-data-index (insertion-position)
		bcc ++
		clc
		adc #tblwidth ;increase pointer in case
		sta (inszptr),y
		jmp ++
+		cmp #$ff
		beq ++ ;in case of $ff endsignal step only 1 byte, as $ff is not followed by other bytes in particular tables
		iny 
+		iny
+		iny
		cpy #lastinstpt ;+1? ;loop checking until end of table is reached
		bcc -
deleret	rts
		
inschrd	cmp #3   ;-------------------------------------------------------------
		bne instmpt ;is it chordwindow?
		lda CHORDS+$fe
		bne deleret ;if there's other than $00 at chordtable's last byte, it's full
		ldx selchor+1;adjust back rest of chordpointers by 1
		lda CHDPTRLO+1,x
		sec
		sbc CHDPTRLO,x
		sbc #maxchordlength ;max length of a chord
		bcs deleret ;if actual chord's length reached $40
		inx
-		inc CHDPTRLO,x
		inx
		cpx #MAXCHORDAMOUNT ;max. number of chords
		bne -
		jsr getctpos ;get chordtable-position under cursor (position in X, value in A)
		stx chinsxs+1 ;storing X for bit later use
		ldx #$ff
-		lda CHORDS-1,x ;move chordtable up by 1 byte
		sta CHORDS,x
		dex
chinsxs	cpx #1  ;self-written, holds actual position 
		bne -
		lda #$00
		sta CHORDS,x ;empty inserted area under cursorposition
		rts
		
instmpt	;insert into tempotable?    ;------------------------------------------
		lda TEMPOTBL+$fe
		bne deleret ;if tempotable is full (nonzero at it's end)
		ldx seltemp+1 ;adjust back rest of tempoprogram-pointers by 1
		lda TEMPTRLO+1,x
		sec
		sbc TEMPTRLO,x
		sbc #maxtempolength ;max length of a tempoprogram
		bcs deleret ;if actual tempoprogram's length reached $40
		inx
-		inc TEMPTRLO,x
		inx
		cpx #MAXTEMPOPRAMOUNT  ;max. number of tempoprograms
		bne -
		jsr gettpos ;get tempotable-position under cursor (position in X, value in A)
		stx tminsxs+1 ;storing X for bit later use
		ldx #$ff
-		lda TEMPOTBL-1,x ;move tempotable up by 1 byte
		sta TEMPOTBL,x
		dex
tminsxs	cpx #1  ;self-written, holds actual position 
		bne -
		lda #$00
		sta TEMPOTBL,x ;empty inserted area under cursorposition
delrret	rts	
		
;-------------------------------------------------------------------------------
delrower ;C= + DEL - deletion (zeroing out) of entire row?
		jsr repeat
		bne delrret
		lda actwind
		bne delrret ;only allow in patternwindow 
		lda followp+1 ;don't allow any deletions in followp+1lay-mode
		bne delrret
		jsr setptnptr ;set pattern pointers in advance based upon actual track/pattern position
		jsr compcur ;overwrites Y!
		beq delrret
		jsr getcurnote ;notevalue in A, positon in X (from pattern displayposition)
		ldy shiftsi
		beq + ;if shift also pressed, zero out note column too
		and #$80
		jsr instpt2
		bpl advdelr ;if note column only
+		ldy #0 ;delete nothing if only note column exists
		jsr getdla2   ;getdelamount subroutine entry without Y setting
		jsr instpt1
		and #$7f
		jsr instpt2
		inx ;deletion pointer after note column
		jsr delbackpt ;deletes actual patternrow, amunt given in Y, position in X
advdelr	lda autoadv
		beq delrret
		jmp godownp ;jsr godownp ;go down in pattern if autoadvance mode is ON

;==========================================================================================================
.FI ;end of part needed only for editor
