

float4x4 g_mWorldViewProjection;    
float4x4 g_mView;    



float zFar = 10000.0;
float zNear = 0.10;

float g_windowWidth;
float g_windowHeight;

float g_time;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};


struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float2  vTexcoordActual : TEXCOORD2;
};


VS_OUTPUT vs_deferred_mixer( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
 // o.vPosition =v.vPosition;
  o.vPosSS = o.vPosition;
 // o.vTexcoord = v.vTexcoord;
 
//  float2 correcter = float2((g_windowWidth)/g_windowWidth, (g_windowHeight)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x, o.vPosition.y))*0.50+float2(0.5/g_windowWidth, 0.5/g_windowHeight);
   
  
  o.vTexcoordActual = v.vTexcoord;
  
  return o;
}

VS_OUTPUT vs_deferred_mixer_ao( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
 // float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x, o.vPosition.y))*0.5+float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  
  o.vTexcoordActual = v.vTexcoord;

  return o;
}


VS_OUTPUT vs_deferred_mixer_ambient( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
 // float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x, o.vPosition.y))*(0.5)+float2(0.5/g_windowWidth, 0.5/g_windowHeight);
 // o.vTexcoord = v.vTexcoord;
 // o.vTexcoord = v.vTexcoord+float2(1.0/g_windowWidth, 1.0/g_windowHeight);
 
 // o.vTexcoord = v.vTexcoord*correcter+float2(-1.0/g_windowWidth, -1.0/g_windowHeight);
 
  o.vTexcoordActual = v.vTexcoord;


  return o;
}


VS_OUTPUT vs_blur_ao( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
 // float2 correcter = float2((g_windowWidth-1)/(g_windowWidth), (g_windowHeight-1)/(g_windowHeight));
 // o.vTexcoord = v.vTexcoord+float2(1.0/g_windowWidth, 1.0/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x, o.vPosition.y))*(0.5)+1.0*float2(0.5/g_windowWidth, 0.5/g_windowHeight);;
 // o.vTexcoord = v.vTexcoord*correcter;
   
  o.vTexcoordActual = o.vTexcoord; // (1.0-float2(-o.vPosition.x-2.0/g_windowWidth, o.vPosition.y-2.0/g_windowHeight))*(0.5);

  return o;
}


float g_ambience = 0.25;
float g_ambience_att = 200.0;
float g_ao_darkness = 2.0;
float g_ao_whiteness = 1.0;
float g_ao_area = 10.0;
float g_ao_pow = 1.0;




texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tNoise;
texture g_tAO;
texture g_tAmbSpec;

texture g_tAmbienceMap;
texture g_tEnvMap;


sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};



sampler smAO =
sampler_state {
  Texture = <g_tAO>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smAmbSpec =
sampler_state {
  Texture = <g_tAmbSpec>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};


sampler smAmbMap =
sampler_state {
  Texture = <g_tAmbienceMap>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};


sampler smEnvMap =
sampler_state {
  Texture = <g_tEnvMap>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};



struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

float4 g_lightPos;
float4 g_lightColor;
float g_lightInvDistance;

float g_specularExponent = 128.0f;
float g_lightBallSharpness;
float g_lightBallSize;


PS_OUT ps_deferred_mixer( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 lightResult = (float4)0;
  float4 result = (float4)0.0;

  float4 lightViewPos;
   
  float4 depthV = tex2D(smDepth, In.vTexcoord);

  if (depthV.r > 0.9999) {
    lightResult.a = 1.0;
    lightResult.r = 1.0;
    o.rt0 = lightResult;
    return o;
  }
  
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV.r-clipA);
  
  float pointDist2 = pointDist*pointDist;
  float4 pointV = float4(In.vPosSS.x*g_windowWidth/g_windowHeight, In.vPosSS.y, 1.0, 0.0)*pointDist;
  
  float4 pointVN = normalize(pointV);
    
  // render lightball
  
  lightViewPos = mul(g_lightPos, g_mView);
  
  float4 lightSS = mul(g_lightPos, g_mWorldViewProjection)*pointDist;
  
  float lightDist2 = dot(lightViewPos, lightViewPos);
  if (lightViewPos.z > 20.0) {
	  float dotta = dot(lightViewPos, pointVN);
	  float4 vd = (lightViewPos-dotta*pointVN);
	  vd = 2.0*float4((In.vTexcoordActual.x-0.5), (In.vTexcoordActual.y-0.5), 0.0, 0.0);
	  dotta = 1.0-pow(abs(dot(vd, vd)), 1.0/g_lightBallSharpness);
	  float vdLen2 = dotta;
	  dotta = clamp(dotta-0.1, 0.0, 1.0);
	  dotta = pow(dotta*1.5, 2.0)*g_lightBallSize;
	//  dotta = pow(dotta, 2.0)*(1.1+1.0/(vdLen2*4.0+1.0)*0.5*sin(g_lightPos.x+20.0*atan((In.vTexcoordActual.y-0.5)/(In.vTexcoordActual.x-0.5))));
// put this to see light box	  
	//  dotta += 0.1;
	  float softArea = 1.0+10000.20*vdLen2;
	  if (pointDist2 > lightDist2) {
		lightResult += dotta*g_lightColor;
		lightResult.a += dotta;
	  } else if (pointDist2 > lightDist2-softArea) {
		float softness = (pointDist2-(lightDist2-softArea))/softArea;
		lightResult += dotta*g_lightColor*softness;	  
		lightResult.a += dotta*softness;
	  }	
  }   

  float2 texus = (In.vTexcoordActual-0.5)*2.0;
  float lightCover = clamp((3.0-dot(texus, texus)*3.0)*1.0, 0.0, 1.0);
  
  lightResult *= lightCover;
  
  


  float4 ambSpec = tex2D(smAmbSpec, In.vTexcoord);
  float4 normalV = (tex2D(smNormal, In.vTexcoord)*2.0)-1.0;
  float4 diffuseV = tex2D(smDiffuse, In.vTexcoord);
  
 diffuseV *= diffuseV;  
    
  lightViewPos = mul(g_lightPos, g_mView);
  
  float4 lightToPoint = lightViewPos-pointV;
  float lightToPointDist2 = dot(lightToPoint, lightToPoint);

  float4 ambienssi = tex2D(smAO, In.vTexcoord).r;
  ambienssi = pow(clamp(1.0-ambienssi, 0.0, 1.0), g_ao_pow);
    
  ambienssi*=ambienssi;
    

  float lightToPointAtt = saturate(1.0-0.005*g_lightInvDistance*g_lightInvDistance*lightToPointDist2);

  // diffuse
  float lightToPointDist = sqrt(lightToPointDist2);
  float normalLightDot = dot(normalV, lightToPoint/(lightToPointDist+1.0));
  normalLightDot = clamp(normalLightDot, 0.0, 100.0);
  normalLightDot = pow(normalLightDot, 1.0)*16.0*lightToPointAtt-0.01;
  normalLightDot = clamp(normalLightDot, 0.0, 10000.0)*lightCover;
  result += (normalLightDot*g_lightColor*g_lightColor)*diffuseV*ambienssi;
 // result += (normalLightDot*g_lightColor)*diffuseV*ambienssi;
  
  // specular reflection
  float3 reflected = reflect(float3(lightToPoint.xyz), normalize(float3(normalV.xyz)));
  float specularDot = dot(reflected, float3(pointVN.xyz))/(lightToPointDist+1.0);
  specularDot = clamp(specularDot*1.0, 0.0, 100.0);
  specularDot = pow(specularDot, ambSpec.z)*ambSpec.y*1.0*lightToPointAtt; // pow(specularDot, g_specularExponent*(ambSpec.y*1.0+1.0))*ambSpec.y*16000.0/(lightToPointDist2*g_lightInvDistance+1.0)-0.01;
  specularDot = clamp(specularDot, 0.0, 10000.0)*lightCover*ambienssi;
  result += specularDot*g_lightColor*g_lightColor*1.0;
 // result += specularDot*g_lightColor*1.0;
  
  
  result += lightResult;
  

  result.a = diffuseV.w;

  
  o.rt0 = result;
  return o;
}



PS_OUT ps_deferred_mixer_ambient( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;

  float2 tc = In.vTexcoord; //+float2(0.5/g_windowWidth, 0.5/g_windowHeight);

  float4 depthV = tex2D(smDepth, tc);

  if (depthV.r > 0.99999) {
   // result.a = 0.0;
   // o.rt0 = result;
   // return o;
    discard;
  }
 
  float4 diffuseV = tex2D(smDiffuse, tc);
  float4 ambSpec = tex2D(smAmbSpec, tc);


/*

  if (diffuseV.a < 0.005)
    discard;

*/
  float3 rVec = float4(1.0, 0.0, 0.0, 0.0);
  float3 upVec = float4(0.0, -1.0, 0.0, 0.0);
  float3 normalV = (float3(tex2D(smNormal, tc).xyz)*2.0)-1.0;

  float3 upAmb = mul(upVec,(float3x3)(g_mView));
  float3 rAmb = mul(rVec,(float3x3)(g_mView));
  float skAmbUp = ((dot(normalV, upAmb)+1.0)*0.5)*0.50+0.50;
  float skAmbR = ((dot(normalV, rAmb)+1.0)*0.5)*0.50+0.50;
  float4 ambColor = tex2D(smAmbMap, saturate(float2(skAmbR*skAmbR, skAmbUp*skAmbUp))*0.8+0.1); // skaala*float4(1.0, 1.0, 1.0, 1.0);
  ambColor *= ambColor;

//  ambColor = float4(0.0, 0.0, 0.0, 0.0);

//  float4 envMap = tex2D(smEnvMap, In.vTexcoord*0.0+float2(0.5, 0.5)+normalize(normalV).xy*float2(0.50, 0.5));
//  diffuseV += envMap*0.1; // *ambSpec.y;
  diffuseV *= diffuseV;

 // float4 diffuseEnv = tex2D(smDiffuse, In.vTexcoord-normalV.xy*float2(0.50, 0.67));
  
  
  
  float ambienssi = tex2D(smAO, tc+1.0*float2(0.50/g_windowWidth, 0.50/g_windowHeight));
  ambienssi = 1.0-clamp(ambienssi, 0.0, 1.0);
 // ambienssi = pow(clamp(1.0-ambienssi, 0.0, 1.0), g_ao_pow);
  //  ambienssi = g_ao_darkness*ambienssi;

  result = ((1.0-ambSpec.x)*ambColor+ambSpec.x)*diffuseV*g_ambience*ambienssi; // *(1.0-pow(depthV.r, g_ambience_att));
  result.a = diffuseV.a;

  
  o.rt0 = result;
  return o;
}


float g_blurAmount;

float4 getPointV(float4 vPosSS, float depthV) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV-clipA);
  float4 pointV = float4(vPosSS.x*4.0/3.0, vPosSS.y, 1.0, 0.0)*pointDist;  
  return pointV;
}


PS_OUT ps_blur_ao_x( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;
  
  float2 tcOfs = 0.0*float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  float2 tcOfsD = 0.0*float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  float2 tcOfsH = 0.0*float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  
  float2 p = In.vTexcoord;
  
  float3 depthV = tex2D(smDepth, p+tcOfsD).xyz;
  
  if (depthV.r > 0.9999) {
    o.rt0 = 0.0;
    return o;
  }
     
  
  float4 tn = tex2D(smNormal, p+tcOfs);
  float3 normalV = (tn.xyz)*2.0-1.0;
  
  // float4 current = tex2D(smAO, p);

  float a = 0.0;
  float2 ko;
  float3 depthVP;
  float3 normalVP;
   
  float koke = g_blurAmount/(clamp((depthV.r-0.99)*100.0, 0.0, 1.0)*1.0+1.0);

//  float ker[5] = { 3.0, 2.0, 1.0, 2.0, 3.0 };
  float ker[3] = { 2.0, 1.0, 2.0 };

  float eroNorm;
  float kerR;
  
  for (int y=0; y<3; y++) {
    for (int x=0; x<3; x++) {
  	  ko = p+koke*float2((x-1.0), (y-1.0));
  //	  koa = p+koke*float2((x-1.0), (y-1.0));
  	  
  	  float4 texNorm = tex2D(smNormal, ko+tcOfs);

   //   if (texNorm.w < 0.5)
   //     continue;

      normalVP = (texNorm.xyz)*2.0-1.0;
   //     eroNorm = 0.0;
      eroNorm = (dot(normalV, normalVP+tcOfs)+1.0)*0.5;
      eroNorm = clamp(eroNorm-0.5, 0.0, 1.0);
      eroNorm = pow(eroNorm, 1.0)*2000.0;
	  depthVP = tex2D(smDepth, ko+tcOfsD);
	  if (depthVP.r > 0.9999)
	    eroNorm = 0.0;
	  float ero = (depthV.r-depthVP.r)*100.0;
	  eroNorm *= 1.0-clamp(ero*ero*ero*ero, 0.0, 1.0);
 	
	  eroNorm *= ker[x]*ker[y];
	  	   
  	  result += tex2D(smAO, ko+tcOfsH)*eroNorm;
    //  result += current*(1.0-eroNorm)*kerR;
  	  
	
      a += eroNorm;
	}
  }
 // result = 1.0-(depthV.r-0.99)*200.0; //result/(a)*1.0;
  result = result/(a);

  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}


float rand(float2 co){
  return 0.5+(frac(sin(dot(co.xy ,float2(12.9898,78.233))) * 43758.5453))*0.5;
}

float doAO(float4 pointV, float3 normalV, float2 dir) {
  float4 ray = pointV+float4(dir, 0.0, 0.0);
  float2 rayTexC = ((float2(ray.x*3.0/4.0, -ray.y)/(ray.z))+1.0)*0.5+float2(0.5/g_windowWidth, 0.5/g_windowHeight);
  float4 depthRay = tex2D(smDepth, rayTexC);

  float4 rayV = getPointV(float4(rayTexC.xy*2.0-1.0, 1.0, 0.0), depthRay.r);
  rayV.y = -rayV.y;

  float4 diff = rayV-pointV;
  float kukko = length(diff);

  float ambienssi = 0.0;

  if (dot(normalV, diff)>0.0) {
	  float dots = dot(normalV, (float3(tex2D(smNormal, rayTexC).xyz)*2.0)-1.0);
		
	  dots = saturate((0.9999-dots)*1.0); // *saturate(dot(normalV, diff));
	  if (depthRay.r > 0.99999999 || depthRay.r < 0.01)
	    dots=0.0;
		
	  ambienssi = (1.0/(kukko+1.0))*dots;
  }

  return ambienssi;
}

PS_OUT ps_deferred_mixer_ao( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;

  float2 tc = In.vTexcoord; // + float2(0.5/g_windowWidth, 0.5/g_windowHeight);

  float4 depthV = tex2D(smDepth, tc);

  if (depthV.r > 0.99999999) {
    discard;
    result.rgb = 0.0;
    result.a = 0.0;
    o.rt0 = result;
    return o;
  }

 const float2 vec[4] = {
   float2(1.0,0.0),
   float2(-1.0,0.0),
   float2(0.0,1.0),
   float2(0.0,-1.0)
 };

  float ambienssi = 0.0;
  
  float4 pointV = getPointV(In.vPosSS, depthV.r); 

  float4 noiseVT = tex2D(smNoise, (tc)*2.0);
  float3 noiseV = (noiseVT.xyz);

  float3 ray;
  
  float3 normalV = (float3(tex2D(smNormal, tc).xyz)*2.0)-1.0;
  
  float radD = g_ao_area/(pointV.z*0.02+0.01)*(noiseVT.a*1.0+0.0); 
  

  int iter = 2;
  
  for (int i=0; i<iter; i++) {

   // float2 rayRefl = reflect(vec[i],noiseV.xy);
	//  ray = ray*sign(dot(ray,normalV))*radD*1.0+pointV+normalV*0.0;
    float2 c1 = reflect(vec[i],noiseV.xy)*radD;
    float2 c2 = float2(c1.x*0.707-c1.y*0.707, c1.x*0.707+c1.y*0.707);

    ambienssi += doAO(pointV, normalV, c1*0.25);
    ambienssi += doAO(pointV, normalV, c2*0.5);
    ambienssi += doAO(pointV, normalV, c1*0.75);
    ambienssi += doAO(pointV, normalV, c2);
  }
  ambienssi = ambienssi/(iter*4.0);
    
  ambienssi = clamp(ambienssi, 0.0, 1000.0)*g_ao_darkness; 
  result = ambienssi;

 // result.x = rayMo.z*0.004;
  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer( );
    }
}


technique RenderAO {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer_ao( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer_ao( );
    }
}

technique BlurAOX {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_blur_ao( );
        PixelShader  = compile ps_3_0 ps_blur_ao_x( );
    }
}


technique MixAmbient {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer_ambient( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer_ambient( );
    }
}

