
float4x4 g_mWorldViewProjection;    

float g_luminosity;
float g_whiteness;
//float g_exponent;
float g_saturation;

float g_windowWidth;
float g_windowHeight;

float4 g_color;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_float_to_onezero( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

sampler sm =
sampler_state {
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = CLAMP;
  AddressV = CLAMP;
};


float atansafe(float y, float x) {
 float ret;
	if (x!=0.0) {
		if (x>0.0) {
			ret=atan(y/x);
		} else	{
			ret=atan(y/x)+3.141592;
		}
	} else	{
		if (y>=0.0) {
			ret=0.5*3.141592;
		} else {
			ret=-0.5*3.141592;
		}
	}
 return ret;
}

float4 hsvToRgb(float4 hsv) {
  float4 rgb = hsv;
  
  if (hsv.y <= 0.01) {
    rgb.xyz = hsv.z;
	return rgb;
  }
  if (hsv.z <= 0.01) {
    rgb.xyz = 0.0;
	return rgb;
  }
  
  float f = frac(hsv.x/60.0);
  
  float v = hsv.z;
  float p = v*(1.0 - hsv.y);
  float q = v*(1.0 - f * hsv.y);
  float t = v*(1.0+hsv.y*(f-1.0));

  if (hsv.x < 60.0) {
	rgb.xyz = float3(v, t, p);
  } else if (hsv.x < 120.0) {
	rgb.xyz = float3(q, v, p);
  } else if (hsv.x < 180.0) {
	rgb.xyz = float3(p, v, t);
  } else if (hsv.x < 240.0) {
	rgb.xyz = float3(p, q, v);
  } else if (hsv.x < 300.0) {
	rgb.xyz = float3(t, p, v);
  } else {
	rgb.xyz = float3(v, p, q);
  }
  return rgb;
}


float4 rgbToHsv(float4 rgb) {
  float4 hsv = rgb;
  
  // hue
//  hsv.x = (atansafe(2.0*rgb.r-rgb.g-rgb.b, 1.44224957*(rgb.g-rgb.b))+1.0*3.141592)/(2.0*3.141592)*360.0;
 // hsv.x = 360.0-(atansafe(2.0*rgb.r-rgb.g-rgb.b, 1.44224957*(rgb.g-rgb.b))+0.50*3.141592)/(2.0*3.141592)*360.0;

  float minC = min(rgb.r, rgb.g);
  minC = min(minC, rgb.b);
  float maxC = max(rgb.r, rgb.g);
  maxC = max(maxC, rgb.b);
    
  // value
  hsv.z = maxC;
  
  float delta=maxC-minC;
  
  float hue = 0.0;
  if( rgb.r >= maxC-0.01 ) {
    hue = ( rgb.g - rgb.b ) / delta; // between yellow & magenta
  } else if( rgb.g >= maxC-0.01) {
    hue = 2.0 + ( rgb.b - rgb.r ) / delta;	// between cyan & yellow
  } else {
    hue = 4.0 + ( rgb.r - rgb.g ) / delta;	// between magenta & cyan
  }
  hue *= 60.0;				// degrees
  if (hue<0.0) {
    hue += 360.0;
  }
  hsv.x = frac(hue/360.0)*359.0;
  
  float sat=0.0;
  if (maxC > 0.01) {
    sat = delta/maxC;
  } else {
    hsv.x = 0.0;
  }
  // saturation
  hsv.y = sat;
  
  return hsv;
   
}

float4 g_exponentRGB;

PS_OUT ps_float_to_onezero( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(sm, In.vTexcoord);

 // colorIn = pow(colorIn, g_exponent);
  colorIn.xyz = pow(colorIn.xyz, g_exponentRGB.xyz);
  colorIn *= g_luminosity;
  float lwhite2 = g_whiteness; 
  float4 result = colorIn*(1.0+colorIn/lwhite2)/(1.0+colorIn);
 
  result = clamp(result, 0.00, 1.0);
  result.a = colorIn.a;

  float3 luma = dot(result.rgb, float3(0.299, 0.587, 0.114));
  result.xyz = lerp(luma.xyz,result.xyz,g_saturation);
  

  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_float_to_onezero( );
    }
}

