#version 330
#extension GL_EXT_geometry_shader4 : enable
layout(points) in;
layout(points) out;
layout(max_vertices = 50) out;

out vec4 Position;
out vec4 Color;
out vec4 Normal;
out vec4 TexCoord;

in vec3 norm[];

uniform sampler2D noise_texture;
uniform float timer;


mat4 rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 roty = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 rotz = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

void initialize_matrices(float anglex, float angley, float anglez)
{
     rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , cos(anglex)   , -sin(anglex)  , 0.0,
                 0.0            , sin(anglex)   , cos(anglex)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     roty = mat4(cos(angley)    , 0.0           , sin(angley)   , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 -sin(angley)   , 0.0           , cos(angley)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     rotz = mat4(cos(anglez)    , -sin(anglez)  , 0.0           , 0.0,
                 sin(anglez)    , cos(anglez)   , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);
}

void main()
{
    vec4 pos = gl_PositionIn[0];
    float length_time = (-pos.x + 4.0) * 1100.0;
    vec4 normal = vec4(norm[0], 0.0);
    TexCoord = vec4(0.5, 0.5, 1.0, 0.0);
    float beat = cos(timer*0.0146607657167523684461590024553+3.1415926535897932384626433832795)+1;

    for(int i=0;i<31;i++)
    {

        Color = vec4(3.0, 1.0, 1.0, 1.0);
        initialize_matrices(0.3, i*0.61/3.1+0.55, 0.18);
        float zero_point = (100.0-sin(i-7)*20.0)*700.0;
        float distancee = 35.0 + sin(i-7)*5.0;
        float height = sin(i-7)*10.0+5.0;
        vec4 zeroo = vec4(0.0, 0.0, 0.0, 1.0);

        if(timer>130285.71428571428571428571428571)
        {
            initialize_matrices(0.0, -1.5707963267948966192313216916398, 0.0);
            zeroo.x += 18.0;
            zeroo.z += 6.0+(87428.57142857142857142857142857-82285.714285714285714285714285714)/600.0;//-(timer-89142.857142857142857142857142856)/600.0;

            initialize_matrices(0.3, i*0.61/3.1+0.55, 0.18);
            zeroo = roty * rotz * (zeroo + vec4(0.0, height, distancee, 0.0));
            initialize_matrices(0.0, -(80571.428571428571428571428571428-zero_point)/(700.0*distancee), 0.0);
            zeroo = roty * zeroo;
        }

        if(timer<zero_point && timer<80571.428571428571428571428571428)
        {
            Position = roty * rotz * (pos+vec4(-100.0+sin(i-7)*20.0+timer/700.0, height, distancee, 0.0));
            Normal = roty * rotz * vec4(normal.xyz, 0.0);
        }else if(timer<80571.428571428571428571428571428)
        {
            Position = roty * rotz * (rotx * pos + vec4(0.0, height, distancee, 0.0));
            Normal = roty * rotz * (rotx * vec4(normal.xyz, 0.0));
            initialize_matrices(0.0, -(timer-zero_point)/(700.0*distancee), 0.0);
            Position = roty * Position;
            Normal = roty * Normal;
        }else
        {
            vec4 pos2 = pos;
            if(timer<82285.714285714285714285714285714)
            {
                initialize_matrices(0.0, (timer-80571.428571428571428571428571428)/1091.3481812015680167009172345545, 0.0);
                pos2 = roty * (pos2 + vec4(0.0, 0.0, -6.0, 0.0));
                pos2.z += 6.0;
                Normal = roty * vec4(normal.xyz, 0.0);
            }else if(timer<87428.57142857142857142857142857)
            {
                initialize_matrices(0.0, 1.5707963267948966192313216916398, 0.0);
                pos2 = roty * (pos2 + vec4(0.0, 0.0, -6.0, 0.0));
                pos2.z += 6.0 + (timer-82285.714285714285714285714285714)/600.0;
                Normal = roty * vec4(normal.xyz, 0.0);
            }else if(timer<89142.857142857142857142857142856)
            {
                initialize_matrices(0.0, 1.5707963267948966192313216916398, 0.0);
                pos2 = roty * pos2;
                Normal = roty * vec4(normal.xyz, 0.0);
                initialize_matrices(0.0, -(timer-87428.57142857142857142857142857)/545.67409060078400835045861727725, 0.0);
                pos2 = roty * (pos2 + vec4(-6.0, 0.0, 0.0, 0.0));
                pos2.x += 12.0;
                pos2.z += 6.0+(87428.57142857142857142857142857-82285.714285714285714285714285714)/600.0;
                Normal = roty * Normal;
            }else
            {
                initialize_matrices(0.0, -1.5707963267948966192313216916398, 0.0);
                pos2 = roty * pos2;
                pos2.x += 18.0;
                pos2.z += 6.0+(87428.57142857142857142857142857-82285.714285714285714285714285714)/600.0;//-(timer-89142.857142857142857142857142856)/600.0;
                Normal = roty * vec4(normal.xyz, 0.0);
            }

            initialize_matrices(0.3, i*0.61/3.1+0.55, 0.18);
            Position = roty * rotz * (pos2 + vec4(0.0, height, distancee, 0.0));
            Normal = roty * rotz * Normal;
            initialize_matrices(0.0, -(80571.428571428571428571428571428-zero_point)/(700.0*distancee), 0.0);
            Position = roty * Position;
            Normal = roty * Normal;

            if(timer>89142.857142857142857142857142856 && timer<100000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0)
            {
                vec3 dir = normalize(vec3(0.0, 0.0, 0.0) - Position.xyz);
                Position += vec4(dir*(timer-89142.857142857142857142857142856)/600.0, 0.0);
            }else if(timer>100000 && timer<103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0)
            {
                vec3 dir = normalize(vec3(0.0, 0.0, 0.0) - Position.xyz);
                Position += vec4(dir*(timer-89142.857142857142857142857142856)/600.0, 0.0);
                vec4 loldir = normalize(vec4(0.0, 0.0, 0.0, 0.0) - Position);
                Position += loldir*(timer-(100000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0))/150.0;
            }else if(timer>103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0 && timer<123428.57142857142857142857142857)
            {
                vec3 dir = normalize(vec3(0.0, 0.0, 0.0) - Position.xyz);
                Position += vec4(dir*(103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0-89142.857142857142857142857142856)/600.0, 0.0);
                vec4 loldir = normalize(vec4(0.0, 0.0, 0.0, 0.0) - Position);
                Position += loldir*(103000+(timer-(103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0))/2000.0-100000)/150.0;
            }else if(timer>123428.57142857142857142857142857 && timer<130285.71428571428571428571428571)
            {
                vec3 dir = normalize(vec3(0.0, 0.0, 0.0) - Position.xyz);
                Position += vec4(dir*((103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0-89142.857142857142857142857142856)/600.0+(timer-123428.57142857142857142857142857)/2600.0), 0.0);
                vec4 loldir = normalize(vec4(0.0, 0.0, 0.0, 0.0) - Position);
                Position += loldir*((103000+(123428.57142857142857142857142857-(103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0))/2000.0-100000)/150.0-(timer-123428.57142857142857142857142857)/400.0);
            }else if(timer>130285.71428571428571428571428571 && timer<148857.14285714285714285714285714 + length_time)
            {
                vec3 dir = normalize(vec3(0.0, 0.0, 0.0) - Position.xyz);
                vec3 dir2 = normalize(zeroo.xyz-Position.xyz);
                Position += vec4(dir*((103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0-89142.857142857142857142857142856)/600.0+(timer-123428.57142857142857142857142857)/1100.0), 0.0);
                Position += vec4(dir*((sin(3.0*distance(Position.xyz,vec3(0.0,0.0,0.0)))+0.5)/3.0), 0.0);
                Position += vec4(dir2*((sin(6.0*distance(Position.xyz,vec3(0.0,0.0,0.0)))+0.5)/3.0), 0.0);
            }else if(timer>148857.14285714285714285714285714 + length_time)
            {
                vec3 dir = normalize(vec3(0.0, 0.0, 0.0) - Position.xyz);
                vec3 dir2 = normalize(zeroo.xyz-Position.xyz);
                Position += vec4(dir*((103000+(distancee-30.0)/1.6666666666666666666666666666667*1000.0-89142.857142857142857142857142856)/600.0+(148857.14285714285714285714285714-123428.57142857142857142857142857 + length_time)/1100.0), 0.0);
                Position += vec4(dir*((sin(3.0*distance(Position.xyz,vec3(0.0,0.0,0.0)))+0.5)/3.0), 0.0);
                Position += vec4(dir2*((sin(6.0*distance(Position.xyz,vec3(0.0,0.0,0.0)))+0.5)/3.0), 0.0);

                initialize_matrices((timer-148857.14285714285714285714285714 + length_time)/1000.0*sin(i), (timer-148857.14285714285714285714285714 + length_time)/1000.0*sin(i-4), (timer-148857.14285714285714285714285714 + length_time)/1000.0*sin(i+3));
                Position = rotx * roty * rotz * Position;
            }
        }

        float factor = (timer-428.57142857142857142857142857143)/857.14285714285714285714285714287 - fract((timer-428.57142857142857142857142857143)/857.14285714285714285714285714287);
        Color.x += 10.0-((timer-428.57142857142857142857142857143)-factor*857.14285714285714285714285714287)/80.0;
        if(timer<130285.71428571428571428571428571)
        {
            Position = Position + 0.6 * vec4(Normal.xyz, 0.0) * texture2D(noise_texture, gl_PositionIn[0].xy/6.0 + distance(Position.xyz, vec3(0.0, 0.0, 0.0))/10.0).x;
        }else{
            Position = Position + 0.6 * vec4(Normal.xyz, 0.0) * texture2D(noise_texture, gl_PositionIn[0].xy/6.0).x;
        }
        if(timer<150857.14285714285714285714285714)
        {
            float factor = (timer-428.57142857142857142857142857143)/857.14285714285714285714285714287 - fract((timer-428.57142857142857142857142857143)/857.14285714285714285714285714287);
            Color.x += 10.0-((timer-428.57142857142857142857142857143)-factor*857.14285714285714285714285714287)/80.0;
        }else
        {
            float factor = timer/428.57142857142857142857142857143 - fract(timer/428.57142857142857142857142857143);
            Position.xyz = Position.xyz * (1.2-(timer-factor*428.57142857142857142857142857143)/1600.0);
            //Color.x += 10.0-(timer-factor*428.57142857142857142857142857143)/80.0;
        }
        EmitVertex();
    }


    EndPrimitive();
}
