#version 330
#extension GL_EXT_geometry_shader4 : enable
layout(points) in;
layout(points) out;
layout(max_vertices = 50) out;

out vec4 Position;
out vec4 Color;
out vec4 Normal;
out vec4 TexCoord;

varying in vec3 norm[];

uniform float timer;



vec4 pos;
float s = 1.0*norm[0].z;
vec2 randseed = vec2(3.45, 2.453);

mat4 rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 roty = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 rotz = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);



void Face(float x1, float x2, float x3, float x4, float y1, float y2, float y3, float y4, float z1, float z2, float z3, float z4, float n1, float n2, float n3)
{
    Normal = rotx * roty * rotz * vec4(n1, n2, n3, 0.0);
    Color = vec4(1-distance(Position.xyz, vec3(0.0, 0.0, 0.0))/18.0, 0.8, 0.8, 1.0);

    Position = pos + rotx * roty * rotz * vec4(x1, y1, z1, 0.0);
    TexCoord = vec4(0.0, 0.0, 0.0, 0.0);
    EmitVertex();

    Color = vec4(1-distance(Position.xyz, vec3(0.0, 0.0, 0.0))/18.0, 0.9, 0.8, 1.0);
    Position = pos + rotx * roty * rotz * vec4(x2, y2, z2, 0.0);
    TexCoord = vec4(1.0, 0.0, 0.0, 0.0);
    EmitVertex();

    Color = vec4(1-distance(Position.xyz, vec3(0.0, 0.0, 0.0))/18.0, 0.9, 0.9, 1.0);
    Position = pos + rotx * roty * rotz * vec4(x3, y3, z3, 0.0);
    TexCoord = vec4(1.0, 1.0, 0.0, 0.0);
    EmitVertex();

    Color = vec4(1-distance(Position.xyz, vec3(0.0, 0.0, 0.0))/18.0, 0.8, 0.9, 1.0);
    Position = pos + rotx * roty * rotz * vec4(x4, y4, z4, 0.0);
    TexCoord = vec4(0.0, 1.0, 0.0, 0.0);
    EmitVertex();

    EndPrimitive();
}

void Cube()
{
    Face(s, -s, -s, s,  s, s, -s, -s,  -s, -s, -s, -s,  0.0, 0.0, -1.0);
    Face(s, -s, -s, s,  -s, -s, s, s,  s, s, s, s,  0.0, 0.0, 1.0);

    Face(-s, -s, -s, -s,  s, s, -s, -s,  -s, s, s, -s,  -1.0, 0.0, 0.0);
    Face(s, s, s, s,  -s, -s, s, s,  -s, s, s, -s,  1.0, 0.0, 0.0);

    Face(s, -s, -s, s,  -s, -s, -s, -s,  -s, -s, s, s,  0.0, -1.0, 0.0);
    Face(s, -s, -s, s,  s, s, s, s,  s, s, -s, -s,  0.0, 1.0, 0.0);
}

float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void initialize_matrices(float anglex, float angley, float anglez)
{
     rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , cos(anglex)   , -sin(anglex)  , 0.0,
                 0.0            , sin(anglex)   , cos(anglex)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     roty = mat4(cos(angley)    , 0.0           , sin(angley)   , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 -sin(angley)   , 0.0           , cos(angley)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     rotz = mat4(cos(anglez)    , -sin(anglez)  , 0.0           , 0.0,
                 sin(anglez)    , cos(anglez)   , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);
}

void main()
{

    pos = gl_PositionIn[0];
    float rotspeed = timer / 6000.0;
    float beat = cos(timer*0.0146607657167523684461590024553+3.1415926535897932384626433832795)+1;

    /*if(fract(timer/857.1428571428)>fract((timer-428.571428571428)/857.1428571428))
    {
        s = .5*s;
    }else{
        s = 1.5*s;
    }
    s = s*(beat/10.0+1.0);*/

    initialize_matrices(rotspeed*gl_FrontColorIn[0].x, rotspeed*gl_FrontColorIn[0].y, rotspeed*gl_FrontColorIn[0].z);

    pos = rotx * roty * rotz * pos;

    initialize_matrices(5.0*rotspeed*norm[0].x, 5.0*rotspeed*norm[0].y, 0.0);
    Cube();

}

