in vec3 norm[];
uniform mat4 matrix;
uniform float timer;


layout(points) in;
layout(triangle_strip , max_vertices=32) out;


vec4 pos;
float s = 1.0*norm[0].z;
vec2 randseed = vec2(3.45, 2.453);

mat4 rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 roty = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 rotz = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

void Cube()
{

    gl_FrontColor = gl_FrontColorIn[0];

    //back

    Position = pos + rotx * roty * rotz * vec4(-s, +s, -s, +.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();

    Position = pos + rotx * roty * rotz * vec4(+s, s, -s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();

    Position = pos + rotx * roty * rotz * vec4(-s, -s, -s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();

    Position = pos + rotx * roty * rotz * vec4(+s, -s, -s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();
    EndPrimitive();


    //front
    Position = pos + rotx * roty * rotz * vec4(-s, +s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();

    Position = pos + rotx * roty * rotz * vec4(+s, +s,+s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();

    Position = pos + rotx * roty * rotz * vec4(-s, -s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();

    Position = pos + rotx * roty * rotz * vec4(+s, -s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();
    EndPrimitive();

    //bot
    Position = pos + rotx * roty * rotz * vec4(-s, -s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();
    Position = pos + rotx * roty * rotz * vec4(+s, -s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();
    Position = pos + rotx * roty * rotz * vec4(-s, -s, -s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();
    Position = pos + rotx * roty * rotz * vec4(+s, -s, -s, 0.0);
    Position = gl_ModelViewProjectionMatrix * Position;
    EmitVertex();
    EndPrimitive();

    //top
    Position = pos + rotx * roty * rotz * vec4(-s, +s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    Position = pos + rotx * roty * rotz * vec4(+s, +s, +s, 0.0);
    Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    Position = pos + rotx * roty * rotz * vec4(-s, +s, -s, 0.0);
    Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(+s, +s, -s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    EndPrimitive();

    //right
    gl_Position = pos + rotx * roty * rotz * vec4(+s, +s, -s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(+s, +s, +s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(+s, -s, -s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(+s, -s, +s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    EndPrimitive();

    //left
    gl_Position = pos + rotx * roty * rotz * vec4(-s, +s, -s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(-s, +s, +s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(-s, -s, -s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    gl_Position = pos + rotx * roty * rotz * vec4(-s, -s, +s, 0.0);
    gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
    EmitVertex();
    EndPrimitive();
}

float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void initialize_matrices(float anglex, float angley, float anglez)
{
     rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , cos(anglex)   , -sin(anglex)  , 0.0,
                 0.0            , sin(anglex)   , cos(anglex)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     roty = mat4(cos(angley)    , 0.0           , sin(angley)   , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 -sin(angley)   , 0.0           , cos(angley)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     rotz = mat4(cos(anglez)    , -sin(anglez)  , 0.0           , 0.0,
                 sin(anglez)    , cos(anglez)   , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);
}

void main()
{

    pos = gl_PositionIn[0];

    float rotspeed = timer / 6000.0;
    float beat = cos(timer/68.2092613250980);
    s = s*(-beat/4.0+1.0);
    initialize_matrices(rotspeed*gl_FrontColorIn[0].x, rotspeed*gl_FrontColorIn[0].y, rotspeed*gl_FrontColorIn[0].z);

    pos = rotx * roty * rotz * pos;


    initialize_matrices(5.0*rotspeed*norm[0].x, 5.0*rotspeed*norm[0].y, 0.0);
    Cube();

}
