#version 120

uniform vec2 screen;

uniform sampler2D texture;
uniform vec2 center;
uniform float time;

void main(){
	float intensity = time;
	
	float ratio = screen.x / screen.y;
	vec2 cen = (vec2(center.x, screen.y-center.y) / screen - gl_TexCoord[0].xy);
	
	vec2 mcen = - // delete minus for implosion effect
		0.07 * intensity * log(length(cen / vec2(1.0, ratio))) * normalize(cen);
	
	gl_FragColor = texture2D(texture, gl_TexCoord[0].xy + mcen);
}